-- MySQL dump 10.14  Distrib 5.5.68-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: call_center
-- ------------------------------------------------------
-- Server version	5.5.68-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `agent`
--

DROP TABLE IF EXISTS `agent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `agent` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('Agent','SIP','IAX2') NOT NULL DEFAULT 'Agent',
  `number` varchar(40) NOT NULL,
  `name` varchar(250) NOT NULL,
  `password` varchar(250) NOT NULL,
  `estatus` enum('A','I') DEFAULT 'A',
  `eccp_password` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_type` (`estatus`,`type`,`number`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `audit`
--

DROP TABLE IF EXISTS `audit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `audit` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_agent` int(10) unsigned NOT NULL,
  `id_break` int(10) unsigned DEFAULT NULL,
  `datetime_init` datetime NOT NULL,
  `datetime_end` datetime DEFAULT NULL,
  `duration` time DEFAULT NULL,
  `ext_parked` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_agent` (`id_agent`),
  KEY `id_break` (`id_break`),
  KEY `agent_break_datetime` (`id_agent`,`id_break`,`datetime_init`),
  CONSTRAINT `audit_ibfk_1` FOREIGN KEY (`id_agent`) REFERENCES `agent` (`id`),
  CONSTRAINT `audit_ibfk_2` FOREIGN KEY (`id_break`) REFERENCES `break` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `break`
--

DROP TABLE IF EXISTS `break`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `break` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `description` varchar(250) DEFAULT NULL,
  `status` varchar(1) NOT NULL DEFAULT 'A',
  `tipo` enum('B','H') DEFAULT 'B',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `call_attribute`
--

DROP TABLE IF EXISTS `call_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `call_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_call` int(10) unsigned NOT NULL,
  `columna` varchar(30) DEFAULT NULL,
  `value` varchar(128) NOT NULL,
  `column_number` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_call` (`id_call`),
  CONSTRAINT `call_attribute_ibfk_1` FOREIGN KEY (`id_call`) REFERENCES `calls` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `call_entry`
--

DROP TABLE IF EXISTS `call_entry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `call_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_agent` int(10) unsigned DEFAULT NULL,
  `id_queue_call_entry` int(10) unsigned NOT NULL,
  `id_contact` int(10) unsigned DEFAULT NULL,
  `callerid` varchar(15) NOT NULL,
  `datetime_init` datetime DEFAULT NULL,
  `datetime_end` datetime DEFAULT NULL,
  `duration` int(10) unsigned DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `transfer` varchar(6) DEFAULT NULL,
  `datetime_entry_queue` datetime DEFAULT NULL,
  `duration_wait` int(11) DEFAULT NULL,
  `uniqueid` varchar(32) DEFAULT NULL,
  `id_campaign` int(10) unsigned DEFAULT NULL,
  `trunk` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_agent` (`id_agent`),
  KEY `id_queue_call_entry` (`id_queue_call_entry`),
  KEY `id_contact` (`id_contact`),
  KEY `call_entry_ibfk_4` (`id_campaign`),
  KEY `datetime_init` (`datetime_init`),
  KEY `datetime_entry_queue` (`datetime_entry_queue`),
  CONSTRAINT `call_entry_ibfk_1` FOREIGN KEY (`id_agent`) REFERENCES `agent` (`id`),
  CONSTRAINT `call_entry_ibfk_2` FOREIGN KEY (`id_queue_call_entry`) REFERENCES `queue_call_entry` (`id`),
  CONSTRAINT `call_entry_ibfk_3` FOREIGN KEY (`id_contact`) REFERENCES `contact` (`id`),
  CONSTRAINT `call_entry_ibfk_4` FOREIGN KEY (`id_campaign`) REFERENCES `campaign_entry` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `call_progress_log`
--

DROP TABLE IF EXISTS `call_progress_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `call_progress_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `datetime_entry` datetime NOT NULL,
  `id_campaign_incoming` int(10) unsigned DEFAULT NULL,
  `id_call_incoming` int(10) unsigned DEFAULT NULL,
  `id_campaign_outgoing` int(10) unsigned DEFAULT NULL,
  `id_call_outgoing` int(10) unsigned DEFAULT NULL,
  `new_status` varchar(32) NOT NULL,
  `retry` int(10) unsigned DEFAULT NULL,
  `uniqueid` varchar(32) DEFAULT NULL,
  `trunk` varchar(20) DEFAULT NULL,
  `id_agent` int(10) unsigned DEFAULT NULL,
  `duration` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `call_progress_log_ibfk_4` (`id_agent`),
  KEY `call_progress_log_ibfk_5` (`id_campaign_incoming`),
  KEY `call_progress_log_ibfk_6` (`id_campaign_outgoing`),
  KEY `incoming_datetime_entry` (`id_call_incoming`,`datetime_entry`),
  KEY `outgoing_datetime_entry` (`id_call_outgoing`,`datetime_entry`),
  CONSTRAINT `call_progress_log_ibfk_1` FOREIGN KEY (`id_call_incoming`) REFERENCES `call_entry` (`id`),
  CONSTRAINT `call_progress_log_ibfk_2` FOREIGN KEY (`id_call_outgoing`) REFERENCES `calls` (`id`),
  CONSTRAINT `call_progress_log_ibfk_4` FOREIGN KEY (`id_agent`) REFERENCES `agent` (`id`),
  CONSTRAINT `call_progress_log_ibfk_5` FOREIGN KEY (`id_campaign_incoming`) REFERENCES `campaign_entry` (`id`),
  CONSTRAINT `call_progress_log_ibfk_6` FOREIGN KEY (`id_campaign_outgoing`) REFERENCES `campaign` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3038 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `call_recording`
--

DROP TABLE IF EXISTS `call_recording`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `call_recording` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `datetime_entry` datetime NOT NULL,
  `id_call_incoming` int(10) unsigned DEFAULT NULL,
  `id_call_outgoing` int(10) unsigned DEFAULT NULL,
  `uniqueid` varchar(32) NOT NULL,
  `channel` varchar(80) NOT NULL,
  `recordingfile` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `call_recording_ibfk_1` (`id_call_incoming`),
  KEY `call_recording_ibfk_2` (`id_call_outgoing`),
  CONSTRAINT `call_recording_ibfk_1` FOREIGN KEY (`id_call_incoming`) REFERENCES `call_entry` (`id`),
  CONSTRAINT `call_recording_ibfk_2` FOREIGN KEY (`id_call_outgoing`) REFERENCES `calls` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1241 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `calls`
--

DROP TABLE IF EXISTS `calls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `calls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_campaign` int(10) unsigned NOT NULL,
  `phone` varchar(32) NOT NULL,
  `status` varchar(32) DEFAULT NULL,
  `uniqueid` varchar(32) DEFAULT NULL,
  `fecha_llamada` datetime DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `retries` int(10) unsigned NOT NULL DEFAULT '0',
  `duration` int(10) unsigned DEFAULT NULL,
  `id_agent` int(10) unsigned DEFAULT NULL,
  `transfer` varchar(6) DEFAULT NULL,
  `datetime_entry_queue` datetime DEFAULT NULL,
  `duration_wait` int(11) DEFAULT NULL,
  `dnc` int(1) NOT NULL DEFAULT '0',
  `date_init` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `time_init` time DEFAULT NULL,
  `time_end` time DEFAULT NULL,
  `agent` varchar(32) DEFAULT NULL,
  `failure_cause` int(10) unsigned DEFAULT NULL,
  `failure_cause_txt` varchar(32) DEFAULT NULL,
  `datetime_originate` datetime DEFAULT NULL,
  `trunk` varchar(20) DEFAULT NULL,
  `scheduled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_campaign` (`id_campaign`),
  KEY `calls_ibfk_2` (`id_agent`),
  KEY `campaign_date_schedule` (`id_campaign`,`date_init`,`date_end`,`time_init`,`time_end`),
  KEY `datetime_init` (`start_time`),
  KEY `datetime_entry_queue` (`datetime_entry_queue`),
  CONSTRAINT `calls_ibfk_1` FOREIGN KEY (`id_campaign`) REFERENCES `campaign` (`id`),
  CONSTRAINT `calls_ibfk_2` FOREIGN KEY (`id_agent`) REFERENCES `agent` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `campaign`
--

DROP TABLE IF EXISTS `campaign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `campaign` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `datetime_init` date NOT NULL,
  `datetime_end` date NOT NULL,
  `daytime_init` time NOT NULL,
  `daytime_end` time NOT NULL,
  `retries` int(10) unsigned NOT NULL DEFAULT '1',
  `trunk` varchar(255) DEFAULT NULL,
  `context` varchar(32) NOT NULL,
  `queue` varchar(16) NOT NULL,
  `max_canales` int(10) unsigned NOT NULL DEFAULT '0',
  `num_completadas` int(10) unsigned DEFAULT NULL,
  `promedio` int(10) unsigned DEFAULT NULL,
  `desviacion` int(10) unsigned DEFAULT NULL,
  `script` text NOT NULL,
  `estatus` varchar(1) NOT NULL DEFAULT 'A',
  `id_url` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_url` (`id_url`),
  CONSTRAINT `campaign_ibfk_1` FOREIGN KEY (`id_url`) REFERENCES `campaign_external_url` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `campaign_entry`
--

DROP TABLE IF EXISTS `campaign_entry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `campaign_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `id_queue_call_entry` int(10) unsigned NOT NULL,
  `id_form` int(10) unsigned DEFAULT NULL,
  `datetime_init` date NOT NULL,
  `datetime_end` date NOT NULL,
  `daytime_init` time NOT NULL,
  `daytime_end` time NOT NULL,
  `estatus` varchar(1) NOT NULL DEFAULT 'A',
  `script` text NOT NULL,
  `id_url` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_queue_call_entry` (`id_queue_call_entry`),
  KEY `id_form` (`id_form`),
  KEY `id_url` (`id_url`),
  CONSTRAINT `campaign_entry_ibfk_1` FOREIGN KEY (`id_queue_call_entry`) REFERENCES `queue_call_entry` (`id`),
  CONSTRAINT `campaign_entry_ibfk_2` FOREIGN KEY (`id_form`) REFERENCES `form` (`id`),
  CONSTRAINT `campaign_entry_ibfk_3` FOREIGN KEY (`id_url`) REFERENCES `campaign_external_url` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `campaign_external_url`
--

DROP TABLE IF EXISTS `campaign_external_url`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `campaign_external_url` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `urltemplate` varchar(250) NOT NULL,
  `description` varchar(64) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `opentype` varchar(16) NOT NULL DEFAULT 'window',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `campaign_form`
--

DROP TABLE IF EXISTS `campaign_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `campaign_form` (
  `id_campaign` int(10) unsigned NOT NULL,
  `id_form` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id_campaign`,`id_form`),
  KEY `id_campaign` (`id_campaign`),
  KEY `id_form` (`id_form`),
  CONSTRAINT `campaign_form_ibfk_1` FOREIGN KEY (`id_campaign`) REFERENCES `campaign` (`id`),
  CONSTRAINT `campaign_form_ibfk_2` FOREIGN KEY (`id_form`) REFERENCES `form` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `campaign_form_entry`
--

DROP TABLE IF EXISTS `campaign_form_entry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `campaign_form_entry` (
  `id_campaign` int(10) unsigned NOT NULL,
  `id_form` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id_campaign`,`id_form`),
  KEY `id_campaign` (`id_campaign`),
  KEY `id_form` (`id_form`),
  CONSTRAINT `campaign_form_entry_ibfk_1` FOREIGN KEY (`id_campaign`) REFERENCES `campaign_entry` (`id`),
  CONSTRAINT `campaign_form_entry_ibfk_2` FOREIGN KEY (`id_form`) REFERENCES `form` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contact`
--

DROP TABLE IF EXISTS `contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `contact` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cedula_ruc` varchar(15) NOT NULL,
  `name` varchar(50) NOT NULL,
  `telefono` varchar(15) NOT NULL,
  `apellido` varchar(50) NOT NULL,
  `origen` varchar(4) DEFAULT 'crm',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `current_call_entry`
--

DROP TABLE IF EXISTS `current_call_entry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `current_call_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_agent` int(10) unsigned NOT NULL,
  `id_queue_call_entry` int(10) unsigned NOT NULL,
  `id_call_entry` int(10) unsigned NOT NULL,
  `callerid` varchar(15) NOT NULL,
  `datetime_init` datetime NOT NULL,
  `uniqueid` varchar(32) DEFAULT NULL,
  `ChannelClient` varchar(32) DEFAULT NULL,
  `hold` enum('N','S') DEFAULT 'N',
  PRIMARY KEY (`id`),
  KEY `id_agent` (`id_agent`),
  KEY `id_queue_call_entry` (`id_queue_call_entry`),
  KEY `id_call_entry` (`id_call_entry`),
  CONSTRAINT `current_call_entry_ibfk_1` FOREIGN KEY (`id_agent`) REFERENCES `agent` (`id`),
  CONSTRAINT `current_call_entry_ibfk_2` FOREIGN KEY (`id_queue_call_entry`) REFERENCES `queue_call_entry` (`id`),
  CONSTRAINT `current_call_entry_ibfk_3` FOREIGN KEY (`id_call_entry`) REFERENCES `call_entry` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `current_calls`
--

DROP TABLE IF EXISTS `current_calls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `current_calls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_call` int(10) unsigned NOT NULL,
  `fecha_inicio` datetime NOT NULL,
  `uniqueid` varchar(32) DEFAULT NULL,
  `queue` varchar(16) NOT NULL,
  `agentnum` varchar(16) NOT NULL,
  `event` varchar(32) NOT NULL,
  `Channel` varchar(32) NOT NULL DEFAULT '',
  `ChannelClient` varchar(32) DEFAULT NULL,
  `hold` enum('N','S') DEFAULT 'N',
  PRIMARY KEY (`id`),
  KEY `id_call` (`id_call`),
  CONSTRAINT `current_calls_ibfk_1` FOREIGN KEY (`id_call`) REFERENCES `calls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dont_call`
--

DROP TABLE IF EXISTS `dont_call`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `dont_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `caller_id` varchar(15) NOT NULL,
  `date_income` datetime DEFAULT NULL,
  `status` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `callerid` (`caller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eccp_authorized_clients`
--

DROP TABLE IF EXISTS `eccp_authorized_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `eccp_authorized_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(64) NOT NULL,
  `md5_password` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `form`
--

DROP TABLE IF EXISTS `form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(40) NOT NULL,
  `descripcion` varchar(150) NOT NULL,
  `estatus` varchar(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `form_data_recolected`
--

DROP TABLE IF EXISTS `form_data_recolected`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `form_data_recolected` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_calls` int(10) unsigned NOT NULL,
  `id_form_field` int(10) unsigned NOT NULL,
  `value` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_form_field` (`id_form_field`),
  KEY `id_calls` (`id_calls`),
  CONSTRAINT `form_data_recolected_ibfk_1` FOREIGN KEY (`id_form_field`) REFERENCES `form_field` (`id`),
  CONSTRAINT `form_data_recolected_ibfk_2` FOREIGN KEY (`id_calls`) REFERENCES `calls` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `form_data_recolected_entry`
--

DROP TABLE IF EXISTS `form_data_recolected_entry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `form_data_recolected_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_call_entry` int(10) unsigned NOT NULL,
  `id_form_field` int(10) unsigned NOT NULL,
  `value` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_call_entry` (`id_call_entry`),
  KEY `id_form_field` (`id_form_field`),
  CONSTRAINT `form_data_recolected_entry_ibfk_1` FOREIGN KEY (`id_call_entry`) REFERENCES `call_entry` (`id`),
  CONSTRAINT `form_data_recolected_entry_ibfk_2` FOREIGN KEY (`id_form_field`) REFERENCES `form_field` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `form_field`
--

DROP TABLE IF EXISTS `form_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `form_field` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_form` int(10) unsigned NOT NULL,
  `etiqueta` text NOT NULL,
  `value` text NOT NULL,
  `tipo` varchar(25) NOT NULL,
  `orden` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_form` (`id_form`),
  CONSTRAINT `form_field_ibfk_1` FOREIGN KEY (`id_form`) REFERENCES `form` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_call_entry`
--

DROP TABLE IF EXISTS `queue_call_entry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `queue_call_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(50) DEFAULT NULL,
  `date_init` date DEFAULT NULL,
  `time_init` time DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `time_end` time DEFAULT NULL,
  `estatus` varchar(1) NOT NULL DEFAULT 'A',
  `script` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `valor_config`
--

DROP TABLE IF EXISTS `valor_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `valor_config` (
  `config_key` varchar(32) NOT NULL,
  `config_value` varchar(128) NOT NULL,
  `config_blob` blob,
  PRIMARY KEY (`config_key`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-04-29 23:59:11
-- MySQL dump 10.14  Distrib 5.5.68-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: call_center
-- ------------------------------------------------------
-- Server version	5.5.68-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `agent`
--

LOCK TABLES `agent` WRITE;
/*!40000 ALTER TABLE `agent` DISABLE KEYS */;
INSERT INTO `agent` (`id`, `type`, `number`, `name`, `password`, `estatus`, `eccp_password`) VALUES (1,'SIP','1001','agent1001','1001','I','80f500ad935f14bbd9db143dc711d74fb612c219'),(2,'SIP','1001','agent1001','1001','A','80f500ad935f14bbd9db143dc711d74fb612c219'),(3,'SIP','1002','Agent1002','1002','A','7c79c82afbd37070255941cee49a595974296743'),(4,'SIP','1003','Agent1003','1003','A','d552c99d7fe10cbffc7279e8d66bc2563ae86d18'),(5,'SIP','1004','Agent1004','1004','A','47c0f2ce033d7897568edfb60462727cc85fd1cc'),(6,'SIP','1005','Agent1005','1','A','56ba299290f7690973ab31e9ee0e7cac95fac70d'),(7,'SIP','1007','Agent1007','1007','A','66d538bece6b14d593313956c0daee558aa8b60f'),(8,'Agent','10012','10012','10012','I','fab8e5cecb5e9c0235bb6c54e51bb9405a45b86b'),(9,'Agent','1012','1012','1012','A','2dc69e1c9c2d71d939acbeb86ebc62763a9edc32'),(10,'Agent','7701','agent7701','1','A','6fb65be1dafe97897e169b707147762bc058b49b');
/*!40000 ALTER TABLE `agent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `audit`
--

LOCK TABLES `audit` WRITE;
/*!40000 ALTER TABLE `audit` DISABLE KEYS */;
INSERT INTO `audit` (`id`, `id_agent`, `id_break`, `datetime_init`, `datetime_end`, `duration`, `ext_parked`) VALUES (1,2,NULL,'2019-07-30 17:27:12','2019-07-30 17:27:29','00:00:17',NULL),(2,2,NULL,'2019-07-30 17:27:36','2019-07-30 17:29:57','00:02:21',NULL),(3,2,NULL,'2019-07-30 17:30:25','2019-07-30 17:32:06','00:01:41',NULL),(4,2,NULL,'2019-07-30 17:32:27','2019-07-30 17:48:01','00:15:34',NULL),(5,2,NULL,'2019-07-30 20:37:14','2019-07-30 20:37:25','00:00:11',NULL),(6,2,NULL,'2019-07-31 12:40:40','2019-07-31 12:40:54','00:00:14',NULL),(7,2,2,'2019-07-31 12:40:49','2019-07-31 12:40:54','00:00:05',NULL),(8,3,NULL,'2019-07-31 14:58:49','2019-07-31 14:59:09','00:00:20',NULL),(9,2,NULL,'2019-07-31 15:07:42','2019-07-31 15:08:06','00:00:24',NULL),(10,2,NULL,'2019-07-31 15:11:21','2019-07-31 15:12:14','00:00:53',NULL),(11,2,2,'2019-07-31 15:11:56','2019-07-31 15:12:14','00:00:18',NULL),(12,3,NULL,'2019-07-31 15:12:56','2019-07-31 15:13:08','00:00:12',NULL),(13,2,NULL,'2019-07-31 15:18:10','2019-07-31 15:19:22','00:01:12',NULL),(14,2,2,'2019-07-31 15:18:42','2019-07-31 15:18:49','00:00:07',NULL),(15,2,NULL,'2019-07-31 15:23:09','2019-07-31 15:23:53','00:00:44',NULL),(16,2,NULL,'2019-07-31 15:45:00','2019-07-31 15:45:35','00:00:35',NULL),(17,2,NULL,'2019-07-31 15:50:38','2019-07-31 15:52:03','00:01:25',NULL),(18,2,NULL,'2019-07-31 15:54:23','2019-07-31 15:55:42','00:01:19',NULL),(19,2,NULL,'2019-07-31 16:00:27','2019-07-31 16:02:00','00:01:33',NULL),(20,2,NULL,'2019-07-31 17:01:49','2019-07-31 17:04:01','00:02:12',NULL),(21,2,NULL,'2019-07-31 17:04:09','2019-07-31 17:04:49','00:00:40',NULL),(22,2,NULL,'2019-07-31 17:05:08','2019-07-31 17:12:27','00:07:19',NULL),(23,6,NULL,'2019-07-31 17:15:28','2019-07-31 17:44:59','00:29:31',NULL),(24,2,NULL,'2019-07-31 19:46:34','2019-07-31 19:47:23','00:00:49',NULL),(25,2,NULL,'2019-07-31 19:49:55','2019-07-31 19:51:19','00:01:24',NULL),(26,2,2,'2019-07-31 19:50:54','2019-07-31 19:51:10','00:00:16',NULL),(27,2,NULL,'2019-08-01 09:43:33','2019-08-01 09:44:16','00:00:43',NULL),(28,2,NULL,'2019-08-01 10:51:29','2019-08-01 10:51:58','00:00:29',NULL),(29,2,NULL,'2019-08-01 10:52:52','2019-08-01 10:53:46','00:00:54',NULL),(30,2,NULL,'2019-08-01 11:33:22','2019-08-01 11:37:35','00:04:13',NULL),(31,2,2,'2019-08-01 11:36:56','2019-08-01 11:37:35','00:00:39',NULL),(32,2,NULL,'2019-08-01 11:58:24','2019-08-01 11:58:27','00:00:03',NULL),(33,2,NULL,'2019-08-01 12:07:10','2019-08-01 12:07:13','00:00:03',NULL),(34,2,NULL,'2019-08-01 12:07:43','2019-08-01 12:08:07','00:00:24',NULL),(35,2,NULL,'2019-08-01 12:24:25','2019-08-01 12:24:56','00:00:31',NULL),(36,2,2,'2019-08-01 12:24:47','2019-08-01 12:24:52','00:00:05',NULL),(37,9,NULL,'2019-08-01 12:27:14','2019-08-01 12:27:32','00:00:18',NULL),(38,2,NULL,'2019-08-01 12:37:56','2019-08-01 12:38:34','00:00:38',NULL),(39,9,NULL,'2019-08-01 13:00:57','2019-08-01 13:01:49','00:00:52',NULL),(40,9,2,'2019-08-01 13:01:47','2019-08-01 13:01:49','00:00:02',NULL),(41,2,NULL,'2019-08-01 13:02:47','2019-08-01 13:03:40','00:00:53',NULL),(42,2,NULL,'2019-08-01 13:05:13','2019-08-01 13:05:29','00:00:16',NULL),(43,2,NULL,'2019-08-01 13:15:33','2019-08-01 13:16:44','00:01:11',NULL),(44,2,NULL,'2019-08-01 13:27:02','2019-08-01 13:28:09','00:01:07',NULL),(45,2,NULL,'2019-08-01 13:36:47','2019-08-01 13:38:02','00:01:15',NULL),(46,2,NULL,'2019-08-01 14:07:06','2019-08-01 14:09:20','00:02:14',NULL),(47,2,NULL,'2019-08-01 14:11:35','2019-08-01 14:12:41','00:01:06',NULL),(48,2,NULL,'2019-08-01 14:19:54','2019-08-01 14:21:31','00:01:37',NULL),(49,2,NULL,'2019-08-01 14:53:53','2019-08-01 14:54:58','00:01:05',NULL),(50,2,NULL,'2019-08-01 15:04:35','2019-08-01 15:09:33','00:04:58',NULL),(51,2,2,'2019-08-01 15:05:15','2019-08-01 15:08:32','00:03:17',NULL),(52,2,NULL,'2019-08-01 15:13:23','2019-08-01 15:14:34','00:01:11',NULL),(53,2,NULL,'2019-08-01 15:18:19','2019-08-01 15:19:24','00:01:05',NULL),(54,2,NULL,'2019-08-01 15:55:43','2019-08-01 15:57:21','00:01:38',NULL),(55,10,NULL,'2019-08-02 00:35:42','2019-08-02 00:48:34','00:12:52',NULL),(56,9,NULL,'2019-08-02 14:03:15','2019-08-02 14:03:28','00:00:13',NULL),(57,2,NULL,'2019-08-03 12:38:21','2019-08-03 12:39:52','00:01:31',NULL),(58,2,NULL,'2019-08-03 12:42:18','2019-08-03 12:44:23','00:02:05',NULL),(59,6,NULL,'2019-08-03 13:33:10','2019-08-03 16:49:33','03:16:23',NULL),(60,2,NULL,'2019-08-03 19:53:55','2019-08-03 19:54:27','00:00:32',NULL),(61,2,NULL,'2019-08-03 19:57:19','2019-08-03 19:57:41','00:00:22',NULL),(62,2,NULL,'2019-08-03 20:06:49','2019-08-03 20:10:33','00:03:44',NULL),(63,2,NULL,'2019-08-03 20:20:45','2019-08-03 20:25:01','00:04:16',NULL),(64,2,NULL,'2019-08-03 20:37:51','2019-08-03 20:39:53','00:02:02',NULL),(65,2,NULL,'2019-08-03 21:17:17','2019-08-03 21:27:07','00:09:50',NULL),(66,6,NULL,'2019-08-03 21:20:23','2019-08-03 21:25:59','00:05:36',NULL),(67,2,NULL,'2019-08-04 09:50:25','2019-08-04 09:51:14','00:00:49',NULL),(68,2,NULL,'2019-08-04 10:13:57','2019-08-04 10:15:00','00:01:03',NULL),(69,2,NULL,'2019-08-04 10:16:12','2019-08-04 10:19:13','00:03:01',NULL),(70,2,2,'2019-08-04 10:17:33','2019-08-04 10:18:33','00:01:00',NULL),(71,2,NULL,'2019-08-04 10:20:03','2019-08-04 10:24:34','00:04:31',NULL),(72,2,NULL,'2019-08-04 10:24:41','2019-08-04 10:28:55','00:04:14',NULL),(73,2,NULL,'2019-08-04 10:31:12','2019-08-04 10:33:06','00:01:54',NULL),(74,2,NULL,'2019-08-04 10:33:18','2019-08-04 10:36:06','00:02:48',NULL),(75,2,NULL,'2019-08-04 10:38:02','2019-08-04 10:39:46','00:01:44',NULL),(76,2,NULL,'2019-08-04 10:50:09','2019-08-04 10:52:40','00:02:31',NULL),(77,2,NULL,'2019-08-04 10:53:25','2019-08-04 10:54:35','00:01:10',NULL),(78,2,NULL,'2019-08-04 10:56:33','2019-08-04 11:03:28','00:06:55',NULL),(79,2,NULL,'2019-08-04 11:04:32','2019-08-04 11:06:45','00:02:13',NULL),(80,2,NULL,'2019-08-04 11:07:01','2019-08-04 11:07:43','00:00:42',NULL),(81,2,NULL,'2019-08-04 12:17:35','2019-08-04 12:18:22','00:00:47',NULL),(82,2,NULL,'2019-08-04 12:40:15','2019-08-04 12:45:22','00:05:07',NULL),(83,2,NULL,'2019-08-04 13:00:39','2019-08-04 13:02:03','00:01:24',NULL),(84,2,NULL,'2019-08-04 13:04:51','2019-08-04 13:09:46','00:04:55',NULL),(85,2,NULL,'2019-08-04 13:56:16','2019-08-04 13:57:40','00:01:24',NULL),(86,2,NULL,'2019-08-04 14:18:06','2019-08-04 14:23:27','00:05:21',NULL),(87,2,NULL,'2019-08-04 15:32:56','2019-08-04 15:38:23','00:05:27',NULL),(88,2,NULL,'2019-08-04 15:40:16','2019-08-04 15:42:23','00:02:07',NULL),(89,2,NULL,'2019-08-04 15:48:26','2019-08-04 15:52:51','00:04:25',NULL),(90,2,NULL,'2019-08-04 15:55:57','2019-08-04 16:10:04','00:14:07',NULL),(91,2,NULL,'2019-08-04 16:14:54','2019-08-04 16:15:38','00:00:44',NULL),(92,2,NULL,'2019-08-04 18:12:49','2019-08-04 18:13:17','00:00:28',NULL),(93,6,NULL,'2019-08-04 18:51:56','2019-08-04 19:23:20','00:31:24',NULL),(94,2,NULL,'2019-08-04 20:05:05','2019-08-04 20:19:33','00:14:28',NULL),(95,6,NULL,'2019-08-04 20:14:40','2019-08-04 21:09:47','00:55:07',NULL),(96,2,NULL,'2019-08-04 20:19:43','2019-08-04 20:45:39','00:25:56',NULL),(97,3,NULL,'2019-08-05 11:29:28','2019-08-05 11:30:37','00:01:09',NULL),(98,3,2,'2019-08-05 11:30:32','2019-08-05 11:30:37','00:00:05',NULL),(99,3,NULL,'2019-08-05 11:32:31','2019-08-05 11:34:15','00:01:44',NULL),(100,3,2,'2019-08-05 11:34:11','2019-08-05 11:34:15','00:00:04',NULL),(101,2,NULL,'2019-08-05 11:38:39','2019-08-05 11:59:35','00:20:56',NULL),(102,2,NULL,'2019-08-05 12:47:07','2019-08-05 12:48:11','00:01:04',NULL),(103,2,2,'2019-08-05 12:48:05','2019-08-05 12:48:11','00:00:06',NULL),(104,3,NULL,'2019-08-05 13:00:31','2019-08-05 13:02:02','00:01:31',NULL),(105,2,NULL,'2019-08-05 14:04:05','2019-08-05 14:07:24','00:03:19',NULL),(106,2,NULL,'2019-08-05 14:14:10','2019-08-05 14:16:33','00:02:23',NULL),(107,2,NULL,'2019-08-05 14:18:21','2019-08-05 14:19:08','00:00:47',NULL),(108,3,NULL,'2019-08-05 14:31:15','2019-08-05 14:31:20','00:00:05',NULL),(109,2,NULL,'2019-08-05 14:31:58','2019-08-05 14:33:20','00:01:22',NULL),(110,2,2,'2019-08-05 14:33:16','2019-08-05 14:33:20','00:00:04',NULL),(111,2,NULL,'2019-08-05 15:22:22','2019-08-05 15:30:37','00:08:15',NULL),(112,2,2,'2019-08-05 15:24:42','2019-08-05 15:30:37','00:05:55',NULL),(113,2,NULL,'2019-08-05 15:47:16','2019-08-05 15:52:13','00:04:57',NULL),(114,2,2,'2019-08-05 15:50:59','2019-08-05 15:52:13','00:01:14',NULL),(115,2,NULL,'2019-08-05 15:52:20','2019-08-05 15:52:32','00:00:12',NULL),(116,2,NULL,'2019-08-05 19:52:22','2019-08-05 20:07:27','00:15:05',NULL),(117,2,NULL,'2019-08-08 12:26:57','2019-08-08 12:27:54','00:00:57',NULL),(118,2,NULL,'2019-08-10 12:58:05','2019-08-10 13:00:14','00:02:09',NULL),(119,2,NULL,'2019-08-10 13:08:45','2019-08-10 13:10:15','00:01:30',NULL),(120,2,NULL,'2019-08-10 13:17:25','2019-08-10 13:19:25','00:02:00',NULL),(121,2,NULL,'2019-08-10 17:52:17','2019-08-10 18:07:14','00:14:57',NULL),(122,2,2,'2019-08-10 17:53:39','2019-08-10 17:54:15','00:00:36',NULL),(123,2,NULL,'2019-08-10 18:10:11','2019-08-10 18:11:46','00:01:35',NULL),(124,2,NULL,'2019-08-10 20:14:44','2019-08-10 20:15:34','00:00:50',NULL),(125,2,NULL,'2019-08-11 09:44:33','2019-08-11 09:46:49','00:02:16',NULL),(126,2,NULL,'2019-08-11 13:03:23','2019-08-11 13:04:33','00:01:10',NULL),(127,3,NULL,'2019-08-11 13:31:42','2019-08-11 13:45:54','00:14:12',NULL),(128,3,2,'2019-08-11 13:35:23','2019-08-11 13:45:54','00:10:31',NULL),(129,2,NULL,'2019-08-20 10:12:05','2019-08-20 10:50:29','00:38:24',NULL),(130,2,NULL,'2019-08-20 14:32:25','2019-08-20 14:32:46','00:00:21',NULL),(131,2,NULL,'2019-09-04 11:09:58','2019-09-04 11:13:22','00:03:24',NULL),(132,2,2,'2019-09-04 11:11:09','2019-09-04 11:11:38','00:00:29',NULL),(133,2,NULL,'2019-09-04 11:19:13','2019-09-04 11:26:10','00:06:57',NULL),(134,2,NULL,'2019-09-04 11:33:36','2019-09-04 11:34:35','00:00:59',NULL),(135,2,NULL,'2019-09-04 12:13:20','2019-09-04 12:15:12','00:01:52',NULL),(136,2,NULL,'2019-09-04 12:23:56','2019-09-04 12:24:45','00:00:49',NULL),(137,2,NULL,'2019-09-04 13:49:54','2019-09-04 13:53:54','00:04:00',NULL),(138,2,NULL,'2019-09-04 14:57:31','2019-09-04 15:10:12','00:12:41',NULL),(139,2,NULL,'2019-09-05 10:07:41','2019-09-05 10:10:27','00:02:46',NULL),(140,2,NULL,'2019-09-05 12:57:28','2019-09-05 12:59:32','00:02:04',NULL),(141,2,NULL,'2019-09-05 15:15:09','2019-09-05 15:19:00','00:03:51',NULL);
/*!40000 ALTER TABLE `audit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `break`
--

LOCK TABLES `break` WRITE;
/*!40000 ALTER TABLE `break` DISABLE KEYS */;
INSERT INTO `break` (`id`, `name`, `description`, `status`, `tipo`) VALUES (1,'Hold','Hold','A','H'),(2,'obed','obed','A','B'),(3,'kuru','kuru','A','B');
/*!40000 ALTER TABLE `break` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `call_attribute`
--

LOCK TABLES `call_attribute` WRITE;
/*!40000 ALTER TABLE `call_attribute` DISABLE KEYS */;
INSERT INTO `call_attribute` (`id`, `id_call`, `columna`, `value`, `column_number`) VALUES (1,1,'1','0532865256',1),(2,1,'2','alex',2),(3,1,'3','alex',3),(4,2,'1','0532865256',1),(5,2,'2','alex',2),(6,2,'3','alex',3),(7,3,'1','0532865256',1),(8,3,'2','alex',2),(9,3,'3','alex',3),(10,4,'1','0532865256',1),(11,4,'2','alex',2),(12,4,'3','alex',3),(13,5,'1','0532865256',1),(14,5,'2','alex',2),(15,5,'3','alex',3),(16,6,'1','0532865256',1),(17,6,'2','alex',2),(18,6,'3','alex',3),(19,7,'1','0532865256',1),(20,7,'2','alex',2),(21,7,'3','alex',3),(22,8,'1','0532865256',1),(23,8,'2','alex',2),(24,8,'3','alex',3),(25,9,'1','0532865256',1),(26,9,'2','alex',2),(27,9,'3','alex',3);
/*!40000 ALTER TABLE `call_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `call_entry`
--

LOCK TABLES `call_entry` WRITE;
/*!40000 ALTER TABLE `call_entry` DISABLE KEYS */;
INSERT INTO `call_entry` (`id`, `id_agent`, `id_queue_call_entry`, `id_contact`, `callerid`, `datetime_init`, `datetime_end`, `duration`, `status`, `transfer`, `datetime_entry_queue`, `duration_wait`, `uniqueid`, `id_campaign`, `trunk`) VALUES (190,NULL,1,NULL,'201',NULL,'2019-08-08 23:59:50',NULL,'abandonada',NULL,'2019-08-08 23:59:44',6,'1565297983.128',NULL,'SIP/201');
/*!40000 ALTER TABLE `call_entry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `call_progress_log`
--

LOCK TABLES `call_progress_log` WRITE;
/*!40000 ALTER TABLE `call_progress_log` DISABLE KEYS */;
INSERT INTO `call_progress_log` (`id`, `datetime_entry`, `id_campaign_incoming`, `id_call_incoming`, `id_campaign_outgoing`, `id_call_outgoing`, `new_status`, `retry`, `uniqueid`, `trunk`, `id_agent`, `duration`) VALUES (912,'2019-08-08 23:59:44',NULL,190,NULL,NULL,'OnQueue',0,'1565297983.128','SIP/201',NULL,NULL),(913,'2019-08-08 23:59:50',NULL,190,NULL,NULL,'Abandoned',0,'1565297983.128','SIP/201',NULL,NULL),(2280,'2019-08-20 10:12:27',NULL,NULL,5,1,'Placing',1,NULL,'SIP/goip',NULL,NULL),(2281,'2019-08-20 10:12:37',NULL,NULL,5,1,'Ringing',1,'1566285147.0','SIP/goip',NULL,NULL),(2282,'2019-08-20 10:12:37',NULL,NULL,5,1,'OnQueue',1,'1566285147.0','SIP/goip',NULL,NULL),(2283,'2019-08-20 10:12:41',NULL,NULL,5,1,'Success',1,'1566285147.0','SIP/goip',2,NULL),(2284,'2019-08-20 10:13:28',NULL,NULL,5,1,'Hangup',1,'1566285147.0','SIP/goip',2,47),(3013,'2019-09-04 11:33:26',NULL,NULL,5,2,'Placing',1,NULL,'SIP/goip',NULL,NULL),(3014,'2019-09-04 11:33:46',NULL,NULL,5,2,'Ringing',1,'1567586006.52','SIP/goip',NULL,NULL),(3015,'2019-09-04 11:33:47',NULL,NULL,5,2,'OnQueue',1,'1567586006.52','SIP/goip',NULL,NULL),(3016,'2019-09-04 11:33:57',NULL,NULL,5,2,'Success',1,'1567586006.52','SIP/goip',2,NULL),(3017,'2019-09-04 11:34:16',NULL,NULL,5,2,'Hangup',1,'1567586006.52','SIP/goip',2,19),(3018,'2019-09-04 12:23:04',NULL,NULL,5,3,'Placing',1,NULL,'SIP/goip',NULL,NULL),(3019,'2019-09-04 12:23:20',NULL,NULL,5,3,'Ringing',1,'1567588984.54','SIP/goip',NULL,NULL),(3020,'2019-09-04 12:23:20',NULL,NULL,5,3,'OnQueue',1,'1567588984.54','SIP/goip',NULL,NULL),(3021,'2019-09-04 12:24:07',NULL,NULL,5,3,'Success',1,'1567588984.54','SIP/goip',2,NULL),(3022,'2019-09-04 12:24:31',NULL,NULL,5,3,'Hangup',1,'1567588984.54','SIP/goip',2,24),(3023,'2019-09-04 13:50:53',NULL,NULL,5,4,'Placing',1,NULL,'SIP/goip',NULL,NULL),(3024,'2019-09-04 13:51:03',NULL,NULL,5,4,'Ringing',1,'1567594253.56','SIP/goip',NULL,NULL),(3025,'2019-09-04 13:51:03',NULL,NULL,5,4,'OnQueue',1,'1567594253.56','SIP/goip',NULL,NULL),(3026,'2019-09-04 13:51:06',NULL,NULL,5,4,'Success',1,'1567594253.56','SIP/goip',2,NULL),(3027,'2019-09-04 13:51:31',NULL,NULL,5,4,'Hangup',1,'1567594253.56','SIP/goip',2,24),(3028,'2019-09-04 14:58:50',NULL,NULL,5,5,'Placing',1,NULL,'SIP/goip',NULL,NULL),(3029,'2019-09-04 14:59:02',NULL,NULL,5,5,'Ringing',1,'1567598330.83','SIP/goip',NULL,NULL),(3030,'2019-09-04 14:59:02',NULL,NULL,5,5,'OnQueue',1,'1567598330.83','SIP/goip',NULL,NULL),(3031,'2019-09-04 14:59:07',NULL,NULL,5,5,'Success',1,'1567598330.83','SIP/goip',2,NULL),(3032,'2019-09-04 14:59:30',NULL,NULL,5,5,'Hangup',1,'1567598330.83','SIP/goip',2,23),(3033,'2019-09-05 10:08:29',NULL,NULL,5,6,'Placing',1,NULL,'SIP/goip',NULL,NULL),(3034,'2019-09-05 10:08:39',NULL,NULL,5,6,'Ringing',1,'1567667309.2','SIP/goip',NULL,NULL),(3035,'2019-09-05 10:08:39',NULL,NULL,5,6,'OnQueue',1,'1567667309.2','SIP/goip',NULL,NULL),(3036,'2019-09-05 10:08:45',NULL,NULL,5,6,'Success',1,'1567667309.2','SIP/goip',2,NULL),(3037,'2019-09-05 10:09:06',NULL,NULL,5,6,'Hangup',1,'1567667309.2','SIP/goip',2,21);
/*!40000 ALTER TABLE `call_progress_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `call_recording`
--

LOCK TABLES `call_recording` WRITE;
/*!40000 ALTER TABLE `call_recording` DISABLE KEYS */;
INSERT INTO `call_recording` (`id`, `datetime_entry`, `id_call_incoming`, `id_call_outgoing`, `uniqueid`, `channel`, `recordingfile`) VALUES (204,'2019-08-08 23:59:44',190,NULL,'1565297983.128','SIP/201-00000080','2019/08/08/q-7001-201-20190808-235944-1565297983.128.wav'),(871,'2019-08-20 10:12:38',NULL,1,'1566285147.0','SIP/goip-00000000','2019/08/20/q-1000-201-20190820-101237-1566285147.0.wav'),(1236,'2019-09-04 11:33:47',NULL,2,'1567586006.52','SIP/goip-00000034','2019/09/04/q-1000-201-20190904-113346-1567586006.52.wav'),(1237,'2019-09-04 12:23:20',NULL,3,'1567588984.54','SIP/goip-00000036','2019/09/04/q-1000-201-20190904-122320-1567588984.54.wav'),(1238,'2019-09-04 13:51:03',NULL,4,'1567594253.56','SIP/goip-00000038','2019/09/04/q-1000-201-20190904-135103-1567594253.56.wav'),(1239,'2019-09-04 14:59:02',NULL,5,'1567598330.83','SIP/goip-00000053','2019/09/04/q-1000-201-20190904-145902-1567598330.83.wav'),(1240,'2019-09-05 10:08:39',NULL,6,'1567667309.2','SIP/goip-00000002','2019/09/05/q-1000-201-20190905-100839-1567667309.2.wav');
/*!40000 ALTER TABLE `call_recording` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `calls`
--

LOCK TABLES `calls` WRITE;
/*!40000 ALTER TABLE `calls` DISABLE KEYS */;
INSERT INTO `calls` (`id`, `id_campaign`, `phone`, `status`, `uniqueid`, `fecha_llamada`, `start_time`, `end_time`, `retries`, `duration`, `id_agent`, `transfer`, `datetime_entry_queue`, `duration_wait`, `dnc`, `date_init`, `date_end`, `time_init`, `time_end`, `agent`, `failure_cause`, `failure_cause_txt`, `datetime_originate`, `trunk`, `scheduled`) VALUES (1,5,'0532865256','Success','1566285147.0','2019-08-20 10:12:37','2019-08-20 10:12:41','2019-08-20 10:13:28',1,47,2,NULL,'2019-08-20 10:12:37',4,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-08-20 10:12:27','SIP/goip',0),(2,5,'0532865256','Success','1567586006.52','2019-09-04 11:33:46','2019-09-04 11:33:57','2019-09-04 11:34:16',1,19,2,NULL,'2019-09-04 11:33:47',10,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-04 11:33:26','SIP/goip',0),(3,5,'0532865256','Success','1567588984.54','2019-09-04 12:23:20','2019-09-04 12:24:07','2019-09-04 12:24:31',1,24,2,NULL,'2019-09-04 12:23:20',46,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-04 12:23:04','SIP/goip',0),(4,5,'0532865256','Success','1567594253.56','2019-09-04 13:51:03','2019-09-04 13:51:06','2019-09-04 13:51:31',1,24,2,NULL,'2019-09-04 13:51:03',3,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-04 13:50:53','SIP/goip',0),(5,5,'0532865256','Success','1567598330.83','2019-09-04 14:59:02','2019-09-04 14:59:07','2019-09-04 14:59:30',1,23,2,NULL,'2019-09-04 14:59:02',4,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-04 14:58:50','SIP/goip',0),(6,5,'0532865256','Success','1567667309.2','2019-09-05 10:08:39','2019-09-05 10:08:45','2019-09-05 10:09:06',1,21,2,NULL,'2019-09-05 10:08:39',6,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-05 10:08:29','SIP/goip',0),(7,5,'0532865256',NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),(8,5,'0532865256',NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),(9,5,'0532865256',NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `calls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `campaign`
--

LOCK TABLES `campaign` WRITE;
/*!40000 ALTER TABLE `campaign` DISABLE KEYS */;
INSERT INTO `campaign` (`id`, `name`, `datetime_init`, `datetime_end`, `daytime_init`, `daytime_end`, `retries`, `trunk`, `context`, `queue`, `max_canales`, `num_completadas`, `promedio`, `desviacion`, `script`, `estatus`, `id_url`) VALUES (5,'asaf','2019-08-03','2019-12-31','00:00:00','23:00:00',1,'SIP/goip','from-internal','777',0,6,27,13,'asaf<style type=\"text/css\">  body {  	background: #FFF;  }  </style>\r\n    <style type=\"text/css\">  body {  	background: #FFF;  }  </style>\r\n  <style type=\"text/css\">  body {  	background: #FFF;  }  </style>\r\n<style type=\"text/css\">\r\nbody {\r\n	background: #FFF;\r\n}\r\n</style>','I',NULL);
/*!40000 ALTER TABLE `campaign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `campaign_entry`
--

LOCK TABLES `campaign_entry` WRITE;
/*!40000 ALTER TABLE `campaign_entry` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign_entry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `campaign_external_url`
--

LOCK TABLES `campaign_external_url` WRITE;
/*!40000 ALTER TABLE `campaign_external_url` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign_external_url` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `campaign_form`
--

LOCK TABLES `campaign_form` WRITE;
/*!40000 ALTER TABLE `campaign_form` DISABLE KEYS */;
INSERT INTO `campaign_form` (`id_campaign`, `id_form`) VALUES (5,1);
/*!40000 ALTER TABLE `campaign_form` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `campaign_form_entry`
--

LOCK TABLES `campaign_form_entry` WRITE;
/*!40000 ALTER TABLE `campaign_form_entry` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign_form_entry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `contact`
--

LOCK TABLES `contact` WRITE;
/*!40000 ALTER TABLE `contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `current_call_entry`
--

LOCK TABLES `current_call_entry` WRITE;
/*!40000 ALTER TABLE `current_call_entry` DISABLE KEYS */;
/*!40000 ALTER TABLE `current_call_entry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `current_calls`
--

LOCK TABLES `current_calls` WRITE;
/*!40000 ALTER TABLE `current_calls` DISABLE KEYS */;
/*!40000 ALTER TABLE `current_calls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `dont_call`
--

LOCK TABLES `dont_call` WRITE;
/*!40000 ALTER TABLE `dont_call` DISABLE KEYS */;
/*!40000 ALTER TABLE `dont_call` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `eccp_authorized_clients`
--

LOCK TABLES `eccp_authorized_clients` WRITE;
/*!40000 ALTER TABLE `eccp_authorized_clients` DISABLE KEYS */;
INSERT INTO `eccp_authorized_clients` (`id`, `username`, `md5_password`) VALUES (1,'agentconsole','7e53aa92f7566f44f39f3f1842832581');
/*!40000 ALTER TABLE `eccp_authorized_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `form`
--

LOCK TABLES `form` WRITE;
/*!40000 ALTER TABLE `form` DISABLE KEYS */;
INSERT INTO `form` (`id`, `nombre`, `descripcion`, `estatus`) VALUES (1,'name','','A');
/*!40000 ALTER TABLE `form` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `form_data_recolected`
--

LOCK TABLES `form_data_recolected` WRITE;
/*!40000 ALTER TABLE `form_data_recolected` DISABLE KEYS */;
INSERT INTO `form_data_recolected` (`id`, `id_calls`, `id_form_field`, `value`) VALUES (1,1,8,'×›×Ÿ'),(2,1,1,'alex'),(3,1,2,'mwsk'),(4,1,3,'012'),(5,1,4,'201254'),(6,1,5,'125'),(7,1,6,'125'),(8,1,7,'101'),(9,4,8,'×œ×'),(10,4,1,'.denx'),(11,4,2,'jkrdn '),(12,4,3,'Cellcom'),(13,4,4,',sdn'),(14,4,5,''),(15,4,6,''),(16,4,7,'');
/*!40000 ALTER TABLE `form_data_recolected` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `form_data_recolected_entry`
--

LOCK TABLES `form_data_recolected_entry` WRITE;
/*!40000 ALTER TABLE `form_data_recolected_entry` DISABLE KEYS */;
/*!40000 ALTER TABLE `form_data_recolected_entry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `form_field`
--

LOCK TABLES `form_field` WRITE;
/*!40000 ALTER TABLE `form_field` DISABLE KEYS */;
INSERT INTO `form_field` (`id`, `id_form`, `etiqueta`, `value`, `tipo`, `orden`) VALUES (1,1,'×©×:','','TEXT',2),(2,1,'×©× ×ž×©×¤×—×”:','','TEXT',3),(3,1,'compani','partner,Cellcom,HOT,Golani,012,Rami Levi,','LIST',4),(4,1,'×ª.×–:','','TEXT',5),(5,1,'×›×ª×•×‘×ª: ','','TEXT',6),(6,1,'×ž×¡×¤×¨×™× × ×•×¡×¤×™×:','','TEXT',7),(7,1,'×”×¢×¨×•×ª:','','TEXTAREA',8),(8,1,'×ž×¢×•× ×™×Ÿ','×œ×,×›×Ÿ,','LIST',1);
/*!40000 ALTER TABLE `form_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `queue_call_entry`
--

LOCK TABLES `queue_call_entry` WRITE;
/*!40000 ALTER TABLE `queue_call_entry` DISABLE KEYS */;
INSERT INTO `queue_call_entry` (`id`, `queue`, `date_init`, `time_init`, `date_end`, `time_end`, `estatus`, `script`) VALUES (1,'7001',NULL,NULL,NULL,NULL,'I','out<style type=\"text/css\">\r\nbody {\r\n	background: #FFF;\r\n}\r\n</style>');
/*!40000 ALTER TABLE `queue_call_entry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `valor_config`
--

LOCK TABLES `valor_config` WRITE;
/*!40000 ALTER TABLE `valor_config` DISABLE KEYS */;
INSERT INTO `valor_config` (`config_key`, `config_value`, `config_blob`) VALUES ('asterisk.asthost','127.0.0.1',NULL),('asterisk.astpass','',NULL),('asterisk.astuser','',NULL),('asterisk.duracion_sesion','0',NULL),('dialer.forzar_sobrecolocar','0',NULL),('dialer.llamada_corta','10',NULL),('dialer.overcommit','0',NULL),('dialer.predictivo','1',NULL),('dialer.qos','0.97',NULL),('dialer.tiempo_contestar','8',NULL),('dialer.timeout_inactivity','15',NULL),('dialer.timeout_originate','0',NULL);
/*!40000 ALTER TABLE `valor_config` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-04-29 23:59:11
