-- MySQL dump 10.14  Distrib 5.5.68-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: qstats
-- ------------------------------------------------------
-- Server version	5.5.68-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `acl`
--

DROP TABLE IF EXISTS `acl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `acl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource` varchar(50) DEFAULT NULL,
  `level` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `byresource` (`resource`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `agent_activity`
--

DROP TABLE IF EXISTS `agent_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `agent_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `queue` varchar(80) DEFAULT NULL,
  `agent` varchar(100) DEFAULT NULL,
  `event` varchar(40) DEFAULT NULL,
  `data` varchar(150) DEFAULT NULL,
  `lastedforseconds` int(11) DEFAULT NULL,
  `uniqueid` varchar(100) DEFAULT NULL,
  `computed` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uni` (`datetime`,`queue`,`agent`,`event`,`uniqueid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `designer`
--

DROP TABLE IF EXISTS `designer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `designer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(50) DEFAULT NULL,
  `parameter` varchar(250) NOT NULL DEFAULT '',
  `value` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `keypar` (`keyword`,`parameter`),
  KEY `keyindex` (`keyword`)
) ENGINE=MyISAM AUTO_INCREMENT=220 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqname`
--

DROP TABLE IF EXISTS `gqname`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `gqname` (
  `groupname_id` int(11) NOT NULL AUTO_INCREMENT,
  `groupname` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`groupname_id`),
  UNIQUE KEY `name` (`groupname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqnameqname`
--

DROP TABLE IF EXISTS `gqnameqname`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `gqnameqname` (
  `gqname_groupname_id` int(11) DEFAULT NULL,
  `qname_queue_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `language`
--

DROP TABLE IF EXISTS `language`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `language` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `iso_code` varchar(5) COLLATE utf8_bin NOT NULL DEFAULT 'en',
  `string` text COLLATE utf8_bin,
  `translation` text COLLATE utf8_bin,
  `pending` tinyint(1) DEFAULT '1',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx` (`iso_code`,`string`(64)),
  KEY `stindex` (`string`(200))
) ENGINE=MyISAM AUTO_INCREMENT=3115 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `plugins`
--

DROP TABLE IF EXISTS `plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rawname` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` tinytext NOT NULL,
  `enabled` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `qagent`
--

DROP TABLE IF EXISTS `qagent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `qagent` (
  `agent_id` int(6) NOT NULL AUTO_INCREMENT,
  `agent` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`agent_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `qevent`
--

DROP TABLE IF EXISTS `qevent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `qevent` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `event` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`event_id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `qname`
--

DROP TABLE IF EXISTS `qname`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `qname` (
  `queue_id` int(11) NOT NULL AUTO_INCREMENT,
  `queue` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`queue_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `qstats.queue_stats_mv`
--

DROP TABLE IF EXISTS `qstats.queue_stats_mv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `qstats.queue_stats_mv` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datetimeconnect` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `datetimeend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `queue` varchar(100) NOT NULL DEFAULT '',
  `agent` varchar(100) NOT NULL DEFAULT '',
  `event` varchar(40) NOT NULL DEFAULT '',
  `uniqueid` varchar(50) NOT NULL DEFAULT '',
  `clid` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `did` varchar(100) NOT NULL DEFAULT '',
  `position` int(6) unsigned NOT NULL DEFAULT '1',
  `info1` varchar(50) NOT NULL DEFAULT '',
  `info2` varchar(50) NOT NULL DEFAULT '',
  `info3` varchar(50) NOT NULL DEFAULT '',
  `info4` varchar(50) NOT NULL DEFAULT '',
  `info5` varchar(50) NOT NULL DEFAULT '',
  `overflow` int(6) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uni` (`uniqueid`),
  KEY `fecha` (`datetime`),
  KEY `ev` (`event`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_stats`
--

DROP TABLE IF EXISTS `queue_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `queue_stats` (
  `queue_stats_id` int(12) NOT NULL AUTO_INCREMENT,
  `uniqueid` varchar(40) DEFAULT NULL,
  `datetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `qname` int(6) DEFAULT NULL,
  `qagent` int(6) DEFAULT NULL,
  `qevent` int(2) DEFAULT NULL,
  `info1` varchar(50) NOT NULL,
  `info2` varchar(50) NOT NULL,
  `info3` varchar(50) NOT NULL,
  `info4` varchar(50) NOT NULL,
  `info5` varchar(50) NOT NULL,
  PRIMARY KEY (`queue_stats_id`),
  UNIQUE KEY `unico` (`uniqueid`,`datetime`,`qname`,`qagent`,`qevent`),
  KEY `ixevent` (`qevent`),
  KEY `ixdate` (`datetime`),
  KEY `ixuni` (`uniqueid`),
  KEY `ixagent` (`qagent`),
  KEY `combieventuni` (`qevent`,`uniqueid`)
) ENGINE=MyISAM AUTO_INCREMENT=714 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`qstatsUser`@`localhost`*/ /*!50003 TRIGGER queue_stats_ins
AFTER INSERT ON queue_stats
FOR EACH ROW
BEGIN

SET @event_name = ''; SET @queue_name = ''; SET @agent_name = ''; SET @enterdate  = '';
SET @connectdate= ''; SET @clid       = ''; SET @position   = ''; SET @url        = '';
set @overflow   = ''; SET @firstenter = ''; SET @lastenter  = ''; SET @did        = '';

SELECT event FROM qevent WHERE event_id = NEW.qevent INTO @event_name;
SELECT agent FROM qagent WHERE agent_id = NEW.qagent INTO @agent_name;
SELECT queue FROM qname  WHERE queue_id = NEW.qname  INTO @queue_name;

IF @event_name LIKE 'COMPLETE%' THEN

/*answered calls*/

/* Elige el primer evento ENTERQUEUE, y si elijo el ultimo? (DESC) */
SELECT datetime,info1,info2,info3,info5 FROM queue_stats JOIN qevent ON qevent=event_id WHERE event='ENTERQUEUE'
AND uniqueid=NEW.uniqueid ORDER BY datetime LIMIT 1 INTO @enterdate,@url,@clid,@position,@did;

/* Elige el ultimo evento CONNECT */
SELECT datetime FROM queue_stats JOIN qevent ON qevent=event_id
WHERE event='CONNECT' AND uniqueid=NEW.uniqueid ORDER BY datetime DESC LIMIT 1 INTO @connectdate;

SELECT IF(count(uniqueid)>1,1,0) FROM queue_stats JOIN qevent ON qevent=event_id WHERE event='ENTERQUEUE'
AND uniqueid=NEW.uniqueid INTO @overflow;


/*
SELECT COUNT(*),SUBSTRING_INDEX(GROUP_CONCAT(datetime),',',1),SUBSTRING_INDEX(GROUP_CONCAT(datetime),',',-1)
FROM queue_stats LEFT JOIN qevent ON qevent = qevent.event_id  WHERE uniqueid=NEW.uniqueid AND event='ENTERQUEUE'
INTO @overflow,@firstenter,@lastenter;
*/

REPLACE INTO queue_stats_mv (uniqueid,event,agent,queue,datetime,datetimeconnect,datetimeend,clid,position,url,did,overflow,info1,info2,info3,info4,info5)
VALUES (NEW.uniqueid,@event_name,@agent_name,@queue_name,@enterdate,@connectdate,NEW.datetime,@clid,IFNULL(NEW.info3,1),IFNULL(@url,''),IFNULL(@did,''),@overflow,IFNULL(NEW.info1,''),IFNULL(NEW.info2,''),IFNULL(NEW.info3,''),IFNULL(NEW.info4,''),IFNULL(NEW.info5,''));

ELSEIF @event_name='TRANSFER' OR @event_name='UPDATETRANSFER' THEN

/*transferred calls*/

SELECT datetime,info1,info2,info3,info5 FROM queue_stats JOIN qevent ON qevent=event_id WHERE event='ENTERQUEUE'
AND uniqueid=NEW.uniqueid ORDER BY datetime LIMIT 1 INTO @enterdate,@url,@clid,@position,@did;

SELECT datetime FROM queue_stats JOIN qevent ON qevent=event_id
WHERE event='CONNECT' AND uniqueid=NEW.uniqueid ORDER BY datetime DESC LIMIT 1 INTO @connectdate;

SELECT count(*) FROM queue_stats JOIN qevent ON qevent=event_id WHERE event='ENTERQUEUE'
AND uniqueid=NEW.uniqueid INTO @overflow;

REPLACE INTO queue_stats_mv (uniqueid,event,agent,queue,datetime,datetimeconnect,datetimeend,clid,position,url,did,info1,info2,overflow,info3,info4,info5)
VALUES (NEW.uniqueid,'TRANSFER',@agent_name,@queue_name,@enterdate,@connectdate,NEW.datetime,@clid,IFNULL(@position,1),IFNULL(@url,''),IFNULL(@did,''),IFNULL(NEW.info1,0),IFNULL(NEW.info2,0),@overflow,IFNULL(NEW.info3,''),IFNULL(NEW.info4,''),IFNULL(NEW.info5,''));

ELSEIF @event_name LIKE '%ABANDON%' OR @event_name LIKE 'EXIT%' OR @event_name='BUSY' OR @event_name='CONGESTION' OR @event_name='CHANUNAVAIL' OR @event_name='DONTCALL' OR @event_name='TORTURE' OR @event_name='INVALIDARGS' THEN

/*unanswered calls*/

SELECT datetime,info1,info2,info3,info5 FROM queue_stats JOIN qevent ON qevent=event_id WHERE event='ENTERQUEUE'
AND uniqueid=NEW.uniqueid ORDER BY datetime LIMIT 1 INTO @enterdate,@url,@clid,@position,@did;

SELECT count(*) FROM queue_stats JOIN qevent ON qevent=event_id WHERE event='ENTERQUEUE'
AND uniqueid=NEW.uniqueid INTO @overflow;

SET @connectdate = @enterdate;

REPLACE INTO queue_stats_mv (uniqueid,event,agent,queue,datetime,datetimeconnect,datetimeend,clid,position,url,did,info1,info2,overflow,info3,info4,info5)
VALUES (NEW.uniqueid,@event_name,@agent_name,@queue_name,@enterdate,@connectdate,NEW.datetime,IFNULL(@clid,''),IFNULL(@position,1),IFNULL(@url,''),IFNULL(@did,''),IFNULL(NEW.info1,0),IFNULL(NEW.info2,0),@overflow,IFNULL(NEW.info3,''),IFNULL(NEW.info4,''),IFNULL(NEW.info5,''));

ELSEIF @event_name LIKE 'AGENT%' OR @event_name LIKE '%PAUSE%' OR @event_name LIKE '%MEMBER%' THEN

/* login, pausa, etc */

INSERT INTO queue_stats_mv (uniqueid,event,agent,queue,datetime,datetimeconnect,datetimeend,info1,info2,info3,info4,info5)
VALUES (CONCAT_WS('.','x',UNIX_TIMESTAMP(NOW()),NEW.queue_stats_id),@event_name,@agent_name,@queue_name,NEW.datetime,NEW.datetime,NEW.datetime,IFNULL(NEW.info1,0),IFNULL(NEW.info2,0),IFNULL(NEW.info3,''),IFNULL(NEW.info4,''),IFNULL(NEW.info5,''));

END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Temporary table structure for view `queue_stats_full`
--

DROP TABLE IF EXISTS `queue_stats_full`;
/*!50001 DROP VIEW IF EXISTS `queue_stats_full`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE TABLE IF NOT EXISTS `queue_stats_full` (
  `queue_stats_id` tinyint NOT NULL,
  `uniqueid` tinyint NOT NULL,
  `datetime` tinyint NOT NULL,
  `qname` tinyint NOT NULL,
  `qagent` tinyint NOT NULL,
  `qevent` tinyint NOT NULL,
  `info1` tinyint NOT NULL,
  `info2` tinyint NOT NULL,
  `info3` tinyint NOT NULL,
  `info4` tinyint NOT NULL,
  `info5` tinyint NOT NULL,
  `event` tinyint NOT NULL,
  `agent` tinyint NOT NULL,
  `queue` tinyint NOT NULL
) ENGINE=MyISAM */;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `queue_stats_mv`
--

DROP TABLE IF EXISTS `queue_stats_mv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `queue_stats_mv` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` datetime DEFAULT '0000-00-00 00:00:00',
  `datetimeconnect` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `datetimeend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `queue` varchar(100) NOT NULL DEFAULT '',
  `agent` varchar(100) NOT NULL DEFAULT '',
  `event` varchar(40) NOT NULL DEFAULT '',
  `uniqueid` varchar(50) NOT NULL DEFAULT '',
  `clid` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `did` varchar(100) NOT NULL DEFAULT '',
  `position` int(6) unsigned NOT NULL DEFAULT '1',
  `info1` varchar(50) NOT NULL DEFAULT '',
  `info2` varchar(50) NOT NULL DEFAULT '',
  `info3` varchar(50) NOT NULL DEFAULT '',
  `info4` varchar(50) NOT NULL DEFAULT '',
  `info5` varchar(50) NOT NULL DEFAULT '',
  `overflow` int(6) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uni` (`uniqueid`),
  KEY `fecha` (`datetime`),
  KEY `ev` (`event`)
) ENGINE=InnoDB AUTO_INCREMENT=387 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recordings`
--

DROP TABLE IF EXISTS `recordings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `recordings` (
  `uniqueid` varchar(40) NOT NULL DEFAULT '',
  `filename` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`uniqueid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sched`
--

DROP TABLE IF EXISTS `sched`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `sched` (
  `schid` int(6) NOT NULL AUTO_INCREMENT,
  `dest` text,
  `reports` text,
  `lastdays` smallint(4) DEFAULT NULL,
  `field` varchar(40) DEFAULT '',
  `exceed` varchar(40) DEFAULT '',
  `crondaymonth` varchar(40) DEFAULT '*',
  `crondayweek` varchar(40) DEFAULT '*',
  `cronhour` varchar(20) DEFAULT '*',
  `cronminute` varchar(20) DEFAULT '*',
  `lastrun` datetime DEFAULT NULL,
  `active` tinyint(4) DEFAULT '1',
  `queues` text,
  PRIMARY KEY (`schid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `secure_level`
--

DROP TABLE IF EXISTS `secure_level`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `secure_level` (
  `level` int(11) NOT NULL DEFAULT '0',
  `detail` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `setup`
--

DROP TABLE IF EXISTS `setup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `setup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(50) DEFAULT NULL,
  `parameter` varchar(50) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `keypar` (`keyword`,`parameter`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sqlrealtime`
--

DROP TABLE IF EXISTS `sqlrealtime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `sqlrealtime` (
  `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `data` longtext,
  `user` varchar(100) NOT NULL,
  PRIMARY KEY (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_filter`
--

DROP TABLE IF EXISTS `user_filter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `user_filter` (
  `user` varchar(30) DEFAULT NULL,
  `param` varchar(30) DEFAULT NULL,
  `value` varchar(100) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userqagent`
--

DROP TABLE IF EXISTS `userqagent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `userqagent` (
  `users_id` int(6) DEFAULT NULL,
  `qagent_agent_id` int(6) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userqname`
--

DROP TABLE IF EXISTS `userqname`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `userqname` (
  `users_id` int(6) DEFAULT NULL,
  `qname_queue_id` int(6) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(30) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `level` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nombre` (`login`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Final view structure for view `queue_stats_full`
--

/*!50001 DROP TABLE IF EXISTS `queue_stats_full`*/;
/*!50001 DROP VIEW IF EXISTS `queue_stats_full`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`qstatsUser`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `queue_stats_full` AS select `q`.`queue_stats_id` AS `queue_stats_id`,`q`.`uniqueid` AS `uniqueid`,`q`.`datetime` AS `datetime`,`q`.`qname` AS `qname`,`q`.`qagent` AS `qagent`,`q`.`qevent` AS `qevent`,`q`.`info1` AS `info1`,`q`.`info2` AS `info2`,`q`.`info3` AS `info3`,`q`.`info4` AS `info4`,`q`.`info5` AS `info5`,`qevent`.`event` AS `event`,`qagent`.`agent` AS `agent`,`qname`.`queue` AS `queue` from (((`queue_stats` `q` FORCE INDEX (`ixdate`) left join `qagent` on((`q`.`qagent` = `qagent`.`agent_id`))) left join `qname` on((`q`.`qname` = `qname`.`queue_id`))) left join `qevent` on((`q`.`qevent` = `qevent`.`event_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-04-29 23:59:11
-- MySQL dump 10.14  Distrib 5.5.68-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: qstats
-- ------------------------------------------------------
-- Server version	5.5.68-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `acl`
--

LOCK TABLES `acl` WRITE;
/*!40000 ALTER TABLE `acl` DISABLE KEYS */;
INSERT INTO `acl` (`id`, `resource`, `level`) VALUES (1,'admin-acl.php','2'),(2,'distribution_summary.php','7'),(3,'distribution_by_queue.php','7'),(4,'distribution_by_month.php','7'),(5,'distribution_by_week.php','7'),(6,'distribution_by_day.php','7'),(7,'distribution_by_hour.php','7'),(8,'distribution_by_day_of_week.php','7'),(9,'distribution_by_url.php','7'),(10,'distribution_detail.php','7'),(11,'answered_calls_summary.php','7'),(12,'answered_calls_by_holdtime.php','7'),(13,'answered_calls_by_queue.php','7'),(14,'answered_calls_by_agent.php','7'),(15,'answered_calls_by_event.php','7'),(16,'answered_calls_by_url.php','7'),(17,'answered_calls_by_duration.php','7'),(18,'answered_calls_transferred.php','7'),(19,'answered_calls_detail.php','7'),(20,'unanswered_calls_summary.php','7'),(21,'unanswered_calls_by_holdtime.php','7'),(22,'unanswered_calls_by_event.php','7'),(23,'unanswered_calls_by_queue.php','7'),(24,'unanswered_calls_by_url.php','7'),(25,'unanswered_calls_detail.php','7'),(26,'agent_summary.php','7'),(27,'agent_availability.php','7'),(29,'agent_pauses.php','7'),(30,'agent_dispositions.php','7'),(31,'agent_detail.php','7'),(32,'admin-setup.php','2'),(33,'admin-designer.php','2'),(34,'admin-users.php','2'),(35,'admin-language.php','10'),(36,'admin-schedule.php','10'),(37,'recordings','7'),(38,'search.php','7'),(39,'realtime.php','7'),(40,'call details drill down','7'),(41,'agent_dispositions','7'),(42,'realtime_queue_summary.php','7'),(43,'realtime_waiting_calls.php','7'),(44,'realtime_agent_status.php','7'),(45,'admin-sched.php','7'),(46,'realtime-agents-status','7'),(47,'realtime-waiting-calls','7'),(48,'index.php','7'),(49,'answered.php','7'),(50,'unanswered.php','7'),(51,'agent.php','7'),(52,'distribution_calls_det','7'),(53,'distribution.php','7'),(54,'add_config','7'),(55,'delete_marked_keyword','7'),(56,'answered_calls_by_queue','7'),(57,'answered_calls_by_agent','7'),(58,'answered_calls_by_url','7'),(59,'call_response','7'),(60,'disconnect_cause','7'),(61,'answered_calls_det','7'),(62,'transfers','7');
/*!40000 ALTER TABLE `acl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `agent_activity`
--

LOCK TABLES `agent_activity` WRITE;
/*!40000 ALTER TABLE `agent_activity` DISABLE KEYS */;
/*!40000 ALTER TABLE `agent_activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `designer`
--

LOCK TABLES `designer` WRITE;
/*!40000 ALTER TABLE `designer` DISABLE KEYS */;
INSERT INTO `designer` (`id`, `keyword`, `parameter`, `value`) VALUES (1,'agent_reports','','agent_summary.php,agent_availability.php,agent_pauses.php,agent_dispositions.php,agent_detail.php'),(2,'ANSWERED_DISPLAY_GRID','event','6,6'),(3,'ANSWERED_DISPLAY_GRID','holdtime','7,5'),(4,'ANSWERED_DISPLAY_GRID','queue','6,6'),(5,'ANSWERED_DISPLAY_ROWS','agent','Received,Completed,Transferred,%% Calls,Talk Time,%% Talk Time,Avg Talk Time,Ring Time,Wait Time,Avg Wait Time,Max Wait Time'),(6,'ANSWERED_DISPLAY_ROWS','duration','Received,Completed,Transferred,%% Calls,Talk Time,%% Talk Time,Avg Talk Time,Wait Time,Avg Wait Time,Max Wait Time'),(7,'ANSWERED_DISPLAY_ROWS','event','Received,%% Calls'),(8,'ANSWERED_DISPLAY_ROWS','holdtime','Count,Delta,%%'),(9,'ANSWERED_DISPLAY_ROWS','queue','Received,%% Calls'),(10,'answered_reports','','answered_calls_summary.php,answered_calls_by_holdtime.php,answered_calls_by_queue.php,answered_calls_by_agent.php,answered_calls_by_event.php,answered_calls_by_url.php,answered_calls_by_did.php,answered_calls_by_duration.php,answered_calls_transferred.php,answered_calls_detail.php'),(11,'CHART_ANSWERED','01,agent,Number of Calls per Agent','Completed'),(12,'CHART_ANSWERED','01,event','Received'),(13,'CHART_ANSWERED','01,holdtime','Delta'),(14,'CHART_ANSWERED','01,queue','Received'),(15,'CHART_ANSWERED','02,agent,Total Time per Agent (seconds)','Talk Time'),(16,'CHART_DISTRIBUTION','01,day','Answered,Transferred,Abandoned,Unanswered'),(17,'CHART_DISTRIBUTION','01,day_of_week,Answered by Day','Answered'),(18,'CHART_DISTRIBUTION','01,hour,Answered/Abandoned per Hour','Answered,Abandoned'),(19,'CHART_DISTRIBUTION','01,queue','Answered,Abandoned'),(20,'CHART_DISTRIBUTION','02,day_of_week,Unanswered by Day','Abandoned'),(21,'CHART_DISTRIBUTION','02,hour','Avg Wait,Avg Talk'),(22,'CHART_DISTRIBUTION','02,queue','Avg Wait,Avg Talk'),(23,'CHART_DISTRIBUTION','03,day_of_week,Average Wait Time by Day','Avg Wait'),(24,'CHART_DISTRIBUTION','04,day_of_week,Average Duration by Day','Avg Talk'),(25,'CHART_UNANSWERED','01,event','Total'),(26,'CHART_UNANSWERED','01,holdtime','Delta'),(27,'CHART_UNANSWERED','01,queue,Answered/Abandoned','Abandoned,Unanswered'),(28,'COLUMN_ANSWERED','%%','(SUM_RECEIVED*100)/TOTAL_RECEIVED'),(29,'COLUMN_ANSWERED','%% Calls','RECEIVED*100/TOTAL_RECEIVED'),(30,'COLUMN_ANSWERED','%% Talk Time','((ANSWERED_TALK_TIME+TRANSFERRED_TALK_TIME)*100)/(TOTAL_ANSWERED_TALK_TIME+TOTAL_TRANSFERRED_TALK_TIME)'),(31,'COLUMN_ANSWERED','Avg Talk Time','(ANSWERED_TALK_TIME+TRANSFERRED_TALK_TIME)/RECEIVED'),(32,'COLUMN_ANSWERED','Avg Wait Time','(ANSWERED_WAIT_TIME + TRANSFERRED_WAIT_TIME) / RECEIVED'),(33,'COLUMN_ANSWERED','Completed','ANSWERED'),(34,'COLUMN_ANSWERED','Count','SUM_RECEIVED'),(35,'COLUMN_ANSWERED','Delta','RECEIVED'),(36,'COLUMN_ANSWERED','Max Wait Time','MAX_ANSWERED_WAIT_TIME'),(37,'COLUMN_ANSWERED','Received','RECEIVED'),(38,'COLUMN_ANSWERED','Talk Time','ANSWERED_TALK_TIME+TRANSFERRED_TALK_TIME'),(39,'COLUMN_ANSWERED','Transferred','TRANSFERRED'),(40,'COLUMN_ANSWERED','Wait Time','ANSWERED_WAIT_TIME+TRANSFERRED_WAIT_TIME'),(41,'COLUMN_ANSWERED_FORMAT','%%','%.2f %%'),(42,'COLUMN_ANSWERED_FORMAT','%% Calls','%.2f %%'),(43,'COLUMN_ANSWERED_FORMAT','%% Talk Time','%.2f %%'),(44,'COLUMN_ANSWERED_FORMAT','Avg Talk Time','{HH}:{MM}:{SS}'),(45,'COLUMN_ANSWERED_FORMAT','Avg Wait Time','{HH}:{MM}:{SS}'),(46,'COLUMN_ANSWERED_FORMAT','Count','%d'),(47,'COLUMN_ANSWERED_FORMAT','Delta','+%d'),(48,'COLUMN_ANSWERED_FORMAT','Max Wait Time','{HH}:{MM}:{SS}'),(49,'COLUMN_ANSWERED_FORMAT','Talk Time','{HH}:{MM}:{SS}'),(50,'COLUMN_ANSWERED_FORMAT','Wait Time','{HH}:{MM}:{SS}'),(51,'COLUMN_DISTRIBUTION','%% Answ','round((ANSWERED*100)/RECEIVED,2)'),(52,'COLUMN_DISTRIBUTION','%% Unansw','round(((UNANSWERED+ABANDONED)*100)/RECEIVED,2)'),(53,'COLUMN_DISTRIBUTION','Abandoned','ABANDONED'),(54,'COLUMN_DISTRIBUTION','Answered','ANSWERED'),(55,'COLUMN_DISTRIBUTION','Avg Talk','intval((ANSWERED_TALK_TIME +  TRANSFERRED_TALK_TIME) / (ANSWERED + TRANSFERRED))'),(56,'COLUMN_DISTRIBUTION','Avg Wait','intval((ANSWERED_WAIT_TIME + TRANSFERRED_WAIT_TIME + UNANSWERED_WAIT_TIME + ABANDONED_WAIT_TIME) / RECEIVED)'),(57,'COLUMN_DISTRIBUTION','Logins','LOGIN'),(58,'COLUMN_DISTRIBUTION','Logoff','LOGOUT'),(59,'COLUMN_DISTRIBUTION','Max Callers','MAX_CALLERS_WAITING'),(60,'COLUMN_DISTRIBUTION','Received','RECEIVED'),(61,'COLUMN_DISTRIBUTION','SLA','round((ANSWERED_SLA / RECEIVED)*100,2)'),(62,'COLUMN_DISTRIBUTION','Transferred','TRANSFERRED'),(63,'COLUMN_DISTRIBUTION','Unanswered','UNANSWERED'),(64,'COLUMN_DISTRIBUTION_FORMAT','%% Answ','%s %%'),(65,'COLUMN_DISTRIBUTION_FORMAT','%% Unansw','%s %%'),(66,'COLUMN_DISTRIBUTION_FORMAT','Avg Talk','{HH}:{MM}:{SS}'),(67,'COLUMN_DISTRIBUTION_FORMAT','Avg Wait','{HH}:{MM}:{SS}'),(68,'COLUMN_DISTRIBUTION_FORMAT','SLA','%s %%'),(69,'COLUMN_RECEIVED','','COMPLETECALLER,COMPLETEAGENT,ABANDON,EXITEMPTY,EXITWITHKEY,EXITWITHTIMEOUT,TRANSFER'),(70,'COLUMN_TRANSFERRED','','TRANSFER'),(71,'COLUMN_UNANSWERED','%%','((SUM_ABANDONED+SUM_UNANSWERED)*100)/(TOTAL_ABANDONED+TOTAL_UNANSWERED)'),(72,'COLUMN_UNANSWERED','%% Calls','((ABANDONED+UNANSWERED)*100)/(TOTAL_UNANSWERED+TOTAL_ABANDONED)'),(73,'COLUMN_UNANSWERED','Abandoned','ABANDONED'),(74,'COLUMN_UNANSWERED','Count','SUM_ABANDONED+SUM_UNANSWERED'),(75,'COLUMN_UNANSWERED','Delta','ABANDONED+UNANSWERED'),(76,'COLUMN_UNANSWERED','Total','UNANSWERED+ABANDONED'),(77,'COLUMN_UNANSWERED','Unanswered','UNANSWERED'),(78,'COLUMN_UNANSWERED_FORMAT','%%','%.2f %%'),(79,'COLUMN_UNANSWERED_FORMAT','%% Calls','%.2f %%'),(80,'COLUMN_UNANSWERED_FORMAT','Delta','+%d'),(81,'DISTRIBUTION_DISPLAY_ROWS','day','Received,Answered,Unanswered,Abandoned,Transferred,Logins,Logoff,Avg Wait,Avg Talk,Max Callers,%% Answ,%% Unansw,SLA'),(82,'DISTRIBUTION_DISPLAY_ROWS','day_of_week','Received,Answered,Unanswered,Abandoned,Transferred,Logins,Logoff,Avg Wait,Avg Talk,Max Callers,%% Answ,%% Unansw,SLA'),(83,'DISTRIBUTION_DISPLAY_ROWS','hour','Received,Answered,Unanswered,Abandoned,Transferred,Logins,Logoff,Avg Wait,Avg Talk,Max Callers,%% Answ,%% Unansw,SLA'),(84,'DISTRIBUTION_DISPLAY_ROWS','month','Received,Answered,Unanswered,Abandoned,Transferred,Logins,Logoff,Avg Wait,Avg Talk,Max Callers,%% Answ,%% Unansw,SLA'),(85,'DISTRIBUTION_DISPLAY_ROWS','queue','Received,Answered,Unanswered,Abandoned,Transferred,Logins,Logoff,Avg Wait,Avg Talk,Max Callers,%% Answ,%% Unansw,SLA'),(86,'DISTRIBUTION_DISPLAY_ROWS','url','Received,Answered,Unanswered,Abandoned,Transferred,Logins,Logoff,Avg Wait,Avg Talk,Max Callers,%% Answ,%% Unansw,SLA'),(87,'DISTRIBUTION_DISPLAY_ROWS','week','Received,Answered,Unanswered,Abandoned,Transferred,Logins,Logoff,Avg Wait,Avg Talk,Max Callers,%% Answ,%% Unansw,SLA'),(88,'distribution_reports','','distribution_summary.php,distribution_by_queue.php,distribution_by_month.php,distribution_by_week.php,distribution_by_day.php,distribution_by_hour.php,distribution_by_day_of_week.php,distribution_by_url.php,distribution_by_did.php,distribution_by_agent.php,distribution_detail.php'),(89,'EVENT_ABANDONED','','ABANDON'),(90,'EVENT_ANSWERED','','COMPLETECALLER,COMPLETEAGENT'),(91,'EVENT_LOGIN','','AGENTLOGIN,ADDMEMBER'),(92,'EVENT_LOGOUT','','AGENTLOGOFF,REMOVEMEMBER'),(93,'EVENT_RECEIVED','','COMPLETECALLER,COMPLETEAGENT,ABANDON,EXITEMPTY,EXITWITHKEY,EXITWITHTIMEOUT,TRANSFER'),(94,'EVENT_TRANSFERRED','','TRANSFER'),(95,'EVENT_UNANSWERED','','EXITWITHKEY,EXITEMPTY,EXITWITHTIMEOUT'),(96,'setup_reports','','admin-setup.php,admin-designer.php,admin-users.php,admin-acl.php,admin-plugins.php,admin-language.php,admin-schedule.php'),(97,'TOTAL_COLUMN_ANSWERED','%% Calls','SUM_COL'),(98,'TOTAL_COLUMN_ANSWERED','%% Talk Time','SUM_COL'),(99,'TOTAL_COLUMN_ANSWERED','Avg Talk Time','(TOTAL_ANSWERED_TALK_TIME+TOTAL_TRANSFERRED_TALK_TIME)/TOTAL_RECEIVED'),(100,'TOTAL_COLUMN_ANSWERED','Avg Wait Time','(TOTAL_ANSWERED_WAIT_TIME+TOTAL_TRANSFERRED_WAIT_TIME)/TOTAL_RECEIVED'),(101,'TOTAL_COLUMN_ANSWERED','Completed','SUM_COL'),(102,'TOTAL_COLUMN_ANSWERED','Count','TOTAL_RECEIVED'),(103,'TOTAL_COLUMN_ANSWERED','Max Wait Time','MAX_COL'),(104,'TOTAL_COLUMN_ANSWERED','Received','SUM_COL'),(105,'TOTAL_COLUMN_ANSWERED','Talk Time','SUM_COL'),(106,'TOTAL_COLUMN_ANSWERED','Transferred','SUM_COL'),(107,'TOTAL_COLUMN_ANSWERED','Wait Time','SUM_COL'),(108,'TOTAL_COLUMN_DISTRIBUTION','%% Answ','round((SUM_ANSWERED*100)/SUM_RECEIVED,2)'),(109,'TOTAL_COLUMN_DISTRIBUTION','%% Unansw','round(((SUM_UNANSWERED+SUM_ABANDONED)*100)/SUM_RECEIVED,2)'),(110,'TOTAL_COLUMN_DISTRIBUTION','Abandoned','SUM_COL'),(111,'TOTAL_COLUMN_DISTRIBUTION','Answered','SUM_COL'),(112,'TOTAL_COLUMN_DISTRIBUTION','Avg Talk','intval((SUM_ANSWERED_TALK_TIME +  SUM_TRANSFERRED_TALK_TIME) / (SUM_ANSWERED + SUM_TRANSFERRED))'),(113,'TOTAL_COLUMN_DISTRIBUTION','Avg Wait','intval((SUM_ANSWERED_WAIT_TIME + SUM_TRANSFERRED_WAIT_TIME + SUM_UNANSWERED_WAIT_TIME + SUM_ABANDONED_WAIT_TIME) / SUM_RECEIVED)'),(114,'TOTAL_COLUMN_DISTRIBUTION','Logins','SUM_COL'),(115,'TOTAL_COLUMN_DISTRIBUTION','Logoff','SUM_COL'),(116,'TOTAL_COLUMN_DISTRIBUTION','Max Callers','MAX_COL'),(117,'TOTAL_COLUMN_DISTRIBUTION','Received','SUM_COL'),(118,'TOTAL_COLUMN_DISTRIBUTION','SLA','round((SUM_ANSWERED_SLA / SUM_RECEIVED)*100,2)'),(119,'TOTAL_COLUMN_DISTRIBUTION','Transferred','SUM_COL'),(120,'TOTAL_COLUMN_DISTRIBUTION','Unanswered','SUM_COL'),(121,'TOTAL_COLUMN_UNANSWERED','%% Calls','SUM_COL'),(122,'TOTAL_COLUMN_UNANSWERED','Abandoned','SUM_COL'),(123,'TOTAL_COLUMN_UNANSWERED','Count','TOTAL_UNANSWERED+TOTAL_ABANDONED'),(124,'TOTAL_COLUMN_UNANSWERED','Total','SUM_COL'),(125,'TOTAL_COLUMN_UNANSWERED','Unanswered','SUM_COL'),(126,'UNANSWERED_DISPLAY_GRID','event','7,5'),(127,'UNANSWERED_DISPLAY_GRID','holdtime','7,5'),(128,'UNANSWERED_DISPLAY_ROWS','event','Total,%% Calls'),(129,'UNANSWERED_DISPLAY_ROWS','holdtime','Count,Delta,%%'),(130,'UNANSWERED_DISPLAY_ROWS','queue','Total,Abandoned,Unanswered,%% Calls'),(131,'UNANSWERED_DISPLAY_ROWS','url','Total,Abandoned,Unanswered,%% Calls'),(132,'unanswered_reports','','unanswered_calls_summary.php,unanswered_calls_by_holdtime.php,unanswered_calls_by_event.php,unanswered_calls_by_queue.php,unanswered_calls_by_url.php,unanswered_calls_by_did.php,unanswered_calls_detail.php'),(135,'COLUMN_REALTIME','Received','RECEIVED'),(136,'COLUMN_REALTIME','Answered','ANSWERED'),(137,'COLUMN_REALTIME','Abandoned','ABANDONED'),(138,'COLUMN_REALTIME','Unanswered','UNANSWERED'),(139,'COLUMN_REALTIME','Transferred','TRANSFERRED'),(140,'COLUMN_REALTIME','Agents','AGENTS_STAFFED'),(141,'COLUMN_REALTIME','Busy','AGENTS_TALKING'),(142,'COLUMN_REALTIME','Paused','AGENTS_PAUSED'),(143,'REALTIME_DISPLAY_ROWS','queue_summary','Waiting,Agents,Logged Off,Busy,Paused,Answered,Unanswered,Abandoned,Abandon Rate,Avg Wait,Avg Duration,Max. wait time'),(144,'COLUMN_REALTIME','Waiting','CALLS_WAITING'),(145,'COLUMN_REALTIME','Available','AGENTS_STAFFED-AGENTS_TALKING'),(151,'COLUMN_REALTIME_FORMAT','Abandon Rate','%.2f %%'),(147,'COLUMN_REALTIME','Abandon Rate','round(((UNANSWERED+ABANDONED)*100)/RECEIVED,2)'),(148,'COLUMN_REALTIME','Max. wait time','MAX_WAIT_TIME'),(149,'COLUMN_REALTIME','Avg Wait','intval((ANSWERED_WAIT_TIME + TRANSFERRED_WAIT_TIME + UNANSWERED_WAIT_TIME + ABANDONED_WAIT_TIME) / RECEIVED)'),(150,'COLUMN_REALTIME','Avg Duration','intval((ANSWERED_TALK_TIME +  TRANSFERRED_TALK_TIME) / (ANSWERED + TRANSFERRED))'),(152,'COLUMN_REALTIME_FORMAT','Max. wait time','{HH}:{MM}:{SS}'),(153,'COLUMN_REALTIME_FORMAT','Avg Wait','{HH}:{MM}:{SS}'),(154,'COLUMN_REALTIME_STYLE','Max. wait time','class=\\\'timer\\\''),(155,'COLUMN_REALTIME_STYLE','Waiting','style=\\\'font-size: 20px; font-weight: bold;\\\''),(156,'COLUMN_REALTIME_FORMAT','Avg Duration','{HH}:{MM}:{SS}'),(157,'COLUMN_REALTIME','Logged Off','AGENTS_LOGGED_OFF'),(158,'realtime_reports','','realtime_waiting_calls.php,realtime_queue_summary.php,realtime_agent_status.php'),(159,'TOTAL_COLUMN_REALTIME','Received','SUM_COL'),(160,'TOTAL_COLUMN_REALTIME','Answered','SUM_COL'),(161,'TOTAL_COLUMN_REALTIME','Waiting','SUM_COL'),(163,'TOTAL_COLUMN_REALTIME','Unanswered','SUM_COL'),(162,'TOTAL_COLUMN_REALTIME','Avg Wait','intval((TOTAL_ANSWERED_WAIT_TIME + TOTAL_TRANSFERRED_WAIT_TIME + TOTAL_UNANSWERED_WAIT_TIME + TOTAL_ABANDONED_WAIT_TIME) / TOTAL_RECEIVED)'),(164,'TOTAL_COLUMN_REALTIME','Abandoned','SUM_COL'),(165,'TOTAL_COLUMN_REALTIME','Abandon Rate','round(((TOTAL_UNANSWERED+TOTAL_ABANDONED)*100)/TOTAL_RECEIVED,2)'),(166,'TOTAL_COLUMN_REALTIME','Avg Duration','intval((TOTAL_ANSWERED_TALK_TIME +  TOTAL_TRANSFERRED_TALK_TIME) / (TOTAL_ANSWERED + TOTAL_TRANSFERRED))'),(167,'TOTAL_COLUMN_REALTIME','Max. wait time','MAX_COL'),(168,'DISTRIBUTION_DISPLAY_OUTBOUND_ROWS','agent','Total,Answered,Not Answered,Logins,Logoff,Avg Wait,Avg Talk,%% Answ,%% Unansw'),(169,'DISTRIBUTION_DISPLAY_OUTBOUND_ROWS','day','Total,Answered,Not Answered,Logins,Logoff,Avg Wait,Avg Talk,%% Answ,%% Unansw'),(170,'DISTRIBUTION_DISPLAY_OUTBOUND_ROWS','day_of_week','Total,Answered,Not Answered,Logins,Logoff,Avg Wait,Avg Talk,%% Answ,%% Unansw'),(171,'DISTRIBUTION_DISPLAY_OUTBOUND_ROWS','hour','Total,Answered,Not Answered,Logins,Logoff,Avg Wait,Avg Talk,%% Answ,%% Unansw'),(172,'DISTRIBUTION_DISPLAY_OUTBOUND_ROWS','month','Total,Answered,Not Answered,Logins,Logoff,Avg Wait,Avg Talk,%% Answ,%% Unansw'),(173,'DISTRIBUTION_DISPLAY_OUTBOUND_ROWS','queue','Total,Answered,Not Answered,Logins,Logoff,Avg Wait,Avg Talk,%% Answ,%% Unansw'),(174,'DISTRIBUTION_DISPLAY_OUTBOUND_ROWS','url','Total,Answered,Not Answered,Logins,Logoff,Avg Wait,Avg Talk,%% Answ,%% Unansw'),(175,'DISTRIBUTION_DISPLAY_OUTBOUND_ROWS','week','Total,Answered,Not Answered,Logins,Logoff,Avg Wait,Avg Talk,%% Answ,%% Unansw'),(176,'COLUMN_DISTRIBUTION','Total','RECEIVED'),(177,'COLUMN_DISTRIBUTION','Not Answered','ABANDONED'),(178,'TOTAL_COLUMN_DISTRIBUTION','Total','SUM_COL'),(179,'TOTAL_COLUMN_DISTRIBUTION','Not Answered','SUM_COL'),(180,'COLUMN_ANSWERED','Ring Time','ANSWERED_RING_TIME+TRANSFERRED_RING_TIME'),(181,'COLUMN_ANSWERED_FORMAT','Ring Time','{HH}:{MM}:{SS}'),(182,'TOTAL_COLUMN_ANSWERED','Ring Time','SUM_COL'),(183,'COLUMN_AGENT','Answered','ANSWERED_CALLS'),(184,'COLUMN_AGENT','Failed','FAILED_CALLS'),(185,'COLUMN_AGENT','Cancelled','CANCELLED_CALLS'),(186,'COLUMN_AGENT','Session Time','SESSION_TIME'),(187,'COLUMN_AGENT','Pause Time','PAUSE_TIME'),(188,'COLUMN_AGENT_FORMAT','Session Time','{HH}:{MM}:{SS}'),(189,'COLUMN_AGENT_FORMAT','Pause Time','{HH}:{MM}:{SS}'),(190,'COLUMN_AGENT','Sessions','SESSION_COUNT'),(191,'COLUMN_AGENT','Pauses','PAUSE_COUNT'),(192,'COLUMN_AGENT','Talk Time','TALK_TIME'),(193,'COLUMN_AGENT','Wrapup Time','WRAPUP_TIME'),(194,'COLUMN_AGENT','Hold Time','HOLD_TIME'),(195,'COLUMN_AGENT_FORMAT','Talk Time','{HH}:{MM}:{SS}'),(196,'COLUMN_AGENT_FORMAT','Wrapup Time','{HH}:{MM}:{SS}'),(197,'COLUMN_AGENT_FORMAT','Hold Time','{HH}:{MM}:{SS}'),(198,'COLUMN_AGENT','%% Session','round((SESSION_TIME * 100) / TOTAL_SESSION_TIME,2)'),(199,'COLUMN_AGENT_FORMAT','%% Session','%.2f %%'),(200,'COLUMN_AGENT','Idle Time','SESSION_TIME - ( TALK_TIME + PAUSE_TIME + WRAPUP_TIME + HOLD_TIME )'),(201,'COLUMN_AGENT_FORMAT','Idle Time','{HH}:{MM}:{SS}'),(202,'COLUMN_AGENT','AHT','(TALK_TIME+WRAPUP_TIME) / ANSWERED_CALLS'),(203,'COLUMN_AGENT_FORMAT','AHT','{HH}:{MM}:{SS}'),(204,'COLUMN_AGENT','%% Paused','PAUSE_TIME * 100 / SESSION_TIME'),(205,'COLUMN_AGENT_FORMAT','%% Paused','%.2f %%'),(206,'TOTAL_COLUMN_AGENT','Answered','TOTAL_ANSWERED_CALLS'),(207,'TOTAL_COLUMN_AGENT','Failed','TOTAL_FAILED_CALLS'),(208,'TOTAL_COLUMN_AGENT','Cancelled','TOTAL_CANCELLED_CALLS'),(209,'TOTAL_COLUMN_AGENT','Session Time','TOTAL_SESSION_TIME'),(210,'TOTAL_COLUMN_AGENT','Pause Time','TOTAL_PAUSE_TIME'),(211,'TOTAL_COLUMN_AGENT','Sessions','TOTAL_SESSION_COUNT'),(212,'TOTAL_COLUMN_AGENT','Pauses','PAUSE_COUNT'),(213,'TOTAL_COLUMN_AGENT','Talk Time','TOTAL_TALK_TIME'),(214,'TOTAL_COLUMN_AGENT','Wrapup Time','TOTAL_WRAPUP_TIME'),(215,'TOTAL_COLUMN_AGENT','Hold Time','TOTAL_HOLD_TIME'),(216,'TOTAL_COLUMN_AGENT','Idle Time','TOTAL_SESSION_TIME - ( TOTAL_TALK_TIME + TOTAL_PAUSE_TIME + TOTAL_WRAPUP_TIME + TOTAL_HOLD_TIME )'),(217,'TOTAL_COLUMN_AGENT','AHT','SUM_COL'),(218,'TOTAL_COLUMN_AGENT','%% Paused','TOTAL_PAUSE_TIME * 100 / TOTAL_SESSION_TIME'),(219,'TOTAL_COLUMN_AGENT','%% Session','SUM_COL');
/*!40000 ALTER TABLE `designer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `gqname`
--

LOCK TABLES `gqname` WRITE;
/*!40000 ALTER TABLE `gqname` DISABLE KEYS */;
/*!40000 ALTER TABLE `gqname` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `gqnameqname`
--

LOCK TABLES `gqnameqname` WRITE;
/*!40000 ALTER TABLE `gqnameqname` DISABLE KEYS */;
/*!40000 ALTER TABLE `gqnameqname` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `language`
--

LOCK TABLES `language` WRITE;
/*!40000 ALTER TABLE `language` DISABLE KEYS */;
INSERT INTO `language` (`id`, `iso_code`, `string`, `translation`, `pending`, `timestamp`) VALUES (1,'es','Filter','Filtrar',0,'2012-09-17 14:40:15'),(2,'es','Loading','Cargando',0,'2012-09-17 14:40:15'),(3,'es','Page parsed in %s seconds','Página procesada en %s segundos',0,'2012-09-17 14:41:28'),(4,'es','Display Report','Mostrar Reporte',0,'2012-09-17 14:40:02'),(5,'es','To','Hasta',0,'2012-09-17 14:40:02'),(6,'es','hours','horas',0,'2012-09-17 14:40:02'),(7,'es','From','Desde',0,'2012-09-17 14:40:02'),(8,'es','Select Time Frame','Seleccione Rango Horario',0,'2012-09-17 14:40:02'),(9,'es','End Date','Fecha Final',0,'2012-09-17 14:40:08'),(10,'es','Higher ...','Mayor ...',0,'2012-09-17 14:40:02'),(11,'es','Lower ...','Menor ...',0,'2012-09-17 14:40:02'),(12,'es','Start Date','Fecha Inicial',0,'2012-09-17 14:40:08'),(13,'es','Last three months','Ultimos tres meses',0,'2012-09-17 14:40:02'),(14,'es','This month','Este mes',0,'2012-09-17 14:40:02'),(15,'es','This week','Esta semana',0,'2012-09-17 14:40:02'),(16,'es','Today','Hoy',0,'2012-09-17 14:40:02'),(17,'es','Shortcuts','Atajos',0,'2012-09-17 14:40:02'),(18,'es','Select Date Range','Seleccione Rango de Fechas',0,'2012-09-17 14:40:02'),(19,'es','Deselects all','Deseleccionar todos',0,'2012-09-17 14:40:02'),(20,'es','Select Agents','Seleccione Agentes',0,'2012-09-17 14:40:02'),(21,'es','Selected','Seleccionados',0,'2012-09-17 14:40:02'),(22,'es','Record deleted','Registro eliminado',0,'2012-09-05 00:36:16'),(23,'es','Selects all','Selecciona todos',0,'2012-09-17 14:40:02'),(24,'es','Deselects marked','Deseleccionar marcados',0,'2012-09-17 14:40:02'),(25,'es','Selects marked','Selecciona marcados',0,'2012-09-17 14:40:02'),(26,'es','Available','Disponible',0,'2012-09-17 14:40:02'),(27,'es','Select Queues','Seleccione Colas',0,'2012-09-17 14:40:02'),(28,'es','Logout','Salir',0,'2012-09-17 14:40:15'),(29,'es','unanswered_calls_detail','Detalle de Llamadas No Atendidas',0,'2012-09-17 14:40:15'),(30,'es','unanswered_calls_by_url','No Atendidas por URL',0,'2012-09-17 14:40:15'),(31,'es','unanswered_calls_by_queue','No Atendidas por Cola',0,'2012-09-17 14:40:15'),(32,'es','unanswered_calls_by_event','Causa de Desconexión',0,'2012-09-17 14:40:15'),(33,'es','unanswered_calls_by_holdtime','Nivel de Servicio',0,'2012-09-17 14:40:15'),(34,'es','unanswered_calls_summary','Sumario de No Atendidas',0,'2012-09-17 14:40:15'),(35,'es','answered_calls_detail','Detalle de Llamadas Atendidas',0,'2012-09-17 14:40:15'),(36,'es','answered_calls_transferred','Llamadas Transferidas',0,'2012-09-17 14:40:15'),(37,'es','answered_calls_by_duration','Atendidas por Duración',0,'2012-09-17 14:40:15'),(38,'es','answered_calls_by_url','Atendidas por URL',0,'2012-09-17 14:40:15'),(39,'es','Licensed to','Licenciado a',0,'2012-09-17 14:40:15'),(40,'es','answered_calls_by_event','Causa de Desconexión',0,'2012-09-17 14:40:15'),(41,'es','answered_calls_by_agent','Atendidas por Agente',0,'2012-09-17 14:40:15'),(42,'es','answered_calls_by_queue','Atendidas por Cola',0,'2012-09-17 14:40:15'),(43,'es','answered_calls_by_holdtime','Nivel de Servicio',0,'2012-09-17 14:40:15'),(44,'es','Password','Clave',0,'2012-09-12 23:35:09'),(45,'es','answered_calls_summary','Sumario de Atendidas',0,'2012-09-17 14:40:15'),(46,'es','distribution_detail','Detalles de Distribución',0,'2012-09-17 14:40:15'),(47,'es','distribution_by_url','Distribución por URL',0,'2012-09-17 14:40:15'),(48,'es','distribution_by_day_of_week','Distribución por Día de Semana',0,'2012-09-17 14:40:15'),(49,'es','distribution_by_hour','Distribución por Hora',0,'2012-09-17 14:40:15'),(50,'es','distribution_by_day','Distribución por Día',0,'2012-09-17 14:40:15'),(51,'es','distribution_by_week','Distribución por Semana',0,'2012-09-17 14:40:15'),(52,'es','distribution_by_month','Distribución por Mes',0,'2012-09-17 14:40:15'),(53,'es','distribution_by_queue','Distribución por Cola',0,'2012-09-17 14:40:15'),(54,'es','distribution_summary','Sumario de Distribución',0,'2012-09-17 14:40:15'),(55,'es','Setup','Configuración',0,'2012-09-17 14:40:15'),(56,'es','Realtime','Estado Actual',0,'2012-09-17 14:40:15'),(57,'es','Search','Buscar',0,'2012-09-17 14:40:15'),(58,'es','Agent','Agente',0,'2012-09-17 14:41:28'),(59,'es','Unanswered','No Atendidas',0,'2012-09-17 14:41:28'),(60,'es','Answered','Atendidas',0,'2012-09-17 14:41:28'),(61,'es','Distribution','Distribución',0,'2012-09-17 14:40:15'),(62,'es','Home','Inicio',0,'2012-09-17 14:40:15'),(63,'en','Setup','Setup',0,'2012-10-02 17:21:37'),(64,'en','admin-setup','Preferences',0,'2012-10-02 17:21:37'),(65,'en','Home','Home',0,'2012-10-02 17:21:37'),(66,'es','Yes','Si',0,'2012-09-12 23:37:57'),(67,'es','ISO Code','Código ISO',0,'2012-09-12 23:26:00'),(68,'es','String','Texto',0,'2012-09-12 23:26:00'),(69,'es','Translation','Traducción',0,'2012-09-12 23:26:00'),(70,'es','Pending','Pendiente',0,'2012-09-12 23:26:00'),(71,'es','Are you sure?','Está seguro?',0,'2012-09-12 23:37:57'),(72,'es','Delete Marked','Eliminar Marcados',0,'2012-09-12 23:37:57'),(73,'es','Export','Exportar',0,'2012-09-12 23:26:00'),(74,'es','Import','Importar',0,'2012-09-12 23:33:42'),(75,'es','View Record','Ver Registro',0,'2012-09-12 23:35:09'),(76,'es','Edit Record','Editar Registro',0,'2012-09-12 23:37:57'),(77,'es','Delete','Eliminar',0,'2012-09-12 23:37:57'),(78,'es','First','Primera',0,'2012-09-12 23:37:57'),(79,'es','Previous','Anterior',0,'2012-09-12 23:37:57'),(80,'es','Next','Siguiente',0,'2012-09-12 23:37:57'),(81,'es','Last','Ultimo',0,'2012-09-12 23:37:57'),(82,'es','Page','Página',0,'2012-09-12 23:37:57'),(83,'es','of','de',0,'2012-09-12 23:37:57'),(84,'es','Total records found','Total de registros encontrados',0,'2012-09-12 23:37:57'),(85,'es','Passwords do not match','Las claves no coinciden',0,'2012-09-12 22:58:56'),(86,'es','Required field','Campo obligatorio',0,'2012-09-12 22:58:56'),(87,'es','Select an option','Elija una opción',0,'2012-09-04 23:47:32'),(88,'es','Save','Guardar',0,'2012-09-12 23:37:57'),(89,'es','Cancel','Cancelar',0,'2012-09-12 23:37:57'),(90,'es','Record updated','Registro actualizado',0,'2012-09-04 23:47:29'),(91,'es','Success!','Exito!',0,'2012-09-05 00:36:16'),(92,'es','Queue','Cola',0,'2012-09-17 14:41:28'),(93,'es','Click to view calls in detail','Pulse aquí para ver detalles',0,'2012-09-17 14:40:08'),(94,'es','Waiting','En espera',0,'2012-09-17 14:41:28'),(95,'es','Agent Status','Estado de Agentes',0,'2012-09-17 14:41:28'),(96,'es','Login Form','Formulario de Ingreso',0,'0000-00-00 00:00:00'),(97,'es','User','Usuario',0,'0000-00-00 00:00:00'),(98,'es','Caller ID','Ident. de Llamada',0,'2012-09-17 14:41:28'),(99,'es','Duration','Duración',0,'2012-09-17 14:41:28'),(100,'es','Goes to the top of the page','Ir al comienzo de la página',0,'2012-09-17 14:41:28'),(101,'es','Login','Ingresar',0,'2012-09-12 23:35:09'),(102,'es','Period','Período',0,'2012-09-17 14:40:08'),(103,'es','%s records deleted','%s registros eliminados',0,'0000-00-00 00:00:00'),(104,'es','Received','Recibidas',0,'2012-09-17 14:40:08'),(105,'es','Abandoned','Abandonadas',0,'2012-09-17 14:41:28'),(106,'es','Transferred','Transferidas',0,'2012-09-17 14:40:08'),(107,'es','Logins','Ingresos',0,'2012-09-17 14:40:08'),(108,'es','Logoff','Egresos',0,'2012-09-17 14:40:08'),(109,'es','Avg Wait','Esp.Media',0,'2012-09-17 14:41:28'),(110,'es','Avg Talk','Dur.Media',0,'2012-09-17 14:40:08'),(111,'es','Max Callers','Max. en Espera',0,'2012-09-17 14:40:08'),(112,'es','%% Answ','%% Atendidas',0,'2012-09-17 14:40:08'),(113,'es','%% Unansw','%% No Atendidas',0,'2012-09-17 14:40:08'),(114,'es','Week','Semana',0,'2012-09-17 14:40:08'),(115,'es','Month','Mes',0,'2012-09-17 14:40:08'),(116,'es','Date','Fecha',0,'2012-09-17 14:40:08'),(117,'es','Hour','Hora',0,'2012-09-17 14:40:08'),(118,'es','Day','Día',0,'2012-09-17 14:40:08'),(119,'es','Number','Número',0,'2012-09-17 14:40:08'),(120,'es','Event','Evento',0,'2012-09-17 14:40:08'),(121,'es','Answer','Atendida',0,'2012-09-07 22:26:34'),(122,'es','Count','Cantidad',0,'2012-09-07 22:26:35'),(123,'es','%% Calls','%% Llamadas',0,'2012-09-07 22:26:34'),(124,'es','Completed','Completadas',0,'2012-09-12 23:26:00'),(125,'es','Talk Time','Tiempo al Habla',0,'2012-09-17 14:40:08'),(126,'es','%% Talk Time','%% Tiempo al habla',0,'2012-09-07 22:26:34'),(127,'es','Avg Talk Time','Duración Media',0,'2012-09-07 22:26:34'),(128,'es','Wait Time','Tiempo Espera',0,'2012-09-17 14:40:08'),(129,'es','Avg Wait Time','Espera Media',0,'2012-09-07 22:26:34'),(130,'es','Max Wait Time','Espera Máxima',0,'2012-09-07 22:26:34'),(131,'es','Answered/Abandoned','Atendidas/Abandonadas',0,'2012-09-04 19:42:02'),(132,'es','Total Calls','Total de Llamadas',0,'2012-09-17 14:40:08'),(133,'es','Number of Received Calls','Número de Llamadas Recibidas',0,'2012-09-17 14:40:08'),(134,'es','Number of Answered Calls','Número de Llamadas Atendidas',0,'2012-09-17 14:40:08'),(135,'es','Number of Unanswered Calls','Número de Llamadas No Atendidas',0,'2012-09-17 14:40:08'),(136,'es','Number of Abandoned Calls','Número de Llamadas Abandonadas',0,'2012-09-17 14:40:08'),(137,'es','Number of Transferred Calls','Número de Llamadas Transferidas',0,'2012-09-17 14:40:08'),(138,'es','Abandon Rate','Tasa de Abandono',0,'2012-09-17 14:41:28'),(139,'es','Number of Agent Logins','Número de Ingresos de Agente',0,'2012-09-17 14:40:08'),(140,'es','Number of Agent Logoffs','Número de Egresos de Agente',0,'2012-09-17 14:40:08'),(141,'es','Actions','Acciones',0,'2012-09-17 14:40:08'),(142,'es','Exports the data to a comma separated file, to be read by your spreadsheet software','Exportar datos a archivo separado por comas para utilizar con planilla de cálculos',0,'2012-09-11 00:46:36'),(143,'es','Exports the data to a .pdf file','Exportar datos a archivo .pdf',0,'2012-09-11 00:46:36'),(144,'es','Filter report by Caller Id','Filtrar reporte por identificador de llamada',0,'2012-09-17 14:40:08'),(145,'es','Add','Agregar',0,'2012-09-12 23:35:09'),(146,'es','Select some options','Select some options',0,'2012-09-12 22:58:56'),(147,'es','Incompleted Calls','Llamadas Incompletas',0,'2012-09-04 19:42:02'),(148,'es','none','ninguno',0,'0000-00-00 00:00:00'),(149,'en','Total Time per Agent (seconds)','Total Time per Agent (seconds)',0,'2012-10-02 01:34:01'),(150,'es','Agents','Agentes',0,'2012-09-17 14:41:28'),(151,'es','Logged Off','Desconectados',0,'2012-09-17 14:41:28'),(152,'en','disposition_help_COMPLETEAGENT','The caller was connected to an agent, and the call was terminated normally\r\nby the *agent*. The caller&lsquo;s hold time and the length of the call are both\r\nrecorded. The caller&lsquo;s original position in the queue is recorded in\r\norigposition.',0,'2012-10-01 18:34:19'),(153,'es','within %d%s seconds','dentro de %d%s segundos',0,'2012-09-07 22:26:34'),(154,'es','Unanswered Rate','Tasa de No Atendidas',0,'2012-09-17 14:40:08'),(155,'en','Number of Calls per Agent','Number of Calls per Agent',0,'2012-10-02 01:34:01'),(156,'es','End Position','Pos. Final',0,'2012-09-04 19:42:02'),(157,'es','Start Position','Posición Inicial',0,'2012-09-04 19:42:02'),(158,'es','Delta','Delta',0,'2012-09-07 22:26:34'),(159,'en','Logged Off','Logged Off',0,'2012-09-18 04:51:34'),(160,'en','Agents','Agents',0,'2012-10-01 23:08:44'),(161,'en','info5','Info 5',0,'2012-09-06 22:00:52'),(162,'es','No records found','No se encontraron registros',0,'2012-09-12 23:16:17'),(163,'es','%%','%%',0,'2012-09-07 22:26:34'),(164,'es','within','dentro de',0,'0000-00-00 00:00:00'),(165,'es','seconds','segundos',0,'0000-00-00 00:00:00'),(166,'es','Total Unanswered Calls','Total de Llamadas No Atendidas',0,'2012-09-04 19:42:02'),(167,'es','All %s records on this page are selected.','Los %s registros de esta página han sido seleccionados.',0,'0000-00-00 00:00:00'),(168,'es','Select all %s records.','Marcar los %s registros encontrados.',0,'0000-00-00 00:00:00'),(169,'es','Hour Range','Rango Horario',0,'2012-09-17 14:40:08'),(170,'es','Total Answered Calls','Total de Llamadas Atendidas',0,'2012-09-07 22:26:34'),(171,'es','Answered Calls','Llamadas Atendidas',0,'2012-09-07 22:26:34'),(172,'es','Total Duration','Duración Total',0,'2012-09-07 22:26:34'),(173,'es','Toggle Search Form','Ocultar/Mostrar Formulario',0,'2012-09-06 18:24:13'),(174,'es','Position','Posición',0,'0000-00-00 00:00:00'),(175,'es','Error updating record','Error actualizando el registro',0,'0000-00-00 00:00:00'),(176,'es','An error has occurred','Ha ocurrido un error',0,'0000-00-00 00:00:00'),(177,'es','January','Enero',0,'2012-09-17 14:41:28'),(178,'es','February','Febrero',0,'2012-09-17 14:41:28'),(179,'es','March','Marzo',0,'2012-09-17 14:41:28'),(180,'es','April','Abril',0,'2012-09-17 14:41:28'),(181,'es','May','Mayo',0,'2012-09-17 14:41:28'),(182,'es','June','Junio',0,'2012-09-17 14:41:28'),(183,'es','July','Julio',0,'2012-09-17 14:41:28'),(184,'es','August','Agosto',0,'2012-09-17 14:41:28'),(185,'es','September','Septiembre',0,'2012-09-17 14:41:28'),(186,'es','October','Octubre',0,'2012-09-17 14:41:28'),(187,'es','November','Noviembre',0,'2012-09-17 14:41:28'),(188,'es','December','Diciembre',0,'2012-09-17 14:41:28'),(189,'es','realtime-agent-ringing','Ringing',0,'0000-00-00 00:00:00'),(190,'es','No','No',0,'2012-09-12 23:37:57'),(191,'es','agent_detail','Reporte Detallado de Agentes',0,'2012-09-17 14:40:15'),(192,'es','agent_dispositions','Disposición de llamados por Agente',0,'2012-09-17 14:40:15'),(193,'es','agent_availability','Disponibilidad de Agentes',0,'2012-09-17 14:40:15'),(194,'es','agent_summary','Sumario de Agentes',0,'2012-09-17 14:40:15'),(195,'es','State','Estado',0,'2012-09-17 14:41:28'),(196,'es','realtime-agent-not in use','Libre',0,'2012-09-17 14:41:28'),(197,'es','%s min. ago','hace %s min.',0,'2012-09-17 14:41:28'),(198,'es','Calls Waiting Detail','Detalle de Llamadas en Espera',0,'0000-00-00 00:00:00'),(199,'es','Hide Logged off','Ocultar Agentes Desconectados',0,'2012-09-17 14:41:28'),(200,'es','Group by Queue','Agrupar por Colas',0,'2012-09-17 14:41:28'),(201,'es','Last in Call','Ultima Llamada',0,'2012-09-17 14:41:28'),(202,'es','Total','Total',0,'2012-09-17 14:41:28'),(203,'es','Max. wait time','Tiempo Máximo de Espera',0,'2012-09-17 14:41:28'),(204,'es','Server Time','Hora en el Servidor',0,'2012-09-17 14:41:28'),(205,'es','Avg Duration','Duración Media',0,'2012-09-17 14:41:28'),(206,'es','Paused','En Pausa',0,'2012-09-17 14:41:28'),(207,'es','Busy','Ocupado',0,'2012-09-17 14:41:28'),(208,'es','Abandoned Calls','Llamadas Abandonadas',0,'2012-09-04 19:42:02'),(209,'es','Unanswered Calls','Llamadas no Atendidas',0,'2012-09-04 19:42:02'),(210,'es','Abandon Avg Wait Before Disconnection','Espera media antes de Abandono',0,'2012-09-04 19:42:02'),(211,'es','Abandon Avg Queue Position at Disconnection','Posicion Final Media en Abandono',0,'2012-09-04 19:42:02'),(212,'es','Abandon Avg Queue Start Position','Posicion Inicial Media en Abandono',0,'2012-09-04 19:42:02'),(213,'en','Select all %s records.','Select all %s records.',0,'2012-10-02 02:40:12'),(214,'es','help_text_realtime_hide_loggedoff','Ocultar Agentes Deslogueados en la vista de &quot;Estado Actual&quot;',0,'2012-09-12 23:12:22'),(215,'en','help_text_realtime_refresh_sql','Refresh time in seconds for statistics values on the queue summary table in the realtime view. Retrieving the information is cpu expensive, so you might want to leave it at the default value of 60 seconds or even higher if you have many supervisors checking the realt time view at the same time.',0,'2012-10-02 04:55:45'),(216,'es','agent_pauses','Detalle de Pausas',0,'2012-09-17 14:40:15'),(217,'es','COMPLETECALLER','Cortó el Usuario',0,'2012-09-11 00:46:36'),(218,'es','COMPLETEAGENT','Cortó el Agente',0,'2012-09-07 18:45:47'),(219,'es','RINGNOANSWER','Fallo en Atender',0,'2012-09-07 18:48:15'),(220,'en','realtime_queue_summary','Queue Summary',0,'2012-09-18 04:51:34'),(221,'es','Listen','Escuchar Llamada',0,'0000-00-00 00:00:00'),(222,'es','Download','Descargar',0,'2012-09-11 00:46:36'),(223,'es','You do not have enough privileges to access this resource','No tiene privilegios para acceder a este recurso',0,'0000-00-00 00:00:00'),(224,'es','Agent Totals','Totales de Agente',0,'2012-09-07 18:45:47'),(225,'es','Number of Agents','Cantidad de Agentes',0,'2012-09-07 18:45:47'),(226,'es','Average Session Time','Duración Media de Sesión',0,'2012-09-07 18:45:47'),(227,'es','Shortest Session Time','Sesión Más Corta',0,'2012-09-07 18:45:47'),(228,'es','Longest Session','Sesión Más Larga',0,'2012-09-07 18:45:47'),(229,'es','Total Session Time','Tiempo Total de Sesiones',0,'2012-09-07 18:45:47'),(230,'es','Session Time','Tiempo de Sesión',0,'2012-09-07 18:45:47'),(231,'es','Avg. Session Time','Duración Media de Sesión',0,'2012-09-07 18:45:47'),(232,'es','Pause Time','Tiempo en Pausa',0,'2012-09-07 18:45:47'),(233,'es','ALL','Todos',0,'2012-09-12 23:35:09'),(234,'en','help_text_realtime_group_queues','Start the realtime view with a grouped queue display.',0,'2012-10-02 04:55:45'),(235,'es','help_text_wait_time_format','Formato para campos de tiempo en espera. HH = horas, MM=minutos, SS=segundos, mm=minutos absolutos, ss=segundos absolutos. Utilizado en reportes de información detallados y drill down.',0,'2012-09-12 23:12:22'),(236,'es','help_text_week_mode','Cuándo empezar a contar semanas en el año:\n<pre>\nModo    1er día de semana       Rango   Semana 1 es la primer semana ...\n0       Domingo                 0-53    con un Domingo en el año\n1       Lunes                   0-53    con más de 3 días en el año\n2       Domingo                 1-53    con un domingo en el año\n3       Lunes                   1-53    con más de 3 días este año\n4       Domingo                 0-53    con más de 3 días este año\n5       Lunes                   0-53    con un Lunes en el año\n6       Domingo                 1-53    con más de 3 días este año\n7       Lunes                   1-53    con un Lunes en el año\n</pre>',0,'2012-09-12 23:12:22'),(237,'es','help_text_timezone','Configurar la zona horaria para el usuario, en formato [+-]HH:MM\r\n\r\nSi pone un nombre de usuario como parámetro, la configuración se aplicará solamente para ese usuario. Si el parámetro se deja en blanco la configuración será global.',0,'2012-09-12 23:12:22'),(238,'es','help_text_realtime_spy_device','Canal o Dispositivo del usuario utilizado para las escuchas, debe ponerse como parámetro el nombre del usuario y como valor el canal completo. Ej: SIP/1234',0,'2012-09-12 23:12:22'),(239,'es','help_text_sla_steps','Número de filas a mostrar en los reportes de Nivel de Servicio en Atendidas y No Atendidas.',0,'2012-09-12 23:12:22'),(240,'es','help_text_sla_interval','Intervalo de tiempo en segundos para separar los reportes de Nivel de Servicio en Atendidas y No Atendidas.',0,'2012-09-12 23:12:22'),(241,'es','help_text_show_agent_field','Mostrar columna de Agente en reportes de no atendidos (util cuando se rastrean llamados salientes)',0,'2012-09-12 23:12:22'),(242,'es','help_text_show_url_field','Mostrar columna de URL en los reportes de llamados atentidos',0,'2012-09-12 23:12:22'),(243,'es','help_text_show_agent_call','Mostrar eventos de llamado cuando se expanden reportes de Agente',0,'2012-09-12 23:12:22'),(244,'es','help_text_shared_lastcall','Compartir la información de último llamado entre colas. Sólo se mostrará el tiempo más corto para todas las colas. Si se utiliza rastreo de salientes y se guarda el valor astdb LASTCALL, será también tomado en cuenta.',0,'2012-09-12 23:12:22'),(245,'en','admin-users','Users',0,'2012-10-02 17:21:37'),(246,'es','help_text_session_time_format','Formato para campos de tiempo de sesión. HH = horas, MM=minutos, SS=segundos, mm=minutos absolutos, ss=segundos absolutos. Utilizado en reportes de información detallados y drill down.',0,'2012-09-12 23:12:22'),(247,'es','help_text_recordings_path','Directorio de grabaciones en el disco duro para descarga directa.',0,'2012-09-12 23:12:22'),(248,'es','help_text_realtime_refresh','Tiempo en segundos para refresco de la vista de &quot;Estado Actual&quote;. El valor por defecto es de 5 segundos.',0,'2012-09-12 23:12:22'),(249,'es','help_text_language','Idioma a usar. Si el parámetro se deja en blanco, se aplicará globalmente. En caso de que el parámetro sea el nombre de un usuario, entonces el idioma se aplicará solamente a ese usuario.',0,'2012-09-12 23:12:22'),(250,'es','help_text_short_abandon_threshold','Tiempo mínimo que una llamada debe tener (en segundos) para que sea considerada entre las llamadas abandonadas. Si se especifica como parámetro el nombre de una cola, entonces se aplicará para esa cola solamente.',0,'2012-09-12 23:12:22'),(251,'es','help_text_ignore_none_abandons','Si no desea contar las llamadas abadonadas entrantes cuando selecciona un reporte sobre una lista parcial de agentes debe poner este seteo en uno. Esto es util cuando se reporta sobre llamados salientes y determinar la performance de cada agente, ya que los abandons entrantes son filtrados debido a que no se puede computar un abandono entrante a ningun agente en particular. Si al ejecutar un reporte se seleccionan todos los agentes disponibles, esto incluira tambien el agente NONE por lo que los abandonos entrantes se contaran incluso si esta configuracion esta puesta en uno.',0,'2012-09-12 23:12:22'),(252,'es','help_text_honor_timeframe_in_agent','Honrar seleccion de horario en reportes de Agente. Tambien intenta computar eventos faltantes. (Por ejemplo, si en la selección de horario en la solapa inicial se pide un reporte de 11 a 16 horas, los reportes de agente computaran un fin de sesión a las 16 hs si no existe un evento de fin de sesión registrado).',0,'2012-09-12 23:12:22'),(253,'en','help_text_realtime_hide_loggedoff','Start the realtime view without showing logged off Agents.',0,'2012-10-02 04:55:45'),(254,'es','agent_durations','Duración de Sesión y Pausas de Agente',0,'2012-09-17 14:40:15'),(255,'en','admin-language','Translations',0,'2012-10-02 17:21:37'),(256,'en','admin-acl','Access Control',0,'2012-10-02 17:21:37'),(257,'en','Distribution','Distribution',0,'2012-10-02 05:43:07'),(258,'es','admin-setup','Preferencias',0,'2012-09-17 14:40:15'),(259,'es','admin-users','Usuarios',0,'2012-09-17 14:40:15'),(260,'es','admin-acl','Control de Acceso',0,'2012-09-17 14:40:15'),(261,'es','admin-language','Traducciones',0,'2012-09-17 14:40:15'),(262,'en','Logout','Logout',0,'2012-10-02 17:21:37'),(263,'es','help_text_realtime_refresh_sql','Tiempo en segundos para refresco de datos estadísticos (atendidas,abandonadas,etc) para la tabla de sumario de colas en la vista de &quot;Estado Actual&quot;. El valor por defecto es de 60 segundos. Esta consulta consume mucho procesador, es recomendado dejar este valor en 60 segundos o incluso subirlo un poco más si hay muchos supervisores revisando la vista simultáneamente.',0,'2012-09-12 23:12:22'),(264,'en','Available','Available',0,'2012-10-02 17:21:11'),(265,'en','Deselects marked','Deselects marked',0,'2012-10-02 17:21:11'),(266,'es','event_help_enterqueue_info2','Identificador de Llamado (CallerID) de la persona que entró en la cola.',0,'2012-09-07 22:26:12'),(267,'en','Deselects all','Deselects all',0,'2012-10-02 17:21:11'),(268,'es','realtime-agent-unavailable','No Disponible',0,'0000-00-00 00:00:00'),(269,'en','You must select at least one agent','You must select at least one agent',0,'0000-00-00 00:00:00'),(270,'en','Shortcuts','Shortcuts',0,'2012-10-02 17:21:11'),(271,'en','Seconds','Seconds',0,'2012-09-06 22:00:52'),(272,'en','Last three months','Last three months',0,'2012-10-02 17:21:11'),(273,'en','Start Date','Start Date',0,'2012-10-02 17:21:11'),(274,'en','January','January',0,'2012-10-02 17:21:37'),(275,'en','February','February',0,'2012-10-02 17:21:37'),(276,'en','March','March',0,'2012-10-02 17:21:37'),(277,'en','April','April',0,'2012-10-02 17:21:37'),(278,'es','event_help_enterqueue_info1','URL configurada en la cola',0,'2012-09-07 22:26:12'),(279,'en','June','June',0,'2012-10-02 17:21:37'),(280,'en','July','July',0,'2012-10-02 17:21:37'),(281,'en','August','August',0,'2012-10-02 17:21:37'),(282,'en','info4','Info 4',0,'2012-09-06 22:00:52'),(283,'en','October','October',0,'2012-10-02 17:21:37'),(284,'en','November','November',0,'2012-10-02 17:21:37'),(285,'en','December','December',0,'2012-10-02 17:21:37'),(286,'en','Lower ...','Lower ...',0,'2012-10-02 17:21:11'),(287,'en','Higher ...','Higher ...',0,'2012-10-02 17:21:11'),(288,'en','From','From',0,'2012-10-02 17:21:11'),(289,'en','realtime-agent-unavailable','Unavailable',0,'0000-00-00 00:00:00'),(290,'en','Display Report','Display Report',0,'2012-10-02 17:21:11'),(291,'en','Page parsed in %s seconds','Page parsed in %s seconds',0,'2012-10-02 17:21:37'),(292,'en','Licensed to','Licensed to',0,'2012-10-02 17:21:37'),(293,'en','Loading','Loading',0,'2012-10-02 17:21:37'),(294,'en','Filter','Filter',0,'2012-10-02 17:21:37'),(295,'en','Yes','Yes',0,'2012-10-02 17:21:37'),(296,'en','ISO Code','ISO Code',0,'2012-10-02 17:21:37'),(297,'en','String','String',0,'2012-10-02 17:21:37'),(298,'en','Translation','Translation',0,'2012-10-02 17:21:37'),(299,'en','Pending','Pending',0,'2012-10-02 17:21:37'),(300,'en','Are you sure?','Are you sure?',0,'2012-10-02 17:21:37'),(301,'en','Delete Marked','Delete Marked',0,'2012-10-02 17:21:37'),(302,'en','Export','Export',0,'2012-10-02 17:21:37'),(303,'en','Import','Import',0,'2012-10-02 17:21:37'),(304,'en','View Record','View Record',0,'2012-10-02 17:21:37'),(305,'en','Edit Record','Edit Record',0,'2012-10-02 17:21:37'),(306,'en','Delete','Delete',0,'2012-10-02 17:21:37'),(307,'en','First','First',0,'2012-10-02 17:21:37'),(308,'en','Previous','Previous',0,'2012-10-02 17:21:37'),(309,'en','Last','Last',0,'2012-10-02 17:21:37'),(310,'en','Page','Page',0,'2012-10-02 17:21:37'),(311,'en','of','of',0,'2012-10-02 17:21:37'),(312,'en','Total records found','Total records found',0,'2012-10-02 17:21:37'),(313,'en','Passwords do not match','Passwords do not match',0,'2012-10-02 17:21:27'),(314,'en','Required field','Required field',0,'2012-10-02 17:21:27'),(315,'es','realtime_queue_summary','Sumario de Colas',0,'2012-09-17 14:41:28'),(316,'en','Cancel','Cancel',0,'2012-10-02 17:21:27'),(317,'en','Record updated','Record updated',0,'2012-10-02 17:21:37'),(318,'en','Success!','Success!',0,'2012-10-02 17:21:37'),(319,'en','Answered','Answered',0,'2012-10-02 05:43:07'),(320,'en','Unanswered','Unanswered',0,'2012-10-02 17:21:01'),(321,'en','Agent','Agent',0,'2012-10-02 05:43:07'),(322,'en','Realtime','Realtime',0,'2012-10-02 00:53:49'),(323,'en','distribution_summary','Distribution Summary',0,'2012-10-02 00:53:49'),(324,'en','distribution_by_queue','Distribution by Queue',0,'2012-10-02 05:43:08'),(325,'en','distribution_by_month','Distribution per Month',0,'2012-10-02 05:43:08'),(326,'en','distribution_by_week','Distribution per Week',0,'2012-10-02 05:43:08'),(327,'en','distribution_by_day','Distribution per Day',0,'2012-10-02 05:43:08'),(328,'en','distribution_by_hour','Distribution per Hour',0,'2012-10-02 05:43:08'),(329,'en','distribution_by_day_of_week','Distribution per Day of Week',0,'2012-10-02 05:43:08'),(330,'en','distribution_by_url','Distribution by URL',0,'2012-10-02 05:43:08'),(331,'en','distribution_detail','Detailed Distribution Report',0,'2012-10-02 05:43:07'),(332,'en','answered_calls_summary','Answered Calls Summary',0,'2012-10-02 00:53:49'),(333,'en','answered_calls_by_holdtime','Service Level',0,'2012-10-02 05:43:08'),(334,'en','answered_calls_by_queue','Answered by Queue',0,'2012-10-02 05:43:08'),(335,'en','answered_calls_by_agent','Answered by Agent',0,'2012-10-02 05:43:08'),(336,'en','answered_calls_by_event','Disconnection Cause',0,'2012-10-02 05:43:08'),(337,'en','answered_calls_by_url','Answered by URL',0,'2012-10-02 05:43:08'),(338,'en','answered_calls_by_duration','Answered by Call Length',0,'2012-10-02 00:53:49'),(339,'en','answered_calls_transferred','Transfers',0,'2012-10-02 05:43:08'),(340,'en','answered_calls_detail','Answered Calls Detail',0,'2012-10-02 00:53:49'),(341,'en','unanswered_calls_summary','Unanswered Calls Summary',0,'2012-10-02 00:53:49'),(342,'en','unanswered_calls_by_holdtime','Service Level',0,'2012-10-02 05:43:08'),(343,'en','unanswered_calls_by_event','Disconnection Cause',0,'2012-10-02 05:43:08'),(344,'en','unanswered_calls_by_queue','Unanswered Calls by Queue',0,'2012-10-02 17:21:01'),(345,'en','unanswered_calls_by_url','Unanswered Calls by URL',0,'2012-10-02 00:53:49'),(346,'en','unanswered_calls_detail','Unanswered Calls Detail',0,'2012-10-02 05:43:07'),(347,'en','agent_summary','Agent Summary',0,'2012-10-02 00:53:49'),(348,'en','agent_durations','Agent Session and Pause Durations',0,'2012-10-02 05:43:08'),(349,'en','agent_pauses','Pause Detail',0,'2012-10-02 00:53:49'),(350,'en','agent_dispositions','Call Disposition by Agent',0,'2012-10-02 05:43:08'),(351,'en','agent_detail','Full Agent Report',0,'2012-10-02 00:53:49'),(352,'en','Goes to the top of the page','Goes to the top of the page',0,'2012-10-01 18:34:19'),(353,'en','Queue','Queue',0,'2012-10-02 17:21:01'),(354,'en','Hour Range','Hour Range',0,'2012-10-01 18:34:18'),(355,'en','Period','Period',0,'2012-10-01 18:34:18'),(356,'en','Total Calls','Total Calls',0,'2012-10-01 18:34:18'),(357,'en','Number of Received Calls','Number of Received Calls',0,'2012-10-01 18:34:18'),(358,'en','Number of Answered Calls','Number of Answered Calls',0,'2012-10-01 18:34:18'),(359,'en','Number of Unanswered Calls','Number of Unanswered Calls',0,'2012-10-01 18:34:18'),(360,'en','Number of Abandoned Calls','Number of Abandoned Calls',0,'2012-10-01 18:34:18'),(361,'en','Number of Transferred Calls','Number of Transferred Calls',0,'2012-10-01 18:34:18'),(362,'en','Unanswered Rate','Unanswered Rate',0,'2012-10-01 18:34:18'),(363,'en','Abandon Rate','Abandon Rate',0,'2012-10-01 18:34:18'),(364,'en','Number of Agent Logins','Number of Agent Logins',0,'2012-10-01 18:34:18'),(365,'en','Number of Agent Logoffs','Number of Agent Logoffs',0,'2012-10-01 18:34:18'),(366,'en','Received','Received',0,'2012-10-02 01:34:01'),(367,'en','Abandoned','Abandoned',0,'2012-10-02 17:21:01'),(368,'en','Transferred','Transferred',0,'2012-10-02 01:34:01'),(369,'en','Logins','Logins',0,'2012-10-02 01:34:01'),(370,'en','Logoff','Logoff',0,'2012-10-02 01:34:01'),(371,'en','Avg Wait','Avg Wait',0,'2012-10-02 01:34:01'),(372,'en','Avg Talk','Avg Talk',0,'2012-10-02 01:34:01'),(373,'en','Max Callers','Max Callers',0,'2012-10-02 01:34:01'),(374,'en','%% Answ','%% Answ',0,'2012-10-02 01:34:01'),(375,'en','%% Unansw','%% Unansw',0,'2012-10-02 01:34:01'),(376,'en','SLA','SLA',0,'2012-10-02 01:34:01'),(377,'en','Exports the data to a .pdf file','Exports the data to a .pdf file',0,'2012-10-01 18:34:19'),(378,'en','Exports the data to a comma separated file, to be read by your spreadsheet software','Exports the data to a comma separated file, to be read by your spreadsheet software',0,'2012-10-01 18:34:19'),(379,'en','Click to view calls in detail','Click to view calls in detail',0,'2012-10-01 18:34:19'),(380,'en','Record deleted','Record deleted',0,'2012-09-07 22:18:02'),(381,'en','OK','OK',0,'0000-00-00 00:00:00'),(382,'en','No active channel','No active channel',0,'0000-00-00 00:00:00'),(383,'en','Week','Week',0,'2012-10-01 18:34:18'),(384,'en','Date','Date',0,'2012-10-01 18:34:19'),(385,'en','Hour','Hour',0,'2012-10-01 18:34:18'),(386,'en','Day','Day',0,'2012-10-01 18:34:19'),(387,'en','URL','URL',0,'2012-10-01 18:34:19'),(388,'en','Number','Number',0,'2012-10-01 18:34:19'),(389,'en','Event','Event',0,'2012-10-02 01:34:01'),(390,'en','Wait Time','Wait Time',0,'2012-10-01 18:34:19'),(391,'en','Actions','Actions',0,'2012-10-01 18:34:19'),(392,'en','Filter report by Caller Id','Filter report by Caller Id',0,'2012-10-01 18:34:19'),(393,'en','Click to add text','Click to add text',0,'2012-10-02 17:21:37'),(394,'en','Total Unanswered Calls','Total Unanswered Calls',0,'2012-09-21 20:07:06'),(395,'en','Incompleted Calls','Incompleted Calls',0,'2012-09-21 20:07:06'),(396,'en','Abandoned Calls','Abandoned Calls',0,'2012-09-21 20:07:06'),(397,'en','Unanswered Calls','Unanswered Calls',0,'2012-09-21 20:07:06'),(398,'en','Abandon Avg Wait Before Disconnection','Abandon Avg Wait Before Disconnection',0,'2012-09-21 20:07:06'),(399,'en','Abandon Avg Queue Position at Disconnection','Abandon Avg Queue Position at Disconnection',0,'2012-09-21 20:07:06'),(400,'en','Abandon Avg Queue Start Position','Abandon Avg Queue Start Position',0,'2012-09-21 20:07:06'),(401,'en','Answer','Answer',0,'2012-09-12 22:00:55'),(402,'es','disposition_help_ABANDON','El usuario cortó el llamado sin haber sido atendido por ningún agente.',0,'2012-09-11 00:46:36'),(403,'en','Delta','Delta',0,'2012-09-21 20:07:06'),(404,'en','%%','%%',0,'2012-09-21 20:07:06'),(405,'en','within','within',0,'0000-00-00 00:00:00'),(406,'en','Answered/Abandoned','Answered/Abandoned',0,'2012-10-02 17:21:01'),(407,'en','%% Calls','%% Calls',0,'2012-10-02 17:21:01'),(408,'en','Start Position','Start Position',0,'2012-09-21 20:07:06'),(409,'en','End Position','End Position',0,'2012-09-21 20:07:06'),(410,'es','Bad username or password','Nombre de Usuario o Clave Incorrectos',0,'0000-00-00 00:00:00'),(411,'en','Caller ID','Caller ID',0,'2012-09-18 04:51:34'),(412,'en','Duration','Duration',0,'2012-09-18 04:51:34'),(413,'es','help_text_realtime_group_queues','Agrupar Colas en la vista de &quot;Estado Actual&quot;',0,'2012-09-12 23:12:22'),(414,'en','Busy','Busy',0,'2012-09-18 04:51:34'),(415,'en','Paused','Paused',0,'2012-09-18 04:51:34'),(416,'en','Avg Duration','Avg Duration',0,'2012-09-18 04:51:34'),(417,'en','Waiting','Waiting',0,'2012-09-18 04:51:34'),(418,'en','Agent Status','Agent Status',0,'2012-09-18 04:51:34'),(419,'en','Hide Logged off','Hide Logged off',0,'2012-09-18 04:51:34'),(420,'en','Group by Queue','Group by Queue',0,'2012-09-18 04:51:34'),(421,'en','State','State',0,'2012-09-18 04:51:34'),(422,'en','Last in Call','Last in Call',0,'2012-09-18 04:51:34'),(423,'en','%s min. ago','%s min. ago',0,'2012-09-18 04:51:34'),(424,'en','realtime-agent-not in use','Not in use',0,'2012-09-18 04:51:34'),(425,'en','You must select at least one queue','You must select at least one queue',0,'0000-00-00 00:00:00'),(426,'en','Calls Waiting Detail','Calls Waiting Detail',0,'2012-09-07 19:04:39'),(427,'en','agent_availability','Agent Availability',0,'2012-10-02 05:43:08'),(428,'en','Agent Totals','Agent Totals',0,'2012-09-07 17:59:17'),(429,'en','Number of Agents','Number of Agents',0,'2012-09-07 17:59:17'),(430,'en','Average Session Time','Average Session Time',0,'2012-09-07 17:59:17'),(431,'en','Shortest Session Time','Shortest Session Time',0,'2012-09-07 17:59:17'),(432,'en','Longest Session','Longest Session',0,'2012-09-07 17:59:17'),(433,'en','Total Session Time','Total Session Time',0,'2012-09-07 17:59:17'),(434,'en','Session Time','Session Time',0,'2012-09-07 17:59:17'),(435,'en','Pause Time','Pause Time',0,'2012-09-07 17:59:17'),(436,'en','Avg. Session Time','Avg. Session Time',0,'2012-09-07 17:59:17'),(437,'en','EXITWITHTIMEOUT','Timed Out',0,'2012-10-01 18:34:19'),(438,'en','Notice','Notice',0,'2012-10-02 05:39:48'),(439,'en','COMPLETECALLER','Complete by Caller',0,'2012-10-01 18:34:19'),(440,'en','COMPLETEAGENT','Complete by Agent',0,'2012-09-07 17:59:17'),(441,'en','TRANSFER','Transfer',0,'2012-09-07 17:59:17'),(442,'en','RINGNOANSWER','Failed to Answer Call',0,'2012-09-07 17:59:17'),(443,'en','Sessions','Sessions',0,'2012-09-07 17:59:17'),(444,'en','Avg. Session','Avg. Session',0,'2012-09-07 17:59:17'),(445,'en','Avg. Paused','Avg. Paused',0,'2012-09-07 17:59:17'),(446,'en','%% Paused','%% Paused',0,'2012-09-07 17:59:17'),(447,'en','Pauses per Session','Pauses per Session',0,'2012-09-07 17:59:17'),(448,'en','Login Form','Login Form',0,'2012-10-02 17:21:11'),(449,'en','User','User',0,'2012-10-02 17:21:11'),(450,'en','Password','Password',0,'2012-10-02 17:21:11'),(451,'en','Login','Login',0,'2012-10-02 17:21:11'),(452,'es','help_text_agent_filter','Expresión regular para filtrar aquellos Agents que no queremos visualizar en la selección inicial.<br/><br/>Ejemplo: <strong>Agent/[0-9][0-9][0-9][0-9]$</strong>\r\n',0,'2012-09-12 23:12:22'),(453,'en','Answered Calls','Answered Calls',0,'2012-09-12 22:00:55'),(454,'es','Cannot steal call. realtime_spy_extension for user <b>%s</b> is not defined in Setup/Preferences.','No se puede capturar el llamado. Falta configurar realtime_spy_extension para el usuario <b>%s</b> en Configuración/Preferencias.',0,'0000-00-00 00:00:00'),(455,'en','Total Duration','Total Duration',0,'2012-09-12 22:00:55'),(456,'en','There is no valid license file on this installation yet.','There is no valid license file on this installation yet.',0,'2012-10-02 05:39:48'),(457,'en','%s records deleted','%s records deleted',0,'2012-10-02 02:40:16'),(458,'en','Completed','Completed',0,'2012-10-02 17:21:37'),(459,'en','%% Talk Time','%% Talk Time',0,'2012-09-12 22:00:55'),(460,'en','Avg Talk Time','Avg Talk Time',0,'2012-09-12 22:00:55'),(461,'en','Avg Wait Time','Avg Wait Time',0,'2012-09-12 22:00:55'),(462,'en','Max Wait Time','Max Wait Time',0,'2012-09-12 22:00:55'),(463,'en','Listen','Listen',0,'2012-09-18 04:51:34'),(464,'en','Download','Download',0,'2012-10-01 18:34:19'),(465,'en','Bad username or password','Bad username or password',0,'2012-09-06 18:22:06'),(466,'en','Add','Add',0,'2012-10-02 05:42:51'),(467,'en','Please copy the above text and send it via email to %s for processing, together with your activation code and the licensee name you want to use','Please copy the above text and send it via email to %s for processing, together with your activation code and the licensee name you want to use',0,'0000-00-00 00:00:00'),(468,'en','Back','Back',0,'2012-10-02 05:39:48'),(469,'en','Revoke','Revoke',0,'0000-00-00 00:00:00'),(470,'en','EXITWITHKEY','Exit with Key',0,'0000-00-00 00:00:00'),(471,'en','Revoke Current License','Revoke Current License',0,'0000-00-00 00:00:00'),(472,'en','No records found','No records found',0,'2012-10-02 17:21:14'),(473,'en','partial','partial',0,'2012-09-07 00:34:02'),(474,'en','ALL','ALL',0,'2012-10-01 23:08:44'),(475,'en','Confirm','Confirm',0,'2012-10-01 23:08:21'),(476,'en','realtime-agent-ringing','Ringing',0,'2012-09-07 21:44:32'),(477,'en','Position','Position',0,'2012-09-07 19:04:39'),(478,'en','realtime-agent-busy','Busy',0,'2012-09-07 21:44:12'),(479,'en','Error updating record','Error updating record',0,'0000-00-00 00:00:00'),(480,'en','An error has occurred','An error has occurred',0,'2012-10-02 02:42:53'),(481,'en','Answered/Abandoned per Hour','Answered/Abandoned per Hour',0,'2012-10-02 01:34:01'),(482,'en','admin-designer','Report Designer',0,'2012-10-02 17:21:37'),(483,'es','Sunday','Domingo',0,'2012-09-17 14:41:28'),(484,'es','Monday','Lunes',0,'2012-09-17 14:41:28'),(485,'es','Tuesday','Martes',0,'2012-09-17 14:41:28'),(486,'es','help_text_hide_parsed_time','Ocultar el tiempo de generación de página en el pie de los reportes.',0,'2012-09-12 23:12:22'),(487,'es','Thursday','Jueves',0,'2012-09-17 14:41:28'),(488,'es','Friday','Viernes',0,'2012-09-17 14:41:28'),(489,'es','Saturday','Sábado',0,'2012-09-17 14:41:28'),(490,'es','admin-designer','Diseñador de Reportes',0,'2012-09-17 14:40:15'),(491,'es','help_text_first_page','Página inicial a cargar (Ej: answered.php, unanswered.php, distribution.php).',0,'2012-09-12 23:12:22'),(492,'es','help_text_drilldown_records_per_page','Numero de registros por pagina en los listados drill down. El valor por omisión es 10.',0,'2012-09-12 23:12:22'),(493,'es','help_text_dict_queue','Entrada de diccionario para nombre de colas. De esta manera podrá cambiar el nombre de una cola por otro. En parámetro debe poner el nombre de cola tal como lo ve originalmente en los reportes, y en valor complete el nombre que desee que aparezca en su lugar.',0,'2012-09-12 23:12:22'),(494,'es','help_text_distribution_interval','Intervalo de tiempo en minutos para separar las tablas de distribución de llamados por hora. El valor por omisión es de 60 minutos, pero puede elegir intervalos menores.',0,'2012-09-12 23:12:22'),(495,'es','help_text_dict_agent','Entrada de diccionario para numero de agente.  En parámetro debe poner el nombre de agente tal como lo ve originalmente en los reportes, y en valor complete el nombre que desee que aparezca en su lugar.',0,'2012-09-12 23:12:22'),(496,'es','help_text_detailed_agent_report','Muestra el reporte detallado de actividad de agentes en la solapa de Agente (similar a la información obtenida durante un drill down, pero aplicado a todos los agentes para el rango completo de fechas seleccionado).',0,'2012-09-12 23:12:22'),(497,'es','help_text_default_start_hour','Hora final para mostrar en la seleccion de fecha/hora, en formato HH:MM.',0,'2012-09-12 23:12:22'),(498,'es','help_text_default_end_hour','Hora inicial para mostrar en la seleccion de fecha/hora, en formato HH:MM.',0,'2012-09-12 23:12:22'),(499,'es','help_text_date_format','Formato para los campos de fecha, en sintaxis Mysql:\r\n\r\nEjemplo: %%m-%%d-%%Y %%H:%%i:%%s',0,'2012-09-12 23:12:22'),(500,'es','help_text_realtime_custom_pauses','Si el valor se pone en 1, la pagina realtime consultara ASTDB por la familia PAUSECUSTOM/Agent y mostrara el tipo de pausa para el agente guardado en el key. Ej: PAUSECUSTOM/Agent/1000 = Break:${EPOCH} guardado en ASTDB mostrara al Agente 1000 con tipo de pausa Break.',0,'2012-09-12 23:12:22'),(501,'es','Transferred Calls','Llamadas Transferidas',0,'2012-09-07 22:26:34'),(502,'es','help_text_csv_separator','Caracter separador para archivos separados por coma (CSV). El valor por defecto es una coma (,) para Excel o similares. Si utiliza OpenOffice puede requerir cambiar este parámetro por un punto y coma (;)',0,'2012-09-12 23:12:22'),(503,'es','Click to add text','Click para agregar texto',0,'2012-09-12 23:26:00'),(504,'es','help_text_call_time_format','Formato para campos de  duración de llamada. HH = horas, MM=minutos, SS=segundos, mm=minutos absolutos, ss=segundos absolutos. Utilizado en reportes de información detallados y drill down.',0,'2012-09-12 23:12:22'),(505,'es','Number of Calls per Agent','Número de Llamadas por Agente',0,'2012-09-07 22:26:35'),(506,'es','Total Time per Agent (seconds)','Tiempo Total por Agente (segundos)',0,'2012-09-07 22:26:35'),(507,'es','Answered/Abandoned per Hour','Atendidas/Abandonadas por Hora',0,'2012-09-17 14:40:08'),(508,'es','partial','parcial',0,'2012-09-06 18:26:33'),(509,'es','help_text_avg_time_format','Formato para campos de promedio de duración. HH = horas, MM=minutos, SS=segundos, mm=minutos absolutos, ss=segundos absolutos. Utilizado en reportes de información detallados y drill down.',0,'2012-09-12 23:12:22'),(510,'es','help_text_asterisk_12','Si utiliza Asterisk 1.2.X ponga este valor en 1 para que funcione la solapa &quot;Estado Actual&quot;',0,'2012-09-12 23:12:22'),(511,'es','help_text_realtime_alarm_threshold','Umbral (en porcentual) a partir del cual empezar a colorear los registros en alarma.',0,'2012-09-12 23:12:22'),(512,'es','Confirm','Confirmar',0,'2012-09-12 22:58:56'),(513,'es','No info','Sin datos',0,'2012-09-04 22:37:44'),(514,'es','Play','Escuchar Grabación',0,'2012-09-11 00:46:36'),(515,'es','help_text_realtime_alarm_wait_count','Alarma (en cantidad de llamados) para los llamados esperando en una cola.',0,'2012-09-12 23:12:22'),(516,'es','help_text_realtime_alarm_row_color','Color de fondo de una fila cuando algún valor está en alarma.',0,'2012-09-12 23:12:22'),(517,'es','Sessions','Sesiones',0,'2012-09-07 18:45:47'),(518,'es','Avg. Session','Promedio Sesión',0,'2012-09-07 18:45:47'),(519,'es','Avg. Paused','Promedio en Pausa',0,'2012-09-07 18:45:47'),(520,'es','%% Paused','%% en Pausa',0,'2012-09-07 18:45:47'),(521,'es','Pauses per Session','Pausas por Sesión',0,'2012-09-07 18:45:47'),(522,'es','Time','Duración',0,'2012-09-07 18:45:47'),(523,'es','Overflow','Desborde',0,'2012-09-06 18:24:13'),(524,'es','Clear Selection','Limpiar Selección',0,'0000-00-00 00:00:00'),(525,'es','All %s records are selected.','Todos los %s registros han sido seleccionados.',0,'0000-00-00 00:00:00'),(526,'es','Wednesday','Miércoles',0,'2012-09-17 14:41:28'),(527,'es','Select language','Elija idioma',0,'2012-09-12 23:26:00'),(528,'es','Invalid Date','Fecha Inválida',0,'0000-00-00 00:00:00'),(529,'en','%s secs','%s secs',0,'0000-00-00 00:00:00'),(530,'es','EXITWITHKEY','Salida por Tecla',0,'0000-00-00 00:00:00'),(531,'es','realtime-agent-busy','Ocupado',0,'0000-00-00 00:00:00'),(532,'en','%','%',0,'2012-10-01 18:34:18'),(533,'en','disposition_help_EXITWITEMPTY','The caller was exited from the queue forcefully because the queue had no\r\nreachable members and it&lsquo;s configured to do that to callers when there\r\nare no reachable members. The position is the caller&lsquo;s position in the\r\nqueue when they hungup, the origposition is the original position the\r\ncaller was when they first entered the queue, and the waittime is how\r\nlong the call had been waiting in the queue at the time of disconnect.',0,'2012-10-01 18:34:19'),(534,'en','none','none',0,'0000-00-00 00:00:00'),(535,'en','seconds','seconds',0,'0000-00-00 00:00:00'),(536,'en','Count','Count',0,'2012-09-21 20:07:06'),(537,'en','Month','Month',0,'2012-10-02 01:34:01'),(538,'es','%s days','%s días',0,'2012-09-17 14:40:08'),(539,'en','Select option','Select option',0,'2012-10-02 17:21:37'),(540,'en','Select language','Select language',0,'2012-10-02 17:21:37'),(541,'en','Cannot steal call. realtime_spy_extension for user <b>%s</b> is not defined in Setup/Preferences.','Cannot steal call. realtime_spy_extension for user <b>%s</b> is not defined in Setup/Preferences.',0,'0000-00-00 00:00:00'),(542,'en','help_text_realtime_spy_options','Options to pass to chanspy when launching a Listen action from the realtime view. You can use any options available to the asterisk chanspy application, like &quot;q&quot; to disable the initial beep, etc.',0,'2012-10-02 04:55:45'),(543,'en','ABANDON','Abandoned',0,'2012-10-01 18:34:19'),(544,'es','Record inserted','Registro Insertado',0,'0000-00-00 00:00:00'),(545,'en','help_text_realtime_spy_extension','Extension to reach the supervisor phone when launching a call steal action in the realtime view. The parameter must be set to the asternic user name, the value could be the extension number followed by the context, for example: 100@from-internal',0,'2012-10-02 04:55:45'),(546,'en','disposition_help_ABANDON','The caller abandoned their position in the queue. The position is the\r\ncaller&rsquo;s position in the queue when they hungup, the origposition is\r\nthe original position the caller was when they first entered the\r\nqueue, and the waittime is how long the call had been waiting in the\r\nqueue at the time of disconnect.',0,'2012-10-01 18:34:19'),(547,'en','disposition_help_EXITWITHKEY','The caller elected to use a menu key to exit the queue. The key and\r\nthe caller&lsquo;s position in the queue are recorded.\r\n',0,'2012-10-01 18:34:19'),(548,'en','help_text_realtime_coach_options','Options to pass to chanspy when launching a Coach action from the realtime view. You can use any options available to the asterisk chanspy application, like &quot;w&quot; to enable whispering, or &quot;d&quot; to use dtmf to switch modes: 4 spy, 5 whisper, 6 barge., etc.',0,'2012-10-02 04:55:45'),(549,'es','help_text_realtime_alarm_wait_duration','Alarma de llamada en espera en la vista en TiempoReal definiendo su duración. Puede asignarse a una cola definiendo el nombre de la cola en el parámetro.',0,'2012-09-12 23:12:22'),(550,'es','help_text_realtime_alarm_pause_duration','Alarma (en segundos) para la duración de pausa en la vista de estado actual. Puede configurarse un valor independiente por cola poniendo el nombre de cola como parámetro.',0,'2012-09-12 23:12:22'),(551,'es','help_text_realtime_alarm_last_call','Alarma (en segundos) para tiempo desde el último llamado recibido de cola en la vista de estado actual. Puede configurarse un valor independiente por cola poniendo el nombre de cola como parámetro.',0,'2012-09-12 23:12:22'),(552,'es','help_text_agent_row_color','Para rellenar el fondo de la celda del Agente con su color de estado en la vista TiempoReal, activar con 1',0,'2012-09-12 23:12:22'),(553,'en','Next','Next',0,'2012-10-02 17:21:37'),(554,'en','No','No',0,'2012-10-02 17:21:37'),(555,'en','Server Time','Server Time',0,'2012-09-18 04:51:34'),(556,'es','help_text_realtime_alarm_call_duration','Alarma de duración de llamada activada por segundos para la vista en TiempoReal. Puede definirse por cola configurando el parámetro al nombre de la cola.',0,'2012-09-12 23:12:22'),(557,'en','No info','No info',0,'2012-09-04 22:05:40'),(558,'en','Total','Total',0,'2012-10-02 17:21:01'),(559,'en','Max. wait time','Max. wait time',0,'2012-09-18 04:51:34'),(560,'en','Toggle Search Form','Toggle Search Form',0,'2012-09-08 19:59:58'),(561,'en','To','To',0,'2012-10-02 17:21:11'),(562,'en','hours','hours',0,'2012-10-02 17:21:11'),(563,'en','Select Time Frame','Select Time Frame',0,'2012-10-02 17:21:11'),(564,'en','This month','This month',0,'2012-10-02 17:21:11'),(565,'en','This week','This week',0,'2012-10-02 17:21:11'),(566,'en','Today','Today',0,'2012-10-02 17:21:11'),(567,'en','Select Date Range','Select Date Range',0,'2012-10-02 17:21:11'),(568,'en','Select Agents','Select Agents',0,'2012-10-02 17:21:11'),(569,'en','Selected','Selected',0,'2012-10-02 17:21:11'),(570,'en','Selects all','Selects all',0,'2012-10-02 17:21:11'),(571,'en','Selects marked','Selects marked',0,'2012-10-02 17:21:11'),(572,'en','Select Queues','Select Queues',0,'2012-10-02 17:21:11'),(573,'en','Search','Search',0,'2012-10-02 17:21:37'),(574,'en','September','September',0,'2012-10-02 17:21:37'),(575,'en','Steal','Steal',0,'2012-09-18 04:51:34'),(576,'en','Saturday','Saturday',0,'2012-10-02 17:21:37'),(577,'en','Friday','Friday',0,'2012-10-02 17:21:37'),(578,'en','Thursday','Thursday',0,'2012-10-02 17:21:37'),(579,'en','Wednesday','Wednesday',0,'2012-10-02 17:21:37'),(580,'en','Tuesday','Tuesday',0,'2012-10-02 17:21:37'),(581,'en','Monday','Monday',0,'2012-10-02 17:21:37'),(582,'en','Sunday','Sunday',0,'2012-10-02 17:21:37'),(583,'es','Add Record','Agregar Registro',0,'0000-00-00 00:00:00'),(584,'es','Select option','Elija opción',0,'2012-09-12 23:38:01'),(585,'es','ABANDON','Abandonada',0,'2012-09-11 00:46:36'),(586,'en','%s %%','%s %%',0,'0000-00-00 00:00:00'),(587,'es','EXITWITHTIMEOUT','Tiempo Máximo Alcanzado',0,'2012-09-07 22:26:30'),(588,'es','realtime-agent-dialout','Llamada Saliente',0,'0000-00-00 00:00:00'),(589,'en','Select some options','Elija algunas opciones',0,'2012-10-01 23:08:21'),(590,'en','Average Duration by Day','Average Duration by Day',0,'2012-10-02 01:34:01'),(591,'en','Average Wait Time by Day','Average Wait Time by Day',0,'2012-10-02 01:34:01'),(592,'es','Average Duration by Day','Duración Promedio por Día',0,'2012-09-17 14:40:08'),(593,'es','Average Wait Time by Day','Espera Promedio por Día',0,'2012-09-17 14:40:08'),(594,'en','%s minutes','%s minutes',0,'0000-00-00 00:00:00'),(595,'es','Unanswered by Day','Sin Atender por Día',0,'2012-09-17 14:40:08'),(596,'en','Invalid Hour','Invalid Hour',0,'0000-00-00 00:00:00'),(597,'en','Invalid Date','Invalid Date',0,'0000-00-00 00:00:00'),(598,'en','%s','%s',0,'2012-09-07 17:59:17'),(599,'en','License Handling','License Handling',0,'2012-10-02 05:39:48'),(600,'es','Spy','Espiar',0,'0000-00-00 00:00:00'),(601,'en','Coach','Coach',0,'2012-09-18 04:51:34'),(602,'es','%','%',0,'2012-09-17 14:40:08'),(603,'en','info2','info 2',0,'2012-09-06 22:00:52'),(604,'en','info3','Info 3',0,'2012-09-06 22:00:52'),(605,'en','info1','Info 1',0,'2012-09-06 22:00:52'),(606,'es','TRANSFER','Transferida',0,'2012-09-07 18:45:47'),(607,'es','%s secs','%s segs',0,'0000-00-00 00:00:00'),(608,'es','URL','URL',0,'2012-09-17 14:40:08'),(609,'es','%s %%','%s %%',0,'0000-00-00 00:00:00'),(610,'en','Generate Offline License Request','Generate Offline License Request',0,'2012-10-02 05:39:48'),(611,'en','Answered by Day','Answered by Day',0,'2012-10-02 01:34:01'),(612,'es','SLA','SLA',0,'2012-09-17 14:40:08'),(613,'en','Play','Play',0,'2012-10-01 18:34:19'),(614,'es','Invalid Hour','Hora Inválida',0,'0000-00-00 00:00:00'),(615,'es','Help','Ayuda',0,'2012-09-12 23:12:22'),(616,'es','If the field value is higher than this number you will receive an alerting email','Si el valor del campo es mayor al indicado aquí, entonces reicibirá un email de alerta.',0,'2012-09-12 23:37:57'),(617,'es','help_text_timeframe_interval','Intervalo en minutos para presentar en la selección de horarios en la solapa de Inicio. El valor por omisión es de 15 minutos.',0,'2012-09-12 23:12:22'),(618,'es','help_text_sla_unanswered','Tiempo SLA en segundos para llamadas No Atendidas (no incluye las Abandonadas sino las no atendidas por otras razones, como ser Tiempo Expirado, Salida por tecla, etc).',0,'2012-09-12 23:12:22'),(619,'es','help_text_sla_transferred','Tiempo SLA en segundos para llamadas Transferidas.',0,'2012-09-12 23:12:22'),(620,'es','help_text_sla_answered','Tiempo SLA en segundos para llamadas Atendidas.',0,'2012-09-12 23:12:22'),(621,'es','help_text_sla_abandoned','Tiempo SLA en segundos para llamadas Abandonadas.',0,'2012-09-12 23:12:22'),(622,'es','help_text_decimal_places','Cantidad de posiciones decimales a mostrar al redondear números decimales. El valor por omisión es dos.',0,'2012-09-12 23:12:22'),(623,'en','disposition_help_COMPLETECALLER','The caller was connected to an agent, and the call was terminated normally\r\nby the *caller*. The callers hold time and the length of the call are both\r\nrecorded. The caller&rsquo;s original position in the queue is recorded in\r\norigposition.\r\n',0,'2012-10-01 18:34:19'),(624,'es','%s','%s',0,'2012-09-07 18:45:47'),(625,'en','realtime-agent-dialout','Outbound Call',0,'2012-09-07 21:45:12'),(626,'en','May','May',0,'2012-10-02 17:21:37'),(627,'en','help_text_agent_filter','Regular Expression to filter unwanted Agents from initial selection.<br/> Example: <strong>Agent/[0-9][0-9][0-9][0-9]$</strong>\r\n\r\n\r\n\r\n',0,'2012-10-02 04:55:45'),(628,'en','help_text_agent_row_color','To paint the whole cell background to the status color for an agent in the realtime view, set this to 1',0,'2012-10-02 04:55:45'),(629,'en','help_text_realtime_alarm_call_duration','Alarm in seconds for call duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',0,'2012-10-02 04:55:45'),(630,'en','help_text_realtime_alarm_wait_duration','Alarm in seconds for call waiting duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',0,'2012-10-02 04:55:45'),(631,'en','help_text_realtime_alarm_last_call','Alarm in seconds for the last call information in the realtime view. Can be set per queue by setting the parameter to the queue name.',0,'2012-10-02 04:55:45'),(632,'en','help_text_realtime_alarm_pause_duration','Alarm in seconds for pause/break duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',0,'2012-10-02 04:55:45'),(633,'en','help_text_realtime_alarm_row_color','Background row color when a value is in alarm in the realtime view.',0,'2012-10-02 04:55:45'),(634,'en','help_text_realtime_alarm_wait_count','Alarm (in number of calls) for calls waiting in a queue in the realtime view.',0,'2012-10-02 04:55:45'),(635,'en','help_text_realtime_alarm_threshold','Threshold (in percentage) from which to start coloring in alarm calls in the realtime view.',0,'2012-10-02 04:55:45'),(636,'en','help_text_asterisk_12','Set this to 1 if you are using Asterisk 1.2 or older, otherwise you will have some issues in the realtime view.',0,'2012-10-02 04:55:45'),(637,'en','help_text_avg_time_format','Format for average duration fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in drill down and detailed reports.',0,'2012-10-02 04:55:45'),(638,'en','help_text_call_time_format','Format for the call duration fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in drill down and detailed reports.',0,'2012-10-02 04:55:45'),(639,'en','help_text_csv_separator','Separator character to use in CSV export files. Default value is comma (,) for Excel and friends. If you use LibreOffice/OpenOffice you might need to change it to semicolon (;)',0,'2012-10-02 04:55:45'),(640,'en','help_text_realtime_custom_pauses','If this value is set to 1 the realtime page will check the ASTDB for the PAUSECUSTOM/Agent family and it will show the pause code stored there for a particular Agent as stored in astdb Key. Eg: PAUSECUSTOM/Agent/1000 = Break:${EPOCH} stored in ASTDB will show Agent 1000 as break when paused.',0,'2012-10-02 04:55:45'),(641,'en','help_text_date_format','Format for the date field, using MySQL syntax. Example: %%m-%%d-%%Y %%H:%%i:%%s. This is used on drill down or detailed reports only. The report format themselves are set in the designer.',0,'2012-10-02 04:55:45'),(642,'en','help_text_default_end_hour','Default end hour in HH:SS format for the date/time selection.',0,'2012-10-02 04:55:45'),(643,'en','help_text_default_start_hour','Default start hour in HH:SS format for the date/time selection.',0,'2012-10-02 04:55:45'),(644,'en','help_text_detailed_agent_report','Show a detailed agent report in the Agent tab. (Similar to the drill down information you can get on a regular report, but already expanded for the complete date range selection).',0,'2012-10-02 04:55:45'),(645,'en','help_text_dict_agent','Dictionary entry for Agents. It will replace the agent set as the parameter to the value you specify (So you can use names instead of interfaces).',0,'2012-10-02 04:55:45'),(646,'en','help_text_dict_queue','Dictionary entry for Queues. Same as the agent dictionary, but for replacing queue names.',0,'2012-10-02 04:55:45'),(647,'en','help_text_distribution_interval','Interval in minutes to break up the distribution by hour report. By default it breaks by hour (60 minutes), but you can use smaller or larger values.',0,'2012-10-02 04:55:45'),(648,'en','help_text_drilldown_records_per_page','Number of records per page to show when expanding/drilling down on any report.',0,'2012-10-02 04:55:45'),(649,'en','help_text_first_page','Initial page to load (Eg: answered.php, unanswered.php, distribution.php, agent.php). Can be set per user',0,'2012-10-02 04:55:45'),(650,'en','help_text_hide_parsed_time','Set this to 1 to hide the parsed time information on the footer of every report.',0,'2012-10-02 04:55:45'),(651,'en','help_text_honor_timeframe_in_agent','Honor time frame selection in Agent Tab Reports. It will also try to compute missing events for the period if \nthey are not in the logs.',0,'2012-10-02 04:55:45'),(652,'en','help_text_ignore_none_abandons','If you do not want to count for inbound abandoned calls when selecting some agents from a report, set this parameter to one. This is useful for when you are tracking outbound campaigns and want to track performance per agent on outbound as it filters out the inbound abandoned calls that are assigned to the whole queue (agent NONE) and not a particular agent. If you select all agents for a report it will include also the NONE agent, so inbound abandons will count normally event if this parameter is set to one.',0,'2012-10-02 04:55:45'),(653,'en','help_text_language','Language to use. You can specify a user name in the parameter field to limit the language to a particular user. If the parameter field is left empty, then the language will be set for all users (global setting).',0,'2012-10-02 04:55:45'),(654,'en','help_text_short_abandon_threshold','Duration  treshhold (in seconds) for a call to be considered as abandoned (if duration is less than this value, then ignore the call completely). Specifying the queue name as a parameter will apply the value to that queue only.',0,'2012-10-02 04:55:45'),(655,'en','help_text_realtime_refresh','Refresh time in seconds for the realtime view.',0,'2012-10-02 04:55:45'),(656,'en','help_text_recordings_path','Recordings location/directory in the hardrive to perform the direct download.',0,'2012-10-02 04:55:45'),(657,'en','help_text_session_time_format','Format for the session duration fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in the agent reports.',0,'2012-10-02 04:55:45'),(658,'en','help_text_shared_lastcall','Compartir la información de último llamado entre colas. Sólo se mostrará el tiempo más corto para todas las colas. Si se utiliza rastreo de salientes y se guarda el valor astdb LASTCALL, será también tomado en cuenta.',0,'2012-10-02 04:55:45'),(659,'en','help_text_show_agent_call','Show end call events when drilling down on agent reports',0,'2012-10-02 04:55:45'),(660,'en','help_text_show_agent_field','Mostrar columna de Agente en reportes de no atendidos (útil cuando se rastrean llamados salientes)',0,'2012-10-02 04:55:45'),(661,'en','help_text_show_url_field','Enable and display the URL field and reports',0,'2012-10-02 04:55:45'),(662,'en','help_text_sla_interval','Time interval in seconds to split the table for SLA (Service Level Agreement) and Abandon Rate reports.',0,'2012-10-02 04:55:45'),(663,'en','help_text_sla_steps','Number of steps to show in SLA (Service Level Agreement) and Abandon Rate reports.',0,'2012-10-02 04:55:45'),(664,'en','help_text_realtime_spy_device','Device used by the user (set in the parameter field). Example: SIP/1234',0,'2012-10-02 04:55:45'),(665,'en','help_text_timezone','Timezone Configuration for user, in the format [ -]HH:MM\r\n\r\nIf the user name is specified as parameter, then applies only to that user. If parameter is left blank it will be applied globally.',0,'2012-10-02 04:55:45'),(666,'en','help_text_wait_time_format','Format for the wait time fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in drill down and detailed reports.',0,'2012-10-02 04:55:45'),(667,'en','help_text_week_mode','When to start counting weeks from the year:<br><pre>\r\nMode    First day of week       Range   Week 1 is the first week ...\r\n0       Sunday                  0-53    with a Sunday in this year\r\n1       Monday                  0-53    with more than 3 days this year\r\n2       Sunday                  1-53    with a Sunday in this year\r\n3       Monday                  1-53    with more than 3 days this year\r\n4       Sunday                  0-53    with more than 3 days this year\r\n5       Monday                  0-53    with a Monday in this year\r\n6       Sunday                  1-53    with more than 3 days this year\r\n7       Monday                  1-53    with a Monday in this year\r\n</pre>',0,'2012-10-02 04:55:45'),(668,'en','disposition_help_EXITWITHTIMEOUT','The caller was on hold too long and the timeout expired.',0,'2012-10-01 18:34:19'),(669,'en','Select an option','Select an option',0,'2012-10-02 17:21:27'),(670,'en','Save','Save',0,'2012-10-02 17:21:27'),(671,'en','Add Record','Add Record',0,'2012-10-01 23:10:14'),(672,'en','Record inserted','Record inserted',0,'2012-10-01 23:10:23'),(673,'en','Help','Help',0,'2012-10-02 04:55:45'),(674,'en','help_text_decimal_places','Number of decimal places to show on float numbers.',0,'2012-10-02 04:55:45'),(675,'en','help_text_sla_abandoned','Service Level value in seconds for Abandoned calls',0,'2012-10-02 04:55:45'),(676,'en','help_text_sla_answered','Service Level value in seconds for Answered calls',0,'2012-10-02 04:55:45'),(677,'en','help_text_sla_transferred','Service Level value in seconds for Transferred calls',0,'2012-10-02 04:55:45'),(678,'en','help_text_sla_unanswered','Service Level value in seconds for unanswered calls (not abandoned, but unanswered due to timeouts, exit with key, etc).',0,'2012-10-02 04:55:45'),(679,'en','help_text_timeframe_interval','Interval in minutes to present the time frame selection on the home tab. Defaults to 15 minutes.',0,'2012-10-02 04:55:45'),(680,'en','%s days','%s days',0,'2012-10-01 18:34:18'),(681,'en','Total Answered Calls','Total Answered Calls',0,'2012-09-12 22:00:55'),(682,'en','Transferred Calls','Transferred Calls',0,'2012-09-12 22:00:55'),(683,'en','Talk Time','Talk Time',0,'2012-10-01 18:34:19'),(684,'es','Answered by Day','Atendidas por Día',0,'2012-09-17 14:40:08'),(685,'en','Unanswered by Day','Unanswered by Day',0,'2012-10-02 01:34:01'),(686,'en','All %s records on this page are selected.','All %s records on this page are selected.',0,'2012-10-02 02:40:12'),(687,'en','Time','Time',0,'2012-09-07 17:59:17'),(688,'es','%s minutes','%s mins',0,'0000-00-00 00:00:00'),(689,'es','Error inserting record:<br/>','Error al insertar registro:<br/>',0,'0000-00-00 00:00:00'),(690,'en','Error inserting record:<br/>','Error inserting record:<br/>',0,'2012-09-07 21:54:46'),(691,'en','Spy','Spy',0,'0000-00-00 00:00:00'),(692,'en','Clear Selection','Clear Selection',0,'2012-10-02 02:40:13'),(693,'en','All %s records are selected.','All %s records are selected.',0,'2012-10-02 02:40:13'),(694,'en','disposition_help_TRANSFER','Caller was transferred to a different extension. Context and extension\r\nare recorded. The caller&lsquo;s hold time and the length of the call are both\r\nrecorded. PLEASE remember that transfers performed by SIP UA&lsquo;s by way\r\nof a reinvite may not always be caught by Asterisk and trigger off this\r\nevent. The only way to be 100% sure that you will get this event when\r\na transfer is performed by a queue member is to use the built-in transfer\r\nfunctionality of Asterisk.',0,'2012-10-01 18:34:19'),(695,'es','Email','Email',0,'2012-09-12 23:37:57'),(696,'es','event_help_completecaller_info1','holdtime, Tiempo que espero el cliente a ser atendido',0,'2012-09-07 22:26:12'),(697,'es','event_help_completecaller_info2','holdtime, Duración de la llamada',0,'2012-09-07 22:26:12'),(698,'es','event_help_completecaller_info3','origposition, Posición donde ingresó en que ingresó el llamado a la cola.',0,'2012-09-07 22:26:12'),(699,'es','event_help_completeagent_info1','holdtime, Tiempo que espero el cliente a ser atendido',0,'2012-09-07 22:26:12'),(700,'es','event_help_completeagent_info2','holdtime, Duración de la llamada',0,'2012-09-07 22:26:12'),(701,'es','event_help_completeagent_info3','origposition, Posición donde ingresó en que ingresó el llamado a la cola.',0,'2012-09-07 22:26:12'),(702,'es','event_help_abandon_info1','position, la posición que tenía en la cola cuando realizó el hangup',0,'2012-09-07 22:26:12'),(703,'es','event_help_abandon_info2','origposition, la posición en la que entró en la cola',0,'2012-09-07 22:26:12'),(704,'es','event_help_abandon_info3','waittime, el tiempo que espero en la cola',0,'2012-09-07 22:26:12'),(705,'es','event_help_agentlogin_info1','channel, el canal donde se genero el logueo',0,'2012-09-07 22:26:12'),(706,'es','event_help_agentcallbacklogin_info1','exten@context, el interno@contexto del agente',0,'2012-09-07 22:26:12'),(707,'es','event_help_agentlogoff_info2','logintime, la cantidad de tiempo que el agente estuvo logueado. (en segundos)',0,'2012-09-07 22:26:12'),(708,'es','event_help_agentlogoff_info1','channel, el canal donde se origino el deslogueo',0,'2012-09-07 22:26:12'),(709,'es','event_help_connect_info1','holdtime, la cantidad de tiempo que el cliente estuvo en hold',0,'2012-09-07 22:26:12'),(710,'es','event_help_connect_info2','bridgedchanneluniqueid, es el uniqueid del canal del agente que toma el llamado',0,'2012-09-07 22:26:12'),(711,'es','event_help_exitempty_info1','position, posición de la llamada en el momento que fue rechazada',0,'2012-09-07 22:26:12'),(712,'es','event_help_exitempty_info2','origposition, posición de la llamada cuando ingresó a la cola',0,'2012-09-07 22:26:12'),(713,'es','event_help_exitempty_info3','waittime, tiempo de espera',0,'2012-09-07 22:26:12'),(714,'es','event_help_exitwithkey_info1','key, tecla que presionó para salir de la cola',0,'2012-09-07 22:26:12'),(715,'es','event_help_exitwithkey_info2','position, posición en la que se encontraba en la cola al momento de salir',0,'2012-09-07 22:26:12'),(716,'es','event_help_ringnoanswer_info1','ringtime, tiempo que estuvo sonando el teléfono del agente.',0,'2012-09-07 22:26:12'),(717,'es','event_help_transfer_info1','extension, interno de destino',0,'2012-09-07 22:26:12'),(718,'es','event_help_transfer_info2','context, contexto utilizado',0,'2012-09-07 22:26:12'),(719,'es','event_help_transfer_info3','holdtime, tiempo en espera del agente hasta que se realizó la transferencia',0,'2012-09-07 22:26:12'),(720,'es','event_help_transfer_info4','calltime, duración de la llamada hasta que fue transferida. ',0,'2012-09-07 22:26:12'),(721,'es','event_help_agentcallbacklogoff_info1','exten@context, el interno@contexto utilizado por el agente',0,'2012-09-07 22:26:12'),(722,'es','event_help_agentcallbacklogoff_info2','logintime, el tiempo que estuvo logueado',0,'2012-09-07 22:26:12'),(723,'es','event_help_agentcallbacklogoff_info3','reason, la razón por la cual fue deslogueado, si no es un logoff normal. Ej: Autologoff, Chanunavail',0,'2012-09-07 22:26:12'),(724,'es','disposition_help_EXITWITHTIMEOUT','El tiempo máximo de espera en cola fue alcanzado, por lo que el usuario fue desconectado de la misma y dirigido al siguiente paso en su plan de discado.',0,'2012-09-11 00:46:36'),(725,'es','disposition_help_EXITWITHKEY','El usuario se salió de la cola marcando un dígito de salida.',0,'2012-09-11 00:46:36'),(726,'en','event_help_agentlogin_info1','The agent logged in. The channel is recorded.',0,'2012-09-06 22:00:52'),(727,'en','event_help_agentcallbacklogin_info1','The callback agent logged in. The login extension and context is recorded.',0,'2012-09-06 22:00:52'),(728,'en','event_help_agentlogoff_info1','The agent logged off.',0,'2012-09-06 22:00:52'),(729,'en','event_help_agentlogoff_info2','The total time the agent was logged in.',0,'2012-09-06 22:00:52'),(730,'en','event_help_agentcallbacklogoff_info1','The callback agent logged off.',0,'2012-09-06 22:00:52'),(731,'en','event_help_agentcallbacklogoff_info2','The last login extension and context is recorded, along with the total time the agent was logged in.',0,'2012-09-06 22:00:52'),(732,'en','event_help_agentcallbacklogoff_info3','The reason for the logoff if it was not a normal logoff (e.g., Autologoff, Chanunavail)',0,'2012-09-06 22:00:52'),(733,'en','event_help_enterqueue_info1','URL parameter',0,'2012-09-06 22:00:52'),(734,'en','event_help_enterqueue_info2','Caller ID',0,'2012-09-06 22:00:52'),(735,'en','event_help_completecaller_info1','The caller&#39;s hold time',0,'2012-09-06 22:00:52'),(736,'en','event_help_completecaller_info2','The length of the call.',0,'2012-09-06 22:00:52'),(737,'en','event_help_completecaller_info3','The caller&#39;s original position in the queue is recorded in origposition.',0,'2012-09-06 22:00:52'),(738,'en','event_help_completeagent_info1','The caller&#39;s hold time.',0,'2012-09-06 22:00:52'),(739,'en','event_help_completeagent_info2','The length of the call.',0,'2012-09-06 22:00:52'),(740,'en','event_help_completeagent_info3','The caller&#39;s original position in the queue is recorded in origposition.',0,'2012-09-06 22:00:52'),(741,'en','event_help_connect_info1','Hold time represents the amount of time the caller was on hold.',0,'2012-09-06 22:00:52'),(742,'en','event_help_connect_info2','The bridged channel unique ID contains the unique ID of the queue member channel that is taking the call.',0,'2012-09-06 22:00:52'),(743,'en','event_help_exitempty_info1','The position is the caller&#39;s position in the queue when they hungup.',0,'2012-09-06 22:00:52'),(744,'en','event_help_exitempty_info2','The origposition is the original position the caller was when they first entered the queue.',0,'2012-09-06 22:00:52'),(745,'en','event_help_exitempty_info3','The waittime is how long the call had been waiting in the queue at the time of disconnect.',0,'2012-09-06 22:00:52'),(746,'en','event_help_exitwithkey_info1','The caller elected to use a menu key to exit the queue.',0,'2012-09-06 22:00:52'),(747,'en','event_help_exitwithkey_info2','The caller&#39;s position.',0,'2012-09-06 22:00:52'),(748,'en','event_help_ringnoanswer_info1','Time in milliseconds the agent phone rang until the timeout was reached. The attempt ended without the member picking up the call. Bad queue member!',0,'2012-09-06 22:00:52'),(749,'en','event_help_transfer_info1','The extension',0,'2012-09-06 22:00:52'),(750,'en','event_help_transfer_info2','The context',0,'2012-09-06 22:00:52'),(751,'en','event_help_transfer_info3','The caller&#39;s hold time',0,'2012-09-06 22:00:52'),(752,'en','event_help_transfer_info4','The length of the call.',0,'2012-09-06 22:00:52'),(753,'en','event_help_abandon_info1','The position is the caller&#39;s position in the queue when they hungup.',0,'2012-09-06 22:00:52'),(754,'en','event_help_abandon_info2','The original position the caller was positioned when they first entered the queue.',0,'2012-09-06 22:00:52'),(755,'en','event_help_abandon_info3','The waittime is how long the call had been waiting in the queue at the time of disconnect.',0,'2012-09-06 22:00:52'),(756,'en','event_help_connect_info3','Ringtime represents the time the queue members phone was ringing prior to being answered.',0,'2012-09-06 22:00:52'),(757,'en','within %d%s seconds','within %d%s seconds',0,'2012-09-21 20:07:06'),(758,'en','event_help_transfer_info5','The caller&#39;s entry position at the time of the transfer.',0,'2012-09-06 22:00:52'),(759,'en','event_help_pause_info1','Pause reason if any',0,'2012-09-06 22:00:52'),(760,'en','event_help_unpause_info1','Unpause reason if any',0,'2012-09-06 22:00:52'),(761,'en','event_help_enterqueue_info3','The original position the caller was positioned when they first entered the queue.',0,'2012-09-06 22:00:52'),(762,'en','event_help_exitwithtimeout_info1','The position the caller was when exiting the queue.',0,'2012-09-06 22:00:52'),(763,'en','event_help_exitwithtimeout_info2','Original position at which the called entered the queue.',0,'2012-09-06 22:00:52'),(764,'en','event_help_exitwithtimeout_info3','Amount of time the caller waited in the queue.',0,'2012-09-06 22:00:52'),(765,'es','disposition_help_EXITWITEMPTY','No había ningún agente disponible en la cola, por lo que el usuario fue desconectado de la misma y dirigido al siguiente paso en el plan de discado.',0,'2012-09-11 00:46:36'),(766,'es','disposition_help_COMPLETECALLER','El llamado fue atendido por el agente, pero quien cortó primero la llamada fue el usuario.',0,'2012-09-11 00:46:36'),(767,'es','disposition_help_COMPLETEAGENT','El llamado fue atendido por el agente, quien finalmente finalizó la llamada cortando antes que el usuario.',0,'2012-09-11 00:46:36'),(768,'es','disposition_help_TRANSFER','El llamado fue conectado al agente, quien finalmente transfirió el mismo hacia otro lugar.',0,'2012-09-11 00:46:36'),(769,'es','info1','Info 1',0,'2012-09-07 22:26:12'),(770,'es','info2','Info 2',0,'2012-09-07 22:26:12'),(771,'es','info3','Info 3',0,'2012-09-07 22:26:12'),(772,'es','info4','Info 4',0,'2012-09-07 22:26:12'),(773,'es','info5','Info 5',0,'2012-09-07 22:26:12'),(774,'es','Seconds','Segundos',0,'2012-09-07 22:26:12'),(775,'es','disposition_help_ENTERQUEUE','La llamada entró en la cola.',0,'2012-09-11 00:46:36'),(776,'es','event_help_enterqueue_info3','La posici&oacute;n inicial en la que entr&oacute; el llamado al entrar en la cola.',0,'2012-09-07 22:26:12'),(777,'es','calls','llamadas',0,'2012-09-17 14:40:08'),(778,'es','Coach','Entrenamiento',0,'0000-00-00 00:00:00'),(779,'es','Steal','Capturar',0,'0000-00-00 00:00:00'),(780,'es','help_text_realtime_coach_options','Opciones de chanspy para pasar a la acción de Entrenamiento, usualmente se utiliza la opción &quot;w&quot; para habilitar whisper. También podría utilizarse &quot;d&quot; en Asterisk 1.8 o superior para habilitar modo selectivo por DTMF, digitando 4 para spy, 5 para whisper y 6 para barge.',0,'2012-09-12 23:12:22'),(781,'es','help_text_realtime_spy_extension','Extensión utilizada por el usuario (configurado como parámetro) para recibir un llamado capturado. Puede incluirse también el contexto de dialplan separandolo con una arroba. \n\nEj: 100@from-internal',0,'2012-09-12 23:12:22'),(782,'es','help_text_realtime_spy_options','Opciones para pasar a chanspy cuando se incia una escucha de llamada. Algunas opciones posibles son: &quot;E&quot; para que finalice la escucha cuando se corta la llamada, &quot;q&quot; para silenciar el beep al inicio de la escucha, etc.',0,'2012-09-12 23:12:22'),(783,'es','disposition_help_RINGNOANSWER','Luego de sonar el teléfono del miembro de cola por la cantidad de milisengundos del campo info1, el intento finalizó sin que el agente atendiera la llamada. Mal desempeño del agente!',0,'2012-09-11 00:46:36'),(784,'es','help_text_short_unanswered_threshold','Tiempo mínimo que una llamada debe tener (en segundos) para que sea considerada entre las llamadas no atendidas. Si se especifica como parámetro el nombre de una cola, entonces se aplicará para esa cola solamente.',0,'2012-09-12 23:12:22'),(785,'en','disposition_help_RINGNOANSWER','The timeout value for ringing the queue member was exceeded. A single parameter will also be written indicating the amount of time the member’s extension rang in the Info 1 field.',0,'2012-10-01 18:34:19'),(786,'en','disposition_help_ENTERQUEUE','A caller entered the queue. Three parameters are also written: the URL (if specified) in the Info 1 field and the caller ID of the caller on the Info 2 field, and the original position where the call has landed in the Info 3 field.',0,'2012-10-01 18:34:19'),(787,'en','disposition_help_CONNECT','The caller was connected to an agent.',0,'2012-10-01 18:34:19'),(788,'es','help_text_variable_ANSWERED_SLA','N&uacute;mero de llamadas atendidas (con la disposici&oacute;n en EVENT_ANSWERED en queue_log) cuyo tiempo de espera fue menor o igual que el seteo en preferencias del sla_answered',0,'2012-09-07 22:21:56'),(789,'en','help_text_short_unanswered_threshold','Duration  treshhold (in seconds) for a call to be considered as unanswered (if duration is less than this value, then ignore the call completely). Specifying the queue name as a parameter will apply the value to that queue only.',0,'2012-10-02 04:55:45'),(790,'en','If the field value is higher than this number you will receive an alerting email','If the field value is higher than this number you will receive an alerting email',0,'2012-10-02 05:43:07'),(791,'en','calls','calls',0,'2012-10-01 18:34:18'),(792,'es','help_text_variable_ANSWERED_TALK_TIME','Tiempo de conversaci&oacute;n de llamadas atendidas para un reporte agrupado en particular.',0,'2012-09-07 22:21:56'),(793,'es','Pauses','Pausas',0,'2012-09-07 18:45:47'),(794,'es','Calls','Llamadas',0,'2012-09-17 14:41:28'),(795,'es','disposition_help_CONNECT','La llamada fue atendida por un agente.',0,'2012-09-11 00:46:36'),(796,'es','event_help_connect_info3','Ringtime es el tiempo en que el tel&eacute;fono son&oacute; hasta ser atendido por un miembro de la cola.',0,'2012-09-07 22:26:12'),(797,'es','event_help_exitwithtimeout_info1','La posici&oacute;n de la llamada en la cola al salir de la misma.',0,'2012-09-07 22:26:12'),(798,'es','event_help_exitwithtimeout_info2','La posici&oacute;n original de la llamada al entrar en la cola inicialmente.',0,'2012-09-07 22:26:12'),(799,'es','Notice','Aviso',0,'0000-00-00 00:00:00'),(800,'es','No active channel','Canal no activado',0,'0000-00-00 00:00:00'),(801,'en','Generate','Generate',0,'2012-10-02 05:39:48'),(802,'es','every day','todos los dias',0,'0000-00-00 00:00:00'),(803,'es','OK','OK',0,'0000-00-00 00:00:00'),(804,'es','every hour','cada hora',0,'2012-09-12 23:37:57'),(805,'es','every minute','cada minuto',0,'2012-09-12 23:37:57'),(806,'es','Generate Offline License Request','Generar solicitud de Licencia Offline',0,'0000-00-00 00:00:00'),(807,'es','Generate','Generar',0,'0000-00-00 00:00:00'),(808,'es','Please copy the above text and send it via email to %s for processing, together with your activation code and the licensee name you want to use','Por favor, copie el texto y env&iacute;elo por email a %s para su procesamiento junto con su c&oacute;digo de activacion y el nombre que desee que aparezca en la licencia.',0,'0000-00-00 00:00:00'),(809,'es','Back','Volver',0,'0000-00-00 00:00:00'),(810,'es','Revoke Current License','Revocar la licencia Actual',0,'0000-00-00 00:00:00'),(811,'es','Revoke','Revocar',0,'0000-00-00 00:00:00'),(812,'es','No results','Sin resultados',0,'2012-09-06 18:26:45'),(813,'es','Reactivate','Reactivar',0,'2012-09-07 22:25:13'),(814,'es','help_text_realtime_strict_interface_status','Si utiliza la opción STATE_INTERFACE cuando utilice AddQueueMemeber la cola podrá informar del estado de agentes de tipo Local sin inconsistencias. En ese caso, debe poner esta valor en 1 para que el estado de agentes en la vista actual se base exclusivamente en la información de la aplicación de cola.',0,'2012-09-12 23:12:22'),(815,'en','Calls','Calls',0,'2012-09-18 04:51:34'),(816,'es','realtime-agent-hold','Retenido',0,'0000-00-00 00:00:00'),(817,'es','Could not connect to the Asterisk Manager Interface to retrieve status information. Please check your manager credentials in config.php and verify they match your settings in /etc/asterisk/manager.conf','No es posible conectar con el Asterisk Manager para obtener informaci&oacute;n de estado actual de las colas y agentes. Por favor revise las credenciales de acceso en config.php y que éstas coincidan con las configuradas en /etc/asterisk/manager.conf.',0,'0000-00-00 00:00:00'),(818,'es','New Scheduled Report','Nuevo Informe Programado',0,'2012-09-12 23:37:57'),(819,'es','Alerts','Alertas',0,'2012-09-12 23:37:57'),(820,'es','admin-schedule','Tareas Programadas',0,'2012-09-17 14:40:15'),(821,'en','New Scheduled Report','New Scheduled Report',0,'2012-10-02 05:43:07'),(822,'es','You must select at least one agent','Debe seleccionar al menos un agente',0,'2012-09-05 02:07:31'),(823,'en','realtime-agent-hold','On Hold',0,'0000-00-00 00:00:00'),(824,'en','admin-schedule','Schedules/Alerts',0,'2012-10-02 17:21:37'),(825,'en','help_text_realtime_strict_interface_status','This setting will make the realtime view show status as returned by the asterisk queue application by means of the STATE INTERFACE options for the AddQueueMember application. It should be set to 1 in systems with Local type queue members with STATE INTERFACE set, like FreePBX 2.8 or higher.',0,'2012-10-02 04:55:45'),(826,'en','on %s since %s seconds ago','en %s desde hace %s segundos',0,'0000-00-00 00:00:00'),(827,'en','on %s since %s secs ago','on %s since %s secs ago',0,'2012-09-04 22:05:40'),(828,'en','Level','Level',0,'2012-10-01 23:08:44'),(829,'en','Alerts','Alerts',0,'2012-10-02 05:43:07'),(830,'en','Name','Name',0,'2012-10-01 23:08:44'),(831,'en','Pauses','Pauses',0,'2012-09-07 17:59:17'),(832,'en','None','None',0,'2012-10-01 18:34:19'),(833,'en','Reactivate','Reactivate',0,'2012-09-06 23:56:46'),(834,'en','Select the report to check','Select the report to check',0,'2012-10-02 05:43:07'),(835,'en','End Date','End Date',0,'2012-10-02 17:21:11'),(836,'es','help_text_variable_ABANDONED','Número de llamados abandonados (con la disposici&oacute;n EVENT_ABANDON en queue_log)',0,'2012-09-07 22:21:56'),(837,'en','Querying data...','Querying data...',0,'2012-10-02 05:43:07'),(838,'en','all month','all month',0,'2012-10-02 05:43:07'),(839,'en','on days','on days',0,'2012-10-02 05:43:07'),(840,'en','every hour','every hour',0,'2012-10-02 05:43:07'),(841,'en','at hour','at hour',0,'2012-10-02 05:43:07'),(842,'en','on hours','on hours',0,'2012-10-02 05:43:07'),(843,'en','every minute','every minute',0,'2012-10-02 05:43:07'),(844,'en','at minute','at minute',0,'2012-10-02 05:43:07'),(845,'en','on minutes','on minutes',0,'2012-10-02 05:43:07'),(846,'es','help_text_variable_ABANDONED_WAIT_TIME','Tiempo de espera para llamadas abandonadas por un reporte agrupado particular.',0,'2012-09-07 22:21:56'),(847,'en','Please write down destination emails','Please write down destination emails',0,'2012-10-02 05:43:07'),(848,'en','Please select the reports to send','Please select the reports to send',0,'2012-10-02 05:43:07'),(849,'en','From the last (X) days','From the last (X) days',0,'2012-10-02 05:43:07'),(851,'en','Select the field to compare','Select the field to compare',0,'2012-10-02 05:43:07'),(852,'en','Write down the value to compare','Write down the value to compare',0,'2012-10-02 05:43:07'),(853,'en','help_text_mail_header_image','Image file to use as header for emails reports/alerts',0,'2012-10-02 04:55:45'),(854,'en','help_text_mail_smtp_password','Schedule and Alert reports, configure an SMTP password if needed.',0,'2012-10-02 04:55:45'),(855,'en','Month days','Month days',0,'2012-10-02 05:43:07'),(856,'en','Week days','Week days',0,'2012-10-02 05:43:07'),(857,'en','Hours','Hours',0,'2012-10-02 05:43:07'),(858,'en','Minutes','Minutes',0,'2012-10-02 05:43:07'),(859,'en','day','day',0,'2012-10-02 05:43:07'),(860,'en','help_text_mail_from_email','Schedule and Alert reports needs a FROM field to send emails.',0,'2012-10-02 04:55:45'),(861,'en','help_text_mail_from_name','Schedule and Alert reports needs a NAME field to send emails.',0,'2012-10-02 04:55:45'),(862,'en','Example','Example',0,'2012-10-02 05:43:07'),(863,'es','help_text_ANSWERED_DISPLAY_GRID','Si una gráfica está definida en los reportes de llamadas atendidas, entonces utilizar la disposición de ancho de grilla de acuerdo a los valores especificados en la campo value. La grilla tiene 12 columnas en total. Ejemplo:<br>\r\n<br>\r\nparameter: campo agrupadogroup field\r\nvalue: 6,6',0,'2012-09-07 22:21:56'),(864,'en','Overflow','Overflow',0,'2012-09-08 19:59:58'),(865,'es','In order to receive scheduled reports or alerts via email, you must setup a cron job in the server. You can use the following command in your server command line:<br/><br/>crontab -e<br/><br/>and add the following line (replacing the user and password with a valid user/password):<br/><br/>','Para recibir los reportes y alertas por email, deberá configurar una tarea de Cron en el servidor. Puede usar la siguiente instrucción en la línea de comandos  comandos:<br/>\r\n<br/>\r\ncrontab -e<br/>\r\n<br/>\r\ny agregar la siguiente línea (reemplazando el usuario y clave por uno válido):<br/>\r\n<br/>',0,'2012-09-12 23:37:57'),(866,'es','New Email Alert','Nuevo Alerta por Email',0,'2012-09-12 23:37:57'),(867,'en','Cron Configuration','Cron Configuration',0,'2012-10-02 05:43:07'),(868,'en','Use comma to separate emails','Use comma to separate emails',0,'2012-10-02 05:43:07'),(869,'en','Active','Active',0,'2012-10-02 05:43:07'),(870,'en','In order to receive scheduled reports or alerts via email, you must setup a cron job in the server. You can use the following command in your server command line:<br/><br/>crontab -e<br/><br/>and add the following line (replacing the user and password with a valid user/password):<br/><br/>','In order to receive scheduled reports or alerts via email, you must setup a cron job in the server. You can use the following command in your server command line:<br/><br/>crontab -e<br/><br/>and add the following line (replacing the user and password with a valid user/password):<br/><br/>',0,'2012-10-02 05:43:07'),(871,'es','help_text_variable_ABANDONED_SLA','N&uacute;mero de llamadas abandonadas (con la disposici&oacute;n EVENT_ABANDON en queue_log) en el que el tiempo de espera es menor o igual que los seteos de preferencias de sla_abandoned.',0,'2012-09-07 22:21:56'),(872,'es','Querying data...','Consultando...',0,'2012-09-12 23:37:57'),(873,'es','all month','todo el mes',0,'2012-09-12 23:37:57'),(874,'es','day','el día',0,'2012-09-12 23:37:57'),(875,'es','on days','los días',0,'2012-09-12 23:37:57'),(876,'es','at hour','a la hora',0,'2012-09-12 23:37:57'),(877,'es','on hours','en las horas',0,'2012-09-12 23:37:57'),(878,'es','at minute','en el minuto',0,'2012-09-12 23:37:57'),(879,'es','on minutes','en los minutos',0,'2012-09-12 23:37:57'),(880,'es','help_text_mail_header_image','Imagen a usar como encabezado en los reportes y alertas por email',0,'2012-09-12 23:12:22'),(881,'en','every day','every day',0,'0000-00-00 00:00:00'),(882,'es','Please write down destination emails','Escriba el/los emails de destino',0,'2012-09-12 23:37:57'),(883,'es','Use comma to separate emails','Use comas ( , ) para separar direcciones',0,'2012-09-12 23:37:57'),(884,'es','Please select the reports to send','Seleccione los informes a enviar',0,'2012-09-12 23:37:57'),(885,'es','From the last (X) days','De los &uacute;ltimos (X) dias',0,'2012-09-12 23:37:57'),(886,'es','Edit Email Alert','Editar Alerta por Email',0,'2012-09-12 23:37:57'),(888,'es','Select the field to compare','Seleccione el campo a comparar',0,'2012-09-12 23:37:57'),(889,'es','Write down the value to compare','Escriba el valor a comparar',0,'2012-09-12 23:37:57'),(890,'es','Cron Configuration','Configuraci&oacute;n Cron',0,'2012-09-12 23:37:57'),(891,'es','Month days','D&iacute;as del mes',0,'2012-09-12 23:37:57'),(892,'en','Separate with comma ( , )<br>* means all','Separate with comma ( , )<br>* means all',0,'2012-10-02 05:43:07'),(893,'es','Week days','Días de la semana',0,'2012-09-12 23:37:57'),(894,'es','Hours','Horas',0,'2012-09-12 23:37:57'),(895,'es','Minutes','Minutos',0,'2012-09-12 23:37:57'),(896,'es','Active','Activo',0,'2012-09-12 23:37:57'),(897,'en','Edit Scheduled Report','Edit Scheduled Report',0,'2012-10-02 05:43:07'),(898,'es','Edit Scheduled Report','Modificar Informe Programado',0,'2012-09-12 23:37:57'),(899,'en','Edit Email Alert','Edit Email Alert',0,'2012-10-02 05:43:07'),(900,'es','Separate with comma ( , )<br>* means all','Separe con comas ( , )<br>* significa todo',0,'2012-09-12 23:37:57'),(901,'es','Example','Ejemplo',0,'2012-09-12 23:37:57'),(902,'en','help_text_mail_smtp_server','Schedule and Alert reports, configure the SMTP server for sending emails. SSL protocol example: ssl://smtp.server.com ; for TLS protocol: tls://smtp.server.com ; without encryption: smtp.server.com',0,'2012-10-02 04:55:45'),(903,'en','help_text_mail_smtp_server_port','Schedule and Alert reports, configure the SMTP port if needed.',0,'2012-10-02 04:55:45'),(904,'en','help_text_mail_smtp_username','Schedule and Alert reports, configure the SMTP username if needed.',0,'2012-10-02 04:55:45'),(905,'es','on %s since %s secs ago','en %s hace %s segundos',0,'2012-09-04 22:37:44'),(906,'es','help_text_mail_from_email','Alertas y Reportes programados, definir un email de remitente para los mails que se originan el servidor.',0,'2012-09-12 23:12:22'),(907,'es','help_text_mail_from_name','Alertas y Reportes programados, definir un nombre de remitente para los mails que se originan el servidor.',0,'2012-09-12 23:12:22'),(908,'es','help_text_variable_ANSWERED','N&uacute;mero de llamadas atendidas (con disposici&oacute;n EVENT_ANSWERED en el queue_log) para el reporte agrupado en particular.',0,'2012-09-07 22:21:56'),(909,'es','help_text_mail_smtp_password','Alertas y Reportes programados, configure la clave del servidor smtp para el env&iacute;o de correos.',0,'2012-09-12 23:12:22'),(910,'es','help_text_mail_smtp_server','Alertas y Reportes programados, definir un servidor SMTP que se utilizará para enviar correos. Para el protocolo SSL: ssl://smtp.servidor.com , para TLS: tls://smtp.servidor.com , sin encriptaci&oacute;n : smtp.servidor.com',0,'2012-09-12 23:12:22'),(911,'es','help_text_mail_smtp_server_port','Alertas y Reportes programados, defina el puerto del servidor SMTP.',0,'2012-09-12 23:12:22'),(912,'es','help_text_mail_smtp_username','Alertas y Reportes programados, configure el nombre de usuario para autenticarse al servidor SMTP para enviar correos electr&oacute;nicos.',0,'2012-09-12 23:12:22'),(913,'en','New Email Alert','New Email Alert',0,'2012-10-02 05:43:07'),(914,'en','Scheduled Reports and Alerts','Scheduled Reports and Alerts',0,'2012-10-02 05:43:07'),(915,'en','Email','Email',0,'2012-10-02 05:43:07'),(916,'en','Reports','Reports',0,'2012-10-02 05:43:07'),(917,'en','Type','Type',0,'2012-10-02 05:43:07'),(918,'en','Alert','Alert',0,'2012-10-02 05:43:07'),(919,'en','Report','Report',0,'2012-10-02 05:43:07'),(920,'en','Queues','Queues',0,'2012-10-01 23:08:44'),(921,'es','Queues','Colas',0,'2012-09-12 23:35:09'),(922,'es','help_text_ACTION','Define un controlador de acci&oacute;n personalizado, para que pueda llamar a sus propias funciones/programas para casos especiales. Debe crear la funci&oacute;n javascript en el archivo js/custom.js . Recibir&aacute; el valor de UNIQUEID de la llamada cuando el icono de acci&oacute;n es clickado.\r\n\r\nparametro: posici&oacute;n,imagen de icono,Tooltip\r\nvalue: javascript_function',0,'2012-09-07 22:21:56'),(923,'es','Scheduled Reports and Alerts','Informes y Alertas Programados',0,'2012-09-12 23:37:57'),(924,'es','Reports','Informes',0,'2012-09-12 23:37:57'),(925,'es','Type','Tipo',0,'2012-09-12 23:37:57'),(926,'es','Alert','Alerta',0,'2012-09-12 23:37:57'),(927,'es','Report','Informe',0,'2012-09-12 23:37:57'),(928,'en','help_text_ACTION','Define a custom action handler, so you can call your own functions/program to handle special cases. You must create the javascript function in the js/custom.js file. It will receive the uniqueid of the call when the action icon is clicked.<br/>\r\n<br/>\r\nparameter: position,icon image,Tooltip<br/>\r\nvalue: javascript_function',0,'2012-10-02 05:42:51'),(929,'en','help_text_ANSWERED_DISPLAY_GRID','If a chart is defined in the answered reports tab, parameter field, then use the grid layout width as setup in the value field. The grid system has 12 columns in total:<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: width1,width2',0,'2012-10-02 05:42:51'),(930,'en','help_text_ANSWERED_DISPLAY_ROWS','Comma separated list of fields to show on a specific Answered reports. The fields are the one defined as COLUMN_ANSWERED.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields ',0,'2012-10-02 05:42:51'),(931,'en','help_text_CHART_ANSWERED','Shows a chart into the Answered reports page.<br/><br/>\n\nparameter: position,group field,title<br/>\nvalue: field,field',0,'2012-10-02 05:42:51'),(932,'en','help_text_CHART_DISTRIBUTION','Shows a chart into the Distribution reports page.<br/><br/>\r\n\r\nparameter: position,group field,title<br/>\r\nvalue: field,field',0,'2012-10-02 05:42:51'),(933,'en','help_text_CHART_UNANSWERED','Shows a chart into the Unanswered reports page.<br/><br/>\r\n\r\nparameter: position,group field,title<br/>\r\nvalue: field,field',0,'2012-10-02 05:42:51'),(934,'en','help_text_COLUMN_ANSWERED','Column to show in Answered reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in ANSWERED_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n\r\n\r\n',0,'2012-10-02 05:42:51'),(935,'en','help_text_COLUMN_ANSWERED_FORMAT','Format to use for displaying a cell value in the answered reports. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_ANSWERED entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',0,'2012-10-02 05:42:51'),(936,'en','help_text_COLUMN_DISTRIBUTION','Column to show in Distribution reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in DISTRIBUTION_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n',0,'2012-10-02 05:42:51'),(937,'en','help_text_COLUMN_DISTRIBUTION_FORMAT','Format to use for displaying a cell value in the distribution reports. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_DISTRIBUTION entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',0,'2012-10-02 05:42:51'),(938,'en','help_text_COLUMN_REALTIME','Column to show in the Realtime summary. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in REALTIME_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n',0,'2012-10-02 05:42:51'),(939,'en','help_text_COLUMN_REALTIME_FORMAT','Format to use for displaying a cell value in the realtime queue summary report. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_REALTIME entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',0,'2012-10-02 05:42:51'),(940,'en','help_text_COLUMN_REALTIME_STYLE','Extra html property to add to cell values in the realtime queue summary table. You can use class or style to modify display on those cells. Example:<br/>\r\n<br/>\r\nclass=&quot;bigblue&quot;\r\n<br/>\r\nstyle=&quot;border:1px solid red;&quot;\r\n\r\n',0,'2012-10-02 05:42:51'),(941,'en','help_text_COLUMN_UNANSWERED','Column to show in Unanswered reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in UNANSWERED_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n',0,'2012-10-02 05:42:51'),(942,'en','help_text_COLUMN_UNANSWERED_FORMAT','Format to use for displaying a cell value in the unanswered reports. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_UNANSWERED entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',0,'2012-10-02 05:42:51'),(943,'en','help_text_DISTRIBUTION_DISPLAY_ROWS','Comma separated list of fields to show on a specific Distribution reports. The fields are the one defined as COLUMN_DISTRIBUTION.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields',0,'2012-10-02 05:42:51'),(944,'en','help_text_EVENT_ABANDONED','Define the queue_log events that will count towards the ABANDONED counters/variables in reports, using a comma separated list. In a standard Asterisk setup, this must be set to \\\"ABANDON\\\" and nothing else.',0,'2012-10-02 05:42:51'),(945,'en','help_text_EVENT_ANSWERED','Define the queue_log events that will count towards the ANSWERED counters/variables in reports, using a comma separated list. Normal answered dispositions in the queue_log are COMPLETECALLER, COMPLETEAGENT, you could also want to count the TRANSFER disposition towards the ANSWERED column, but as transfers have their own variable, you can also leave them separated.',0,'2012-10-02 05:42:51'),(946,'en','help_text_EVENT_LOGIN','Define the queue_log events that will count towards the LOGIN counters/variables in reports, using a comma separated list. Usually you have AGENTLOGIN and ADDMEMBER as events for login events in the queue_log file. Old asterisk versions could also use AGENTCALLBACKLOGIN.',0,'2012-10-02 05:42:51'),(947,'en','help_text_EVENT_LOGOUT','Define the queue_log events that will count towards the LOGOUT counters/variables in reports, using a comma separated list. Usually you have AGENTLOGOFF and REMOVEMEMBER as events for login events in the queue_log file.',0,'2012-10-02 05:42:51'),(948,'en','help_text_EVENT_RECEIVED','Define the queue_log events that will count towards the RECEIVED counters/variables in reports, using a comma separated list. All dispositions on the queue_log file that should add to a received call should be listed here, for example:<br/><br/>\r\nCOMPLETECALLER,COMPLETEAGENT,ABANDON,EXITEMPTY,EXITWITHKEY,EXITWITHTIMEOUT,TRANSFER',0,'2012-10-02 05:42:51'),(949,'en','help_text_EVENT_TRANSFERRED','Define the queue_log events that will count towards the TRANSFERRED counters/variables in reports, using a comma separated list. In a regular Asterisk setup, the only event associated with transfers is TRANSFER.',0,'2012-10-02 05:42:51'),(950,'en','help_text_EVENT_UNANSWERED','Define the queue_log events that will count towards the UNANSWERED counters/variables in reports, using a comma separated list. As an abandon call has its own variable, you should list here the rest of the unanswered dispositions, for example:<br/><br/>\r\nEXITWITHKEY,EXITEMPTY,EXITWITHTIMEOUT',0,'2012-10-02 05:42:51'),(951,'en','help_text_REALTIME_DISPLAY_ROWS','Comma separated list of fields to show on the Realtime Queue Summary table. The fields are the one defined as COLUMN_REALTIME.<br/>\r\n<br/>\r\nparameter: group field (queue_summary)<br/>\r\nvalue: comma separated list of fields',0,'2012-10-02 05:42:51'),(952,'en','help_text_TOTAL_COLUMN_ANSWERED','Formula to use for the Total row on Answered reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',0,'2012-10-02 05:42:51'),(953,'en','help_text_TOTAL_COLUMN_DISTRIBUTION','Formula to use for the Total row on Distribution reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',0,'2012-10-02 05:42:51'),(954,'en','help_text_TOTAL_COLUMN_REALTIME','Formula to use for the Total row on Realtime reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',0,'2012-10-02 05:42:51'),(955,'en','help_text_TOTAL_COLUMN_UNANSWERED','Formula to use for the Total row on Unanswered reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',0,'2012-10-02 05:42:51'),(956,'en','help_text_UNANSWERED_DISPLAY_GRID','If a chart is defined in the unanswered reports, parameter field, then use the grid layout width as setup in the value field. The grid system has 12 columns in total:<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: width1,width2',0,'2012-10-02 05:42:51'),(957,'en','help_text_UNANSWERED_DISPLAY_ROWS','Comma separated list of fields to show on a specific Unanswered reports. The fields are the one defined as COLUMN_UNANSWERED.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields',0,'2012-10-02 05:42:51'),(958,'en','help_text_agent_reports','Comma separated list of reports to show on the Agent page. You must specify the correct .php file that displays the report you want on each element.',0,'2012-10-02 05:42:51'),(959,'en','help_text_answered_reports','Comma separated list of reports to show on the Answered page. You must specify the correct .php file that displays the report you want on each element.',0,'2012-10-02 05:42:51'),(960,'en','help_text_distribution_reports','Comma separated list of reports to show on the Distribution page. You must specify the correct .php file that displays the report you want on each element.',0,'2012-10-02 05:42:51'),(961,'en','help_text_realtime_reports','Comma separated list of reports to show on the Realtime page. You must specify the correct .php file that displays the report you want on each element.',0,'2012-10-02 05:42:51'),(962,'en','help_text_setup_reports','Comma separated list of reports to show on the Setup page. You must specify the correct .php file that displays the report you want on each element.',0,'2012-10-02 05:42:51'),(963,'en','help_text_unanswered_reports','Comma separated list of reports to show on the Unanswered page. You must specify the correct .php file that displays the report you want on each element.',0,'2012-10-02 05:42:51'),(964,'es','help_text_ANSWERED_DISPLAY_ROWS','Listado de campos separados por coma para mostrarse en los reportes de Atendidas. Los campos se definen como COLUMN_ANSWERED\r\n\r\nparametro: group field\r\nvalor: listado de campos separados por coma ',0,'2012-09-07 22:21:56'),(965,'es','help_text_CHART_ANSWERED','Muestra un diagrama dentro de la p&aacute;gina de Atendidas.\r\n\r\nparametro: posicion,group field,titulo\r\nvalor: campo,campo',0,'2012-09-07 22:21:56'),(966,'es','help_text_CHART_DISTRIBUTION','Muestra un diagrama dentro de la p&aacute;gina de Distribuci&oacute;n.\r\n\r\nparametro: posicion,group field,titulo\r\nvalor: campo,campo',0,'2012-09-07 22:21:56'),(967,'es','help_text_CHART_UNANSWERED','Muestra un diagrama dentro de la p&aacute;gina de Desatendidas.\r\n\r\nparametro: posicion,group field,titulo\r\nvalor: campo,campo',0,'2012-09-07 22:21:56'),(968,'es','help_text_COLUMN_ANSWERED','Columna para mostrar dentro de los reportes de Atendidas. Puede agregar todas las columnas que usted quiera a un reporte, luego podr&aacute; limitarlas en cada grupo enumerandolas con ANSWERED_DISPLAY_ROWS.\r\n\r\nparametro: nombre columna/etiqueta\r\nvalor: variable o f&oacute;rmula',0,'2012-09-07 22:21:56'),(969,'es','help_text_COLUMN_ANSWERED_FORMAT','Formato para mostrar en el valor de la celda en los reportes de Atendidas. Utiliza las t&iacute;picas reglas de formato de printf, excepto por los valores horarios que pueden usar tambi&eacute;n \r\n{HH}, {MM}, {SS}, {mm} y {ss}\r\n\r\npar&aacute;metro: nombre de campo\r\nvalor: cadena de formato\r\n\r\nEl par&aacute;metro nombre de campo debe ser definido como el campo de par&aacute;metro en COLUMN_ANSWERED.\r\n\r\nFormato de Ejemplo:\r\n\r\nDado un valor en segundos, convertirlo a HH:MM:SS con:\r\n\r\n{HH}:{MM}:{SS} ',0,'2012-09-07 22:21:56'),(970,'es','help_text_COLUMN_DISTRIBUTION','Columna a mostrar en los reportes de Distribuci&oacute;n. Puede agregar todas las columnas que quiera a cada reporte, luego puede limitarlos filtrando en cada grupo enumerandolos en DISTRIBUTION_DISPLAY_ROWS.\r\n\r\nparametro: nombre de columna/etiqueta\r\nvalue: variable o f&oacute;rmula\r\n',0,'2012-09-07 22:21:56'),(971,'es','help_text_COLUMN_DISTRIBUTION_FORMAT','Formato para mostrar el valor de la celda en los reportes de distribuci&oacute;n. Usa las t&iacute;picas reglas de formato de printf, excepto por los valores horarios que pueden usar\r\n{HH}, {MM}, {SS}, {mm} y {ss}\r\n\r\nparametro: nombre del campo\r\nvalor: cadena de formato\r\n\r\nEl par&aacute;metro nombre del campo debe ser definido en COLUMN_DISTRIBUTION.\r\nEjemplos de Formato:\r\n\r\nDado un valor en segundos, convertirlo a HH:MM:SS con:\r\n{HH}:{MM}:{SS} ',0,'2012-09-07 22:21:56'),(972,'es','help_text_COLUMN_REALTIME','Columna a mostrar en el sumario de la vista REALTIME. Puede agregar todas las columnas que quiera al reporte, luego puede filtrarlas en cada reporte enumerandolas en REATIME_DISPLAY_ROWS.\r\n\r\nparametro: nombre de columna/etiqueta\r\nvalor: variable o f&oacute;rmula',0,'2012-09-07 22:21:56'),(973,'es','help_text_COLUMN_REALTIME_FORMAT','Formato a utilizar para mostrar el valor de una columna en el sumario de Realtime. Usa las t&iacute;picas reglas de formato de printf, excepto por los valores horarios que puede utilizar {HH}, {MM}, {SS}, {mm} y {ss}\r\n\r\nparametro: nombre del campo\r\nvalor: cadena con el formato\r\n\r\nEl par&aacute;metro nombre del campo debe ser definido en COLUMN_REALTIME.\r\nEjemplo de Formato:\r\n\r\nDado un valor en segundos, convertirlo a HH:MM:SS con:\r\n{HH}:{MM}:{SS} ',0,'2012-09-07 22:21:56'),(974,'es','help_text_COLUMN_REALTIME_STYLE','Propiedad HTML extra para adicionar a los valores de las celdas en el sumario de REALTIME. Puede usar class o style para modificar la visualizaci&oacute;n de la celda. Ejemplo:\r\n\r\nclass=\\\"bigblue\\\"\r\nstyle=\\\"border:1px solid red;\\\" ',0,'2012-09-07 22:21:56'),(975,'es','help_text_variable_AGENTS_TALKING','N&uacute;mero de agentes con una llamada establecida. S&oacute;lo disponible en f&oacute;rmulas de COLUMN_REALTIME.',0,'2012-09-07 22:21:56'),(976,'es','help_text_COLUMN_UNANSWERED','Columna para ser mostrada en los reportes de Desatendidas. Puede agregar todas las columnas que desee a un reporte, luego podr&aacute; filtrarlos en cada grupo enumerandolas en UNANSWERED_DISPLAY_ROWS.\r\n\r\nparametro: nombre de columna/etiqueta\r\nvalor: variable o f&oacute;rmula',0,'2012-09-07 22:21:56'),(977,'es','help_text_COLUMN_UNANSWERED_FORMAT','Formato a utilizar para mostrar en las celdas de reportes de desatendidas. Usa las t&iacute;picas reglas de formato de printf, excepto por los valores de horarios que puede utilizar {HH}, {MM}, {SS}, {mm} y {ss}\r\n\r\nparametro: nombre del campo\r\nvalor: cadena de formato\r\n\r\nEl par&aacute;metro nombre de campo debe ser definido en COLUMN_UNANSWERED.\r\nEjemplo de formato:\r\n\r\nDado un valor en segundos, convertirlo a HH:MM:SS con:\r\n{HH}:{MM}:{SS} ',0,'2012-09-07 22:21:56'),(978,'es','help_text_DISTRIBUTION_DISPLAY_ROWS','Listado de campos separados por coma para mostrar en un reporte específico de Distribui&oaucte;n. Los campos son los definidos en COLUMN_DISTRIBUTION.\r\n\r\nparametro: group field\r\nvalor: lista de campos separados por coma',0,'2012-09-07 22:21:56'),(979,'es','help_text_EVENT_ABANDONED','Define los eventos de queue_log que incrementarán los contadores/variables de llamadas Abandonadas usando un listado separado por coma. Dentro de la configuraci&oacute;n est&aacute;ndar de Asterisk, esto debe ser definido como &quot;ABANDON&quot; y nada m&aacute;s.',0,'2012-09-07 22:21:56'),(980,'es','help_text_EVENT_ANSWERED','Define los eventos de queue_log que incrementarán los contadores/variables de llamadas Atendidas en los reportes, usando un listado separado por coma. Las disposiciones usuales de llamadas atendidas dentro de la configuraci&oacute;n est&aacute;ndar de Asterisk son COMPLETECALLER y COMPLETEAGENT. Podría también incluirse la disposición TRANSFER. Pero tenga en cuenta que las transferencias disponen de su propio evento/variable por si desea reportearlas de forma separada.',0,'2012-09-07 22:21:56'),(981,'es','help_text_EVENT_LOGIN','Define los eventos de queue_log que incrementarán los contadores/variables de ingreso de agentes en los reportes, usando un listado separado por coma. En una configuración normal de Asterisk dichos eventos son AGENTLOGIN y ADDMEMBER. Versiones antiguas de Asterisk podrían incluir AGENTCALLBACKLOGIN.',0,'2012-09-07 22:21:56'),(982,'es','help_text_EVENT_LOGOUT','Define los eventos de queue_log que incrementarán los contadores/variables de egreso/desconexión de agentes en los reportes, usando un listado separado por coma. En una configuración normal de Asterisk dichos eventos son AGENTLOGOFF y REMOVEMEMBER.',0,'2012-09-07 22:21:56'),(983,'es','help_text_EVENT_RECEIVED','Define los eventos de queue_log que incrementarán los contadores/variables de llamadas Recibidas usando un listado separado por coma. Todas las disposiciones que figuren en el queue_log que deban sumar como llamada recibida, tanto atendida como no, deberán ser listadas aquí, por ejemplo:<br/><br/>\r\nCOMPLETECALLER,COMPLETEAGENT,ABANDON,EXITEMPTY,EXITWITHKEY,EXITWITHTIMEOUT,TRANSFER',0,'2012-09-07 22:21:56'),(984,'es','help_text_EVENT_TRANSFERRED','Define los eventos de queue_log que incrementarán los contadores/variables de llamadas Transferidas usando un listado separado por coma. En instalaciones normales, el único evento a listar es TRANSFER',0,'2012-09-07 22:21:56'),(985,'es','help_text_EVENT_UNANSWERED','Define los eventos de queue_log que incrementarán los contadores/variables de llamadas No Atendidas usando un listado separado por coma. A diferencia de un Abandono, done el llamado no es atendido porque el llamante corta la llamada antes de ser atendido por un agente, las disposiciones de No Atendidas listan las razones por las cuales un llamado puede salirse de la espera en cola por otros motivos, como ser tiempo máximo de espera, salida por pulsación de tecla, etc. Los eventos usuales son: EXITWITHKEY,EXITEMPTY,EXITWITHTIMEOUT',0,'2012-09-07 22:21:56'),(986,'es','help_text_REALTIME_DISPLAY_ROWS','Lista separada por comas de los campos a mostrar en la tabla de sumario de tiempo real. Los campos posibles son los definidos en COLUMN_REALTIME.<br/>\r\n<br/>\r\nparameter: campo agrupado<br/>\r\nvalue: lista de campos separados por coma',0,'2012-09-07 22:21:56'),(987,'es','help_text_TOTAL_COLUMN_ANSWERED','Formula a usar para la fila Total en los reportes de llamados Atendidos.<br/>\r\n<br/>\r\nparameter: campo<br/>\r\nvalue: formula',0,'2012-09-07 22:21:56'),(988,'es','help_text_TOTAL_COLUMN_DISTRIBUTION','Formula a usar para la fila Total en los reportes de Distribución.<br/>\r\n<br/>\r\nparameter: campo<br/>\r\nvalue: formula',0,'2012-09-07 22:21:56'),(989,'es','help_text_TOTAL_COLUMN_REALTIME','Formula a usar para la fila Total en los reportes de Tiempo Real.<br/>\r\n<br/>\r\nparameter: campo<br/>\r\nvalue: formula',0,'2012-09-07 22:21:56'),(990,'es','help_text_TOTAL_COLUMN_UNANSWERED','Formula a usar para la fila Total en los reportes de llamados No Atendidos.<br/>\r\n<br/>\r\nparameter: campo<br/>\r\nvalue: formula',0,'2012-09-07 22:21:56'),(991,'es','help_text_UNANSWERED_DISPLAY_GRID','Si una gráfica está definida en los reportes de llamadas no atendidas, entonces utilizar la disposición de ancho de grilla de acuerdo a los valores especificados en la campo value. La grilla tiene 12 columnas en total. Ejemplo:<br>\r\n<br>\r\nparameter: campo agrupadogroup field\r\nvalue: 6,6',0,'2012-09-07 22:21:56'),(992,'es','help_text_UNANSWERED_DISPLAY_ROWS','Listado de campos separados por coma para mostrarse en los reportes de No Atendidas. Los campos se definen como COLUMN_UNANSWERED<br><br>\r\n\r\nparametro: group field\r\nvalor: listado de campos separados por coma ',0,'2012-09-07 22:21:56'),(993,'es','help_text_agent_reports','Lista separada por comas de los reportes a mostrar en la solapa de Agente. Debe especificar el listado correcto de archivos .php para mostrar en cada elemento/sección.\r\n',0,'2012-09-07 22:21:56'),(994,'es','help_text_answered_reports','Lista separada por comas de los reportes a mostrar en la solapa de Atendidos. Debe especificar el listado correcto de archivos .php para mostrar en cada elemento/sección.\r\n',0,'2012-09-07 22:21:56'),(995,'es','help_text_distribution_reports','Lista separada por comas de los reportes a mostrar en la solapa de Distribución. Debe especificar el listado correcto de archivos .php para mostrar en cada elemento/sección.\r\n',0,'2012-09-07 22:21:56'),(996,'es','help_text_realtime_reports','Lista separada por comas de los reportes a mostrar en la solapa de Tiempo Real. Debe especificar el listado correcto de archivos .php para mostrar en cada elemento/sección.\r\n',0,'2012-09-07 22:21:56'),(997,'es','help_text_setup_reports','Lista separada por comas de los reportes a mostrar en el menú de Configuración. Debe especificar el listado correcto de archivos .php para mostrar en cada elemento/sección.\r\n',0,'2012-09-07 22:21:56'),(998,'es','help_text_unanswered_reports','Lista separada por comas de los reportes a mostrar en la solapa de No Atendidas. Debe especificar el listado correcto de archivos .php para mostrar en cada elemento/sección.\r\n',0,'2012-09-07 22:21:56'),(999,'es','Select the report to check','Elija el reporte a verificar',0,'2012-09-12 23:37:57'),(1000,'en','help_text_custom_reports','Comma separated list of custom reports to show on a new/custom tab on the menu. The parameter is the tab name to display, and value is a comma separated list of .php scripts to load.',0,'2012-10-02 05:42:51'),(1001,'en','Could not connect to the Asterisk Manager Interface to retrieve status information. Please check your manager credentials in config.php and verify they match your settings in /etc/asterisk/manager.conf','Could not connect to the Asterisk Manager Interface to retrieve status information. Please check your manager credentials in config.php and verify they match your settings in /etc/asterisk/manager.conf',0,'0000-00-00 00:00:00'),(1002,'en','Available Keywords','Available Keywords',0,'2012-10-02 05:42:51'),(1003,'en','Available Variables','Available Variables',0,'2012-10-02 05:42:51'),(1004,'en','help_text_variable_SUM_ANSWERED','Sum of Answered Calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1005,'en','help_text_variable_SUM_UNANSWERED','Sum of Unanswered calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1006,'en','help_text_variable_SUM_RECEIVED','Sum of Received Calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1007,'en','help_text_variable_SUM_TRANSFERRED_SLA','Sum of Transferred Calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_transferred seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1008,'en','help_text_variable_SUM_ABANDONED_SLA','Sum of Abandoned calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_abandoned seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1009,'en','help_text_variable_SUM_ANSWERED_SLA','Sum of Answered Calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_answered seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1010,'en','help_text_variable_SUM_UNANSWERED_SLA','Sum of Unanswered calls up to the particular row in a report, who&#146;s wait time is less or equal than transferred_sla seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1011,'en','help_text_variable_SUM_ABANDONED_WAIT_TIME','Sum of Wait Time for Abandoned Calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1012,'en','help_text_variable_SUM_UNANSWERED_WAIT_TIME','Sum of Wait Time for Transferred calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1013,'en','help_text_variable_SUM_TRANSFERRED_WAIT_TIME','Sum of Wait Time for Transferred calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1014,'en','help_text_variable_SUM_TRANSFERRED_TALK_TIME','Sum of Talk Time for Transferred calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1015,'en','help_text_variable_SUM_ANSWERED_WAIT_TIME','Sum of Wait Time for Answered calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1016,'en','help_text_variable_SUM_ANSWERED_TALK_TIME','Sum of Talk Time for Answered calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1017,'en','help_text_variable_TOTAL_LOGOUT','Total number of Logoff events.',0,'2012-10-02 05:42:51'),(1018,'en','help_text_variable_TOTAL_LOGIN','Total number of Login events.',0,'2012-10-02 05:42:51'),(1019,'en','help_text_variable_TOTAL_TRANSFERRED','Total number of Transferred calls.',0,'2012-10-02 05:42:51'),(1020,'en','help_text_variable_TOTAL_ABANDONED','Total number of Abandoned Calls.',0,'2012-10-02 05:42:51'),(1021,'en','help_text_variable_TOTAL_ANSWERED','Total number of Answered calls',0,'2012-10-02 05:42:51'),(1022,'en','help_text_variable_TOTAL_UNANSWERED','Total number of Unanswered Calls.',0,'2012-10-02 05:42:51'),(1023,'en','help_text_variable_TOTAL_RECEIVED','Total number of Received calls.',0,'2012-10-02 05:42:51'),(1024,'en','help_text_variable_TOTAL_TRANSFERRED_SLA','Total of Transferred Calls that have a wait time of less or equal transferred_sla seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1025,'en','help_text_variable_TOTAL_ABANDONED_SLA','Total number of Abandoned calls who&#146;s wait time is less or equal than abandoned_sla seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1026,'en','help_text_variable_TOTAL_ANSWERED_SLA','Total number of Answered calls who&#146;s wait time is less or equal than answered_sla seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1027,'en','help_text_variable_TOTAL_UNANSWERED_SLA','Total of Unanswered Calls that have a wait time of less or equal unanswered_sla seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1028,'en','help_text_variable_TOTAL_ABANDONED_WAIT_TIME','Total Wait Time for Abandoned Calls',0,'2012-10-02 05:42:51'),(1029,'en','help_text_variable_TOTAL_UNANSWERED_WAIT_TIME','Wait Time for Unanswered Calls for the whole set of data.',0,'2012-10-02 05:42:51'),(1030,'en','help_text_variable_TOTAL_TRANSFERRED_WAIT_TIME','Total Wait Time for Transferred Calls.',0,'2012-10-02 05:42:51'),(1031,'en','help_text_variable_TOTAL_TRANSFERRED_TALK_TIME','Total Talk Time for Transferred Calls.',0,'2012-10-02 05:42:51'),(1032,'en','help_text_variable_TOTAL_ANSWERED_WAIT_TIME','Total Wait Time for Answered Calls',0,'2012-10-02 05:42:51'),(1033,'en','help_text_variable_TOTAL_ANSWERED_TALK_TIME','Total Talk Time for Answered Calls',0,'2012-10-02 05:42:51'),(1034,'en','help_text_variable_SUM_ABANDONED','Sum of Abandoned calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1035,'en','help_text_variable_SUM_TRANSFERRED','Sum of Transferred Calls up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1036,'en','help_text_variable_SUM_LOGIN','Sum of Login events up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1037,'en','help_text_variable_SUM_LOGOUT','Sum of Logoff events up to the particular row in a report.',0,'2012-10-02 05:42:51'),(1038,'en','help_text_variable_AVG_ANSWERED_TALK_TIME','Average Talk Time for Answered Calls',0,'2012-10-02 05:42:51'),(1039,'en','help_text_variable_AVG_ANSWERED_WAIT_TIME','Average Wait Time for Answered Calls',0,'2012-10-02 05:42:51'),(1040,'en','help_text_variable_AVG_TRANSFERRED_TALK_TIME','Average Talk Time of Transferred Calls',0,'2012-10-02 05:42:51'),(1041,'en','help_text_variable_AVG_TRANSFERRED_WAIT_TIME','Average Wait Time of Transferred Calls',0,'2012-10-02 05:42:51'),(1042,'en','help_text_variable_AVG_UNANSWERED_WAIT_TIME','Average Wait Time for Unanswered Calls',0,'2012-10-02 05:42:51'),(1043,'en','help_text_variable_AVG_ABANDONED_WAIT_TIME','Average Wait Time for Abandoned Calls',0,'2012-10-02 05:42:51'),(1044,'en','help_text_variable_AVG_UNANSWERED_SLA','Average number of Unanswered Calls that had a wait time of less or equal seconds as set in unanswered_sla in Preferences.',0,'2012-10-02 05:42:51'),(1045,'en','help_text_variable_AVG_ANSWERED_SLA','Average number of Answered Calls that were waiting for less or equal than answered_sla seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1046,'en','help_text_variable_AVG_ABANDONED_SLA','Average of Abandoned Calls that where waiting less or equal abandoned_sla time as setup in Preferences.',0,'2012-10-02 05:42:51'),(1047,'en','help_text_variable_AVG_TRANSFERRED_SLA','Average number of Transferred Calls that were waiting for less or equal than transferred_sla seconds as set in Preferences.',0,'2012-10-02 05:42:51'),(1048,'en','help_text_variable_AVG_RECEIVED','Average number of Received Calls',0,'2012-10-02 05:42:51'),(1049,'en','help_text_variable_AVG_UNANSWERED','Average number of Unanswered Calls',0,'2012-10-02 05:42:51'),(1050,'en','help_text_variable_AVG_ANSWERED','Average number of Answered Calls',0,'2012-10-02 05:42:51'),(1051,'en','help_text_variable_AVG_ABANDONED','Average of Abandoned Calls',0,'2012-10-02 05:42:51'),(1052,'en','help_text_variable_AVG_TRANSFERRED','Average number of Transferred Calls',0,'2012-10-02 05:42:51'),(1053,'en','help_text_variable_AVG_LOGIN','Average number of Agent Logins',0,'2012-10-02 05:42:51'),(1054,'en','help_text_variable_AVG_LOGOUT','Average number of Agents Logoffs',0,'2012-10-02 05:42:51'),(1055,'en','help_text_variable_MAX_ANSWERED_TALK_TIME','Maximum Talk Time in Answered Calls.',0,'2012-10-02 05:42:51'),(1056,'en','help_text_variable_MAX_TRANSFERRED_TALK_TIME','Maximum Talk Time for Transferred Calls.',0,'2012-10-02 05:42:51'),(1057,'en','help_text_variable_MAX_ANSWERED_WAIT_TIME','Maximum Wait Time in Answered Calls.',0,'2012-10-02 05:42:51'),(1058,'en','help_text_variable_MAX_TRANSFERRED_WAIT_TIME','Maximum Wait Time for Transferred Calls.',0,'2012-10-02 05:42:51'),(1059,'en','help_text_variable_MAX_UNANSWERED_WAIT_TIME','Maximum Wait Time for Unanswered Calls.',0,'2012-10-02 05:42:51'),(1060,'en','help_text_variable_MAX_ABANDONED_WAIT_TIME','Maximum Wait Time in Abandoned Calls.',0,'2012-10-02 05:42:51'),(1061,'en','help_text_variable_MIN_ANSWERED_TALK_TIME','Minimum Talk Time in Answered Calls.',0,'2012-10-02 05:42:51'),(1062,'en','help_text_variable_MIN_TRANSFERRED_TALK_TIME','Minimum Talk Time for Transferred Calls.',0,'2012-10-02 05:42:51'),(1063,'en','help_text_variable_MIN_ANSWERED_WAIT_TIME','Minimum Wait Time in Answered Calls.',0,'2012-10-02 05:42:51'),(1064,'en','help_text_variable_MIN_TRANSFERRED_WAIT_TIME','Minimum Wait Time for Transferred Calls.',0,'2012-10-02 05:42:51'),(1065,'en','help_text_variable_MIN_UNANSWERED_WAIT_TIME','Minimum Wait Time for Unanswered Calls.',0,'2012-10-02 05:42:51'),(1066,'en','help_text_variable_MIN_ABANDONED_WAIT_TIME','Minimum Wait Time in Abandoned Calls.',0,'2012-10-02 05:42:51'),(1067,'en','help_text_variable_UNANSWERED_SLA','Number of Unanswered calls (with EVENT_UNANSWERED disposition in queue_log) who&#146;s wait time was less or equal than sla_unanswered setting in Preferences.',0,'2012-10-02 05:42:51'),(1068,'en','help_text_variable_ANSWERED_SLA','Number of Anaswered calls (with EVENT_ANSWERED disposition in queue_log) who&#146;s wait time was less or equal than sla_answered setting in Preferences.',0,'2012-10-02 05:42:51'),(1069,'en','help_text_variable_ABANDONED_SLA','Number of Abandoned calls (with EVENT_ABANDON disposition in queue_log) who&#146;s wait time was less or equal than sla_abandoned setting in Preferences.',0,'2012-10-02 05:42:51'),(1070,'en','help_text_variable_TRANSFERRED_SLA','Number of Transferred Calls (with EVENT_TRANSFERRED disposition in queue_log) who&#146;s wait time is less or equal than transferred_sla as set in Preferences.',0,'2012-10-02 05:42:51'),(1071,'en','help_text_variable_ANSWERED_TALK_TIME','Talk Time of Answered Calls for the particular grouped report.',0,'2012-10-02 05:42:51'),(1072,'en','help_text_variable_TRANSFERRED_TALK_TIME','Talk Time for Transferred Calls for a particular row.',0,'2012-10-02 05:42:51'),(1073,'en','help_text_variable_UNANSWERED_WAIT_TIME','Wait Time for Unanswered Calls for a particular row.',0,'2012-10-02 05:42:51'),(1074,'en','help_text_variable_ANSWERED_WAIT_TIME','Wait Time of Answered Calls for the particular grouped report. (Wait Time is the time an user was waiting on the queue before being connected to an agent, it only counts the time since the queue was entered, it does not count potential previous times like IVRs, etc.)',0,'2012-10-02 05:42:51'),(1075,'en','help_text_variable_ABANDONED_WAIT_TIME','Wait time for abandoned calls for the particular grouped report.',0,'2012-10-02 05:42:51'),(1076,'en','help_text_variable_TRANSFERRED_WAIT_TIME','Wait Time for Transferred Calls for a particular row.',0,'2012-10-02 05:42:51'),(1077,'en','help_text_variable_RECEIVED','Number of Received calls (with EVENT_RECEIVED disposition in the queue_log file) for the particular grouped report.',0,'2012-10-02 05:42:51'),(1078,'en','help_text_variable_UNANSWERED','Number of Unanswered calls (with EVENT_UNANSWERED disposition in the queue_log file) for the particular grouped report.',0,'2012-10-02 05:42:51'),(1079,'en','help_text_variable_ANSWERED','Number of Answered calls (with EVENT_ANSWERED disposition in the queue_log file) for the particular grouped report.',0,'2012-10-02 05:42:51'),(1080,'en','help_text_variable_ABANDONED','Number of Abandoned calls (with EVENT_ABANDON disposition in queue_log)',0,'2012-10-02 05:42:51'),(1081,'en','help_text_variable_TRANSFERRED','Number of Transferred Calls (with EVENT_TRANSFERRED disposition in queue_log)',0,'2012-10-02 05:42:51'),(1082,'en','help_text_variable_LOGIN','Number of Agent Logins.',0,'2012-10-02 05:42:51'),(1083,'en','help_text_variable_LOGOUT','Number of Agent Logoffs.',0,'2012-10-02 05:42:51'),(1084,'en','help_text_variable_ROW_COUNT','Number of Rows on the report. To be used in TOTAL formulas.',0,'2012-10-02 05:42:51'),(1085,'en','help_text_variable_SUM_COL','Sum of all values for a particular column. To be used in TOTAL formulas.',0,'2012-10-02 05:42:51'),(1086,'en','help_text_variable_MAX_COL','Maximum value for the column, to be used in TOTAL formulas.',0,'2012-10-02 05:42:51'),(1087,'en','help_text_variable_MIN_COL','Minimum value for the column, to be used in TOTAL formulas.',0,'2012-10-02 05:42:51'),(1088,'en','help_text_variable_MAX_CALLERS_WAITING','Maximum number of callers waiting in the queue.',0,'2012-10-02 05:42:51'),(1089,'en','help_text_variable_AGENTS_STAFFED','Number of Logged In/Available agents. Only available in COLUMN_REALTIME formulas.',0,'2012-10-02 05:42:51'),(1090,'en','help_text_variable_AGENTS_TALKING','Number of Agents engaged on a call. Only available in COLUMN_REALTIME formulas.',0,'2012-10-02 05:42:51'),(1091,'en','help_text_variable_AGENTS_PAUSED','Number of Paused agents. Only available in COLUMN_REALTIME formulas.',0,'2012-10-02 05:42:51'),(1092,'en','help_text_variable_CALLS_WAITING','Number of Calls Waiting. Only available in COLUMN_REALTIME formulas.',0,'2012-10-02 05:42:51'),(1093,'en','help_text_variable_MAX_WAIT_TIME','Maximum Wait Time for the particular grouped report.',0,'2012-10-02 05:42:51'),(1094,'en','help_text_variable_AGENTS_LOGGED_OFF','Number of Logged Off agents. Only available in COLUMN_REALTIME formulas.',0,'2012-10-02 05:42:51'),(1095,'en','Click to edit...','Click to edit...',0,'0000-00-00 00:00:00'),(1096,'es','Click to edit...','Click para editar...',0,'0000-00-00 00:00:00'),(1097,'es','Available Keywords','Seteos Disponibles',0,'2012-09-07 22:21:56'),(1098,'es','help_text_custom_reports','Lista separada por comas de los reportes a mostrar en una solapa personalizada en el menú. El parámetro es el nombre de solapa a utilizar. Debe especificar el listado correcto de archivos .php para mostrar en cada elemento/sección.\r\n',0,'2012-09-07 22:21:56'),(1099,'es','None','Ninguno',0,'2012-09-11 00:46:36'),(1100,'es','help_text_variable_AGENTS_STAFFED','N&uacute;mero de agentes disponibles (Logged In). S&oacute;lo disponible en formulas de COLUMN_REALTIME.',0,'2012-09-07 22:21:56'),(1101,'es','help_text_variable_AGENTS_PAUSED','N&uacute;mero de agentes pausados. S&oacute;lo disponible en formulas de COLUMN_REALTIME',0,'2012-09-07 22:21:56'),(1102,'es','help_text_variable_AGENTS_LOGGED_OFF','N&uacute;mero de agentes en estado Logged Off. S&oacute;lo disponible en las f&oacute;rmulas de COLUMN_REALTIME.',0,'2012-09-07 22:21:56'),(1103,'es','Available Variables','Variables Disponibles',0,'2012-09-07 22:21:56'),(1104,'es','event_help_transfer_info5','La posici&oacute;n que toma la llamada en el momento de la transferencia.',0,'2012-09-07 22:26:12'),(1105,'es','event_help_exitwithtimeout_info3','Cantidad de tiempo que una llamada esper&oacute; en la cola.',0,'2012-09-07 22:26:12'),(1106,'es','event_help_unpause_info1','Raz&oacute;n de la salida de pausa (si existe)',0,'2012-09-07 22:26:12'),(1107,'es','event_help_pause_info1','Raz&oacute;n de una pausa (si existe)',0,'2012-09-07 22:26:12'),(1108,'es','help_text_variable_ANSWERED_WAIT_TIME','Wait Time of Answered Calls for the particular grouped report. (Wait Time is the time an user was waiting on the queue before being connected to an agent, it only counts the time since the queue was entered, it does not count potential previous times like IVRs, etc.)',0,'2012-09-07 22:21:56'),(1109,'es','help_text_variable_AVG_ABANDONED','Promedio de llamadas abandonadas.',0,'2012-09-07 22:21:56'),(1110,'es','help_text_variable_AVG_ABANDONED_SLA','Promedio de llamadas abandonadas que han esperado menos o igual tiempo que el definido en preferencias en abandonen_sla.',0,'2012-09-07 22:21:56'),(1111,'es','help_text_variable_AVG_ABANDONED_WAIT_TIME','Promedio de tiempo de espera para llamadas abandonadas.',0,'2012-09-07 22:21:56'),(1112,'es','help_text_variable_AVG_ANSWERED','Promedio de llamadas atendidas.',0,'2012-09-07 22:21:56'),(1113,'es','help_text_variable_AVG_ANSWERED_SLA','Promedio de llamadas atendidas que han esperado menos o igual que lo definido en segundos en las preferencias en answered_sla.',0,'2012-09-07 22:21:56'),(1114,'es','help_text_variable_AVG_ANSWERED_TALK_TIME','Promedio de tiempo de conversaci&oacute;n para llamadas atendidas.',0,'2012-09-07 22:21:56'),(1115,'es','help_text_variable_AVG_ANSWERED_WAIT_TIME','Promedio the tiempo de espera para llamadas atendidas.',0,'2012-09-07 22:21:56'),(1116,'es','help_text_variable_AVG_LOGIN','Promedio de agentes logueados',0,'2012-09-07 22:21:56'),(1117,'es','help_text_variable_AVG_LOGOUT','Promerdio de agentes desloagueados.',0,'2012-09-07 22:21:56'),(1118,'es','help_text_variable_AVG_RECEIVED','Promedio de llamadas recibidas.',0,'2012-09-07 22:21:56'),(1119,'es','help_text_variable_AVG_TRANSFERRED','Promedio de llamadas transferidas.',0,'2012-09-07 22:21:56'),(1120,'es','help_text_variable_AVG_TRANSFERRED_SLA','Promedio de llamadas transferidas que han esperado menos o iguales segundos que los definidos en preferencias en transferred_sla',0,'2012-09-07 22:21:56'),(1121,'es','help_text_variable_AVG_TRANSFERRED_TALK_TIME','Promedio de tiempo de conversaci&oacute;n de llamadas transferidas.',0,'2012-09-07 22:21:56'),(1122,'es','help_text_variable_AVG_TRANSFERRED_WAIT_TIME','Promedio de tiempo de espera para llamadas transferidas.',0,'2012-09-07 22:21:56'),(1123,'es','help_text_variable_AVG_UNANSWERED','Promedio de llamadas no atendidas.',0,'2012-09-07 22:21:56'),(1124,'es','help_text_variable_AVG_UNANSWERED_SLA','Promedio de llamadas no atendidas que han esperado menos o iguales segundos a los definidos en las preferencias en unanswered_sla.',0,'2012-09-07 22:21:56'),(1125,'es','help_text_variable_AVG_UNANSWERED_WAIT_TIME','Promedio de tiempo de espera para llamadas no atendidas.',0,'2012-09-07 22:21:56'),(1126,'es','help_text_variable_CALLS_WAITING','N&uacute;mero de llamadas esperando. S&oacute;lo disponible en f&oacute;rmulas de COLUMN_REALTIME',0,'2012-09-07 22:21:56'),(1127,'es','help_text_variable_LOGIN','Number of Agent Logins.',0,'2012-09-07 22:21:56'),(1128,'es','help_text_variable_LOGOUT','Number of Agent Logoffs.',0,'2012-09-07 22:21:56'),(1129,'es','help_text_variable_MAX_ABANDONED_WAIT_TIME','Tiempo de espera m&aacute;ximo para llamadas abandonadas.',0,'2012-09-07 22:21:56'),(1130,'es','help_text_variable_MAX_ANSWERED_TALK_TIME','Tiempo m&aacute;ximo de conversaci&oacute;n para llamadas atendidas.',0,'2012-09-07 22:21:56'),(1131,'es','help_text_variable_MAX_ANSWERED_WAIT_TIME','Tiempo de espera m&aacute;ximo para llamadas atendidas.',0,'2012-09-07 22:21:56'),(1132,'es','help_text_variable_MAX_CALLERS_WAITING','N&uacute;mero de llamantes m&aacute;ximo esperando en una cola.',0,'2012-09-07 22:21:56'),(1133,'es','help_text_variable_MAX_COL','Maximum value for the column, to be used in TOTAL formulas.',0,'2012-09-07 22:21:56'),(1134,'es','help_text_variable_MAX_TRANSFERRED_TALK_TIME','Tiempo de conversaci&oacute;n m&aacute;ximo para llamadas transferidas.',0,'2012-09-07 22:21:56'),(1135,'es','help_text_variable_MAX_TRANSFERRED_WAIT_TIME','Tiempo de espera m&aacute;ximo para llamadas transferidas.',0,'2012-09-07 22:21:56'),(1136,'es','help_text_variable_MAX_UNANSWERED_WAIT_TIME','Maximum Wait Time for Unanswered Calls.',0,'2012-09-07 22:21:56'),(1137,'es','help_text_variable_MAX_WAIT_TIME','Tiempo de espera m&aacute;ximo para un reporte agrupado particular.',0,'2012-09-07 22:21:56'),(1138,'es','help_text_variable_MIN_ABANDONED_WAIT_TIME','Tiempo de espera m&iacute;nimo en llamadas abandonadas.',0,'2012-09-07 22:21:56'),(1139,'es','help_text_variable_MIN_ANSWERED_TALK_TIME','Tiempo de conversaci&oacute;n m&iacute;nimo para llamadas atendidas.',0,'2012-09-07 22:21:56'),(1140,'es','help_text_variable_MIN_ANSWERED_WAIT_TIME','Tiempo de espera m&iacute;nimo para llamadas atendidas.',0,'2012-09-07 22:21:56'),(1141,'es','help_text_variable_MIN_COL','Valor m&iacute;nimo para la columna para ser usado en f&oacute;rmulas de TOTAL.',0,'2012-09-07 22:21:56'),(1142,'es','help_text_variable_MIN_TRANSFERRED_TALK_TIME','Tiempo mínimo al habla de llamadas transferidas.',0,'2012-09-07 22:21:56'),(1143,'es','help_text_variable_MIN_TRANSFERRED_WAIT_TIME','Tiempo mínimo de espera en llamadas transferidas.',0,'2012-09-07 22:21:56'),(1144,'es','help_text_variable_MIN_UNANSWERED_WAIT_TIME','Tiempo mínimo de espera en llamadas no atendidas.',0,'2012-09-07 22:21:56'),(1145,'es','help_text_variable_RECEIVED','Número de llamadas recibidas (con disposición enumerada en EVENT_RECEIVED) para el reporte agrupado en particular.',0,'2012-09-07 22:21:56'),(1146,'es','help_text_variable_ROW_COUNT','N&uacute;mero de filas en el reporte. Para ser usado en f&oacute;rmulas en TOTAL.',0,'2012-09-07 22:21:56'),(1147,'es','help_text_variable_SUM_ABANDONED','Suma de llamadas abandonadas para una fila en particular en un reporte.',0,'2012-09-07 22:21:56'),(1148,'es','help_text_variable_SUM_ABANDONED_SLA','Sum of Abandoned calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_abandoned seconds as set in Preferences.',0,'2012-09-07 22:21:56'),(1149,'es','help_text_variable_SUM_ABANDONED_WAIT_TIME','Suma de tiempo de espera de llamadas abandonadas para una fila particular en un reporte.',0,'2012-09-07 22:21:56'),(1150,'es','help_text_variable_SUM_ANSWERED','Suma de llamadas atendidas de una fila particular en un reporte.',0,'2012-09-07 22:21:56'),(1151,'es','help_text_variable_SUM_ANSWERED_SLA','Suma de llamadas atendidas de una fila particular en un reporte, cuyo tiempo de espera es menor o igual que el seteo en las preferencias de sla_answered (segundos)',0,'2012-09-07 22:21:56'),(1152,'es','help_text_variable_SUM_ANSWERED_TALK_TIME','Suma de tiempo de conversaci&oacute;n para llamadas atendidas de una fila en particular dentro de un reporte.',0,'2012-09-07 22:21:56'),(1153,'es','help_text_variable_SUM_ANSWERED_WAIT_TIME','Suma del tiempo de espera para llamadas atendidas de una fila particular de un reporte.',0,'2012-09-07 22:21:56'),(1154,'es','help_text_variable_SUM_COL','Suma de todos los valores para una columna en particular. Para ser usado en f&oacute;rmulas TOTAL.',0,'2012-09-07 22:21:56'),(1155,'es','help_text_variable_SUM_LOGIN','Suma de los eventos de Login para una fila en particular en un reporte.',0,'2012-09-07 22:21:56'),(1156,'es','help_text_variable_SUM_LOGOUT','Suma de los eventos de Logoff para una fila en particular en un reporte.',0,'2012-09-07 22:21:56'),(1157,'es','help_text_variable_SUM_RECEIVED','Suma de las llamadas recibidas para una fila en particular en un reporte.',0,'2012-09-07 22:21:56'),(1158,'es','help_text_variable_SUM_TRANSFERRED','Suma de las llamadas transferidas para una fila particular en un reporte.',0,'2012-09-07 22:21:56'),(1159,'es','help_text_variable_SUM_TRANSFERRED_SLA','Suma de llamadas transferidas para una fila particular en un reporte, cuyo tiempo de espera es menor o igual que lo definido en las preferencias en sla_transferred (segundos)',0,'2012-09-07 22:21:56'),(1160,'es','help_text_variable_SUM_TRANSFERRED_TALK_TIME','Suma del tiempo de conversaci&oacute;n para llamadas transferidas para una fila particular en un reporte.',0,'2012-09-07 22:21:56'),(1161,'es','help_text_variable_SUM_TRANSFERRED_WAIT_TIME','Suma del tiempo de espera para llamadas transferidas de una fila particular en un reporte.',0,'2012-09-07 22:21:56'),(1162,'es','help_text_variable_SUM_UNANSWERED','Suma de las llamadas no atendidas para la fila particular en un reporte.',0,'2012-09-07 22:21:56'),(1163,'es','help_text_variable_SUM_UNANSWERED_SLA','Suma de las llamadas no atendidas para una fila particular en un reporte, cuyo tiempo de espera es menor o igual al definido en preferencias en transferred_sla (segundos)',0,'2012-09-07 22:21:56'),(1164,'es','help_text_variable_SUM_UNANSWERED_WAIT_TIME','Suma del tiempo de espera para llamadas transferidas para una fila particular en un reporte.',0,'2012-09-07 22:21:56'),(1165,'es','help_text_variable_TOTAL_ABANDONED','Total de llamadas abandonadas.',0,'2012-09-07 22:21:56'),(1166,'es','help_text_variable_TOTAL_ABANDONED_SLA','Total de llamadas abandonadas cuyo tiempo de espera es menor o igual que el definido en preferencias en abandoned_sla.',0,'2012-09-07 22:21:56'),(1167,'es','help_text_variable_TOTAL_ABANDONED_WAIT_TIME','Tiempo de espera total para llamadas abandonadas.',0,'2012-09-07 22:21:56'),(1168,'es','help_text_variable_TOTAL_ANSWERED','Total de llamadas atendidas.',0,'2012-09-07 22:21:56'),(1169,'es','help_text_variable_TOTAL_ANSWERED_SLA','Total de llamadas atendidas cuyo tiempo de espera es menor o igual que lo definido en preferencias en answered_sla (segundos)',0,'2012-09-07 22:21:56'),(1170,'es','help_text_variable_TOTAL_ANSWERED_TALK_TIME','Tiempo de conversaci&oacute;n total para llamadas atendidas.',0,'2012-09-07 22:21:56'),(1171,'es','help_text_variable_TOTAL_ANSWERED_WAIT_TIME','Tiempo de espera total para llamadas atendidas.',0,'2012-09-07 22:21:56'),(1172,'es','help_text_variable_TOTAL_LOGIN','Total de eventos Login.',0,'2012-09-07 22:21:56'),(1173,'es','help_text_variable_TOTAL_LOGOUT','Total de eventos Logoff',0,'2012-09-07 22:21:56'),(1174,'es','help_text_variable_TOTAL_RECEIVED','Total de llamadas recibidas.',0,'2012-09-07 22:21:56'),(1175,'es','help_text_variable_TOTAL_TRANSFERRED','Total de llamadas transferidas.',0,'2012-09-07 22:21:56'),(1176,'es','help_text_variable_TOTAL_TRANSFERRED_SLA','Total de llamadas transferidas que cuyo tiempo de espera es menor o igual al definido en preferencias en transferred_sla (segundos)',0,'2012-09-07 22:21:56'),(1177,'es','help_text_variable_TOTAL_TRANSFERRED_TALK_TIME','Tiempo de conversaci&oacute;n total para llamadas transferidas.',0,'2012-09-07 22:21:56'),(1178,'es','help_text_variable_TOTAL_TRANSFERRED_WAIT_TIME','Tiempo de espera total para llamadas transferidas.',0,'2012-09-07 22:21:56'),(1179,'es','help_text_variable_TOTAL_UNANSWERED','Total de llamadas no atendidas.',0,'2012-09-07 22:21:56'),(1180,'es','help_text_variable_TOTAL_UNANSWERED_SLA','Total de llamadas no atendidas cuyo tiempo de espera es menor o igual al definido en preferencias en unanswered_sla',0,'2012-09-07 22:21:56'),(1181,'es','help_text_variable_TOTAL_UNANSWERED_WAIT_TIME','Tiempo de espera total para la totalidad de llamadas no atendidas.',0,'2012-09-07 22:21:56'),(1182,'es','help_text_variable_TRANSFERRED','Cantidad de llamadas transferidas (con disposici&oacute;n EVENT_TRANSFERRED en queue_log)',0,'2012-09-07 22:21:56'),(1183,'es','help_text_variable_TRANSFERRED_SLA','Cantidad de llamadas transferidas (con disposición EVENT_TRANSFERRED en queue_log) cuyo tiempo de espera es menor o igual que el definido en preferencias en transferred_sla',0,'2012-09-07 22:21:56'),(1184,'es','help_text_variable_TRANSFERRED_TALK_TIME','Tiempo de conversaci&oacute;n para llamadas transferidas en una fila en particular.',0,'2012-09-07 22:21:56'),(1185,'es','help_text_variable_TRANSFERRED_WAIT_TIME','Tiempo de espera para llamadas transferidas para la fila en particular.',0,'2012-09-07 22:21:56'),(1186,'es','help_text_variable_UNANSWERED','Cantidad de llamadas no atendidas (con disposici&oacute;n EVENT_UNANSWERED en el queue_log) para el reporte agrupado particular.',0,'2012-09-07 22:21:56'),(1187,'es','help_text_variable_UNANSWERED_SLA','Cantidad de llamadas no atendidas (con disposici&oacute;n EVENT_UNANSWERED en queue_log) cuyo tiempo de espera es menor o igual que el definido en preferencias en sla_unanswered.',0,'2012-09-07 22:21:56'),(1188,'es','help_text_variable_UNANSWERED_WAIT_TIME','Tiempo de espera para llamadas no atendidas en la fila particular.',0,'2012-09-07 22:21:56'),(1189,'en','License validation problem','License validation problem',0,'2012-09-07 21:26:28'),(1190,'es','You must select at least one queue','Debe seleccionar al menos una cola',0,'2012-09-05 02:07:06'),(1191,'en','Proceed','Proceed',0,'2012-09-06 23:56:50'),(1192,'en','No results','No results',0,'2012-09-06 18:23:21'),(1193,'es','License validation problem','Problema al validar la licencia',0,'2012-09-06 18:26:36'),(1194,'es','help_text_CHART_SERIES_COLOR','Color a utilizar en los gráficos. El parámetro es el número de posición/índice, y el valor el color en valor hexadecimal html.',0,'2012-09-07 22:21:56'),(1195,'en','help_text_CHART_SERIES_COLOR','Colors to use for charts. Parameter is the index position, and value the hex html color.',0,'2012-10-02 05:42:51'),(1196,'es','Proceed','Proceder',0,'2012-09-07 22:25:24'),(1197,'es','Name','Nombre',0,'2012-09-12 23:35:09'),(1198,'es','Level','Nivel',0,'2012-09-12 23:35:09'),(1199,'en','Could not copy uploaded file','Could not copy uploaded file',0,'2012-10-01 23:37:27'),(1200,'en','Empty file?','Empty file?',0,'2012-10-01 23:37:27'),(1201,'fr','Unanswered by Day','No Atendidas por Día',1,'2012-10-01 23:17:33'),(1202,'fr','Unanswered Rate','Unanswered Rate',1,'2012-10-01 23:17:33'),(1203,'fr','Unanswered Calls','Unanswered Calls',1,'0000-00-00 00:00:00'),(1204,'fr','Unanswered','Unanswered',1,'2012-10-01 23:17:33'),(1205,'fr','URL','URL',1,'2012-10-01 23:17:33'),(1206,'fr','Type','Type',1,'0000-00-00 00:00:00'),(1207,'fr','Tuesday','Tuesday',1,'2012-10-01 23:17:42'),(1208,'fr','Translation','Translation',1,'2012-10-01 23:17:20'),(1209,'fr','Transferred Calls','Transferred Calls',1,'0000-00-00 00:00:00'),(1210,'fr','Generate','Generate',1,'0000-00-00 00:00:00'),(1211,'fr','Transferred','Transferred',1,'2012-10-01 23:17:33'),(1212,'fr','Total records found','Total records found',1,'2012-10-01 23:17:20'),(1213,'fr','Total Unanswered Calls','Total Unanswered Calls',1,'0000-00-00 00:00:00'),(1214,'fr','Total Time per Agent (seconds)','Total Time per Agent (seconds)',1,'0000-00-00 00:00:00'),(1215,'fr','Total Session Time','Total Session Time',1,'0000-00-00 00:00:00'),(1216,'fr','Total Duration','Total Duration',1,'0000-00-00 00:00:00'),(1217,'fr','Total Calls','Total Calls',1,'2012-10-01 23:17:33'),(1218,'fr','Total Answered Calls','Total Answered Calls',1,'0000-00-00 00:00:00'),(1219,'fr','Total','Total',1,'2012-10-01 23:17:33'),(1220,'fr','Toggle Search Form','Toggle Search Form',1,'0000-00-00 00:00:00'),(1221,'fr','Today','Today',1,'2012-10-01 23:17:29'),(1222,'fr','Time','Time',1,'0000-00-00 00:00:00'),(1223,'fr','To','To',1,'2012-10-01 23:17:29'),(1224,'fr','This week','This week',1,'2012-10-01 23:17:29'),(1225,'fr','Thursday','Thursday',1,'2012-10-01 23:17:42'),(1226,'fr','This month','This month',1,'2012-10-01 23:17:29'),(1227,'fr','There is no valid license file on this installation yet.','There is no valid license file on this installation yet.',1,'0000-00-00 00:00:00'),(1228,'fr','Talk Time','Talk Time',1,'2012-10-01 23:17:33'),(1229,'fr','TRANSFER','Transfer',1,'0000-00-00 00:00:00'),(1230,'fr','Sunday','Sunday',1,'2012-10-01 23:17:42'),(1231,'fr','Success!','Success!',1,'0000-00-00 00:00:00'),(1232,'fr','String','String',1,'2012-10-01 23:17:20'),(1233,'fr','Steal','Steal',1,'0000-00-00 00:00:00'),(1234,'fr','State','State',1,'0000-00-00 00:00:00'),(1235,'fr','Start Position','Start Position',1,'0000-00-00 00:00:00'),(1236,'fr','Start Date','Start Date',1,'2012-10-01 23:17:33'),(1237,'fr','Spy','Spy',1,'0000-00-00 00:00:00'),(1238,'fr','Shortest Session Time','Shortest Session Time',1,'0000-00-00 00:00:00'),(1239,'fr','Shortcuts','Shortcuts',1,'2012-10-01 23:17:29'),(1240,'fr','Setup','Setup',1,'2012-10-01 23:17:33'),(1241,'fr','Sessions','Sessions',1,'0000-00-00 00:00:00'),(1242,'fr','Session Time','Session Time',1,'0000-00-00 00:00:00'),(1243,'fr','Server Time','Server Time',1,'0000-00-00 00:00:00'),(1244,'fr','September','September',1,'2012-10-01 23:17:42'),(1245,'fr','Separate with comma ( , )<br>* means all','Separate with comma ( , )<br>* means all',1,'0000-00-00 00:00:00'),(1246,'fr','Selects marked','Selects marked',1,'2012-10-01 23:17:29'),(1247,'fr','Selects all','Selects all',1,'2012-10-01 23:17:29'),(1248,'fr','Selected','Selected',1,'2012-10-01 23:17:29'),(1250,'fr','Select the field to compare','Select the field to compare',1,'0000-00-00 00:00:00'),(1251,'fr','Select the report to check','Select the report to check',1,'0000-00-00 00:00:00'),(1252,'fr','Select some options','Choisir certaines options',1,'0000-00-00 00:00:00'),(1253,'fr','Select option','Select option',1,'2012-10-01 23:17:20'),(1254,'fr','Select language','Select language',1,'2012-10-01 23:17:20'),(1255,'fr','Select an option','Select an option',1,'0000-00-00 00:00:00'),(1256,'fr','Select all %s records.','Select all %s records.',1,'0000-00-00 00:00:00'),(1257,'fr','Scheduled Reports and Alerts','Scheduled Reports and Alerts',1,'0000-00-00 00:00:00'),(1258,'fr','Search','Search',1,'2012-10-01 23:17:33'),(1259,'fr','Seconds','Seconds',1,'0000-00-00 00:00:00'),(1260,'fr','Select Agents','Select Agents',1,'2012-10-01 23:17:29'),(1261,'fr','Select Date Range','Select Date Range',1,'2012-10-01 23:17:29'),(1262,'fr','Select Queues','Select Queues',1,'2012-10-01 23:17:29'),(1263,'fr','Select Time Frame','Select Time Frame',1,'2012-10-01 23:17:29'),(1264,'fr','Save','Save',1,'0000-00-00 00:00:00'),(1265,'fr','Saturday','Saturday',1,'2012-10-01 23:17:42'),(1266,'fr','SLA','SLA',1,'2012-10-01 23:17:33'),(1267,'fr','Revoke Current License','Revoke Current License',1,'0000-00-00 00:00:00'),(1268,'fr','Revoke','Revoke',1,'0000-00-00 00:00:00'),(1269,'fr','Required field','Required field',1,'0000-00-00 00:00:00'),(1270,'fr','Reports','Reports',1,'0000-00-00 00:00:00'),(1271,'fr','Report','Report',1,'0000-00-00 00:00:00'),(1272,'fr','Record updated','Record updated',1,'0000-00-00 00:00:00'),(1273,'fr','Record inserted','Record inserted',1,'0000-00-00 00:00:00'),(1274,'fr','Record deleted','Record deleted',1,'0000-00-00 00:00:00'),(1275,'fr','Received','Received',1,'2012-10-01 23:17:33'),(1276,'fr','Realtime','Realtime',1,'2012-10-01 23:17:33'),(1277,'fr','Reactivate','Reactivate',1,'0000-00-00 00:00:00'),(1278,'fr','RINGNOANSWER','Failed to Answer Call',1,'0000-00-00 00:00:00'),(1279,'fr','Queues','Queues',1,'0000-00-00 00:00:00'),(1280,'fr','Queue','Queue',1,'2012-10-01 23:17:33'),(1281,'fr','Querying data...','Querying data...',1,'0000-00-00 00:00:00'),(1282,'fr','Proceed','Proceed',1,'0000-00-00 00:00:00'),(1283,'fr','Previous','Previous',1,'2012-10-01 23:17:20'),(1284,'fr','Position','Position',1,'0000-00-00 00:00:00'),(1285,'fr','Please write down destination emails','Please write down destination emails',1,'0000-00-00 00:00:00'),(1286,'fr','Please select the reports to send','Please select the reports to send',1,'0000-00-00 00:00:00'),(1287,'fr','Please copy the above text and send it via email to %s for processing, together with your activation code and the licensee name you want to use','Please copy the above text and send it via email to %s for processing, together with your activation code and the licensee name you want to use',1,'0000-00-00 00:00:00'),(1288,'fr','Play','Play',1,'2012-10-01 23:17:33'),(1289,'fr','Period','Period',1,'2012-10-01 23:17:33'),(1290,'fr','Pending','Pending',1,'2012-10-01 23:17:20'),(1291,'fr','Pauses','Pauses',1,'0000-00-00 00:00:00'),(1292,'fr','Pauses per Session','Pauses per Session',1,'0000-00-00 00:00:00'),(1293,'fr','Paused','Paused',1,'0000-00-00 00:00:00'),(1294,'fr','Pause Time','Pause Time',1,'0000-00-00 00:00:00'),(1295,'fr','Passwords do not match','Passwords do not match',1,'0000-00-00 00:00:00'),(1296,'fr','Password','Password',1,'0000-00-00 00:00:00'),(1297,'fr','October','October',1,'2012-10-01 23:17:42'),(1298,'fr','Overflow','Overflow',1,'0000-00-00 00:00:00'),(1299,'fr','Page','Page',1,'2012-10-01 23:17:20'),(1300,'fr','Page parsed in %s seconds','Page parsed in %s seconds',1,'2012-10-01 23:17:33'),(1301,'fr','OK','OK',1,'0000-00-00 00:00:00'),(1302,'fr','Number of Agent Logoffs','Number of Agent Logoffs',1,'2012-10-01 23:17:33'),(1303,'fr','Number of Agents','Number of Agents',1,'0000-00-00 00:00:00'),(1304,'fr','Number of Answered Calls','Number of Answered Calls',1,'2012-10-01 23:17:33'),(1305,'fr','Number of Calls per Agent','Number of Calls per Agent',1,'0000-00-00 00:00:00'),(1306,'fr','Number of Received Calls','Number of Received Calls',1,'2012-10-01 23:17:33'),(1307,'fr','Number of Transferred Calls','Number of Transferred Calls',1,'2012-10-01 23:17:33'),(1308,'fr','Number of Unanswered Calls','Number of Unanswered Calls',1,'2012-10-01 23:17:33'),(1309,'fr','Number of Agent Logins','Number of Agent Logins',1,'2012-10-01 23:17:33'),(1310,'fr','Number of Abandoned Calls','Number of Abandoned Calls',1,'2012-10-01 23:17:33'),(1311,'fr','Number','Number',1,'2012-10-01 23:17:33'),(1312,'fr','November','November',1,'2012-10-01 23:17:42'),(1313,'fr','Notice','Notice',1,'0000-00-00 00:00:00'),(1314,'fr','None','None',1,'2012-10-01 23:17:33'),(1315,'fr','No results','No results',1,'0000-00-00 00:00:00'),(1316,'fr','No records found','No records found',1,'0000-00-00 00:00:00'),(1317,'fr','No info','No info',1,'0000-00-00 00:00:00'),(1318,'fr','No active channel','No active channel',1,'0000-00-00 00:00:00'),(1319,'fr','No','No',1,'2012-10-01 23:17:20'),(1320,'fr','Next','Next',1,'2012-10-01 23:17:20'),(1321,'fr','New Scheduled Report','New Scheduled Report',1,'0000-00-00 00:00:00'),(1322,'fr','New Email Alert','New Email Alert',1,'0000-00-00 00:00:00'),(1323,'fr','Name','Name',1,'0000-00-00 00:00:00'),(1324,'fr','Month days','Month days',1,'0000-00-00 00:00:00'),(1325,'fr','Month','Month',1,'2012-10-01 23:17:33'),(1326,'fr','Monday','Monday',1,'2012-10-01 23:17:42'),(1327,'fr','Minutes','Minutes',1,'0000-00-00 00:00:00'),(1328,'fr','May','May',1,'2012-10-01 23:17:42'),(1329,'fr','Max. wait time','Max. wait time',1,'0000-00-00 00:00:00'),(1330,'fr','Max Wait Time','Max Wait Time',1,'0000-00-00 00:00:00'),(1331,'fr','Max Callers','Max Callers',1,'2012-10-01 23:17:33'),(1332,'fr','March','March',1,'2012-10-01 23:17:42'),(1333,'fr','Lower ...','Lower ...',1,'2012-10-01 23:17:29'),(1334,'fr','Longest Session','Longest Session',1,'0000-00-00 00:00:00'),(1335,'fr','Logout','Logout',1,'2012-10-01 23:17:33'),(1336,'fr','Logoff','Logoff',1,'2012-10-01 23:17:33'),(1337,'fr','Logins','Logins',1,'2012-10-01 23:17:33'),(1338,'fr','Login Form','Login Form',1,'0000-00-00 00:00:00'),(1339,'fr','Login','Login',1,'0000-00-00 00:00:00'),(1340,'fr','Logged Off','Logged Off',1,'0000-00-00 00:00:00'),(1341,'fr','Loading','Loading',1,'2012-10-01 23:17:33'),(1342,'fr','Listen','Listen',1,'0000-00-00 00:00:00'),(1343,'fr','Licensed to','Licensed to',1,'2012-10-01 23:17:33'),(1344,'fr','License validation problem','License validation problem',1,'0000-00-00 00:00:00'),(1345,'fr','License Handling','License Handling',1,'0000-00-00 00:00:00'),(1346,'fr','Level','Level',1,'0000-00-00 00:00:00'),(1347,'fr','Last three months','Last three months',1,'2012-10-01 23:17:29'),(1348,'fr','Last in Call','Last in Call',1,'0000-00-00 00:00:00'),(1349,'fr','June','June',1,'2012-10-01 23:17:42'),(1350,'fr','Last','Last',1,'2012-10-01 23:17:20'),(1351,'fr','July','July',1,'2012-10-01 23:17:42'),(1352,'fr','January','January',1,'2012-10-01 23:17:42'),(1353,'fr','Invalid Hour','Invalid Hour',1,'0000-00-00 00:00:00'),(1354,'fr','Invalid Date','Invalid Date',1,'0000-00-00 00:00:00'),(1355,'fr','Incompleted Calls','Incompleted Calls',1,'0000-00-00 00:00:00'),(1356,'fr','Import','Import',1,'2012-10-01 23:17:20'),(1357,'fr','In order to receive scheduled reports or alerts via email, you must setup a cron job in the server. You can use the following command in your server command line:<br/><br/>crontab -e<br/><br/>and add the following line (replacing the user and password with a valid user/password):<br/><br/>','In order to receive scheduled reports or alerts via email, you must setup a cron job in the server. You can use the following command in your server command line:<br/><br/>crontab -e<br/><br/>and add the following line (replacing the user and password with a valid user/password):<br/><br/>',1,'0000-00-00 00:00:00'),(1358,'fr','If the field value is higher than this number you will receive an alerting email','If the field value is higher than this number you will receive an alerting email',1,'0000-00-00 00:00:00'),(1359,'fr','ISO Code','ISO Code',1,'2012-10-01 23:17:20'),(1360,'fr','Hours','Hours',1,'0000-00-00 00:00:00'),(1361,'fr','Hour Range','Hour Range',1,'2012-10-01 23:17:33'),(1362,'fr','Hour','Hour',1,'2012-10-01 23:17:33'),(1363,'fr','Home','Home',1,'2012-10-01 23:17:33'),(1364,'fr','Higher ...','Higher ...',1,'2012-10-01 23:17:29'),(1365,'fr','Hide Logged off','Hide Logged off',1,'0000-00-00 00:00:00'),(1366,'fr','Help','Help',1,'2012-10-01 23:17:33'),(1367,'fr','Group by Queue','Group by Queue',1,'0000-00-00 00:00:00'),(1368,'fr','Goes to the top of the page','Goes to the top of the page',1,'2012-10-01 23:17:33'),(1369,'fr','Generate Offline License Request','Generate Offline License Request',1,'0000-00-00 00:00:00'),(1370,'fr','From','From',1,'2012-10-01 23:17:29'),(1371,'fr','From the last (X) days','From the last (X) days',1,'0000-00-00 00:00:00'),(1372,'fr','Friday','Friday',1,'2012-10-01 23:17:42'),(1373,'fr','First','First',1,'2012-10-01 23:17:20'),(1374,'fr','Filter report by Caller Id','Filter report by Caller Id',1,'2012-10-01 23:17:33'),(1375,'fr','Filter','Filter',1,'2012-10-01 23:17:42'),(1376,'fr','February','February',1,'2012-10-01 23:17:42'),(1377,'fr','Exports the data to a comma separated file, to be read by your spreadsheet software','Exports the data to a comma separated file, to be read by your spreadsheet software',1,'2012-10-01 23:17:33'),(1378,'fr','Exports the data to a .pdf file','Exports the data to a .pdf file',1,'2012-10-01 23:17:33'),(1379,'fr','Export','Export',1,'2012-10-01 23:17:20'),(1380,'fr','Event','Event',1,'2012-10-01 23:17:33'),(1381,'fr','Example','Example',1,'0000-00-00 00:00:00'),(1382,'fr','Error updating record','Error updating record',1,'0000-00-00 00:00:00'),(1383,'fr','End Position','End Position',1,'0000-00-00 00:00:00'),(1384,'fr','Error inserting record:<br/>','Error inserting record:<br/>',1,'0000-00-00 00:00:00'),(1385,'fr','End Date','End Date',1,'2012-10-01 23:17:33'),(1386,'fr','Empty file?','Empty file?',1,'0000-00-00 00:00:00'),(1387,'fr','Email','Email',1,'0000-00-00 00:00:00'),(1388,'fr','Edit Scheduled Report','Edit Scheduled Report',1,'0000-00-00 00:00:00'),(1389,'fr','Edit Record','Edit Record',1,'2012-10-01 23:17:20'),(1390,'fr','Edit Email Alert','Edit Email Alert',1,'0000-00-00 00:00:00'),(1391,'fr','EXITWITHTIMEOUT','Timed Out',1,'2012-10-01 23:17:33'),(1392,'fr','EXITWITHKEY','Exit with Key',1,'0000-00-00 00:00:00'),(1393,'fr','Duration','Duration',1,'0000-00-00 00:00:00'),(1394,'fr','Download','Download',1,'2012-10-01 23:17:33'),(1395,'fr','Distribution','Distribution',1,'2012-10-01 23:17:33'),(1396,'fr','Deselects marked','Deselects marked',1,'2012-10-01 23:17:29'),(1397,'fr','Display Report','Display Report',1,'2012-10-01 23:17:29'),(1398,'fr','Deselects all','Deselects all',1,'2012-10-01 23:17:29'),(1399,'fr','Delta','Delta',1,'0000-00-00 00:00:00'),(1400,'fr','Delete Marked','Delete Marked',1,'2012-10-01 23:17:20'),(1401,'fr','Delete','Delete',1,'2012-10-01 23:17:20'),(1402,'fr','December','December',1,'2012-10-01 23:17:42'),(1403,'fr','Day','Day',1,'2012-10-01 23:17:33'),(1404,'fr','Date','Date',1,'2012-10-01 23:17:33'),(1405,'fr','Cron Configuration','Cron Configuration',1,'0000-00-00 00:00:00'),(1406,'fr','Count','Count',1,'0000-00-00 00:00:00'),(1407,'fr','Could not copy uploaded file','Could not copy uploaded file',1,'0000-00-00 00:00:00'),(1408,'fr','Could not connect to the Asterisk Manager Interface to retrieve status information. Please check your manager credentials in config.php and verify they match your settings in /etc/asterisk/manager.conf','Could not connect to the Asterisk Manager Interface to retrieve status information. Please check your manager credentials in config.php and verify they match your settings in /etc/asterisk/manager.conf',1,'0000-00-00 00:00:00'),(1409,'fr','Confirm','Confirm',1,'0000-00-00 00:00:00'),(1410,'fr','Completed','Completed',1,'2012-10-01 23:17:20'),(1411,'fr','Coach','Coach',1,'0000-00-00 00:00:00'),(1412,'fr','Click to view calls in detail','Click to view calls in detail',1,'2012-10-01 23:17:33'),(1413,'fr','Click to edit...','Cliquer pour modifier...',1,'0000-00-00 00:00:00'),(1414,'fr','Click to add text','Click to add text',1,'2012-10-01 23:17:20'),(1415,'fr','Clear Selection','Clear Selection',1,'0000-00-00 00:00:00'),(1416,'fr','Cannot steal call. realtime_spy_extension for user <b>%s</b> is not defined in Setup/Preferences.','Cannot steal call. realtime_spy_extension for user <b>%s</b> is not defined in Setup/Preferences.',1,'0000-00-00 00:00:00'),(1417,'fr','Cancel','Cancel',1,'0000-00-00 00:00:00'),(1418,'fr','Calls Waiting Detail','Calls Waiting Detail',1,'0000-00-00 00:00:00'),(1419,'fr','Calls','Calls',1,'0000-00-00 00:00:00'),(1420,'fr','Caller ID','Caller ID',1,'0000-00-00 00:00:00'),(1421,'fr','COMPLETECALLER','Complete by Caller',1,'2012-10-01 23:17:33'),(1422,'fr','COMPLETEAGENT','Complete by Agent',1,'0000-00-00 00:00:00'),(1423,'fr','Busy','Busy',1,'0000-00-00 00:00:00'),(1424,'fr','Bad username or password','Bad username or password',1,'0000-00-00 00:00:00'),(1425,'fr','Back','Back',1,'0000-00-00 00:00:00'),(1426,'fr','Avg. Session Time','Avg. Session Time',1,'0000-00-00 00:00:00'),(1427,'fr','Avg. Session','Avg. Session',1,'0000-00-00 00:00:00'),(1428,'fr','Avg. Paused','Avg. Paused',1,'0000-00-00 00:00:00'),(1429,'fr','Avg Wait Time','Avg Wait Time',1,'0000-00-00 00:00:00'),(1430,'fr','Avg Wait','Avg Wait',1,'2012-10-01 23:17:33'),(1431,'fr','Avg Talk Time','Avg Talk Time',1,'0000-00-00 00:00:00'),(1432,'fr','Avg Talk','Avg Talk',1,'2012-10-01 23:17:33'),(1433,'fr','Avg Duration','Avg Duration',1,'0000-00-00 00:00:00'),(1434,'fr','Average Wait Time by Day','Average Wait Time by Day',1,'2012-10-01 23:17:33'),(1435,'fr','Average Session Time','Average Session Time',1,'0000-00-00 00:00:00'),(1436,'fr','Average Duration by Day','Average Duration by Day',1,'2012-10-01 23:17:33'),(1437,'fr','Available Variables','Available Variables',1,'0000-00-00 00:00:00'),(1438,'fr','April','April',1,'2012-10-01 23:17:42'),(1439,'fr','Are you sure?','Are you sure?',1,'2012-10-01 23:17:20'),(1440,'fr','August','August',1,'2012-10-01 23:17:42'),(1441,'fr','Available','Available',1,'2012-10-01 23:17:29'),(1442,'fr','Available Keywords','Available Keywords',1,'0000-00-00 00:00:00'),(1443,'fr','Answered','Answered',1,'2012-10-01 23:17:33'),(1444,'fr','Answered Calls','Answered Calls',1,'0000-00-00 00:00:00'),(1445,'fr','Answered by Day','Answered by Day',1,'2012-10-01 23:17:33'),(1446,'fr','Answered/Abandoned','Answered/Abandoned',1,'0000-00-00 00:00:00'),(1447,'fr','Answered/Abandoned per Hour','Answered/Abandoned per Hour',1,'2012-10-01 23:17:33'),(1448,'fr','All %s records on this page are selected.','All %s records on this page are selected.',1,'0000-00-00 00:00:00'),(1449,'fr','An error has occurred','An error has occurred',1,'0000-00-00 00:00:00'),(1450,'fr','Answer','Answer',1,'0000-00-00 00:00:00'),(1451,'fr','Alerts','Alerts',1,'0000-00-00 00:00:00'),(1452,'fr','All %s records are selected.','All %s records are selected.',1,'0000-00-00 00:00:00'),(1453,'fr','Agent','Agent',1,'2012-10-01 23:17:33'),(1454,'fr','Agent Status','Agent Status',1,'0000-00-00 00:00:00'),(1455,'fr','Agent Totals','Agent Totals',1,'0000-00-00 00:00:00'),(1456,'fr','Agents','Agents',1,'0000-00-00 00:00:00'),(1457,'fr','Alert','Alert',1,'0000-00-00 00:00:00'),(1458,'fr','Abandon Avg Wait Before Disconnection','Abandon Avg Wait Before Disconnection',1,'0000-00-00 00:00:00'),(1459,'fr','Abandon Rate','Abandon Rate',1,'2012-10-01 23:17:33'),(1460,'fr','Abandoned','Abandoned',1,'2012-10-01 23:17:33'),(1461,'fr','Abandoned Calls','Abandoned Calls',1,'0000-00-00 00:00:00'),(1462,'fr','Actions','Actions',1,'2012-10-01 23:17:33'),(1463,'fr','Active','Active',1,'0000-00-00 00:00:00'),(1464,'fr','Add','Add',1,'0000-00-00 00:00:00'),(1465,'fr','Add Record','Add Record',1,'0000-00-00 00:00:00'),(1466,'fr','Abandon Avg Queue Start Position','Abandon Avg Queue Start Position',1,'0000-00-00 00:00:00'),(1467,'fr','ALL','ALL',1,'0000-00-00 00:00:00'),(1468,'fr','Abandon Avg Queue Position at Disconnection','Abandon Avg Queue Position at Disconnection',1,'0000-00-00 00:00:00'),(1469,'fr','%s minutes','%s min',0,'0000-00-00 00:00:00'),(1470,'fr','%s records deleted','%s records deleted',1,'0000-00-00 00:00:00'),(1471,'fr','%s secs','%s secs',1,'0000-00-00 00:00:00'),(1472,'fr','ABANDON','Abandonné',0,'2012-10-01 23:17:33'),(1473,'fr','%%','%%',0,'0000-00-00 00:00:00'),(1474,'fr','%% Answ','%% Rép',0,'2012-10-01 23:17:33'),(1475,'fr','%% Calls','%% Appel',0,'0000-00-00 00:00:00'),(1476,'fr','%% Paused','%% On pause',0,'0000-00-00 00:00:00'),(1477,'fr','%% Talk Time','%% Talk Time',0,'0000-00-00 00:00:00'),(1478,'fr','%% Unansw','%% Non Rép',0,'2012-10-01 23:17:33'),(1479,'fr','%s','%s',0,'0000-00-00 00:00:00'),(1480,'fr','%s %%','%s %%',0,'0000-00-00 00:00:00'),(1481,'fr','%s days','%s jours',0,'2012-10-01 23:17:33'),(1482,'fr','%s min. ago','%s min. ago',0,'0000-00-00 00:00:00'),(1483,'fr','%','%',0,'2012-10-01 23:17:33'),(1484,'pt_br','Required field','Campo obrigatorio',0,'2012-10-01 23:24:45'),(1485,'pt_br','Report','Relatorio',0,'2012-10-02 17:18:52'),(1486,'pt_br','Alert','Alerta',0,'2012-10-02 17:18:52'),(1487,'pt_br','In order to receive scheduled reports or alerts via email, you must setup a cron job in the server. You can use the following command in your server command line:<br/><br/>crontab -e<br/><br/>and add the following line (replacing the user and password with a valid user/password):<br/><br/>','Para receber relatorios programados ou alertas via email, é necessario criar um “cron job” no servidor. É possivel usar o seguinte commando na linha de commando do servidor:<br/><br/>crontab -e<br/><br/>and acrescenta a linha seguinte (repoem user/password com o usuario e senha validos:<br/><br/>',0,'2012-10-02 17:18:52'),(1488,'pt_br','Type','Tipo',0,'2012-10-02 17:18:52'),(1489,'pt_br','Active','Ativo',0,'2012-10-02 17:18:52'),(1490,'pt_br','Scheduled Reports and Alerts','Relatorios e alarmes programados',0,'2012-10-02 17:18:52'),(1491,'pt_br','Week days','Dias da semana',0,'2012-10-02 17:18:52'),(1492,'pt_br','Minutes','Minutos',0,'2012-10-02 17:18:52'),(1493,'pt_br','Separate with comma ( , )<br>* means all','separar com vírgula ( , )<br>* significa tudo',0,'2012-10-02 17:18:52'),(1494,'pt_br','If the field value is higher than this number you will receive an alerting email','Se o valor do campo é maior do que este número, você receberá um e-mail de alerta',0,'2012-10-02 17:18:52'),(1495,'pt_br','Write down the value to compare','Anote o valor para comparar',0,'2012-10-02 17:18:52'),(1496,'pt_br','Select the field to compare','Selecione campo para comparar',0,'2012-10-02 17:18:52'),(1497,'pt_br','Select the report to check','Selecione relatorio para verificar',0,'2012-10-02 17:18:52'),(1498,'pt_br','New Email Alert','Nova alerta de Email',0,'2012-10-02 17:18:52'),(1499,'pt_br','Please select the reports to send','Selecione os relatorios para enviar',0,'2012-10-02 17:18:52'),(1500,'pt_br','Use comma to separate emails','Use vírgula para separar e-mails',0,'2012-10-02 17:18:52'),(1501,'pt_br','New Scheduled Report','Novo relatorio automatico',0,'2012-10-02 17:18:52'),(1502,'pt_br','Please write down destination emails','Favor indicar email de envio',0,'2012-10-02 17:18:52'),(1503,'pt_br','at minute','no minuto ?',0,'2012-10-02 17:18:52'),(1504,'pt_br','Reports','Relatorio',0,'2012-10-02 17:18:52'),(1505,'pt_br','Alerts','Alertas',0,'2012-10-02 17:18:52'),(1506,'pt_br','at hour','na hora ?',0,'2012-10-02 17:18:52'),(1507,'pt_br','every minute','a cada minuto',0,'2012-10-02 17:18:52'),(1508,'pt_br','every hour','todas as horas',0,'2012-10-02 17:18:52'),(1509,'pt_br','day','dia',0,'2012-10-02 17:18:52'),(1510,'pt_br','Querying data...','Procurando informaçao',0,'2012-10-02 17:18:52'),(1511,'pt_br','all month','Mes atual',0,'2012-10-02 17:18:52'),(1512,'pt_br','EXITWITHTIMEOUT','Exit with Timeout',1,'2012-10-02 17:17:26'),(1513,'pt_br','Record updated','Registro atualizado',0,'2012-10-01 23:06:53'),(1514,'en','help_text_REALTIME_COLUMN_WIDTHS','Comma separated list of column widths for realtime reports, where parameter is the report to modify, for example &#39;agent&#39;',0,'2012-10-02 05:42:51'),(1515,'pt_br','disposition_help_ENTERQUEUE','disposition_help_ENTERQUEUE',1,'2012-10-02 17:17:26'),(1516,'pt_br','disposition_help_CONNECT','The caller was connected to an agent.',1,'2012-10-02 17:17:26'),(1517,'pt_br','Play','Tocar',0,'2012-10-02 17:16:33'),(1518,'pt_br','disposition_help_TRANSFER','Caller was transferred to a different extension. Context and extension\r\nare recorded. The caller&lsquo;s hold time and the length of the call are both\r\nrecorded. PLEASE remember that transfers performed by SIP UA&lsquo;s by way\r\nof a reinvite may not always be caught by Asterisk and trigger off this\r\nevent. The only way to be 100% sure that you will get this event when\r\na transfer is performed by a queue member is to use the built-in transfer\r\nfunctionality of Asterisk.',1,'2012-10-02 17:17:26'),(1519,'pt_br','disposition_help_RINGNOANSWER','The timeout value for ringing the queue member was exceeded. A single parameter will also be written indicating the amount of time the member’s extension rang in the Info 1 field.',1,'2012-10-02 17:17:26'),(1520,'pt_br','disposition_help_COMPLETEAGENT','Ligação foi atendida por um agente e a ligação foi encerrada pelo agente.Tempo de espera, e porisição ao entrar na fila sao registradas.',0,'2012-10-02 17:17:26'),(1521,'pt_br','disposition_help_EXITWITEMPTY','The caller was exited from the queue forcefully because the queue had no\r\nreachable members and it&lsquo;s configured to do that to callers when there\r\nare no reachable members. The position is the caller&lsquo;s position in the\r\nqueue when they hungup, the origposition is the original position the\r\ncaller was when they first entered the queue, and the waittime is how\r\nlong the call had been waiting in the queue at the time of disconnect.',1,'2012-10-02 17:17:26'),(1522,'pt_br','disposition_help_COMPLETECALLER','The caller was connected to an agent, and the call was terminated normally\r\nby the *caller*. The callers hold time and the length of the call are both\r\nrecorded. The caller&rsquo;s original position in the queue is recorded in\r\norigposition.\r\n',1,'2012-10-02 17:17:26'),(1523,'pt_br','disposition_help_EXITWITHTIMEOUT','The caller was on hold too long and the timeout expired.',1,'2012-10-02 17:17:26'),(1524,'pt_br','None','Nenhum',0,'2012-10-02 17:17:26'),(1525,'pt_br','disposition_help_ABANDON','Ligou e abandonou/desligou a ligação antes de ser atendido',0,'2012-10-02 17:17:26'),(1526,'pt_br','disposition_help_EXITWITHKEY','The caller elected to use a menu key to exit the queue. The key and\r\nthe caller&lsquo;s position in the queue are recorded.\r\n',1,'2012-10-02 17:17:26'),(1527,'pt_br','Success!','Sucesso!',0,'2012-10-01 23:06:53'),(1528,'pt_br','Start Position','Posição ao entrar na fila',0,'2012-10-02 17:17:26'),(1529,'pt_br','Exports the data to a comma separated file, to be read by your spreadsheet software','Exportar para CSV para excel',0,'2012-10-02 17:17:26'),(1530,'pt_br','Add Record','Acrescentar registro',0,'2012-09-26 01:06:23'),(1531,'pt_br','Save','Salvar',0,'2012-10-02 17:18:52'),(1532,'pt_br','Record inserted','Registro inserido',0,'2012-09-26 01:06:31'),(1533,'pt_br','User','Usuario',0,'2012-09-26 22:26:20'),(1534,'pt_br','No info','Sem Informação',0,'2012-09-25 22:49:04'),(1535,'pt_br','Passwords do not match','Senhas digitadas nao são iguais',0,'2012-10-01 23:24:45'),(1536,'pt_br','Max Wait Time','Tempo Max Espera\n',0,'2012-09-26 22:27:13'),(1537,'pt_br','Answered/Abandoned','Atendidas/Abandonadas',0,'2012-10-02 17:17:26'),(1538,'pt_br','Transferred Calls','Ligações Transferidas',0,'2012-09-26 22:27:13'),(1539,'pt_br','%%','%%',0,'2012-10-02 17:17:26'),(1540,'pt_br','Number of Calls per Agent','Ligações por Atendentes',0,'2012-09-26 22:27:13'),(1541,'pt_br','Overflow','Overflow',1,'2012-10-02 17:18:49'),(1542,'pt_br','Listen','Escutar',0,'2012-09-26 01:11:21'),(1543,'pt_br','Steal','Puxar ligação',0,'2012-09-26 01:11:21'),(1544,'pt_br','Level','Nivel',0,'2012-09-22 00:07:38'),(1545,'pt_br','All %s records on this page are selected.','Todos os %s registros nesta página são selecionados.',0,'2012-09-21 23:53:04'),(1546,'pt_br','ALL','TODOS',0,'2012-09-22 00:07:38'),(1547,'pt_br','Queues','Filas',0,'2012-09-22 00:07:38'),(1548,'pt_br','Password','Senha',0,'2012-09-26 22:26:20'),(1549,'pt_br','Name','Nome',0,'2012-09-22 00:07:38'),(1550,'pt_br','Month','Mes',0,'2012-10-02 17:18:40'),(1551,'pt_br','Week','Semana',0,'2012-10-02 17:18:40'),(1552,'pt_br','URL','URL',0,'2012-10-02 17:18:40'),(1553,'pt_br','Number','Numero',0,'2012-10-02 17:18:49'),(1554,'pt_br','Logins','Logins',1,'2012-10-02 17:18:40'),(1555,'pt_br','Max Callers','Max Ligaçoes',0,'2012-10-02 17:18:40'),(1556,'pt_br','SLA','SLA',0,'2012-10-02 17:18:40'),(1557,'pt_br','Total','Total',0,'2012-10-02 17:18:50'),(1558,'pt_br','Number of Transferred Calls','Numero ligaçoes transferidas',0,'2012-10-02 17:18:40'),(1559,'pt_br','Number of Agent Logins','Numero de Logins de Agentes',0,'2012-10-02 17:18:40'),(1560,'pt_br','Number of Agent Logoffs','Numero de Logoffs de Agentes',0,'2012-10-02 17:18:40'),(1561,'pt_br','Number of Abandoned Calls','Ligaçoes Abandonadas',0,'2012-10-02 17:18:40'),(1562,'pt_br','Number of Received Calls','Ligaçoes Recebidas',0,'2012-10-02 17:18:40'),(1563,'pt_br','agent_detail','Detalhe por Agente',0,'2012-10-02 17:19:07'),(1564,'pt_br','Period','Periodo',0,'2012-10-02 17:18:40'),(1565,'pt_br','agent_durations','Sessões e Pausas dos Agentes',0,'2012-10-02 17:19:07'),(1566,'pt_br','agent_pauses','Detalhe pausas',0,'2012-10-02 17:19:07'),(1567,'pt_br','agent_dispositions','Status de ligações por Agente',0,'2012-10-02 17:19:07'),(1568,'pt_br','String','Texto',0,'2012-10-01 23:24:45'),(1569,'pt_br','agent_summary','Resumo de Agentes',0,'2012-10-02 17:19:07'),(1570,'pt_br','agent_availability','Disponibilidade dos Agentes',0,'2012-10-02 17:19:07'),(1571,'pt_br','Pending','Pendente',0,'2012-10-01 23:24:45'),(1572,'pt_br','Select option','Selecione opção',0,'2012-10-02 17:18:53'),(1573,'pt_br','Selects all','Seleciona TODOS',0,'2012-10-02 17:19:07'),(1574,'pt_br','Shortcuts','Atalhos',0,'2012-10-02 17:19:07'),(1575,'pt_br','Lower ...','Mais Baixo...',0,'2012-10-02 17:19:07'),(1576,'pt_br','To','Para',0,'2012-10-02 17:19:07'),(1577,'pt_br','Page parsed in %s seconds','Pagina atualizada em %s segundos',0,'2012-10-02 17:19:07'),(1578,'pt_br','Selects marked','Seleciona opções marcadas',0,'2012-10-02 17:19:07'),(1579,'pt_br','Next','Proximo',0,'2012-10-02 17:18:52'),(1580,'pt_br','Page','Pagina',0,'2012-10-02 17:18:52'),(1581,'pt_br','Total records found','Total de registros encontrados',0,'2012-10-02 17:18:52'),(1582,'pt_br','No','No',0,'2012-10-02 17:18:52'),(1583,'pt_br','View Record','Ver registro',0,'2012-10-01 23:24:54'),(1584,'pt_br','Previous','Anterior',0,'2012-10-02 17:18:52'),(1585,'pt_br','help_text_week_mode','When to start counting weeks from the year:<br><pre>\r\nMode    First day of week       Range   Week 1 is the first week ...\r\n0       Sunday                  0-53    with a Sunday in this year\r\n1       Monday                  0-53    with more than 3 days this year\r\n2       Sunday                  1-53    with a Sunday in this year\r\n3       Monday                  1-53    with more than 3 days this year\r\n4       Sunday                  0-53    with more than 3 days this year\r\n5       Monday                  0-53    with a Monday in this year\r\n6       Sunday                  1-53    with more than 3 days this year\r\n7       Monday                  1-53    with a Monday in this year\r\n</pre>',1,'2012-10-01 23:24:54'),(1586,'pt_br','Yes','Sim',0,'2012-10-02 17:18:52'),(1587,'pt_br','help_text_timezone','Timezone Configuration for user, in the format [ -]HH:MM\r\n\r\nIf the user name is specified as parameter, then applies only to that user. If parameter is left blank it will be applied globally.',0,'2012-09-26 22:29:50'),(1588,'pt_br','help_text_wait_time_format','Format for the wait time fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in drill down and detailed reports.',1,'2012-10-01 23:24:54'),(1589,'pt_br','help_text_sla_abandoned','Service Level value in seconds for Abandoned calls',1,'2012-10-01 23:24:54'),(1590,'pt_br','help_text_sla_answered','Service Level value in seconds for Answered calls',1,'2012-10-01 23:24:54'),(1591,'pt_br','help_text_sla_interval','Time interval in seconds to split the table for SLA (Service Level Agreement) and Abandon Rate reports.',1,'2012-10-01 23:24:54'),(1592,'pt_br','help_text_sla_steps','Number of steps to show in SLA (Service Level Agreement) and Abandon Rate reports.',1,'2012-10-01 23:24:54'),(1593,'pt_br','help_text_sla_transferred','Service Level value in seconds for Transferred calls',1,'2012-10-01 23:24:54'),(1594,'pt_br','help_text_sla_unanswered','Service Level value in seconds for unanswered calls (not abandoned, but unanswered due to timeouts, exit with key, etc).',1,'2012-10-01 23:24:54'),(1595,'pt_br','help_text_timeframe_interval','Interval in minutes to present the time frame selection on the home tab. Defaults to 15 minutes.',1,'2012-10-01 23:24:54'),(1596,'pt_br','help_text_show_agent_call','Show end call events when drilling down on agent reports',1,'2012-10-01 23:24:54'),(1597,'pt_br','help_text_show_agent_field','Mostrar columna de Agente en reportes de no atendidos (útil cuando se rastrean llamados salientes)',1,'2012-10-01 23:24:54'),(1598,'pt_br','help_text_show_url_field','Enable and display the URL field and reports',1,'2012-10-01 23:24:54'),(1599,'pt_br','help_text_short_unanswered_threshold','Ignorar ligação curta: ligações menores do que este valor serão COMPLETAMENTE ignoradas. Se especificar nome da fila no parametro ai somente esta fila será afetada.',0,'2012-10-01 23:24:54'),(1600,'pt_br','help_text_short_abandon_threshold','Ligações com duração abaixo deste valor nao serão consideradas no relatorio de abandono.',0,'2012-10-01 23:24:54'),(1601,'pt_br','help_text_shared_lastcall','Compartir la información de último llamado entre colas. Sólo se mostrará el tiempo más corto para todas las colas. Si se utiliza rastreo de salientes y se guarda el valor astdb LASTCALL, será también tomado en cuenta.',1,'2012-10-01 23:24:54'),(1602,'pt_br','help_text_realtime_strict_interface_status','This setting will make the realtime view show status as returned by the asterisk queue application by means of the STATE INTERFACE options for the AddQueueMember application. It should be set to 1 in systems with Local type queue members with STATE INTERFACE set, like FreePBX 2.8 or higher.',1,'2012-10-01 23:24:54'),(1603,'pt_br','help_text_recordings_path','Recordings location/directory in the hardrive to perform the direct download.',1,'2012-10-01 23:24:54'),(1604,'pt_br','help_text_session_time_format','Format for the session duration fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in the agent reports.',1,'2012-10-01 23:24:54'),(1605,'pt_br','help_text_realtime_spy_options','Options to pass to chanspy when launching a Listen action from the realtime view. You can use any options available to the asterisk chanspy application, like &quot;q&quot; to disable the initial beep, etc.',1,'2012-10-01 23:24:54'),(1606,'pt_br','help_text_realtime_spy_extension','Extension to reach the supervisor phone when launching a call steal action in the realtime view. The parameter must be set to the asternic user name, the value could be the extension number followed by the context, for example: 100@from-internal',1,'2012-10-01 23:24:54'),(1607,'pt_br','help_text_realtime_refresh_sql','Refresh time in seconds for statistics values on the queue summary table in the realtime view. Retrieving the information is cpu expensive, so you might want to leave it at the default value of 60 seconds or even higher if you have many supervisors checking the realt time view at the same time.',1,'2012-10-01 23:24:54'),(1608,'pt_br','help_text_realtime_spy_device','Device used by the user (set in the parameter field). Example: SIP/1234',1,'2012-10-01 23:24:54'),(1609,'pt_br','help_text_realtime_hide_loggedoff','Start the realtime view without showing logged off Agents.',1,'2012-10-01 23:24:54'),(1610,'pt_br','help_text_realtime_refresh','Refresh time in seconds for the realtime view.',1,'2012-10-01 23:24:54'),(1611,'pt_br','help_text_realtime_group_queues','Start the realtime view with a grouped queue display.',1,'2012-10-01 23:24:54'),(1612,'pt_br','help_text_realtime_custom_pauses','If this value is set to 1 the realtime page will check the ASTDB for the PAUSECUSTOM/Agent family and it will show the pause code stored there for a particular Agent as stored in astdb Key. Eg: PAUSECUSTOM/Agent/1000 = Break:${EPOCH} stored in ASTDB will show Agent 1000 as break when paused.',1,'2012-10-01 23:24:54'),(1613,'pt_br','help_text_realtime_alarm_wait_duration','Alarm in seconds for call waiting duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',1,'2012-10-01 23:24:54'),(1614,'pt_br','help_text_realtime_coach_options','Options to pass to chanspy when launching a Coach action from the realtime view. You can use any options available to the asterisk chanspy application, like &quot;w&quot; to enable whispering, or &quot;d&quot; to use dtmf to switch modes: 4 spy, 5 whisper, 6 barge., etc.',1,'2012-10-01 23:24:54'),(1615,'pt_br','help_text_realtime_alarm_wait_count','Alarm (in number of calls) for calls waiting in a queue in the realtime view.',1,'2012-10-01 23:24:54'),(1616,'pt_br','help_text_realtime_alarm_row_color','Background row color when a value is in alarm in the realtime view.',1,'2012-10-01 23:24:54'),(1617,'pt_br','help_text_realtime_alarm_threshold','Threshold (in percentage) from which to start coloring in alarm calls in the realtime view.',1,'2012-10-01 23:24:54'),(1618,'pt_br','help_text_realtime_alarm_call_duration','Alarm in seconds for call duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',1,'2012-10-01 23:24:54'),(1619,'pt_br','help_text_realtime_alarm_last_call','Alarm in seconds for the last call information in the realtime view. Can be set per queue by setting the parameter to the queue name.',1,'2012-10-01 23:24:54'),(1620,'pt_br','help_text_realtime_alarm_pause_duration','Alarm in seconds for pause/break duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',1,'2012-10-01 23:24:54'),(1621,'pt_br','help_text_language','Language to use. You can specify a user name in the parameter field to limit the language to a particular user. If the parameter field is left empty, then the language will be set for all users (global setting).',1,'2012-10-01 23:24:54'),(1622,'pt_br','help_text_mail_from_email','Schedule and Alert reports needs a FROM field to send emails.',1,'2012-10-01 23:24:54'),(1623,'pt_br','help_text_mail_from_name','Schedule and Alert reports needs a NAME field to send emails.',1,'2012-10-01 23:24:54'),(1624,'pt_br','help_text_mail_header_image','Image file to use as header for emails reports/alerts',1,'2012-10-01 23:24:54'),(1625,'pt_br','help_text_mail_smtp_password','Schedule and Alert reports, configure an SMTP password if needed.',1,'2012-10-01 23:24:54'),(1626,'pt_br','help_text_first_page','Initial page to load (Eg: answered.php, unanswered.php, distribution.php, agent.php). Can be set per user',1,'2012-10-01 23:24:54'),(1627,'pt_br','help_text_hide_parsed_time','Set this to 1 to hide the parsed time information on the footer of every report.',1,'2012-10-01 23:24:54'),(1628,'pt_br','help_text_honor_timeframe_in_agent','Honor time frame selection in Agent Tab Reports. It will also try to compute missing events for the period if \nthey are not in the logs.',1,'2012-10-01 23:24:54'),(1629,'pt_br','help_text_ignore_none_abandons','If you do not want to count for inbound abandoned calls when selecting some agents from a report, set this parameter to one. This is useful for when you are tracking outbound campaigns and want to track performance per agent on outbound as it filters out the inbound abandoned calls that are assigned to the whole queue (agent NONE) and not a particular agent. If you select all agents for a report it will include also the NONE agent, so inbound abandons will count normally event if this parameter is set to one.',1,'2012-10-01 23:24:54'),(1630,'pt_br','help_text_drilldown_records_per_page','Number of records per page to show when expanding/drilling down on any report.',1,'2012-10-01 23:24:54'),(1631,'pt_br','help_text_mail_smtp_username','Schedule and Alert reports, configure the SMTP username if needed.',1,'2012-10-01 23:24:54'),(1632,'pt_br','help_text_mail_smtp_server','Schedule and Alert reports, configure the SMTP server for sending emails. SSL protocol example: ssl://smtp.server.com ; for TLS protocol: tls://smtp.server.com ; without encryption: smtp.server.com',1,'2012-10-01 23:24:54'),(1633,'pt_br','help_text_mail_smtp_server_port','Schedule and Alert reports, configure the SMTP port if needed.',1,'2012-10-01 23:24:54'),(1634,'pt_br','help_text_distribution_interval','Interval in minutes to break up the distribution by hour report. By default it breaks by hour (60 minutes), but you can use smaller or larger values.',1,'2012-10-01 23:24:54'),(1635,'pt_br','No records found','Nenhum Registro encontrado',0,'2012-10-01 23:24:29'),(1636,'pt_br','%','%',0,'2012-10-02 17:18:40'),(1637,'pt_br','%% Answ','%% Atendidas',0,'2012-10-02 17:18:40'),(1638,'pt_br','%% Calls','%% Chamadas',0,'2012-10-02 17:17:26'),(1639,'pt_br','%% Talk Time','%% Tempo Total',0,'2012-09-26 22:27:13'),(1640,'pt_br','%% Unansw','%% Nao Atendidas',0,'2012-10-02 17:18:40'),(1641,'pt_br','%s days','%s dias',0,'2012-10-02 17:18:40'),(1642,'pt_br','%s min. ago','%s min. atras',0,'2012-10-02 17:18:50'),(1643,'pt_br','%s records deleted','%s registros deletados',0,'2012-09-21 23:45:37'),(1644,'pt_br','ABANDON','Abandono',0,'2012-10-02 17:17:26'),(1645,'pt_br','Abandon Avg Queue Position at Disconnection','Posiçao Media na Fila ao Abandonar',0,'2012-10-02 17:17:26'),(1646,'pt_br','Abandon Avg Queue Start Position','Posiçao Inicial na fila de quem abandonou',0,'2012-10-02 17:17:26'),(1647,'pt_br','Abandon Avg Wait Before Disconnection','Media espera antes de desligar dos Abandonos',0,'2012-10-02 17:17:26'),(1648,'pt_br','Abandon Rate','Percentual Abandono',0,'2012-10-02 17:18:50'),(1649,'pt_br','Abandoned','Ligações abandonadas',0,'2012-10-02 17:18:50'),(1650,'pt_br','Abandoned Calls','Lig. Abandonadas',0,'2012-10-02 17:17:26'),(1651,'pt_br','Actions','Açao',0,'2012-10-02 17:18:49'),(1652,'pt_br','Add','Adicionar',0,'2012-10-01 23:24:54'),(1653,'pt_br','Agent','Agente',0,'2012-10-02 17:19:07'),(1654,'pt_br','Agent Status','Status Agentes',0,'2012-10-02 17:18:50'),(1655,'pt_br','Agents','Total de Agentes',0,'2012-10-02 17:18:50'),(1656,'pt_br','All %s records are selected.','Todos %s registros selecionados',0,'2012-09-21 23:53:08'),(1657,'pt_br','An error has occurred','Ocorreu um Erro',0,'2012-09-21 23:45:37'),(1658,'pt_br','Answer','Atendidas em ate X Segundos',0,'2012-09-26 22:27:13'),(1659,'pt_br','Answered','Total Lig. Atend.',0,'2012-10-02 17:19:07'),(1660,'pt_br','Answered Calls','Atendidas',0,'2012-09-26 22:27:13'),(1661,'pt_br','Answered by Day','Atendidas por Dia',0,'2012-10-02 17:18:40'),(1662,'pt_br','Answered/Abandoned per Hour','Atendido/Abandonado por Hora',0,'2012-10-02 17:18:40'),(1663,'pt_br','April','Abril',0,'2012-10-02 17:19:10'),(1664,'pt_br','Are you sure?','Tem Certeza?',0,'2012-10-02 17:18:52'),(1665,'pt_br','August','Agosto',0,'2012-10-02 17:19:10'),(1666,'pt_br','Available','Disponivel',0,'2012-10-02 17:19:07'),(1667,'pt_br','Average Duration by Day','Duração Media por Dia',0,'2012-10-02 17:18:40'),(1668,'pt_br','Average Wait Time by Day','Espera Media por Dia',0,'2012-10-02 17:18:40'),(1669,'pt_br','Avg Duration','Duração Media',0,'2012-10-02 17:18:50'),(1670,'pt_br','Avg Talk','Tempo Medio',0,'2012-10-02 17:18:40'),(1671,'pt_br','Avg Talk Time','Media Tempo Falando',0,'2012-09-26 22:27:13'),(1672,'pt_br','Avg Wait','Espera Media',0,'2012-10-02 17:18:50'),(1673,'pt_br','Avg Wait Time','Media Tempo Espera',0,'2012-09-26 22:27:13'),(1674,'pt_br','Busy','Ocupados',0,'2012-10-02 17:18:50'),(1675,'pt_br','COMPLETEAGENT','COMPLETADA',0,'2012-10-02 17:17:24'),(1676,'pt_br','COMPLETECALLER','COMPLETADA',0,'2012-10-02 17:17:24'),(1677,'pt_br','Caller ID','Numero',0,'2012-10-02 17:18:50'),(1678,'pt_br','Calls','Ligaçoes Atend.',0,'2012-10-02 17:18:50'),(1679,'pt_br','Calls Waiting Detail','Detalhes Fila',0,'2012-09-25 23:33:57'),(1680,'pt_br','Cancel','Cancelar',0,'2012-10-02 17:18:52'),(1681,'pt_br','Cannot steal call. realtime_spy_extension for user <b>%s</b> is not defined in Setup/Preferences.','Nao é possivel captar a ligaçao.  realtime_spy_extension para usuario <b>%s</b> no foi definido em Setup/Preferencias',0,'2012-09-21 23:45:37'),(1682,'pt_br','Clear Selection','Desselecionar',0,'2012-09-21 23:53:08'),(1683,'pt_br','Click to add text','Clique para acrescentar Texto',0,'2012-10-01 23:24:37'),(1684,'pt_br','Click to edit...','Clique para editar...',0,'2012-09-21 23:45:37'),(1685,'pt_br','Click to view calls in detail','Clica para ver detalhs da ligaçao',0,'2012-10-02 17:18:40'),(1686,'pt_br','Coach','Supervisionar',0,'2012-09-26 01:11:21'),(1687,'pt_br','Completed','Completado',0,'2012-10-01 23:24:45'),(1688,'pt_br','Confirm','Confirmar',0,'2012-09-21 23:45:37'),(1689,'pt_br','Could not connect to the Asterisk Manager Interface to retrieve status information. Please check your manager credentials in config.php and verify they match your settings in /etc/asterisk/manager.conf','Nao foi possivel conectar a interface Manager do asterisk para pegar inforamçao de status. Favor checar seus credencias no config.php e verificar que correspondem as configuraçoes no  /etc/asterisk/manager.conf',0,'2012-09-21 23:45:37'),(1690,'pt_br','Could not copy uploaded file','Nao foi possivel importar arquivo',0,'2012-09-21 23:45:37'),(1691,'pt_br','Count','Contagem',0,'2012-10-02 17:17:26'),(1692,'pt_br','Cron Configuration','Configuraçao Cron',0,'2012-10-02 17:18:52'),(1693,'pt_br','Date','Data',0,'2012-10-02 17:18:49'),(1694,'pt_br','Day','Dia',0,'2012-10-02 17:18:40'),(1695,'pt_br','December','Dezembro',0,'2012-10-02 17:19:10'),(1696,'pt_br','Delete','Deletar',0,'2012-10-02 17:18:52'),(1697,'pt_br','Delete Marked','Deletar selecionados',0,'2012-10-02 17:18:52'),(1698,'pt_br','Delta','Delta',0,'2012-10-02 17:17:26'),(1699,'pt_br','Deselects all','Desselecionar todos',0,'2012-10-02 17:19:07'),(1700,'pt_br','Deselects marked','Desselecionar marcados',0,'2012-10-02 17:19:07'),(1701,'pt_br','Display Report','Mostrar Relatorio',0,'2012-10-02 17:19:07'),(1702,'pt_br','Distribution','Distribuiçao',0,'2012-10-02 17:19:07'),(1703,'pt_br','Download','Download',0,'2012-10-02 17:16:33'),(1704,'pt_br','Duration','Duração ',0,'2012-10-02 17:18:50'),(1705,'pt_br','Edit Email Alert','Editar Alerta de EMail',0,'2012-10-02 17:18:52'),(1706,'pt_br','Edit Record','Editar Registro',0,'2012-10-02 17:18:52'),(1707,'pt_br','Edit Scheduled Report','Editar Relatorio Automatico',0,'2012-10-02 17:18:52'),(1708,'pt_br','Email','Email',0,'2012-10-02 17:18:52'),(1709,'pt_br','End Date','Data Final',0,'2012-10-02 17:19:07'),(1710,'pt_br','End Position','Posição ao Abandonar Fila',0,'2012-10-02 17:17:26'),(1711,'pt_br','Error inserting record:<br/>','Erro Inserindo Registro:<br/>',0,'2012-09-21 23:45:37'),(1712,'pt_br','Error updating record','Erro Atualizando Registro',0,'2012-09-21 23:45:37'),(1713,'pt_br','Event','Evento',0,'2012-10-02 17:18:49'),(1714,'pt_br','Example','Exemplo',0,'2012-10-02 17:18:52'),(1715,'pt_br','Export','Exportar',0,'2012-10-01 23:24:37'),(1716,'pt_br','Exports the data to a .pdf file','Exportar para pdf',0,'2012-10-02 17:17:26'),(1717,'pt_br','February','Fevereiro',0,'2012-10-02 17:19:10'),(1718,'pt_br','Filter','Filtro',0,'2012-10-02 17:19:07'),(1719,'pt_br','Filter report by Caller Id','Filtrar por Bina',0,'2012-10-02 17:18:40'),(1720,'pt_br','First','Primeiro',0,'2012-10-02 17:18:52'),(1721,'pt_br','Friday','Sexta',0,'2012-10-02 17:19:10'),(1722,'pt_br','From','De',0,'2012-10-02 17:19:07'),(1723,'pt_br','From the last (X) days','Dos ultimo (X) dias',0,'2012-10-02 17:18:52'),(1724,'pt_br','Goes to the top of the page','Votar ao topo da Pagina',0,'2012-10-02 17:18:50'),(1725,'pt_br','Group by Queue','Agrupar Filas',0,'2012-10-02 17:18:50'),(1726,'pt_br','Help','Ajuda',0,'2012-10-02 17:17:26'),(1727,'pt_br','Hide Logged off','Esconder Nao Logados',0,'2012-10-02 17:18:50'),(1728,'pt_br','Higher ...','Maior ...',0,'2012-10-02 17:19:07'),(1729,'pt_br','Home','Home',0,'2012-10-02 17:19:07'),(1730,'pt_br','Hour','Hora',0,'2012-10-02 17:18:40'),(1731,'pt_br','Hour Range','Horario',0,'2012-10-02 17:18:40'),(1732,'pt_br','Hours','Horas',0,'2012-10-02 17:18:52'),(1733,'pt_br','ISO Code','Codigo ISO',0,'2012-10-01 23:24:45'),(1734,'pt_br','Import','Importar',0,'2012-10-01 23:24:37'),(1735,'pt_br','Incompleted Calls','Ligaçoes Nao completadas',0,'2012-10-02 17:17:26'),(1736,'pt_br','Invalid Date','Data Invalida',0,'2012-09-21 23:45:37'),(1737,'pt_br','Invalid Hour','Hora Invalida',0,'2012-09-21 23:45:37'),(1738,'pt_br','January','Janeiro',0,'2012-10-02 17:19:10'),(1739,'pt_br','July','Julho',0,'2012-10-02 17:19:10'),(1740,'pt_br','June','Junho',0,'2012-10-02 17:19:10'),(1741,'fr','You do not have enough privileges to access this resource','You do not have enough privileges to access this resource',1,'0000-00-00 00:00:00'),(1742,'pt_br','Last','Ultimo',0,'2012-10-02 17:18:52'),(1743,'pt_br','Last in Call','Ultima Lig. At.',0,'2012-10-02 17:18:50'),(1744,'pt_br','Last three months','Ultimos 3 meses',0,'2012-10-02 17:19:07'),(1745,'pt_br','Licensed to','Licenciado:',0,'2012-10-02 17:19:07'),(1746,'fr','Records imported','Records imported',1,'0000-00-00 00:00:00'),(1747,'pt_br','Loading','Carregando',0,'2012-10-02 17:19:07'),(1748,'fr','No valid fields to import!','No valid fields to import!',1,'0000-00-00 00:00:00'),(1749,'pt_br','Logged Off','Não Logados',0,'2012-10-02 17:18:50'),(1750,'pt_br','Login','Login',0,'2012-09-26 22:26:20'),(1751,'pt_br','Login Form','Login',0,'2012-09-26 22:26:20'),(1752,'pt_br','Logoff','Logoffs',0,'2012-10-02 17:18:40'),(1753,'pt_br','Max. wait time','Temp Max. Espera',0,'2012-10-02 17:18:50'),(1754,'pt_br','Month days','Dias Mes',0,'2012-10-02 17:18:52'),(1755,'pt_br','Number of Answered Calls','Atendidas',0,'2012-10-02 17:18:40'),(1756,'pt_br','Number of Unanswered Calls','Ligaçeos Nao Atendidas',0,'2012-10-02 17:18:40'),(1757,'pt_br','Paused','Pausados',0,'2012-10-02 17:18:50'),(1758,'pt_br','Position','Posiçao',0,'2012-09-25 23:33:57'),(1759,'pt_br','Queue','Fila',0,'2012-10-02 17:18:50'),(1760,'pt_br','Realtime','Tempo Real',0,'2012-10-02 17:19:07'),(1761,'pt_br','Received','Recebidas',0,'2012-10-02 17:18:40'),(1762,'pt_br','Search','Busca',0,'2012-10-02 17:19:07'),(1763,'pt_br','Select Agents','Selecione Agentes',0,'2012-10-02 17:19:07'),(1764,'pt_br','Select Date Range','Selecione Data',0,'2012-10-02 17:19:07'),(1765,'pt_br','Select Queues','Selecione Fila',0,'2012-10-02 17:19:07'),(1766,'pt_br','Select Time Frame','Selecione Horario',0,'2012-10-02 17:19:07'),(1767,'pt_br','Select all %s records.','Selecionar todos %s registros',0,'2012-09-21 23:53:04'),(1768,'pt_br','Select an option','Selecione uma opçao',0,'2012-10-01 23:24:45'),(1769,'pt_br','Select language','Selecione Idioma',0,'2012-10-01 23:24:45'),(1770,'pt_br','Selected','Selecionado',0,'2012-10-02 17:19:07'),(1771,'pt_br','September','Setembro',0,'2012-10-02 17:19:10'),(1772,'pt_br','Server Time','HORA =',0,'2012-10-02 17:18:50'),(1773,'pt_br','Setup','Configuraçoes',0,'2012-10-02 17:19:07'),(1774,'pt_br','Start Date','Data Inicial',0,'2012-10-02 17:19:07'),(1775,'pt_br','State','Status',0,'2012-10-02 17:18:50'),(1776,'pt_br','Talk Time','Tempo conversando',0,'2012-10-02 17:18:49'),(1777,'pt_br','This month','Este Mes',0,'2012-10-02 17:19:07'),(1778,'pt_br','This week','Esta Semana',0,'2012-10-02 17:19:07'),(1779,'pt_br','Today','Hoje',0,'2012-10-02 17:19:07'),(1780,'pt_br','Toggle Search Form','Expandir Busca',0,'2012-10-02 17:18:49'),(1781,'pt_br','Total Answered Calls','Total Atendidas',0,'2012-09-26 22:27:13'),(1782,'pt_br','Total Calls','Total Ligações',0,'2012-10-02 17:18:40'),(1783,'pt_br','Total Duration','Duração Total das Ligações:',0,'2012-09-26 22:27:13'),(1784,'pt_br','Total Time per Agent (seconds)','Tempo Total por Agenete',0,'2012-09-26 22:27:13'),(1785,'pt_br','Total Unanswered Calls','Total ligações não atendidas\n',0,'2012-10-02 17:17:26'),(1786,'fr','Ignoring field ','Ignoring field ',1,'0000-00-00 00:00:00'),(1787,'pt_br','Transferred','Transferidas',0,'2012-10-02 17:18:40'),(1788,'pt_br','Translation','Traduçao',0,'2012-10-01 23:24:45'),(1789,'pt_br','Unanswered','Total Não Atendidas',0,'2012-10-02 17:19:07'),(1790,'pt_br','Unanswered Calls','N_Atendidas',0,'2012-10-02 17:17:26'),(1791,'pt_br','Unanswered Rate','Percentual Nao Atendidas\n',0,'2012-10-02 17:18:40'),(1792,'pt_br','Unanswered by Day','Não Atendidas por Dia',0,'2012-10-02 17:18:40'),(1793,'pt_br','Wait Time','Tempo espernado ate Abandonar',0,'2012-10-02 17:18:49'),(1794,'pt_br','Waiting','Na Fila',0,'2012-10-02 17:18:50'),(1795,'pt_br','admin-acl','Controle de Acesso',0,'2012-10-02 17:19:07'),(1796,'pt_br','admin-designer','Configurar Relatorios',0,'2012-10-02 17:19:07'),(1797,'pt_br','admin-language','Traduçao',0,'2012-10-02 17:19:07'),(1798,'pt_br','admin-setup','Preferencias',0,'2012-10-02 17:19:07'),(1799,'pt_br','admin-users','Usuarios',0,'2012-10-02 17:19:07'),(1800,'pt_br','answered_calls_by_agent','Atendidas por Agente',0,'2012-10-02 17:19:07'),(1801,'pt_br','answered_calls_by_duration','Atendidas por Duração',0,'2012-10-02 17:19:07'),(1802,'pt_br','answered_calls_by_event','Causa Desconexão',0,'2012-10-02 17:19:07'),(1803,'pt_br','answered_calls_by_holdtime','Nivel de Serviço',0,'2012-10-02 17:19:07'),(1804,'pt_br','answered_calls_by_queue','Atendidas por Fila',0,'2012-10-02 17:19:07'),(1805,'pt_br','answered_calls_by_url','Atendidas por URL',0,'2012-10-02 17:19:07'),(1806,'pt_br','answered_calls_detail','Detalhes das Ligaçoes Atendidas',0,'2012-10-02 17:19:07'),(1807,'pt_br','answered_calls_summary','Atendidas - Resumo',0,'2012-10-02 17:19:07'),(1808,'pt_br','answered_calls_transferred','Transferencias',0,'2012-10-02 17:19:07'),(1809,'pt_br','calls','ligaçoes',0,'2012-10-02 17:18:40'),(1810,'pt_br','distribution_by_day','Ligações por Dia',0,'2012-10-02 17:19:07'),(1811,'pt_br','distribution_by_day_of_week','Ligações por dia da Semana',0,'2012-10-02 17:19:07'),(1812,'pt_br','distribution_by_hour','Ligações por Hora',0,'2012-10-02 17:19:07'),(1813,'pt_br','distribution_by_month','Ligações por Mes',0,'2012-10-02 17:19:07'),(1814,'pt_br','distribution_by_queue','Ligações por Fila',0,'2012-10-02 17:19:07'),(1815,'pt_br','distribution_by_url','Ligações por URL',0,'2012-10-02 17:19:07'),(1816,'pt_br','distribution_by_week','Ligações por Semana',0,'2012-10-02 17:19:07'),(1817,'pt_br','distribution_detail','Detalhes Ligaçoes',0,'2012-10-02 17:19:07'),(1818,'pt_br','distribution_summary','Resumo',0,'2012-10-02 17:19:07'),(1819,'pt_br','hours','horas',0,'2012-10-02 17:19:07'),(1820,'pt_br','none','Nenhum',0,'2012-09-21 23:45:37'),(1821,'pt_br','of','de',0,'2012-10-02 17:18:52'),(1822,'pt_br','on %s since %s seconds ago','em %s desde %s segundos',0,'2012-09-21 23:45:37'),(1823,'pt_br','on %s since %s secs ago','ativo %s á %s secs',0,'2012-09-21 23:45:37'),(1824,'pt_br','on days','dias ativos',0,'2012-10-02 17:18:52'),(1825,'pt_br','on hours','horas ativas',0,'2012-10-02 17:18:52'),(1826,'pt_br','on minutes','minutos ativos',0,'2012-10-02 17:18:52'),(1827,'pt_br','partial','parcial',0,'2012-09-21 23:45:37'),(1828,'pt_br','realtime-agent-busy','Ocupado',0,'2012-09-25 23:17:47'),(1829,'pt_br','realtime-agent-dialout','Lig. Ativa',0,'2012-09-21 23:45:37'),(1830,'pt_br','realtime-agent-hold','Em Espera',0,'2012-09-21 23:45:37'),(1831,'pt_br','realtime-agent-not in use','Logado',0,'2012-10-02 17:18:50'),(1832,'pt_br','realtime-agent-ringing','Tocando',0,'2012-09-25 23:33:52'),(1833,'pt_br','realtime-agent-unavailable','Não Logado',0,'2012-09-25 23:18:44'),(1834,'pt_br','realtime_queue_summary','Resumo Fila',0,'2012-10-02 17:18:50'),(1835,'pt_br','seconds','segundos',0,'2012-09-21 23:45:37'),(1836,'pt_br','unanswered_calls_by_event','Ligaçoes Nao atendidas - Por Evento',0,'2012-10-02 17:19:07'),(1837,'pt_br','unanswered_calls_by_holdtime','Nivel de Servico',0,'2012-10-02 17:19:07'),(1838,'pt_br','unanswered_calls_by_queue','Ligações Não atendidas - Por fila',0,'2012-10-02 17:19:07'),(1839,'pt_br','unanswered_calls_by_url','Nao atendidas - Por URL',0,'2012-10-02 17:19:07'),(1840,'pt_br','unanswered_calls_detail','Ligações Não atendidas - Detalhes',0,'2012-10-02 17:19:07'),(1841,'pt_br','unanswered_calls_summary','Resumo Ligações Não Atendidas',0,'2012-10-02 17:19:07'),(1842,'pt_br','within','dentro de ',0,'2012-09-21 23:45:37'),(1843,'pt_br','within %d%s seconds','%d%s segundos',0,'2012-10-02 17:17:26'),(1844,'pt_br','Sunday','Domingo',0,'2012-10-02 17:19:10'),(1845,'pt_br','Monday','Segunda Feira',0,'2012-10-02 17:19:10'),(1846,'pt_br','Tuesday','3a Feira',0,'2012-10-02 17:19:10'),(1847,'pt_br','Wednesday','4a Feira',0,'2012-10-02 17:19:10'),(1848,'pt_br','Thursday','5a Feira',0,'2012-10-02 17:19:10'),(1849,'pt_br','Saturday','Sábado',0,'2012-10-02 17:19:10'),(1850,'pt_br','March','Março',0,'2012-10-02 17:19:10'),(1851,'pt_br','May','Maio',0,'2012-10-02 17:19:10'),(1852,'pt_br','October','Outubro',0,'2012-10-02 17:19:10'),(1853,'pt_br','November','Novembro',0,'2012-10-02 17:19:10'),(1854,'pt_br','admin-schedule','Configurar Alertas',0,'2012-10-02 17:19:07'),(1855,'pt_br','Logout','Logout',1,'2012-10-02 17:19:07'),(1856,'pt_br','help_text_agent_filter','Regular Expression to filter unwanted Agents from initial selection.<br/> Example: <strong>Agent/[0-9][0-9][0-9][0-9]$</strong>\r\n\r\n\r\n\r\n',1,'2012-10-01 23:24:54'),(1857,'pt_br','help_text_agent_row_color','To paint the whole cell background to the status color for an agent in the realtime view, set this to 1',1,'2012-10-01 23:24:54'),(1858,'pt_br','help_text_asterisk_12','Set this to 1 if you are using Asterisk 1.2 or older, otherwise you will have some issues in the realtime view.',1,'2012-10-01 23:24:54'),(1859,'pt_br','help_text_avg_time_format','Format for average duration fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in drill down and detailed reports.',1,'2012-10-01 23:24:54'),(1860,'pt_br','help_text_call_time_format','Format for the call duration fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in drill down and detailed reports.',1,'2012-10-01 23:24:54'),(1861,'pt_br','help_text_csv_separator','Separator character to use in CSV export files. Default value is comma (,) for Excel and friends. If you use LibreOffice/OpenOffice you might need to change it to semicolon (;)',1,'2012-10-01 23:24:54'),(1862,'pt_br','help_text_date_format','Format for the date field, using MySQL syntax. Example: %%m-%%d-%%Y %%H:%%i:%%s. This is used on drill down or detailed reports only. The report format themselves are set in the designer.',1,'2012-10-01 23:24:54'),(1863,'pt_br','help_text_decimal_places','Number of decimal places to show on float numbers.',1,'2012-10-01 23:24:54'),(1864,'pt_br','help_text_default_end_hour','Default end hour in HH:SS format for the date/time selection.',1,'2012-10-01 23:24:54'),(1865,'pt_br','help_text_default_start_hour','Default start hour in HH:SS format for the date/time selection.',1,'2012-10-01 23:24:54'),(1866,'pt_br','help_text_detailed_agent_report','Show a detailed agent report in the Agent tab. (Similar to the drill down information you can get on a regular report, but already expanded for the complete date range selection).',1,'2012-10-01 23:24:54'),(1867,'pt_br','help_text_dict_agent','Dictionary entry for Agents. It will replace the agent set as the parameter to the value you specify (So you can use names instead of interfaces).',1,'2012-10-01 23:24:54'),(1868,'pt_br','help_text_dict_queue','Dictionary entry for Queues. Same as the agent dictionary, but for replacing queue names.',1,'2012-10-01 23:24:54'),(1869,'fr','Use comma to separate emails','Use comma to separate emails',1,'0000-00-00 00:00:00'),(1870,'fr','User','User',1,'0000-00-00 00:00:00'),(1871,'fr','View Record','View Record',1,'2012-10-01 23:17:20'),(1872,'fr','Wait Time','Wait Time',1,'2012-10-01 23:17:33'),(1873,'fr','Waiting','Waiting',1,'0000-00-00 00:00:00'),(1874,'fr','Wednesday','Wednesday',1,'2012-10-01 23:17:42'),(1875,'fr','Week','Week',1,'2012-10-01 23:17:33'),(1876,'fr','Week days','Week days',1,'0000-00-00 00:00:00'),(1877,'fr','Write down the value to compare','Write down the value to compare',1,'0000-00-00 00:00:00'),(1878,'fr','Yes','Yes',1,'2012-10-01 23:17:20'),(1879,'fr','You must select at least one agent','You must select at least one agent',1,'0000-00-00 00:00:00'),(1880,'fr','You must select at least one queue','You must select at least one queue',1,'0000-00-00 00:00:00'),(1881,'fr','admin-acl','Access Control',1,'2012-10-01 23:17:33'),(1882,'fr','admin-designer','Report Designer',1,'2012-10-01 23:17:33'),(1883,'fr','admin-language','Translations',1,'2012-10-01 23:17:33'),(1884,'fr','admin-schedule','Schedules/Alerts',1,'2012-10-01 23:17:33'),(1885,'fr','admin-setup','Preferences',1,'2012-10-01 23:17:33'),(1886,'fr','admin-users','Users',1,'2012-10-01 23:17:33'),(1887,'es','License Handling','Manejo de Licencia',0,'0000-00-00 00:00:00'),(1888,'fr','agent_availability','Agent Availability',1,'2012-10-01 23:17:33'),(1889,'fr','agent_detail','Full Agent Report',1,'2012-10-01 23:17:33'),(1890,'fr','agent_dispositions','Call Disposition by Agent',1,'2012-10-01 23:17:33'),(1891,'fr','agent_durations','Agent Session and Pause Durations',1,'2012-10-01 23:17:33'),(1892,'fr','agent_pauses','Pause Detail',1,'2012-10-01 23:17:33'),(1893,'fr','agent_summary','Agent Summary',1,'2012-10-01 23:17:33'),(1894,'fr','all month','all month',1,'0000-00-00 00:00:00'),(1895,'fr','answered_calls_by_agent','Answered by Agent',1,'2012-10-01 23:17:33'),(1896,'fr','answered_calls_by_duration','Answered by Call Length',1,'2012-10-01 23:17:33'),(1897,'fr','answered_calls_by_event','Disconnection Cause',1,'2012-10-01 23:17:33'),(1898,'fr','answered_calls_by_holdtime','Service Level',1,'2012-10-01 23:17:33'),(1899,'fr','answered_calls_by_queue','Answered by Queue',1,'2012-10-01 23:17:33'),(1900,'fr','answered_calls_by_url','Answered by URL',1,'2012-10-01 23:17:33'),(1901,'fr','answered_calls_detail','Answered Calls Detail',1,'2012-10-01 23:17:33'),(1902,'fr','answered_calls_summary','Answered Calls Summary',1,'2012-10-01 23:17:33'),(1903,'fr','answered_calls_transferred','Transfers',1,'2012-10-01 23:17:33'),(1904,'fr','at hour','at hour',1,'0000-00-00 00:00:00'),(1905,'fr','at minute','at minute',1,'0000-00-00 00:00:00'),(1906,'fr','calls','calls',1,'2012-10-01 23:17:33'),(1907,'fr','day','day',1,'0000-00-00 00:00:00'),(1908,'fr','disposition_help_ABANDON','The caller abandoned their position in the queue. The position is the\r\ncaller&rsquo;s position in the queue when they hungup, the origposition is\r\nthe original position the caller was when they first entered the\r\nqueue, and the waittime is how long the call had been waiting in the\r\nqueue at the time of disconnect.',1,'2012-10-01 23:17:33'),(1909,'fr','disposition_help_COMPLETEAGENT','The caller was connected to an agent, and the call was terminated normally\r\nby the *agent*. The caller&lsquo;s hold time and the length of the call are both\r\nrecorded. The caller&lsquo;s original position in the queue is recorded in\r\norigposition.',1,'2012-10-01 23:17:33'),(1910,'fr','disposition_help_COMPLETECALLER','The caller was connected to an agent, and the call was terminated normally\r\nby the *caller*. The callers hold time and the length of the call are both\r\nrecorded. The caller&rsquo;s original position in the queue is recorded in\r\norigposition.\r\n',1,'2012-10-01 23:17:33'),(1911,'fr','disposition_help_CONNECT','The caller was connected to an agent.',1,'2012-10-01 23:17:33'),(1912,'fr','disposition_help_ENTERQUEUE','A caller entered the queue. Three parameters are also written: the URL (if specified) in the Info 1 field and the caller ID of the caller on the Info 2 field, and the original position where the call has landed in the Info 3 field.',1,'2012-10-01 23:17:33'),(1913,'fr','disposition_help_EXITWITEMPTY','The caller was exited from the queue forcefully because the queue had no\r\nreachable members and it&lsquo;s configured to do that to callers when there\r\nare no reachable members. The position is the caller&lsquo;s position in the\r\nqueue when they hungup, the origposition is the original position the\r\ncaller was when they first entered the queue, and the waittime is how\r\nlong the call had been waiting in the queue at the time of disconnect.',1,'2012-10-01 23:17:33'),(1914,'fr','disposition_help_EXITWITHKEY','The caller elected to use a menu key to exit the queue. The key and\r\nthe caller&lsquo;s position in the queue are recorded.\r\n',1,'2012-10-01 23:17:33'),(1915,'fr','disposition_help_EXITWITHTIMEOUT','The caller was on hold too long and the timeout expired.',1,'2012-10-01 23:17:33'),(1916,'fr','disposition_help_RINGNOANSWER','The timeout value for ringing the queue member was exceeded. A single parameter will also be written indicating the amount of time the member’s extension rang in the Info 1 field.',1,'2012-10-01 23:17:33'),(1917,'fr','disposition_help_TRANSFER','Caller was transferred to a different extension. Context and extension\r\nare recorded. The caller&lsquo;s hold time and the length of the call are both\r\nrecorded. PLEASE remember that transfers performed by SIP UA&lsquo;s by way\r\nof a reinvite may not always be caught by Asterisk and trigger off this\r\nevent. The only way to be 100% sure that you will get this event when\r\na transfer is performed by a queue member is to use the built-in transfer\r\nfunctionality of Asterisk.',1,'2012-10-01 23:17:33'),(1918,'fr','distribution_by_day','Distribution per Day',1,'2012-10-01 23:17:33'),(1919,'fr','distribution_by_day_of_week','Distribution per Day of Week',1,'2012-10-01 23:17:33'),(1920,'fr','distribution_by_hour','Distribution per Hour',1,'2012-10-01 23:17:33'),(1921,'fr','distribution_by_month','Distribution per Month',1,'2012-10-01 23:17:33'),(1922,'fr','distribution_by_queue','Distribution by Queue',1,'2012-10-01 23:17:33'),(1923,'fr','distribution_by_url','Distribution by URL',1,'2012-10-01 23:17:33'),(1924,'fr','distribution_by_week','Distribution per Week',1,'2012-10-01 23:17:33'),(1925,'fr','distribution_detail','Detailed Distribution Report',1,'2012-10-01 23:17:33'),(1926,'fr','distribution_summary','Distribution Summary',1,'2012-10-01 23:17:33'),(1927,'fr','event_help_abandon_info1','The position is the caller&#39;s position in the queue when they hungup.',1,'0000-00-00 00:00:00'),(1928,'fr','event_help_abandon_info2','The original position the caller was positioned when they first entered the queue.',1,'0000-00-00 00:00:00'),(1929,'fr','event_help_abandon_info3','The waittime is how long the call had been waiting in the queue at the time of disconnect.',1,'0000-00-00 00:00:00'),(1930,'fr','event_help_agentcallbacklogin_info1','The callback agent logged in. The login extension and context is recorded.',1,'0000-00-00 00:00:00'),(1931,'fr','event_help_agentcallbacklogoff_info1','The callback agent logged off.',1,'0000-00-00 00:00:00'),(1932,'fr','event_help_agentcallbacklogoff_info2','The last login extension and context is recorded, along with the total time the agent was logged in.',1,'0000-00-00 00:00:00'),(1933,'fr','event_help_agentcallbacklogoff_info3','The reason for the logoff if it was not a normal logoff (e.g., Autologoff, Chanunavail)',1,'0000-00-00 00:00:00'),(1934,'fr','event_help_agentlogin_info1','The agent logged in. The channel is recorded.',1,'0000-00-00 00:00:00'),(1935,'fr','event_help_agentlogoff_info1','The agent logged off.',1,'0000-00-00 00:00:00'),(1936,'fr','event_help_agentlogoff_info2','The total time the agent was logged in.',1,'0000-00-00 00:00:00'),(1937,'fr','event_help_completeagent_info1','The caller&#39;s hold time.',1,'0000-00-00 00:00:00'),(1938,'fr','event_help_completeagent_info2','The length of the call.',1,'0000-00-00 00:00:00'),(1939,'fr','event_help_completeagent_info3','The caller&#39;s original position in the queue is recorded in origposition.',1,'0000-00-00 00:00:00'),(1940,'fr','event_help_completecaller_info1','The caller&#39;s hold time',1,'0000-00-00 00:00:00'),(1941,'fr','event_help_completecaller_info2','The length of the call.',1,'0000-00-00 00:00:00'),(1942,'fr','event_help_completecaller_info3','The caller&#39;s original position in the queue is recorded in origposition.',1,'0000-00-00 00:00:00'),(1943,'fr','event_help_connect_info1','Hold time represents the amount of time the caller was on hold.',1,'0000-00-00 00:00:00'),(1944,'fr','event_help_connect_info2','The bridged channel unique ID contains the unique ID of the queue member channel that is taking the call.',1,'0000-00-00 00:00:00'),(1945,'fr','event_help_connect_info3','Ringtime represents the time the queue members phone was ringing prior to being answered.',1,'0000-00-00 00:00:00'),(1946,'fr','event_help_enterqueue_info1','URL parameter',1,'0000-00-00 00:00:00'),(1947,'fr','event_help_enterqueue_info2','Caller ID',1,'0000-00-00 00:00:00'),(1948,'fr','event_help_enterqueue_info3','The original position the caller was positioned when they first entered the queue.',1,'0000-00-00 00:00:00'),(1949,'fr','event_help_exitempty_info1','The position is the caller&#39;s position in the queue when they hungup.',1,'0000-00-00 00:00:00'),(1950,'fr','event_help_exitempty_info2','The origposition is the original position the caller was when they first entered the queue.',1,'0000-00-00 00:00:00'),(1951,'fr','event_help_exitempty_info3','The waittime is how long the call had been waiting in the queue at the time of disconnect.',1,'0000-00-00 00:00:00'),(1952,'fr','event_help_exitwithkey_info1','The caller elected to use a menu key to exit the queue.',1,'0000-00-00 00:00:00'),(1953,'fr','event_help_exitwithkey_info2','The caller&#39;s position.',1,'0000-00-00 00:00:00'),(1954,'fr','event_help_exitwithtimeout_info1','The position the caller was when exiting the queue.',1,'0000-00-00 00:00:00'),(1955,'fr','event_help_exitwithtimeout_info2','Original position at which the called entered the queue.',1,'0000-00-00 00:00:00'),(1956,'fr','event_help_exitwithtimeout_info3','Amount of time the caller waited in the queue.',1,'0000-00-00 00:00:00'),(1957,'fr','event_help_pause_info1','Pause reason if any',1,'0000-00-00 00:00:00'),(1958,'fr','event_help_ringnoanswer_info1','Time in milliseconds the agent phone rang until the timeout was reached. The attempt ended without the member picking up the call. Bad queue member!',1,'0000-00-00 00:00:00'),(1959,'fr','event_help_transfer_info1','The extension',1,'0000-00-00 00:00:00'),(1960,'fr','event_help_transfer_info2','The context',1,'0000-00-00 00:00:00'),(1961,'fr','event_help_transfer_info3','The caller&#39;s hold time',1,'0000-00-00 00:00:00'),(1962,'fr','event_help_transfer_info4','The length of the call.',1,'0000-00-00 00:00:00'),(1963,'fr','event_help_transfer_info5','The caller&#39;s entry position at the time of the transfer.',1,'0000-00-00 00:00:00'),(1964,'fr','event_help_unpause_info1','Unpause reason if any',1,'0000-00-00 00:00:00'),(1965,'fr','every day','every day',1,'0000-00-00 00:00:00'),(1966,'fr','every hour','every hour',1,'0000-00-00 00:00:00'),(1967,'fr','every minute','every minute',1,'0000-00-00 00:00:00'),(1968,'fr','help_text_ACTION','Define a custom action handler, so you can call your own functions/program to handle special cases. You must create the javascript function in the js/custom.js file. It will receive the uniqueid of the call when the action icon is clicked.<br/>\r\n<br/>\r\nparameter: position,icon image,Tooltip<br/>\r\nvalue: javascript_function',1,'0000-00-00 00:00:00'),(1969,'fr','help_text_ANSWERED_DISPLAY_GRID','If a chart is defined in the answered reports tab, parameter field, then use the grid layout width as setup in the value field. The grid system has 12 columns in total:<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: width1,width2',1,'0000-00-00 00:00:00'),(1970,'fr','help_text_ANSWERED_DISPLAY_ROWS','Comma separated list of fields to show on a specific Answered reports. The fields are the one defined as COLUMN_ANSWERED.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields ',1,'0000-00-00 00:00:00'),(1971,'fr','help_text_CHART_ANSWERED','Shows a chart into the Answered reports page.<br/><br/>\n\nparameter: position,group field,title<br/>\nvalue: field,field',1,'0000-00-00 00:00:00'),(1972,'fr','help_text_CHART_DISTRIBUTION','Shows a chart into the Distribution reports page.<br/><br/>\r\n\r\nparameter: position,group field,title<br/>\r\nvalue: field,field',1,'0000-00-00 00:00:00'),(1973,'fr','help_text_CHART_SERIES_COLOR','Colors to use for charts. Parameter is the index position, and value the hex html color.',1,'0000-00-00 00:00:00'),(1974,'fr','help_text_CHART_UNANSWERED','Shows a chart into the Unanswered reports page.<br/><br/>\r\n\r\nparameter: position,group field,title<br/>\r\nvalue: field,field',1,'0000-00-00 00:00:00'),(1975,'fr','help_text_COLUMN_ANSWERED','Column to show in Answered reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in ANSWERED_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n\r\n\r\n',1,'0000-00-00 00:00:00'),(1976,'fr','help_text_COLUMN_ANSWERED_FORMAT','Format to use for displaying a cell value in the answered reports. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_ANSWERED entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',1,'0000-00-00 00:00:00'),(1977,'fr','help_text_COLUMN_DISTRIBUTION','Column to show in Distribution reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in DISTRIBUTION_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n',1,'0000-00-00 00:00:00'),(1978,'fr','help_text_COLUMN_DISTRIBUTION_FORMAT','Format to use for displaying a cell value in the distribution reports. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_DISTRIBUTION entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',1,'0000-00-00 00:00:00'),(1979,'fr','help_text_COLUMN_REALTIME','Column to show in the Realtime summary. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in REALTIME_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n',1,'0000-00-00 00:00:00'),(1980,'fr','help_text_COLUMN_REALTIME_FORMAT','Format to use for displaying a cell value in the realtime queue summary report. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_REALTIME entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',1,'0000-00-00 00:00:00'),(1981,'fr','help_text_COLUMN_REALTIME_STYLE','Extra html property to add to cell values in the realtime queue summary table. You can use class or style to modify display on those cells. Example:<br/>\r\n<br/>\r\nclass=&quot;bigblue&quot;\r\n<br/>\r\nstyle=&quot;border:1px solid red;&quot;\r\n\r\n',1,'0000-00-00 00:00:00'),(1982,'fr','help_text_COLUMN_UNANSWERED','Column to show in Unanswered reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in UNANSWERED_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n',1,'0000-00-00 00:00:00'),(1983,'fr','help_text_COLUMN_UNANSWERED_FORMAT','Format to use for displaying a cell value in the unanswered reports. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_UNANSWERED entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',1,'0000-00-00 00:00:00'),(1984,'fr','help_text_DISTRIBUTION_DISPLAY_ROWS','Comma separated list of fields to show on a specific Distribution reports. The fields are the one defined as COLUMN_DISTRIBUTION.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields',1,'0000-00-00 00:00:00'),(1985,'fr','help_text_EVENT_ABANDONED','Define the queue_log events that will count towards the ABANDONED counters/variables in reports, using a comma separated list. In a standard Asterisk setup, this must be set to \\\"ABANDON\\\" and nothing else.',1,'0000-00-00 00:00:00'),(1986,'fr','help_text_EVENT_ANSWERED','Define the queue_log events that will count towards the ANSWERED counters/variables in reports, using a comma separated list. Normal answered dispositions in the queue_log are COMPLETECALLER, COMPLETEAGENT, you could also want to count the TRANSFER disposition towards the ANSWERED column, but as transfers have their own variable, you can also leave them separated.',1,'0000-00-00 00:00:00'),(1987,'fr','help_text_EVENT_LOGIN','Define the queue_log events that will count towards the LOGIN counters/variables in reports, using a comma separated list. Usually you have AGENTLOGIN and ADDMEMBER as events for login events in the queue_log file. Old asterisk versions could also use AGENTCALLBACKLOGIN.',1,'0000-00-00 00:00:00'),(1988,'fr','help_text_EVENT_LOGOUT','Define the queue_log events that will count towards the LOGOUT counters/variables in reports, using a comma separated list. Usually you have AGENTLOGOFF and REMOVEMEMBER as events for login events in the queue_log file.',1,'0000-00-00 00:00:00'),(1989,'fr','help_text_EVENT_RECEIVED','Define the queue_log events that will count towards the RECEIVED counters/variables in reports, using a comma separated list. All dispositions on the queue_log file that should add to a received call should be listed here, for example:<br/><br/>\r\nCOMPLETECALLER,COMPLETEAGENT,ABANDON,EXITEMPTY,EXITWITHKEY,EXITWITHTIMEOUT,TRANSFER',1,'0000-00-00 00:00:00'),(1990,'fr','help_text_EVENT_TRANSFERRED','Define the queue_log events that will count towards the TRANSFERRED counters/variables in reports, using a comma separated list. In a regular Asterisk setup, the only event associated with transfers is TRANSFER.',1,'0000-00-00 00:00:00'),(1991,'fr','help_text_EVENT_UNANSWERED','Define the queue_log events that will count towards the UNANSWERED counters/variables in reports, using a comma separated list. As an abandon call has its own variable, you should list here the rest of the unanswered dispositions, for example:<br/><br/>\r\nEXITWITHKEY,EXITEMPTY,EXITWITHTIMEOUT',1,'0000-00-00 00:00:00'),(1992,'fr','help_text_REALTIME_COLUMN_WIDTHS','help_text_REALTIME_COLUNN_WIDTHS',1,'0000-00-00 00:00:00'),(1993,'fr','help_text_REALTIME_DISPLAY_ROWS','Comma separated list of fields to show on the Realtime Queue Summary table. The fields are the one defined as COLUMN_REALTIME.<br/>\r\n<br/>\r\nparameter: group field (queue_summary)<br/>\r\nvalue: comma separated list of fields',1,'0000-00-00 00:00:00'),(1994,'fr','help_text_TOTAL_COLUMN_ANSWERED','Formula to use for the Total row on Answered reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',1,'0000-00-00 00:00:00'),(1995,'fr','help_text_TOTAL_COLUMN_DISTRIBUTION','Formula to use for the Total row on Distribution reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',1,'0000-00-00 00:00:00'),(1996,'fr','help_text_TOTAL_COLUMN_REALTIME','Formula to use for the Total row on Realtime reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',1,'0000-00-00 00:00:00'),(1997,'fr','help_text_TOTAL_COLUMN_UNANSWERED','Formula to use for the Total row on Unanswered reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',1,'0000-00-00 00:00:00'),(1998,'fr','help_text_UNANSWERED_DISPLAY_GRID','If a chart is defined in the unanswered reports, parameter field, then use the grid layout width as setup in the value field. The grid system has 12 columns in total:<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: width1,width2',1,'0000-00-00 00:00:00'),(1999,'fr','help_text_UNANSWERED_DISPLAY_ROWS','Comma separated list of fields to show on a specific Unanswered reports. The fields are the one defined as COLUMN_UNANSWERED.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields',1,'0000-00-00 00:00:00'),(2000,'fr','help_text_agent_filter','Regular Expression to filter unwanted Agents from initial selection.<br/> Example: <strong>Agent/[0-9][0-9][0-9][0-9]$</strong>\r\n\r\n\r\n\r\n',1,'0000-00-00 00:00:00'),(2001,'fr','help_text_agent_reports','Comma separated list of reports to show on the Agent page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2002,'fr','help_text_agent_row_color','To paint the whole cell background to the status color for an agent in the realtime view, set this to 1',1,'0000-00-00 00:00:00'),(2003,'fr','help_text_answered_reports','Comma separated list of reports to show on the Answered page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2004,'fr','help_text_asterisk_12','Set this to 1 if you are using Asterisk 1.2 or older, otherwise you will have some issues in the realtime view.',1,'0000-00-00 00:00:00'),(2005,'fr','help_text_avg_time_format','Format for average duration fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in drill down and detailed reports.',1,'0000-00-00 00:00:00'),(2006,'fr','help_text_call_time_format','Format for the call duration fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in drill down and detailed reports.',1,'0000-00-00 00:00:00'),(2007,'fr','help_text_csv_separator','Separator character to use in CSV export files. Default value is comma (,) for Excel and friends. If you use LibreOffice/OpenOffice you might need to change it to semicolon (;)',1,'0000-00-00 00:00:00'),(2008,'fr','help_text_custom_reports','Comma separated list of custom reports to show on a new/custom tab on the menu. The parameter is the tab name to display, and value is a comma separated list of .php scripts to load.',1,'0000-00-00 00:00:00'),(2009,'fr','help_text_date_format','Format for the date field, using MySQL syntax. Example: %%m-%%d-%%Y %%H:%%i:%%s. This is used on drill down or detailed reports only. The report format themselves are set in the designer.',1,'0000-00-00 00:00:00'),(2010,'fr','help_text_decimal_places','Number of decimal places to show on float numbers.',1,'0000-00-00 00:00:00'),(2011,'fr','help_text_default_end_hour','Default end hour in HH:SS format for the date/time selection.',1,'0000-00-00 00:00:00'),(2012,'fr','help_text_default_start_hour','Default start hour in HH:SS format for the date/time selection.',1,'0000-00-00 00:00:00'),(2013,'fr','help_text_detailed_agent_report','Show a detailed agent report in the Agent tab. (Similar to the drill down information you can get on a regular report, but already expanded for the complete date range selection).',1,'0000-00-00 00:00:00'),(2014,'fr','help_text_dict_agent','Dictionary entry for Agents. It will replace the agent set as the parameter to the value you specify (So you can use names instead of interfaces).',1,'0000-00-00 00:00:00'),(2015,'fr','help_text_dict_queue','Dictionary entry for Queues. Same as the agent dictionary, but for replacing queue names.',1,'0000-00-00 00:00:00'),(2016,'fr','help_text_distribution_interval','Interval in minutes to break up the distribution by hour report. By default it breaks by hour (60 minutes), but you can use smaller or larger values.',1,'0000-00-00 00:00:00'),(2017,'fr','help_text_distribution_reports','Comma separated list of reports to show on the Distribution page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2018,'fr','help_text_drilldown_records_per_page','Number of records per page to show when expanding/drilling down on any report.',1,'0000-00-00 00:00:00'),(2019,'fr','help_text_first_page','Initial page to load (Eg: answered.php, unanswered.php, distribution.php, agent.php). Can be set per user',1,'0000-00-00 00:00:00'),(2020,'fr','help_text_hide_parsed_time','Set this to 1 to hide the parsed time information on the footer of every report.',1,'0000-00-00 00:00:00'),(2021,'fr','help_text_honor_timeframe_in_agent','Honor time frame selection in Agent Tab Reports. It will also try to compute missing events for the period if \nthey are not in the logs.',1,'0000-00-00 00:00:00'),(2022,'fr','help_text_ignore_none_abandons','If you do not want to count for inbound abandoned calls when selecting some agents from a report, set this parameter to one. This is useful for when you are tracking outbound campaigns and want to track performance per agent on outbound as it filters out the inbound abandoned calls that are assigned to the whole queue (agent NONE) and not a particular agent. If you select all agents for a report it will include also the NONE agent, so inbound abandons will count normally event if this parameter is set to one.',1,'0000-00-00 00:00:00'),(2023,'fr','help_text_language','Language to use. You can specify a user name in the parameter field to limit the language to a particular user. If the parameter field is left empty, then the language will be set for all users (global setting).',1,'0000-00-00 00:00:00'),(2024,'fr','help_text_mail_from_email','Schedule and Alert reports needs a FROM field to send emails.',1,'0000-00-00 00:00:00'),(2025,'fr','help_text_mail_from_name','Schedule and Alert reports needs a NAME field to send emails.',1,'0000-00-00 00:00:00'),(2026,'fr','help_text_mail_header_image','Image file to use as header for emails reports/alerts',1,'0000-00-00 00:00:00'),(2027,'fr','help_text_mail_smtp_password','Schedule and Alert reports, configure an SMTP password if needed.',1,'0000-00-00 00:00:00'),(2028,'fr','help_text_mail_smtp_server','Schedule and Alert reports, configure the SMTP server for sending emails. SSL protocol example: ssl://smtp.server.com ; for TLS protocol: tls://smtp.server.com ; without encryption: smtp.server.com',1,'0000-00-00 00:00:00'),(2029,'fr','help_text_mail_smtp_server_port','Schedule and Alert reports, configure the SMTP port if needed.',1,'0000-00-00 00:00:00'),(2030,'fr','help_text_mail_smtp_username','Schedule and Alert reports, configure the SMTP username if needed.',1,'0000-00-00 00:00:00'),(2031,'fr','help_text_realtime_alarm_call_duration','Alarm in seconds for call duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',1,'0000-00-00 00:00:00'),(2032,'fr','help_text_realtime_alarm_last_call','Alarm in seconds for the last call information in the realtime view. Can be set per queue by setting the parameter to the queue name.',1,'0000-00-00 00:00:00'),(2033,'fr','help_text_realtime_alarm_pause_duration','Alarm in seconds for pause/break duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',1,'0000-00-00 00:00:00'),(2034,'fr','help_text_realtime_alarm_row_color','Background row color when a value is in alarm in the realtime view.',1,'0000-00-00 00:00:00'),(2035,'fr','help_text_realtime_alarm_threshold','Threshold (in percentage) from which to start coloring in alarm calls in the realtime view.',1,'0000-00-00 00:00:00'),(2036,'fr','help_text_realtime_alarm_wait_count','Alarm (in number of calls) for calls waiting in a queue in the realtime view.',1,'0000-00-00 00:00:00'),(2037,'fr','help_text_realtime_alarm_wait_duration','Alarm in seconds for call waiting duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',1,'0000-00-00 00:00:00'),(2038,'fr','help_text_realtime_coach_options','Options to pass to chanspy when launching a Coach action from the realtime view. You can use any options available to the asterisk chanspy application, like &quot;w&quot; to enable whispering, or &quot;d&quot; to use dtmf to switch modes: 4 spy, 5 whisper, 6 barge., etc.',1,'0000-00-00 00:00:00'),(2039,'fr','help_text_realtime_custom_pauses','If this value is set to 1 the realtime page will check the ASTDB for the PAUSECUSTOM/Agent family and it will show the pause code stored there for a particular Agent as stored in astdb Key. Eg: PAUSECUSTOM/Agent/1000 = Break:${EPOCH} stored in ASTDB will show Agent 1000 as break when paused.',1,'0000-00-00 00:00:00'),(2040,'fr','help_text_realtime_group_queues','Start the realtime view with a grouped queue display.',1,'0000-00-00 00:00:00'),(2041,'fr','help_text_realtime_hide_loggedoff','Start the realtime view without showing logged off Agents.',1,'0000-00-00 00:00:00'),(2042,'fr','help_text_realtime_refresh','Refresh time in seconds for the realtime view.',1,'0000-00-00 00:00:00'),(2043,'fr','help_text_realtime_refresh_sql','Refresh time in seconds for statistics values on the queue summary table in the realtime view. Retrieving the information is cpu expensive, so you might want to leave it at the default value of 60 seconds or even higher if you have many supervisors checking the realt time view at the same time.',1,'0000-00-00 00:00:00'),(2044,'fr','help_text_realtime_reports','Comma separated list of reports to show on the Realtime page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2045,'fr','help_text_realtime_spy_device','Device used by the user (set in the parameter field). Example: SIP/1234',1,'0000-00-00 00:00:00'),(2046,'fr','help_text_realtime_spy_extension','Extension to reach the supervisor phone when launching a call steal action in the realtime view. The parameter must be set to the asternic user name, the value could be the extension number followed by the context, for example: 100@from-internal',1,'0000-00-00 00:00:00'),(2047,'fr','help_text_realtime_spy_options','Options to pass to chanspy when launching a Listen action from the realtime view. You can use any options available to the asterisk chanspy application, like &quot;q&quot; to disable the initial beep, etc.',1,'0000-00-00 00:00:00'),(2048,'fr','help_text_realtime_strict_interface_status','This setting will make the realtime view show status as returned by the asterisk queue application by means of the STATE INTERFACE options for the AddQueueMember application. It should be set to 1 in systems with Local type queue members with STATE INTERFACE set, like FreePBX 2.8 or higher.',1,'0000-00-00 00:00:00'),(2049,'fr','help_text_recordings_path','Recordings location/directory in the hardrive to perform the direct download.',1,'0000-00-00 00:00:00'),(2050,'fr','help_text_session_time_format','Format for the session duration fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in the agent reports.',1,'0000-00-00 00:00:00'),(2051,'fr','help_text_setup_reports','Comma separated list of reports to show on the Setup page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2052,'fr','help_text_shared_lastcall','Compartir la información de último llamado entre colas. Sólo se mostrará el tiempo más corto para todas las colas. Si se utiliza rastreo de salientes y se guarda el valor astdb LASTCALL, será también tomado en cuenta.',1,'0000-00-00 00:00:00'),(2053,'fr','help_text_short_abandon_threshold','Duration  treshhold (in seconds) for a call to be considered as abandoned (if duration is less than this value, then ignore the call completely). Specifying the queue name as a parameter will apply the value to that queue only.',1,'0000-00-00 00:00:00'),(2054,'fr','help_text_short_unanswered_threshold','Duration  treshhold (in seconds) for a call to be considered as unanswered (if duration is less than this value, then ignore the call completely). Specifying the queue name as a parameter will apply the value to that queue only.',1,'0000-00-00 00:00:00'),(2055,'fr','help_text_show_agent_call','Show end call events when drilling down on agent reports',1,'0000-00-00 00:00:00'),(2056,'fr','help_text_show_agent_field','Mostrar columna de Agente en reportes de no atendidos (útil cuando se rastrean llamados salientes)',1,'0000-00-00 00:00:00'),(2057,'fr','help_text_show_url_field','Enable and display the URL field and reports',1,'0000-00-00 00:00:00'),(2058,'fr','help_text_sla_abandoned','Service Level value in seconds for Abandoned calls',1,'0000-00-00 00:00:00'),(2059,'fr','help_text_sla_answered','Service Level value in seconds for Answered calls',1,'0000-00-00 00:00:00'),(2060,'fr','help_text_sla_interval','Time interval in seconds to split the table for SLA (Service Level Agreement) and Abandon Rate reports.',1,'0000-00-00 00:00:00'),(2061,'fr','help_text_sla_steps','Number of steps to show in SLA (Service Level Agreement) and Abandon Rate reports.',1,'0000-00-00 00:00:00'),(2062,'fr','help_text_sla_transferred','Service Level value in seconds for Transferred calls',1,'0000-00-00 00:00:00'),(2063,'fr','help_text_sla_unanswered','Service Level value in seconds for unanswered calls (not abandoned, but unanswered due to timeouts, exit with key, etc).',1,'0000-00-00 00:00:00'),(2064,'fr','help_text_timeframe_interval','Interval in minutes to present the time frame selection on the home tab. Defaults to 15 minutes.',1,'0000-00-00 00:00:00'),(2065,'fr','help_text_timezone','Timezone Configuration for user, in the format [ -]HH:MM\\\"\n\nIf the user name is specified as parameter, then applies only to that user. If parameter is left blank it will be applied globally.',1,'0000-00-00 00:00:00'),(2066,'fr','help_text_unanswered_reports','Comma separated list of reports to show on the Unanswered page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2067,'fr','help_text_variable_ABANDONED','Number of Abandoned calls (with EVENT_ABANDON disposition in queue_log)',1,'0000-00-00 00:00:00'),(2068,'fr','help_text_variable_ABANDONED_SLA','Number of Abandoned calls (with EVENT_ABANDON disposition in queue_log) who&#146;s wait time was less or equal than sla_abandoned setting in Preferences.',1,'0000-00-00 00:00:00'),(2069,'fr','help_text_variable_ABANDONED_WAIT_TIME','Wait time for abandoned calls for the particular grouped report.',1,'0000-00-00 00:00:00'),(2070,'fr','help_text_variable_AGENTS_LOGGED_OFF','Number of Logged Off agents. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2071,'fr','help_text_variable_AGENTS_PAUSED','Number of Paused agents. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2072,'fr','help_text_variable_AGENTS_STAFFED','Number of Logged In/Available agents. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2073,'fr','help_text_variable_AGENTS_TALKING','Number of Agents engaged on a call. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2074,'fr','help_text_variable_ANSWERED','Number of Answered calls (with EVENT_ANSWERED disposition in the queue_log file) for the particular grouped report.',1,'0000-00-00 00:00:00'),(2075,'fr','help_text_variable_ANSWERED_SLA','Number of Anaswered calls (with EVENT_ANSWERED disposition in queue_log) who&#146;s wait time was less or equal than sla_answered setting in Preferences.',1,'0000-00-00 00:00:00'),(2076,'fr','help_text_variable_ANSWERED_TALK_TIME','Talk Time of Answered Calls for the particular grouped report.',1,'0000-00-00 00:00:00'),(2077,'fr','help_text_variable_ANSWERED_WAIT_TIME','Wait Time of Answered Calls for the particular grouped report. (Wait Time is the time an user was waiting on the queue before being connected to an agent, it only counts the time since the queue was entered, it does not count potential previous times like IVRs, etc.)',1,'0000-00-00 00:00:00'),(2078,'fr','help_text_variable_AVG_ABANDONED','Average of Abandoned Calls',1,'0000-00-00 00:00:00'),(2079,'fr','help_text_variable_AVG_ABANDONED_SLA','Average of Abandoned Calls that where waiting less or equal abandoned_sla time as setup in Preferences.',1,'0000-00-00 00:00:00'),(2080,'fr','help_text_variable_AVG_ABANDONED_WAIT_TIME','Average Wait Time for Abandoned Calls',1,'0000-00-00 00:00:00'),(2081,'fr','help_text_variable_AVG_ANSWERED','Average number of Answered Calls',1,'0000-00-00 00:00:00'),(2082,'fr','help_text_variable_AVG_ANSWERED_SLA','Average number of Answered Calls that were waiting for less or equal than answered_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2083,'fr','help_text_variable_AVG_ANSWERED_TALK_TIME','Average Talk Time for Answered Calls',1,'0000-00-00 00:00:00'),(2084,'fr','help_text_variable_AVG_ANSWERED_WAIT_TIME','Average Wait Time for Answered Calls',1,'0000-00-00 00:00:00'),(2085,'fr','help_text_variable_AVG_LOGIN','Average number of Agent Logins',1,'0000-00-00 00:00:00'),(2086,'fr','help_text_variable_AVG_LOGOUT','Average number of Agents Logoffs',1,'0000-00-00 00:00:00'),(2087,'fr','help_text_variable_AVG_RECEIVED','Average number of Received Calls',1,'0000-00-00 00:00:00'),(2088,'fr','help_text_variable_AVG_TRANSFERRED','Average number of Transferred Calls',1,'0000-00-00 00:00:00'),(2089,'fr','help_text_variable_AVG_TRANSFERRED_SLA','Average number of Transferred Calls that were waiting for less or equal than transferred_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2090,'fr','help_text_variable_AVG_TRANSFERRED_TALK_TIME','Average Talk Time of Transferred Calls',1,'0000-00-00 00:00:00'),(2091,'fr','help_text_variable_AVG_TRANSFERRED_WAIT_TIME','Average Wait Time of Transferred Calls',1,'0000-00-00 00:00:00'),(2092,'fr','help_text_variable_AVG_UNANSWERED','Average number of Unanswered Calls',1,'0000-00-00 00:00:00'),(2093,'fr','help_text_variable_AVG_UNANSWERED_SLA','Average number of Unanswered Calls that had a wait time of less or equal seconds as set in unanswered_sla in Preferences.',1,'0000-00-00 00:00:00'),(2094,'fr','help_text_variable_AVG_UNANSWERED_WAIT_TIME','Average Wait Time for Unanswered Calls',1,'0000-00-00 00:00:00'),(2095,'fr','help_text_variable_CALLS_WAITING','Number of Calls Waiting. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2096,'fr','help_text_variable_LOGIN','Number of Agent Logins.',1,'0000-00-00 00:00:00'),(2097,'fr','help_text_variable_LOGOUT','Number of Agent Logoffs.',1,'0000-00-00 00:00:00'),(2098,'fr','help_text_variable_MAX_ABANDONED_WAIT_TIME','Maximum Wait Time in Abandoned Calls.',1,'0000-00-00 00:00:00'),(2099,'fr','help_text_variable_MAX_ANSWERED_TALK_TIME','Maximum Talk Time in Answered Calls.',1,'0000-00-00 00:00:00'),(2100,'fr','help_text_variable_MAX_ANSWERED_WAIT_TIME','Maximum Wait Time in Answered Calls.',1,'0000-00-00 00:00:00'),(2101,'fr','help_text_variable_MAX_CALLERS_WAITING','Maximum number of callers waiting in the queue.',1,'0000-00-00 00:00:00'),(2102,'fr','help_text_variable_MAX_COL','Maximum value for the column, to be used in TOTAL formulas.',1,'0000-00-00 00:00:00'),(2103,'fr','help_text_variable_MAX_TRANSFERRED_TALK_TIME','Maximum Talk Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2104,'fr','help_text_variable_MAX_TRANSFERRED_WAIT_TIME','Maximum Wait Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2105,'fr','help_text_variable_MAX_UNANSWERED_WAIT_TIME','Maximum Wait Time for Unanswered Calls.',1,'0000-00-00 00:00:00'),(2106,'fr','help_text_variable_MAX_WAIT_TIME','Maximum Wait Time for the particular grouped report.',1,'0000-00-00 00:00:00'),(2107,'fr','help_text_variable_MIN_ABANDONED_WAIT_TIME','Minimum Wait Time in Abandoned Calls.',1,'0000-00-00 00:00:00'),(2108,'fr','help_text_variable_MIN_ANSWERED_TALK_TIME','Minimum Talk Time in Answered Calls.',1,'0000-00-00 00:00:00'),(2109,'fr','help_text_variable_MIN_ANSWERED_WAIT_TIME','Minimum Wait Time in Answered Calls.',1,'0000-00-00 00:00:00'),(2110,'fr','help_text_variable_MIN_COL','Minimum value for the column, to be used in TOTAL formulas.',1,'0000-00-00 00:00:00'),(2111,'fr','help_text_variable_MIN_TRANSFERRED_TALK_TIME','Minimum Talk Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2112,'fr','help_text_variable_MIN_TRANSFERRED_WAIT_TIME','Minimum Wait Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2113,'fr','help_text_variable_MIN_UNANSWERED_WAIT_TIME','Minimum Wait Time for Unanswered Calls.',1,'0000-00-00 00:00:00'),(2114,'fr','help_text_variable_RECEIVED','Number of Received calls (with EVENT_RECEIVED disposition in the queue_log file) for the particular grouped report.',1,'0000-00-00 00:00:00'),(2115,'fr','help_text_variable_ROW_COUNT','Number of Rows on the report. To be used in TOTAL formulas.',1,'0000-00-00 00:00:00'),(2116,'fr','help_text_variable_SUM_ABANDONED','Sum of Abandoned calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2117,'fr','help_text_variable_SUM_ABANDONED_SLA','Sum of Abandoned calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_abandoned seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2118,'fr','help_text_variable_SUM_ABANDONED_WAIT_TIME','Sum of Wait Time for Abandoned Calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2119,'fr','help_text_variable_SUM_ANSWERED','Sum of Answered Calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2120,'fr','help_text_variable_SUM_ANSWERED_SLA','Sum of Answered Calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_answered seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2121,'fr','help_text_variable_SUM_ANSWERED_TALK_TIME','Sum of Talk Time for Answered calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2122,'fr','help_text_variable_SUM_ANSWERED_WAIT_TIME','Sum of Wait Time for Answered calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2123,'fr','help_text_variable_SUM_COL','Sum of all values for a particular column. To be used in TOTAL formulas.',1,'0000-00-00 00:00:00'),(2124,'fr','help_text_variable_SUM_LOGIN','Sum of Login events up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2125,'fr','help_text_variable_SUM_LOGOUT','Sum of Logoff events up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2126,'fr','help_text_variable_SUM_RECEIVED','Sum of Received Calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2127,'fr','help_text_variable_SUM_TRANSFERRED','Sum of Transferred Calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2128,'fr','help_text_variable_SUM_TRANSFERRED_SLA','Sum of Transferred Calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_transferred seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2129,'fr','help_text_variable_SUM_TRANSFERRED_TALK_TIME','Sum of Talk Time for Transferred calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2130,'fr','help_text_variable_SUM_TRANSFERRED_WAIT_TIME','Sum of Wait Time for Transferred calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2131,'fr','help_text_variable_SUM_UNANSWERED','Sum of Unanswered calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2132,'fr','help_text_variable_SUM_UNANSWERED_SLA','Sum of Unanswered calls up to the particular row in a report, who&#146;s wait time is less or equal than transferred_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2133,'fr','help_text_variable_SUM_UNANSWERED_WAIT_TIME','Sum of Wait Time for Transferred calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2134,'fr','help_text_variable_TOTAL_ABANDONED','Total number of Abandoned Calls.',1,'0000-00-00 00:00:00'),(2135,'fr','help_text_variable_TOTAL_ABANDONED_SLA','Total number of Abandoned calls who&#146;s wait time is less or equal than abandoned_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2136,'fr','help_text_variable_TOTAL_ABANDONED_WAIT_TIME','Total Wait Time for Abandoned Calls',1,'0000-00-00 00:00:00'),(2137,'fr','help_text_variable_TOTAL_ANSWERED','Total number of Answered calls',1,'0000-00-00 00:00:00'),(2138,'fr','help_text_variable_TOTAL_ANSWERED_SLA','Total number of Answered calls who&#146;s wait time is less or equal than answered_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2139,'fr','help_text_variable_TOTAL_ANSWERED_TALK_TIME','Total Talk Time for Answered Calls',1,'0000-00-00 00:00:00'),(2140,'fr','help_text_variable_TOTAL_ANSWERED_WAIT_TIME','Total Wait Time for Answered Calls',1,'0000-00-00 00:00:00'),(2141,'fr','help_text_variable_TOTAL_LOGIN','Total number of Login events.',1,'0000-00-00 00:00:00'),(2142,'fr','help_text_variable_TOTAL_LOGOUT','Total number of Logoff events.',1,'0000-00-00 00:00:00'),(2143,'fr','help_text_variable_TOTAL_RECEIVED','Total number of Received calls.',1,'0000-00-00 00:00:00'),(2144,'fr','help_text_variable_TOTAL_TRANSFERRED','Total number of Transferred calls.',1,'0000-00-00 00:00:00'),(2145,'fr','help_text_variable_TOTAL_TRANSFERRED_SLA','Total of Transferred Calls that have a wait time of less or equal transferred_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2146,'fr','help_text_variable_TOTAL_TRANSFERRED_TALK_TIME','Total Talk Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2147,'fr','help_text_variable_TOTAL_TRANSFERRED_WAIT_TIME','Total Wait Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2148,'fr','help_text_variable_TOTAL_UNANSWERED','Total number of Unanswered Calls.',1,'0000-00-00 00:00:00'),(2149,'fr','help_text_variable_TOTAL_UNANSWERED_SLA','Total of Unanswered Calls that have a wait time of less or equal unanswered_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2150,'fr','help_text_variable_TOTAL_UNANSWERED_WAIT_TIME','Wait Time for Unanswered Calls for the whole set of data.',1,'0000-00-00 00:00:00'),(2151,'fr','help_text_variable_TRANSFERRED','Number of Transferred Calls (with EVENT_TRANSFERRED disposition in queue_log)',1,'0000-00-00 00:00:00'),(2152,'fr','help_text_variable_TRANSFERRED_SLA','Number of Transferred Calls (with EVENT_TRANSFERRED disposition in queue_log) who&#146;s wait time is less or equal than transferred_sla as set in Preferences.',1,'0000-00-00 00:00:00'),(2153,'fr','help_text_variable_TRANSFERRED_TALK_TIME','Talk Time for Transferred Calls for a particular row.',1,'0000-00-00 00:00:00'),(2154,'fr','help_text_variable_TRANSFERRED_WAIT_TIME','Wait Time for Transferred Calls for a particular row.',1,'0000-00-00 00:00:00'),(2155,'fr','help_text_variable_UNANSWERED','Number of Unanswered calls (with EVENT_UNANSWERED disposition in the queue_log file) for the particular grouped report.',1,'0000-00-00 00:00:00'),(2156,'fr','help_text_variable_UNANSWERED_SLA','Number of Unanswered calls (with EVENT_UNANSWERED disposition in queue_log) who&#146;s wait time was less or equal than sla_unanswered setting in Preferences.',1,'0000-00-00 00:00:00'),(2157,'fr','help_text_variable_UNANSWERED_WAIT_TIME','Wait Time for Unanswered Calls for a particular row.',1,'0000-00-00 00:00:00'),(2158,'fr','help_text_wait_time_format','Format for the wait time fields. HH = hours, MM=minutes, SS=seconds, mm=full minutes, ss=full seconds. Used in drill down and detailed reports.',1,'0000-00-00 00:00:00'),(2159,'fr','help_text_week_mode','When to start counting weeks from the year:<br><pre>\r\nMode    First day of week       Range   Week 1 is the first week ...\r\n0       Sunday                  0-53    with a Sunday in this year\r\n1       Monday                  0-53    with more than 3 days this year\r\n2       Sunday                  1-53    with a Sunday in this year\r\n3       Monday                  1-53    with more than 3 days this year\r\n4       Sunday                  0-53    with more than 3 days this year\r\n5       Monday                  0-53    with a Monday in this year\r\n6       Sunday                  1-53    with more than 3 days this year\r\n7       Monday                  1-53    with a Monday in this year\r\n</pre>',1,'0000-00-00 00:00:00'),(2160,'fr','hours','hours',1,'2012-10-01 23:17:29'),(2161,'fr','info1','Info 1',1,'0000-00-00 00:00:00'),(2162,'fr','info2','info 2',1,'0000-00-00 00:00:00'),(2163,'fr','info3','Info 3',1,'0000-00-00 00:00:00'),(2164,'fr','info4','Info 4',1,'0000-00-00 00:00:00'),(2165,'fr','info5','Info 5',1,'0000-00-00 00:00:00'),(2166,'fr','none','none',1,'0000-00-00 00:00:00'),(2167,'fr','of','of',1,'2012-10-01 23:17:20'),(2168,'fr','on %s since %s seconds ago','en %s desde hace %s segundos',1,'0000-00-00 00:00:00'),(2169,'fr','on %s since %s secs ago','on %s since %s secs ago',1,'0000-00-00 00:00:00'),(2170,'fr','on days','on days',1,'0000-00-00 00:00:00'),(2171,'fr','on hours','on hours',1,'0000-00-00 00:00:00'),(2172,'fr','on minutes','on minutes',1,'0000-00-00 00:00:00'),(2173,'fr','partial','partial',1,'0000-00-00 00:00:00'),(2174,'fr','realtime-agent-busy','Busy',1,'0000-00-00 00:00:00'),(2175,'fr','realtime-agent-dialout','Outbound Call',1,'0000-00-00 00:00:00'),(2176,'fr','realtime-agent-hold','On Hold',1,'0000-00-00 00:00:00'),(2177,'fr','realtime-agent-not in use','Not in use',1,'0000-00-00 00:00:00'),(2178,'fr','realtime-agent-ringing','Ringing',1,'0000-00-00 00:00:00'),(2179,'fr','realtime-agent-unavailable','Unavailable',1,'0000-00-00 00:00:00'),(2180,'fr','realtime_queue_summary','Queue Summary',1,'0000-00-00 00:00:00'),(2181,'fr','seconds','seconds',1,'0000-00-00 00:00:00'),(2182,'fr','unanswered_calls_by_event','Disconnection Cause',1,'2012-10-01 23:17:33'),(2183,'fr','unanswered_calls_by_holdtime','Service Level',1,'2012-10-01 23:17:33'),(2184,'fr','unanswered_calls_by_queue','Unanswered Calls by Queue',1,'2012-10-01 23:17:33'),(2185,'fr','unanswered_calls_by_url','Unanswered Calls by URL',1,'2012-10-01 23:17:33'),(2186,'fr','unanswered_calls_detail','Unanswered Calls Detail',1,'2012-10-01 23:17:33'),(2187,'fr','unanswered_calls_summary','Unanswered Calls Summary',1,'2012-10-01 23:17:33'),(2188,'fr','within','within',1,'0000-00-00 00:00:00'),(2189,'fr','within %d%s seconds','within %d%s seconds',1,'0000-00-00 00:00:00'),(2190,'en','Ignoring field ','Ignoring field ',0,'2012-10-02 02:42:52'),(2191,'en','Records imported','Records imported',0,'2012-10-02 02:42:53'),(2192,'en','No valid fields to import!','No valid fields to import!',0,'2012-10-02 02:05:22'),(2193,'pt_br','help_text_variable_UNANSWERED_WAIT_TIME','Wait Time for Unanswered Calls for a particular row.',1,'0000-00-00 00:00:00'),(2194,'pt_br','info1','Info 1',0,'0000-00-00 00:00:00'),(2195,'pt_br','info2','info 2',0,'0000-00-00 00:00:00'),(2196,'pt_br','info3','Info 3',0,'0000-00-00 00:00:00'),(2197,'pt_br','info4','Info 4',0,'0000-00-00 00:00:00'),(2198,'pt_br','info5','Info 5',0,'0000-00-00 00:00:00'),(2199,'pt_br','help_text_variable_UNANSWERED_SLA','Number of Unanswered calls (with EVENT_UNANSWERED disposition in queue_log) who&#146;s wait time was less or equal than sla_unanswered setting in Preferences.',1,'0000-00-00 00:00:00'),(2200,'pt_br','help_text_variable_TRANSFERRED_SLA','Number of Transferred Calls (with EVENT_TRANSFERRED disposition in queue_log) who&#146;s wait time is less or equal than transferred_sla as set in Preferences.',1,'0000-00-00 00:00:00'),(2201,'pt_br','help_text_variable_TRANSFERRED_TALK_TIME','Talk Time for Transferred Calls for a particular row.',1,'0000-00-00 00:00:00'),(2202,'pt_br','help_text_variable_TRANSFERRED_WAIT_TIME','Wait Time for Transferred Calls for a particular row.',1,'0000-00-00 00:00:00'),(2203,'pt_br','help_text_variable_UNANSWERED','Number of Unanswered calls (with EVENT_UNANSWERED disposition in the queue_log file) for the particular grouped report.',1,'0000-00-00 00:00:00'),(2204,'pt_br','help_text_variable_TOTAL_UNANSWERED_SLA','Total of Unanswered Calls that have a wait time of less or equal unanswered_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2205,'pt_br','help_text_variable_TOTAL_UNANSWERED_WAIT_TIME','Wait Time for Unanswered Calls for the whole set of data.',1,'0000-00-00 00:00:00'),(2206,'pt_br','help_text_variable_TRANSFERRED','Number of Transferred Calls (with EVENT_TRANSFERRED disposition in queue_log)',1,'0000-00-00 00:00:00'),(2207,'pt_br','help_text_variable_TOTAL_UNANSWERED','Total number of Unanswered Calls.',1,'0000-00-00 00:00:00'),(2208,'pt_br','help_text_variable_TOTAL_TRANSFERRED_TALK_TIME','Total Talk Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2209,'pt_br','help_text_variable_TOTAL_TRANSFERRED_WAIT_TIME','Total Wait Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2210,'pt_br','help_text_variable_TOTAL_RECEIVED','Total number of Received calls.',1,'0000-00-00 00:00:00'),(2211,'pt_br','help_text_variable_TOTAL_TRANSFERRED','Total number of Transferred calls.',1,'0000-00-00 00:00:00'),(2212,'pt_br','help_text_variable_TOTAL_TRANSFERRED_SLA','Total of Transferred Calls that have a wait time of less or equal transferred_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2213,'pt_br','help_text_variable_TOTAL_LOGOUT','Total number of Logoff events.',1,'0000-00-00 00:00:00'),(2214,'pt_br','help_text_variable_TOTAL_ANSWERED_WAIT_TIME','Total Wait Time for Answered Calls',1,'0000-00-00 00:00:00'),(2215,'pt_br','help_text_variable_TOTAL_LOGIN','Total number of Login events.',1,'0000-00-00 00:00:00'),(2216,'pt_br','help_text_variable_TOTAL_ANSWERED_TALK_TIME','Total Talk Time for Answered Calls',1,'0000-00-00 00:00:00'),(2217,'pt_br','help_text_variable_TOTAL_ANSWERED_SLA','Total number of Answered calls who&#146;s wait time is less or equal than answered_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2218,'pt_br','help_text_variable_TOTAL_ANSWERED','Total number of Answered calls',1,'0000-00-00 00:00:00'),(2219,'pt_br','help_text_variable_TOTAL_ABANDONED_WAIT_TIME','Total Wait Time for Abandoned Calls',1,'0000-00-00 00:00:00'),(2220,'pt_br','help_text_variable_TOTAL_ABANDONED','Total number of Abandoned Calls.',1,'0000-00-00 00:00:00'),(2221,'pt_br','help_text_variable_TOTAL_ABANDONED_SLA','Total number of Abandoned calls who&#146;s wait time is less or equal than abandoned_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2222,'pt_br','help_text_variable_SUM_UNANSWERED','Sum of Unanswered calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2223,'pt_br','help_text_variable_SUM_UNANSWERED_SLA','Sum of Unanswered calls up to the particular row in a report, who&#146;s wait time is less or equal than transferred_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2224,'pt_br','help_text_variable_SUM_UNANSWERED_WAIT_TIME','Sum of Wait Time for Transferred calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2225,'pt_br','help_text_variable_SUM_TRANSFERRED_WAIT_TIME','Sum of Wait Time for Transferred calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2226,'pt_br','help_text_variable_SUM_TRANSFERRED_TALK_TIME','Sum of Talk Time for Transferred calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2227,'pt_br','help_text_variable_SUM_RECEIVED','Sum of Received Calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2228,'pt_br','help_text_variable_SUM_TRANSFERRED','Sum of Transferred Calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2229,'pt_br','help_text_variable_SUM_TRANSFERRED_SLA','Sum of Transferred Calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_transferred seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2230,'pt_br','help_text_variable_SUM_ANSWERED_TALK_TIME','Sum of Talk Time for Answered calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2231,'pt_br','help_text_variable_SUM_ANSWERED_WAIT_TIME','Sum of Wait Time for Answered calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2232,'pt_br','help_text_variable_SUM_COL','Sum of all values for a particular column. To be used in TOTAL formulas.',1,'0000-00-00 00:00:00'),(2233,'pt_br','help_text_variable_SUM_LOGIN','Sum of Login events up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2234,'pt_br','help_text_variable_SUM_LOGOUT','Sum of Logoff events up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2235,'pt_br','help_text_variable_SUM_ANSWERED','Sum of Answered Calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2236,'pt_br','help_text_variable_SUM_ANSWERED_SLA','Sum of Answered Calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_answered seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2237,'pt_br','help_text_variable_SUM_ABANDONED_WAIT_TIME','Sum of Wait Time for Abandoned Calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2238,'pt_br','help_text_variable_RECEIVED','Number of Received calls (with EVENT_RECEIVED disposition in the queue_log file) for the particular grouped report.',1,'0000-00-00 00:00:00'),(2239,'pt_br','help_text_variable_SUM_ABANDONED_SLA','Sum of Abandoned calls up to the particular row in a report, who&#146;s wait time is less or equal than sla_abandoned seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2240,'pt_br','help_text_variable_ROW_COUNT','Number of Rows on the report. To be used in TOTAL formulas.',1,'0000-00-00 00:00:00'),(2241,'pt_br','help_text_variable_SUM_ABANDONED','Sum of Abandoned calls up to the particular row in a report.',1,'0000-00-00 00:00:00'),(2242,'pt_br','help_text_variable_MIN_TRANSFERRED_TALK_TIME','Minimum Talk Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2243,'pt_br','help_text_variable_MIN_TRANSFERRED_WAIT_TIME','Minimum Wait Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2244,'pt_br','help_text_variable_MIN_UNANSWERED_WAIT_TIME','Minimum Wait Time for Unanswered Calls.',1,'0000-00-00 00:00:00'),(2245,'pt_br','help_text_variable_MIN_ANSWERED_WAIT_TIME','Minimum Wait Time in Answered Calls.',1,'0000-00-00 00:00:00'),(2246,'pt_br','help_text_variable_MIN_COL','Minimum value for the column, to be used in TOTAL formulas.',1,'0000-00-00 00:00:00'),(2247,'pt_br','help_text_variable_MIN_ABANDONED_WAIT_TIME','Minimum Wait Time in Abandoned Calls.',1,'0000-00-00 00:00:00'),(2248,'pt_br','help_text_variable_MIN_ANSWERED_TALK_TIME','Minimum Talk Time in Answered Calls.',1,'0000-00-00 00:00:00'),(2249,'pt_br','help_text_variable_MAX_WAIT_TIME','Maximum Wait Time for the particular grouped report.',1,'0000-00-00 00:00:00'),(2250,'pt_br','help_text_variable_MAX_TRANSFERRED_WAIT_TIME','Maximum Wait Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2251,'pt_br','help_text_variable_MAX_UNANSWERED_WAIT_TIME','Maximum Wait Time for Unanswered Calls.',1,'0000-00-00 00:00:00'),(2252,'pt_br','help_text_variable_LOGIN','Number of Agent Logins.',1,'0000-00-00 00:00:00'),(2253,'pt_br','help_text_variable_LOGOUT','Number of Agent Logoffs.',1,'0000-00-00 00:00:00'),(2254,'pt_br','help_text_variable_MAX_ABANDONED_WAIT_TIME','Maximum Wait Time in Abandoned Calls.',1,'0000-00-00 00:00:00'),(2255,'pt_br','help_text_variable_MAX_ANSWERED_TALK_TIME','Maximum Talk Time in Answered Calls.',1,'0000-00-00 00:00:00'),(2256,'pt_br','help_text_variable_MAX_ANSWERED_WAIT_TIME','Maximum Wait Time in Answered Calls.',1,'0000-00-00 00:00:00'),(2257,'pt_br','help_text_variable_MAX_CALLERS_WAITING','Maximum number of callers waiting in the queue.',1,'0000-00-00 00:00:00'),(2258,'pt_br','help_text_variable_MAX_COL','Maximum value for the column, to be used in TOTAL formulas.',1,'0000-00-00 00:00:00'),(2259,'pt_br','help_text_variable_MAX_TRANSFERRED_TALK_TIME','Maximum Talk Time for Transferred Calls.',1,'0000-00-00 00:00:00'),(2260,'pt_br','help_text_variable_AVG_UNANSWERED','Average number of Unanswered Calls',1,'0000-00-00 00:00:00'),(2261,'pt_br','help_text_variable_AVG_UNANSWERED_SLA','Average number of Unanswered Calls that had a wait time of less or equal seconds as set in unanswered_sla in Preferences.',1,'0000-00-00 00:00:00'),(2262,'pt_br','help_text_variable_AVG_UNANSWERED_WAIT_TIME','Average Wait Time for Unanswered Calls',1,'0000-00-00 00:00:00'),(2263,'pt_br','help_text_variable_CALLS_WAITING','Number of Calls Waiting. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2264,'pt_br','help_text_variable_AVG_TRANSFERRED_TALK_TIME','Average Talk Time of Transferred Calls',1,'0000-00-00 00:00:00'),(2265,'pt_br','help_text_variable_AVG_TRANSFERRED_WAIT_TIME','Average Wait Time of Transferred Calls',1,'0000-00-00 00:00:00'),(2266,'pt_br','help_text_variable_AVG_TRANSFERRED','Average number of Transferred Calls',1,'0000-00-00 00:00:00'),(2267,'pt_br','help_text_variable_AVG_TRANSFERRED_SLA','Average number of Transferred Calls that were waiting for less or equal than transferred_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2268,'pt_br','help_text_variable_AVG_LOGIN','Average number of Agent Logins',1,'0000-00-00 00:00:00'),(2269,'pt_br','help_text_variable_AVG_LOGOUT','Average number of Agents Logoffs',1,'0000-00-00 00:00:00'),(2270,'pt_br','help_text_variable_AVG_RECEIVED','Average number of Received Calls',1,'0000-00-00 00:00:00'),(2271,'pt_br','help_text_variable_AVG_ANSWERED_WAIT_TIME','Average Wait Time for Answered Calls',1,'0000-00-00 00:00:00'),(2272,'pt_br','help_text_variable_AVG_ABANDONED','Average of Abandoned Calls',1,'0000-00-00 00:00:00'),(2273,'pt_br','help_text_variable_AVG_ABANDONED_SLA','Average of Abandoned Calls that where waiting less or equal abandoned_sla time as setup in Preferences.',1,'0000-00-00 00:00:00'),(2274,'pt_br','help_text_variable_AVG_ABANDONED_WAIT_TIME','Average Wait Time for Abandoned Calls',1,'0000-00-00 00:00:00'),(2275,'pt_br','help_text_variable_AVG_ANSWERED','Average number of Answered Calls',1,'0000-00-00 00:00:00'),(2276,'pt_br','help_text_variable_AVG_ANSWERED_SLA','Average number of Answered Calls that were waiting for less or equal than answered_sla seconds as set in Preferences.',1,'0000-00-00 00:00:00'),(2277,'pt_br','help_text_variable_AVG_ANSWERED_TALK_TIME','Average Talk Time for Answered Calls',1,'0000-00-00 00:00:00'),(2278,'pt_br','help_text_variable_ANSWERED_TALK_TIME','Talk Time of Answered Calls for the particular grouped report.',1,'0000-00-00 00:00:00'),(2279,'pt_br','help_text_variable_ANSWERED_WAIT_TIME','Wait Time of Answered Calls for the particular grouped report. (Wait Time is the time an user was waiting on the queue before being connected to an agent, it only counts the time since the queue was entered, it does not count potential previous times like IVRs, etc.)',1,'0000-00-00 00:00:00'),(2280,'pt_br','help_text_variable_ANSWERED_SLA','Number of Anaswered calls (with EVENT_ANSWERED disposition in queue_log) who&#146;s wait time was less or equal than sla_answered setting in Preferences.',1,'0000-00-00 00:00:00'),(2281,'pt_br','help_text_variable_ANSWERED','Number of Answered calls (with EVENT_ANSWERED disposition in the queue_log file) for the particular grouped report.',1,'0000-00-00 00:00:00'),(2282,'pt_br','help_text_variable_AGENTS_TALKING','Number of Agents engaged on a call. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2283,'pt_br','help_text_variable_AGENTS_STAFFED','Number of Logged In/Available agents. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2284,'pt_br','help_text_variable_AGENTS_PAUSED','Number of Paused agents. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2285,'pt_br','help_text_variable_AGENTS_LOGGED_OFF','Number of Logged Off agents. Only available in COLUMN_REALTIME formulas.',1,'0000-00-00 00:00:00'),(2286,'pt_br','help_text_variable_ABANDONED_WAIT_TIME','Wait time for abandoned calls for the particular grouped report.',1,'0000-00-00 00:00:00'),(2287,'pt_br','help_text_variable_ABANDONED_SLA','Number of Abandoned calls (with EVENT_ABANDON disposition in queue_log) who&#146;s wait time was less or equal than sla_abandoned setting in Preferences.',1,'0000-00-00 00:00:00'),(2288,'pt_br','help_text_variable_ABANDONED','Number of Abandoned calls (with EVENT_ABANDON disposition in queue_log)',1,'0000-00-00 00:00:00'),(2289,'pt_br','help_text_unanswered_reports','Comma separated list of reports to show on the Unanswered page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2290,'pt_br','help_text_setup_reports','Comma separated list of reports to show on the Setup page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2291,'pt_br','help_text_realtime_reports','Comma separated list of reports to show on the Realtime page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2292,'pt_br','help_text_distribution_reports','Comma separated list of reports to show on the Distribution page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2293,'pt_br','help_text_custom_reports','Comma separated list of custom reports to show on a new/custom tab on the menu. The parameter is the tab name to display, and value is a comma separated list of .php scripts to load.',1,'0000-00-00 00:00:00'),(2294,'pt_br','help_text_answered_reports','Comma separated list of reports to show on the Answered page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2295,'pt_br','help_text_agent_reports','Comma separated list of reports to show on the Agent page. You must specify the correct .php file that displays the report you want on each element.',1,'0000-00-00 00:00:00'),(2296,'pt_br','help_text_UNANSWERED_DISPLAY_ROWS','Comma separated list of fields to show on a specific Unanswered reports. The fields are the one defined as COLUMN_UNANSWERED.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields',1,'0000-00-00 00:00:00'),(2297,'pt_br','help_text_UNANSWERED_DISPLAY_GRID','If a chart is defined in the unanswered reports, parameter field, then use the grid layout width as setup in the value field. The grid system has 12 columns in total:<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: width1,width2',1,'0000-00-00 00:00:00'),(2298,'pt_br','help_text_TOTAL_COLUMN_UNANSWERED','Formula to use for the Total row on Unanswered reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',1,'0000-00-00 00:00:00'),(2299,'pt_br','help_text_TOTAL_COLUMN_REALTIME','Formula to use for the Total row on Realtime reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',1,'0000-00-00 00:00:00'),(2300,'pt_br','help_text_TOTAL_COLUMN_DISTRIBUTION','Formula to use for the Total row on Distribution reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',1,'0000-00-00 00:00:00'),(2301,'pt_br','help_text_TOTAL_COLUMN_ANSWERED','Formula to use for the Total row on Answered reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',1,'0000-00-00 00:00:00'),(2302,'pt_br','help_text_REALTIME_DISPLAY_ROWS','Comma separated list of fields to show on the Realtime Queue Summary table. The fields are the one defined as COLUMN_REALTIME.<br/>\r\n<br/>\r\nparameter: group field (queue_summary)<br/>\r\nvalue: comma separated list of fields',1,'0000-00-00 00:00:00'),(2303,'pt_br','help_text_REALTIME_COLUMN_WIDTHS','Comma separated list of column widths for realtime reports, where parameter is the report to modify, for example &#39;agent&#39;',1,'0000-00-00 00:00:00'),(2304,'pt_br','help_text_EVENT_UNANSWERED','Define the queue_log events that will count towards the UNANSWERED counters/variables in reports, using a comma separated list. As an abandon call has its own variable, you should list here the rest of the unanswered dispositions, for example:<br/><br/>\r\nEXITWITHKEY,EXITEMPTY,EXITWITHTIMEOUT',1,'0000-00-00 00:00:00'),(2305,'pt_br','help_text_EVENT_TRANSFERRED','Define the queue_log events that will count towards the TRANSFERRED counters/variables in reports, using a comma separated list. In a regular Asterisk setup, the only event associated with transfers is TRANSFER.',1,'0000-00-00 00:00:00'),(2306,'pt_br','help_text_EVENT_RECEIVED','Define the queue_log events that will count towards the RECEIVED counters/variables in reports, using a comma separated list. All dispositions on the queue_log file that should add to a received call should be listed here, for example:<br/><br/>\r\nCOMPLETECALLER,COMPLETEAGENT,ABANDON,EXITEMPTY,EXITWITHKEY,EXITWITHTIMEOUT,TRANSFER',1,'0000-00-00 00:00:00'),(2307,'pt_br','help_text_EVENT_LOGOUT','Define the queue_log events that will count towards the LOGOUT counters/variables in reports, using a comma separated list. Usually you have AGENTLOGOFF and REMOVEMEMBER as events for login events in the queue_log file.',1,'0000-00-00 00:00:00'),(2308,'pt_br','help_text_EVENT_LOGIN','Define the queue_log events that will count towards the LOGIN counters/variables in reports, using a comma separated list. Usually you have AGENTLOGIN and ADDMEMBER as events for login events in the queue_log file. Old asterisk versions could also use AGENTCALLBACKLOGIN.',1,'0000-00-00 00:00:00'),(2309,'pt_br','help_text_EVENT_ANSWERED','Define the queue_log events that will count towards the ANSWERED counters/variables in reports, using a comma separated list. Normal answered dispositions in the queue_log are COMPLETECALLER, COMPLETEAGENT, you could also want to count the TRANSFER disposition towards the ANSWERED column, but as transfers have their own variable, you can also leave them separated.',1,'0000-00-00 00:00:00'),(2310,'pt_br','help_text_EVENT_ABANDONED','Define the queue_log events that will count towards the ABANDONED counters/variables in reports, using a comma separated list. In a standard Asterisk setup, this must be set to \\\"ABANDON\\\" and nothing else.',1,'0000-00-00 00:00:00'),(2311,'pt_br','help_text_DISTRIBUTION_DISPLAY_ROWS','Comma separated list of fields to show on a specific Distribution reports. The fields are the one defined as COLUMN_DISTRIBUTION.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields',1,'0000-00-00 00:00:00'),(2312,'pt_br','help_text_COLUMN_UNANSWERED','Column to show in Unanswered reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in UNANSWERED_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n',1,'0000-00-00 00:00:00'),(2313,'pt_br','help_text_COLUMN_UNANSWERED_FORMAT','Format to use for displaying a cell value in the unanswered reports. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_UNANSWERED entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',1,'0000-00-00 00:00:00'),(2314,'pt_br','help_text_COLUMN_REALTIME_STYLE','Extra html property to add to cell values in the realtime queue summary table. You can use class or style to modify display on those cells. Example:<br/>\r\n<br/>\r\nclass=&quot;bigblue&quot;\r\n<br/>\r\nstyle=&quot;border:1px solid red;&quot;\r\n\r\n',1,'0000-00-00 00:00:00'),(2315,'pt_br','help_text_COLUMN_REALTIME_FORMAT','Format to use for displaying a cell value in the realtime queue summary report. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_REALTIME entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',1,'0000-00-00 00:00:00'),(2316,'pt_br','help_text_COLUMN_REALTIME','Column to show in the Realtime summary. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in REALTIME_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n',1,'0000-00-00 00:00:00'),(2317,'pt_br','help_text_COLUMN_DISTRIBUTION_FORMAT','Format to use for displaying a cell value in the distribution reports. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_DISTRIBUTION entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',1,'0000-00-00 00:00:00'),(2318,'pt_br','help_text_COLUMN_DISTRIBUTION','Column to show in Distribution reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in DISTRIBUTION_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n',1,'0000-00-00 00:00:00'),(2319,'pt_br','help_text_COLUMN_ANSWERED_FORMAT','Format to use for displaying a cell value in the answered reports. It uses regular printf formatting rules, except for hourly values that can use {HH}, {MM}, {SS}, {mm} and {ss}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nThe parameter field name must be set as the parameter field on the COLUMN_ANSWERED entry.<br/>\r\nFormat Examples:<br/><br/>\r\nGiven a value in seconds, convert it to HH:MM:SS with:<br/>\r\n{HH}:{MM}:{SS}\r\n',1,'0000-00-00 00:00:00'),(2320,'pt_br','help_text_COLUMN_ANSWERED','Column to show in Answered reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in ANSWERED_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n\r\n\r\n',1,'0000-00-00 00:00:00'),(2321,'pt_br','help_text_CHART_UNANSWERED','Shows a chart into the Unanswered reports page.<br/><br/>\r\n\r\nparameter: position,group field,title<br/>\r\nvalue: field,field',1,'0000-00-00 00:00:00'),(2322,'pt_br','help_text_CHART_SERIES_COLOR','Colors to use for charts. Parameter is the index position, and value the hex html color.',1,'0000-00-00 00:00:00'),(2323,'pt_br','help_text_CHART_DISTRIBUTION','Shows a chart into the Distribution reports page.<br/><br/>\r\n\r\nparameter: position,group field,title<br/>\r\nvalue: field,field',1,'0000-00-00 00:00:00'),(2324,'pt_br','event_help_unpause_info1','Unpause reason if any',1,'0000-00-00 00:00:00'),(2325,'pt_br','every day','todos os dias',0,'0000-00-00 00:00:00'),(2326,'pt_br','help_text_ACTION','Define a custom action handler, so you can call your own functions/program to handle special cases. You must create the javascript function in the js/custom.js file. It will receive the uniqueid of the call when the action icon is clicked.<br/>\r\n<br/>\r\nparameter: position,icon image,Tooltip<br/>\r\nvalue: javascript_function',1,'0000-00-00 00:00:00'),(2327,'pt_br','help_text_CHART_ANSWERED','Shows a chart into the Answered reports page.<br/><br/>\n\nparameter: position,group field,title<br/>\nvalue: field,field',1,'0000-00-00 00:00:00'),(2328,'pt_br','help_text_ANSWERED_DISPLAY_GRID','If a chart is defined in the answered reports tab, parameter field, then use the grid layout width as setup in the value field. The grid system has 12 columns in total:<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: width1,width2',1,'0000-00-00 00:00:00'),(2329,'pt_br','help_text_ANSWERED_DISPLAY_ROWS','Comma separated list of fields to show on a specific Answered reports. The fields are the one defined as COLUMN_ANSWERED.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields ',1,'0000-00-00 00:00:00'),(2330,'pt_br','event_help_transfer_info4','The length of the call.',1,'0000-00-00 00:00:00'),(2331,'pt_br','event_help_transfer_info5','The caller&#39;s entry position at the time of the transfer.',1,'0000-00-00 00:00:00'),(2332,'pt_br','event_help_transfer_info3','The caller&#39;s hold time',1,'0000-00-00 00:00:00'),(2333,'pt_br','event_help_transfer_info2','The context',1,'0000-00-00 00:00:00'),(2334,'pt_br','event_help_transfer_info1','The extension',1,'0000-00-00 00:00:00'),(2335,'pt_br','event_help_ringnoanswer_info1','Time in milliseconds the agent phone rang until the timeout was reached. The attempt ended without the member picking up the call. Bad queue member!',1,'0000-00-00 00:00:00'),(2336,'pt_br','event_help_pause_info1','Pause reason if any',1,'0000-00-00 00:00:00'),(2337,'pt_br','event_help_exitwithtimeout_info3','Amount of time the caller waited in the queue.',1,'0000-00-00 00:00:00'),(2338,'pt_br','event_help_exitwithtimeout_info2','Original position at which the called entered the queue.',1,'0000-00-00 00:00:00'),(2339,'pt_br','event_help_exitwithtimeout_info1','The position the caller was when exiting the queue.',1,'0000-00-00 00:00:00'),(2340,'pt_br','event_help_exitwithkey_info2','The caller&#39;s position.',1,'0000-00-00 00:00:00'),(2341,'pt_br','event_help_exitwithkey_info1','The caller elected to use a menu key to exit the queue.',1,'0000-00-00 00:00:00'),(2342,'pt_br','event_help_exitempty_info3','The waittime is how long the call had been waiting in the queue at the time of disconnect.',1,'0000-00-00 00:00:00'),(2343,'pt_br','event_help_exitempty_info2','The origposition is the original position the caller was when they first entered the queue.',1,'0000-00-00 00:00:00'),(2344,'pt_br','event_help_exitempty_info1','The position is the caller&#39;s position in the queue when they hungup.',1,'0000-00-00 00:00:00'),(2345,'pt_br','event_help_enterqueue_info3','The original position the caller was positioned when they first entered the queue.',1,'0000-00-00 00:00:00'),(2346,'pt_br','event_help_enterqueue_info2','Caller ID',1,'0000-00-00 00:00:00'),(2347,'pt_br','event_help_enterqueue_info1','URL parameter',1,'0000-00-00 00:00:00'),(2348,'pt_br','event_help_connect_info3','Ringtime represents the time the queue members phone was ringing prior to being answered.',1,'0000-00-00 00:00:00'),(2349,'pt_br','event_help_connect_info2','The bridged channel unique ID contains the unique ID of the queue member channel that is taking the call.',1,'0000-00-00 00:00:00'),(2350,'pt_br','event_help_connect_info1','Hold time represents the amount of time the caller was on hold.',1,'0000-00-00 00:00:00'),(2351,'pt_br','event_help_completecaller_info3','The caller&#39;s original position in the queue is recorded in origposition.',1,'0000-00-00 00:00:00'),(2352,'pt_br','event_help_completecaller_info2','The length of the call.',1,'0000-00-00 00:00:00'),(2353,'pt_br','event_help_completecaller_info1','The caller&#39;s hold time',1,'0000-00-00 00:00:00'),(2354,'pt_br','event_help_completeagent_info3','The caller&#39;s original position in the queue is recorded in origposition.',1,'0000-00-00 00:00:00'),(2355,'pt_br','event_help_completeagent_info2','The length of the call.',1,'0000-00-00 00:00:00'),(2356,'pt_br','event_help_completeagent_info1','The caller&#39;s hold time.',1,'0000-00-00 00:00:00'),(2357,'pt_br','event_help_agentcallbacklogoff_info3','The reason for the logoff if it was not a normal logoff (e.g., Autologoff, Chanunavail)',1,'0000-00-00 00:00:00'),(2358,'pt_br','event_help_agentlogin_info1','The agent logged in. The channel is recorded.',1,'0000-00-00 00:00:00'),(2359,'pt_br','event_help_agentlogoff_info1','The agent logged off.',1,'0000-00-00 00:00:00'),(2360,'pt_br','event_help_agentlogoff_info2','The total time the agent was logged in.',1,'0000-00-00 00:00:00'),(2361,'pt_br','event_help_agentcallbacklogoff_info2','The last login extension and context is recorded, along with the total time the agent was logged in.',1,'0000-00-00 00:00:00'),(2362,'pt_br','event_help_agentcallbacklogoff_info1','The callback agent logged off.',1,'0000-00-00 00:00:00'),(2363,'pt_br','event_help_agentcallbacklogin_info1','The callback agent logged in. The login extension and context is recorded.',1,'0000-00-00 00:00:00'),(2364,'pt_br','event_help_abandon_info3','The waittime is how long the call had been waiting in the queue at the time of disconnect.',1,'0000-00-00 00:00:00'),(2365,'pt_br','event_help_abandon_info2','The original position the caller was positioned when they first entered the queue.',1,'0000-00-00 00:00:00'),(2366,'pt_br','event_help_abandon_info1','The position is the caller&#39;s position in the queue when they hungup.',1,'0000-00-00 00:00:00'),(2367,'pt_br','You must select at least one queue','Você deve selecionar pelo menos uma fila',0,'0000-00-00 00:00:00'),(2368,'pt_br','You must select at least one agent','Você deve selecionar pelo menos um agente',0,'0000-00-00 00:00:00'),(2369,'pt_br','You do not have enough privileges to access this resource','Você não tem privilégios suficientes para aceder a este recurso',0,'0000-00-00 00:00:00'),(2370,'pt_br','Total Session Time','Tempo Total da Sessão',0,'2012-10-02 17:17:24'),(2371,'pt_br','Time','Tempo',0,'2012-10-02 17:17:24'),(2372,'pt_br','There is no valid license file on this installation yet.','There is no valid license file on this installation yet.',1,'0000-00-00 00:00:00'),(2373,'pt_br','Spy','Espiar',0,'0000-00-00 00:00:00'),(2374,'pt_br','TRANSFER','Transferência',0,'2012-10-02 17:17:24'),(2375,'pt_br','Shortest Session Time','Menor tempo de sessão',0,'2012-10-02 17:17:24'),(2376,'pt_br','Sessions','Sessões',0,'2012-10-02 17:17:24'),(2377,'pt_br','Session Time','Duração da Sessão',0,'2012-10-02 17:17:24'),(2379,'pt_br','Seconds','Segundos',0,'0000-00-00 00:00:00'),(2380,'pt_br','Select some options','Selecione algumas opções',0,'0000-00-00 00:00:00'),(2381,'pt_br','Revoke Current License','Revogar Licença',0,'0000-00-00 00:00:00'),(2382,'pt_br','Records imported','Registros importados',0,'0000-00-00 00:00:00'),(2383,'pt_br','Revoke','Revogar',0,'0000-00-00 00:00:00'),(2384,'pt_br','Record deleted','Registros deletados',0,'0000-00-00 00:00:00'),(2385,'pt_br','Reactivate','Reativar',0,'0000-00-00 00:00:00'),(2386,'pt_br','RINGNOANSWER','Failed to Answer Call',1,'2012-10-02 17:17:24'),(2387,'pt_br','Proceed','Prosseguir',0,'0000-00-00 00:00:00'),(2388,'pt_br','Please copy the above text and send it via email to %s for processing, together with your activation code and the licensee name you want to use','Por favor, copie o texto acima e enviá-lo por e-mail a %s para processamento, juntamente com seu código de ativação eo nome licenciado que pretende utilizar',0,'0000-00-00 00:00:00'),(2389,'pt_br','Pauses per Session','Pausas por Sessão',0,'2012-10-02 17:17:24'),(2390,'pt_br','Pauses','Pausas',0,'2012-10-02 17:17:24'),(2391,'pt_br','OK','OK',0,'0000-00-00 00:00:00'),(2392,'pt_br','Pause Time','Duração da Pausa',0,'2012-10-02 17:17:24'),(2393,'pt_br','Number of Agents','Número de Agentes',0,'2012-10-02 17:17:24'),(2394,'pt_br','Notice','Aviso',0,'0000-00-00 00:00:00'),(2395,'pt_br','No valid fields to import!','No valid fields to import!',1,'0000-00-00 00:00:00'),(2396,'pt_br','No results','Nenhum resultado',0,'0000-00-00 00:00:00'),(2397,'pt_br','No active channel','Nenhum canal ativo',0,'0000-00-00 00:00:00'),(2398,'pt_br','Longest Session','Sessão mais longa',0,'2012-10-02 17:17:24'),(2399,'pt_br','License validation problem','Problema de validação de licença',0,'0000-00-00 00:00:00'),(2400,'pt_br','License Handling','Manipulação de Licença',0,'0000-00-00 00:00:00'),(2401,'pt_br','Ignoring field ','Ignoring field ',1,'0000-00-00 00:00:00'),(2402,'pt_br','Generate Offline License Request','Gerar Solicitação de Licença Desligada ',0,'0000-00-00 00:00:00'),(2403,'pt_br','Generate','Gerar',0,'0000-00-00 00:00:00'),(2404,'pt_br','EXITWITHKEY','Saída com tecla',0,'0000-00-00 00:00:00'),(2405,'pt_br','Empty file?','Arquivo vazio?',0,'0000-00-00 00:00:00'),(2406,'pt_br','Back','Voltar',0,'0000-00-00 00:00:00'),(2407,'pt_br','Bad username or password','Nome de usuário ou senha ruim',0,'0000-00-00 00:00:00'),(2408,'pt_br','Avg. Session','Média de sessões',0,'2012-10-02 17:17:24'),(2409,'pt_br','Avg. Session Time','Sessões - Tempo Medio',0,'2012-10-02 17:17:24'),(2410,'pt_br','Avg. Paused','Pausa - Tempo Medio',0,'2012-10-02 17:17:24'),(2411,'pt_br','Average Session Time','Sessões - Tempo Medio',0,'2012-10-02 17:17:24'),(2412,'pt_br','Available Variables','Variáveis Disponíveis',0,'0000-00-00 00:00:00'),(2413,'pt_br','Available Keywords','Palavras-chave Disponíveis',0,'0000-00-00 00:00:00'),(2414,'pt_br','Agent Totals','Total Agentes',0,'2012-10-02 17:17:24'),(2415,'pt_br','%s secs','%s segs',0,'0000-00-00 00:00:00'),(2416,'pt_br','%s minutes','%s minutos',0,'0000-00-00 00:00:00'),(2417,'pt_br','%s %%','%s %%',0,'0000-00-00 00:00:00'),(2418,'pt_br','%s','%s',0,'2012-10-02 17:17:24'),(2419,'pt_br','%% Paused','%% Pausado',0,'2012-10-02 17:17:24'),(2420,'es','on %s since %s seconds ago','en %s desde hace %s segundos',0,'0000-00-00 00:00:00'),(2421,'es','There is no valid license file on this installation yet.','No hay licencia válida para esta instalación.',0,'0000-00-00 00:00:00'),(2422,'es','Could not copy uploaded file','No pude copiar el archivo subido',0,'0000-00-00 00:00:00'),(2423,'es','Empty file?','Archivo vacío?',0,'0000-00-00 00:00:00'),(2424,'es','Ignoring field ','Ignorando el campo',0,'0000-00-00 00:00:00'),(2425,'es','No valid fields to import!','No hay campos válidos para importar',0,'0000-00-00 00:00:00'),(2426,'es','Records imported','Registros Importados',0,'0000-00-00 00:00:00'),(2427,'es','help_text_REALTIME_COLUMN_WIDTHS','Lista separada por comas del ancho de columnas para reportes de tiempo real, el parametro especifica el reporte, por ejemplo &#39;agent&#39;',0,'0000-00-00 00:00:00'),(2428,'en','You do not have enough privileges to access this resource','You do not have enough privileges to access this resource',0,'2012-10-02 05:41:59'),(2429,'ru','%','%',0,'0000-00-00 00:00:00'),(2430,'ru','%%','%%',0,'0000-00-00 00:00:00'),(2431,'ru','%% Answ','%% Отвеченных',0,'0000-00-00 00:00:00'),(2432,'ru','%% Calls','%% Вызовов',0,'0000-00-00 00:00:00'),(2433,'ru','%% Paused','%% Приостановленных',0,'0000-00-00 00:00:00'),(2434,'ru','%% Talk Time','%% Продолжительности разговора',0,'0000-00-00 00:00:00'),(2435,'ru','%% Unansw','%% Неотвеченных',0,'0000-00-00 00:00:00'),(2436,'ru','%s','%в',0,'0000-00-00 00:00:00'),(2437,'ru','%s %%','%в %%',0,'0000-00-00 00:00:00'),(2438,'ru','%s days','%s дней',0,'0000-00-00 00:00:00'),(2439,'ru','%s min. ago','%s минут назад',0,'0000-00-00 00:00:00'),(2440,'ru','%s minutes','%s минут',0,'0000-00-00 00:00:00'),(2441,'ru','%s records deleted','%s удаленных записей',0,'0000-00-00 00:00:00'),(2442,'ru','%s secs','%s секунд',0,'0000-00-00 00:00:00'),(2443,'ru','ABANDON','Несостоявшийся',0,'0000-00-00 00:00:00'),(2444,'ru','ALL','ВСЕГО',0,'0000-00-00 00:00:00'),(2445,'ru','Abandon Avg Queue Position at Disconnection','Среднее положение в очереди до отмены вызова во время разъединения Abandon Avg Queue Position at Disconnection',0,'0000-00-00 00:00:00'),(2446,'ru','Abandon Avg Queue Start Position','Среднее начальное положение в очереди до отмены вызова Abandon Avg Queue Start Position',0,'0000-00-00 00:00:00'),(2447,'ru','Abandon Avg Wait Before Disconnection','Среднее время ожидания отмены вызова до разъединения',0,'0000-00-00 00:00:00'),(2448,'ru','Abandon Rate','Частота отмены вызовов',0,'0000-00-00 00:00:00'),(2449,'ru','Abandoned','Несостоявшийся',0,'0000-00-00 00:00:00'),(2450,'ru','Abandoned Calls','Несостоявшиеся вызовы',0,'0000-00-00 00:00:00'),(2451,'ru','Actions','Действия',0,'0000-00-00 00:00:00'),(2452,'ru','Active','Активировать',0,'0000-00-00 00:00:00'),(2453,'ru','Add','Добавить',0,'0000-00-00 00:00:00'),(2454,'ru','Add Record','Добавить запись',0,'0000-00-00 00:00:00'),(2455,'ru','Agent','Оператор',0,'0000-00-00 00:00:00'),(2456,'ru','Agent Status','Статус оператора',0,'0000-00-00 00:00:00'),(2457,'ru','Agent Totals','Всего операторов',0,'0000-00-00 00:00:00'),(2458,'ru','Agents','Операторы',0,'0000-00-00 00:00:00'),(2459,'ru','Alert','Уведомление',0,'0000-00-00 00:00:00'),(2460,'ru','Alerts','Уведомления',0,'0000-00-00 00:00:00'),(2461,'ru','All %s records are selected.','Все записи выбраны.',0,'0000-00-00 00:00:00'),(2462,'ru','All %s records on this page are selected.','Все записи на странице выбраны.',0,'0000-00-00 00:00:00'),(2463,'ru','An error has occurred','Произошла ошибка',0,'0000-00-00 00:00:00'),(2464,'ru','Answer','Ответить',0,'0000-00-00 00:00:00'),(2465,'ru','Answered','Отвеченный вызов',0,'0000-00-00 00:00:00'),(2466,'ru','Answered Calls','Отвеченные вызовы',0,'0000-00-00 00:00:00'),(2467,'ru','Answered by Day','Отвеченные вызовы по дням',0,'0000-00-00 00:00:00'),(2468,'ru','Answered/Abandoned','Отвеченный/Несостоявшийся',0,'0000-00-00 00:00:00'),(2469,'ru','Answered/Abandoned per Hour','Количество отвеченных/несостоявшихся вызовов в час',0,'0000-00-00 00:00:00'),(2470,'ru','April','Апрель',0,'0000-00-00 00:00:00'),(2471,'ru','Are you sure?','Вы уверены?',0,'0000-00-00 00:00:00'),(2472,'ru','August','Август',0,'0000-00-00 00:00:00'),(2473,'ru','Available','Доступные',0,'0000-00-00 00:00:00'),(2474,'ru','Available Keywords','Доступные ключевые слова',0,'0000-00-00 00:00:00'),(2475,'ru','Available Variables','Доступные значения',0,'0000-00-00 00:00:00'),(2476,'ru','Average Duration by Day','Средняя продолжительность в день',0,'0000-00-00 00:00:00'),(2477,'ru','Average Session Time','Среднее время обработки вызова',0,'0000-00-00 00:00:00'),(2478,'ru','Average Wait Time by Day','Среднее время ожидания в день',0,'0000-00-00 00:00:00'),(2479,'ru','Avg Duration','Средняя продолжительность',0,'0000-00-00 00:00:00'),(2480,'ru','Avg Talk','Среднее время разговора',0,'0000-00-00 00:00:00'),(2481,'ru','Avg Talk Time','Среднее время разговора',0,'0000-00-00 00:00:00'),(2482,'ru','Avg Wait','Среднее время ожидания',0,'0000-00-00 00:00:00'),(2483,'ru','Avg Wait Time','Среднее время ожидания',0,'0000-00-00 00:00:00'),(2484,'ru','Avg. Paused','Среднее количество приостановленных вызовов',0,'0000-00-00 00:00:00'),(2485,'ru','Avg. Session','Среднее время обработки вызова',0,'0000-00-00 00:00:00'),(2486,'ru','Avg. Session Time','Среднее время обработки вызова',0,'0000-00-00 00:00:00'),(2487,'ru','Back','Назад',0,'0000-00-00 00:00:00'),(2488,'ru','Bad username or password','Неверное имя пользователя или пароль',0,'0000-00-00 00:00:00'),(2489,'ru','Busy','Занято',0,'0000-00-00 00:00:00'),(2490,'ru','COMPLETEAGENT','Завершено оператором Complete by Agent',0,'0000-00-00 00:00:00'),(2491,'ru','COMPLETECALLER','Завершено абонентом Complete by Caller',0,'0000-00-00 00:00:00'),(2492,'ru','Caller ID','Идентификатор абонента',0,'0000-00-00 00:00:00'),(2493,'ru','Calls','Звонки',0,'0000-00-00 00:00:00'),(2494,'ru','Calls Waiting Detail','Информация о вызовах, находящихся в ожидании',0,'0000-00-00 00:00:00'),(2495,'ru','Cancel','Отмена',0,'0000-00-00 00:00:00'),(2496,'ru','Cannot steal call. realtime_spy_extension for user <b>%s</b> is not defined in Setup/Preferences.','Невозможно перехватить вызов. Параметр realtime_spy_extension для пользователя <b>%s</b> не задан в разделе \"Установки/Настройки\".',0,'0000-00-00 00:00:00'),(2497,'ru','Clear Selection','Снять выделение',0,'0000-00-00 00:00:00'),(2498,'ru','Click to add text','Нажмите, чтобы добавить текст',0,'0000-00-00 00:00:00'),(2499,'ru','Click to edit...','Нажмите, чтобы отредактировать',0,'0000-00-00 00:00:00'),(2500,'ru','Click to view calls in detail','Нажмите, чтобы просмотреть описание вызова',0,'0000-00-00 00:00:00'),(2501,'ru','Coach','Инструктор',0,'0000-00-00 00:00:00'),(2502,'ru','Completed','Завершено',0,'0000-00-00 00:00:00'),(2503,'ru','Confirm','Подтвердить',0,'0000-00-00 00:00:00'),(2504,'ru','Could not connect to the Asterisk Manager Interface to retrieve status information. Please check your manager credentials in config.php and verify they match your settings in /etc/asterisk/manager.conf','Не удалось соединиться с Asterisk Manager Interface для получения информации о статусе. Пожалуйста, проверьте Ваши учетные данные в файле config.php и убедитесь, что они соответствуют данным, указанным в файле /etc/asterisk/manager.conf.',0,'0000-00-00 00:00:00'),(2505,'ru','Count','Подсчитать',0,'0000-00-00 00:00:00'),(2506,'ru','Cron Configuration','Конфигурация планировщика',0,'0000-00-00 00:00:00'),(2507,'ru','Date','Дата',0,'0000-00-00 00:00:00'),(2508,'ru','Day','День',0,'0000-00-00 00:00:00'),(2509,'ru','December','Декабрь',0,'0000-00-00 00:00:00'),(2510,'ru','Delete','Удалить',0,'0000-00-00 00:00:00'),(2511,'ru','Delete Marked','Удалить отмеченные',0,'0000-00-00 00:00:00'),(2512,'ru','Delta','Разница',0,'0000-00-00 00:00:00'),(2513,'ru','Deselects all','Удалить все',0,'0000-00-00 00:00:00'),(2514,'ru','Deselects marked','Удалить отмеченные',0,'0000-00-00 00:00:00'),(2515,'ru','Display Report','Показать отчет',0,'0000-00-00 00:00:00'),(2516,'ru','Distribution','Распределение вызовов',0,'0000-00-00 00:00:00'),(2517,'ru','Download','Загрузить',0,'0000-00-00 00:00:00'),(2518,'ru','Duration','Продолжительность',0,'0000-00-00 00:00:00'),(2519,'ru','EXITWITHKEY','Выход по нажатию клавиши',0,'0000-00-00 00:00:00'),(2520,'ru','EXITWITHTIMEOUT','Время ожидания истекло',0,'0000-00-00 00:00:00'),(2521,'ru','Edit Email Alert','Редактировать уведомление электронной почтой',0,'0000-00-00 00:00:00'),(2522,'ru','Edit Record','Редактировать запись',0,'0000-00-00 00:00:00'),(2523,'ru','Edit Scheduled Report','Редактировать запланированный отчет',0,'0000-00-00 00:00:00'),(2524,'ru','Email','Email',0,'0000-00-00 00:00:00'),(2525,'ru','End Date','Дата окончания',0,'0000-00-00 00:00:00'),(2526,'ru','End Position','Конечная позиция',0,'0000-00-00 00:00:00'),(2527,'ru','Error inserting record:<br/>','Ошибка внесения записи:<br/>',0,'0000-00-00 00:00:00'),(2528,'ru','Error updating record','Ошибка обновления записи',0,'0000-00-00 00:00:00'),(2529,'ru','Event','Событие',0,'0000-00-00 00:00:00'),(2530,'ru','Example','Например',0,'0000-00-00 00:00:00'),(2531,'ru','Export','Экспортировать',0,'0000-00-00 00:00:00'),(2532,'ru','Exports the data to a .pdf file','Экспортирует данные в файл .pdf',0,'0000-00-00 00:00:00'),(2533,'ru','Exports the data to a comma separated file, to be read by your spreadsheet software','Экспортирует данные в файл с разделением значений запятыми для последующего использования программами для работы с электронными таблицами.',0,'0000-00-00 00:00:00'),(2534,'ru','February','Февраль',0,'0000-00-00 00:00:00'),(2535,'ru','Filter','Фильтр',0,'0000-00-00 00:00:00'),(2536,'ru','Filter report by Caller Id','Отсортировать отчет по индентификатору абонента',0,'0000-00-00 00:00:00'),(2537,'ru','First','Первая',0,'0000-00-00 00:00:00'),(2538,'ru','Friday','Пятница',0,'0000-00-00 00:00:00'),(2539,'ru','From','От',0,'0000-00-00 00:00:00'),(2540,'ru','From the last (X) days','За последние (X) дней',0,'0000-00-00 00:00:00'),(2541,'ru','Generate Offline License Request','Генерирует автономный запрос на лицензию.',0,'0000-00-00 00:00:00'),(2542,'ru','Goes to the top of the page','Переходит на начало страницы',0,'0000-00-00 00:00:00'),(2543,'ru','Group by Queue','Сгруппировать по очереди',0,'0000-00-00 00:00:00'),(2544,'ru','Help','Справка',0,'0000-00-00 00:00:00'),(2545,'ru','Hide Logged off','Скрыть незарегистрированных операторов',0,'0000-00-00 00:00:00'),(2546,'ru','Higher ...','Последующие...',0,'0000-00-00 00:00:00'),(2547,'ru','Home','Главная страница',0,'0000-00-00 00:00:00'),(2548,'ru','Hour','Час',0,'0000-00-00 00:00:00'),(2549,'ru','Hour Range','Диапазон часов',0,'0000-00-00 00:00:00'),(2550,'ru','Hours','Час',0,'0000-00-00 00:00:00'),(2551,'ru','ISO Code','Код ISO',0,'0000-00-00 00:00:00'),(2552,'ru','If the field value is higher than this number you will receive an alerting email','Если значение поля выше заданного числа, Вы получите предупреждение по электронной почте.',0,'0000-00-00 00:00:00'),(2553,'ru','Import','Импортировать',0,'0000-00-00 00:00:00'),(2554,'ru','In order to receive scheduled reports or alerts via email, you must setup a cron job in the server. You can use the following command in your server command line:<br/><br/>crontab -e<br/><br/>and add the following line (replacing the user and password with a valid user/password):<br/><br/>','Чтобы получать запланированные отчеты или уведомления электронной почтой, Вам необходимо настроить работу планировщика на сервере. Для этого в командной строке (на сервере) введите следующую команду: <br/><br/>crontab -e<br/><br/> и добавьте следующую строку (вместо user и password введите действующие имя пользователя и пароль): <br/><br/> .',0,'0000-00-00 00:00:00'),(2555,'ru','Incompleted Calls','Незавершенные вызовы',0,'0000-00-00 00:00:00'),(2556,'ru','Invalid Date','Недопустимая дата',0,'0000-00-00 00:00:00'),(2557,'ru','Invalid Hour','Недопустимый час',0,'0000-00-00 00:00:00'),(2558,'ru','January','Январь',0,'0000-00-00 00:00:00'),(2559,'ru','July','Июль',0,'0000-00-00 00:00:00'),(2560,'ru','June','Июнь',0,'0000-00-00 00:00:00'),(2561,'ru','Last','Последняя',0,'0000-00-00 00:00:00'),(2562,'ru','Last in Call','Последний оператор вызова',0,'0000-00-00 00:00:00'),(2563,'ru','Last three months','Последние три месяца',0,'0000-00-00 00:00:00'),(2564,'ru','Level','Права доступа',0,'0000-00-00 00:00:00'),(2565,'ru','License Handling','Обработка лицензии',0,'0000-00-00 00:00:00'),(2566,'ru','License validation problem','Ошибка проверки лицензии',0,'0000-00-00 00:00:00'),(2567,'ru','Licensed to','Лицензия выдана для',0,'0000-00-00 00:00:00'),(2568,'ru','Listen','Прослушать',0,'0000-00-00 00:00:00'),(2569,'ru','Loading','Идет загрузка',0,'0000-00-00 00:00:00'),(2570,'ru','Logged Off','Вышел из системы',0,'0000-00-00 00:00:00'),(2571,'ru','Login','Логин',0,'0000-00-00 00:00:00'),(2572,'ru','Login Form','Форма регистрации',0,'0000-00-00 00:00:00'),(2573,'ru','Logins','Имя пользователя',0,'0000-00-00 00:00:00'),(2574,'ru','Logoff','Выход из системы',0,'0000-00-00 00:00:00'),(2575,'ru','Logout','Выйти',0,'0000-00-00 00:00:00'),(2576,'ru','Longest Session','Максимальная длительность вызова',0,'0000-00-00 00:00:00'),(2577,'ru','Lower ...','Предыдущие...',0,'0000-00-00 00:00:00'),(2578,'ru','March','Март',0,'0000-00-00 00:00:00'),(2579,'ru','Max Callers','Максимальное количество абонентов',0,'0000-00-00 00:00:00'),(2580,'ru','Max Wait Time','Максимальное время ожидания',0,'0000-00-00 00:00:00'),(2581,'ru','Max. wait time','Максимальное время ожидания',0,'0000-00-00 00:00:00'),(2582,'ru','May','Май',0,'0000-00-00 00:00:00'),(2583,'ru','Minutes','Минута',0,'0000-00-00 00:00:00'),(2584,'ru','Monday','Понедельник',0,'0000-00-00 00:00:00'),(2585,'ru','Month','Месяц',0,'0000-00-00 00:00:00'),(2586,'ru','Month days','День месяца',0,'0000-00-00 00:00:00'),(2587,'ru','Name','Имя',0,'0000-00-00 00:00:00'),(2588,'ru','New Email Alert','Создать уведомление электронной почтой',0,'0000-00-00 00:00:00'),(2589,'ru','New Scheduled Report','Создать запланированный отчет',0,'0000-00-00 00:00:00'),(2590,'ru','Next','Следующая',0,'0000-00-00 00:00:00'),(2591,'ru','No','Нет',0,'0000-00-00 00:00:00'),(2592,'ru','No active channel','Нет активного канала',0,'0000-00-00 00:00:00'),(2593,'ru','No info','Информация отсутствует',0,'0000-00-00 00:00:00'),(2594,'ru','No records found','Записей не найдено',0,'0000-00-00 00:00:00'),(2595,'ru','No results','Нет результатов',0,'0000-00-00 00:00:00'),(2596,'ru','None','Отсутствует',0,'0000-00-00 00:00:00'),(2597,'ru','Notice','Уведомление',0,'0000-00-00 00:00:00'),(2598,'ru','November','Ноябрь',0,'0000-00-00 00:00:00'),(2599,'ru','Number','Номер',0,'0000-00-00 00:00:00'),(2600,'ru','Number of Abandoned Calls','Количество несостоявшихся вызовов',0,'0000-00-00 00:00:00'),(2601,'ru','Number of Agent Logins','Количество входов оператора в систему',0,'0000-00-00 00:00:00'),(2602,'ru','Number of Agent Logoffs','Количество выходов оператора из системы',0,'0000-00-00 00:00:00'),(2603,'ru','Number of Agents','Количество операторов',0,'0000-00-00 00:00:00'),(2604,'ru','Number of Answered Calls','Количество отвеченных вызовов',0,'0000-00-00 00:00:00'),(2605,'ru','Number of Calls per Agent','Количество вызовов на одного оператора',0,'0000-00-00 00:00:00'),(2606,'ru','Number of Received Calls','Количество принятых вызовов',0,'0000-00-00 00:00:00'),(2607,'ru','Number of Transferred Calls','Количество переадресованных вызовов',0,'0000-00-00 00:00:00'),(2608,'ru','Number of Unanswered Calls','Количество неотвеченных вызовов',0,'0000-00-00 00:00:00'),(2609,'ru','OK','OK',0,'0000-00-00 00:00:00'),(2610,'ru','October','Октябрь',0,'0000-00-00 00:00:00'),(2611,'ru','Overflow','Переполнение',0,'0000-00-00 00:00:00'),(2612,'ru','Page','Страница',0,'0000-00-00 00:00:00'),(2613,'ru','Page parsed in %s seconds','Страница проанализирована %s секунд',0,'0000-00-00 00:00:00'),(2614,'ru','Password','Пароль',0,'0000-00-00 00:00:00'),(2615,'ru','Passwords do not match','Пароли не совпадают',0,'0000-00-00 00:00:00'),(2616,'ru','Pause Time','Длительность паузы',0,'0000-00-00 00:00:00'),(2617,'ru','Paused','Поставлено на паузу',0,'0000-00-00 00:00:00'),(2618,'ru','Pauses','Паузы',0,'0000-00-00 00:00:00'),(2619,'ru','Pauses per Session','Количество пауз во время вызова',0,'0000-00-00 00:00:00'),(2620,'ru','Pending','Ожидание',0,'0000-00-00 00:00:00'),(2621,'ru','Period','Период',0,'0000-00-00 00:00:00'),(2622,'ru','Play','Воспроизвести',0,'0000-00-00 00:00:00'),(2623,'ru','Please copy the above text and send it via email to %s for processing, together with your activation code and the licensee name you want to use','Пожалуйста, скопируйте текст выше и отправьте электронным письмом для обработки. В письме укажите код активации и имя владельца лицензии, которую Вы используете. Please copy the above text and send it via email to %s for processing, together with your activation code and the licensee name you want to use',0,'0000-00-00 00:00:00'),(2624,'ru','Please select the reports to send','Выберите отчеты для отправки',0,'0000-00-00 00:00:00'),(2625,'ru','Please write down destination emails','Введите электронные адреса',0,'0000-00-00 00:00:00'),(2626,'ru','Position','Рабочее место',0,'0000-00-00 00:00:00'),(2627,'ru','Previous','Предыдущая',0,'0000-00-00 00:00:00'),(2628,'ru','Proceed','Продолжить',0,'0000-00-00 00:00:00'),(2629,'ru','Querying data...','Идет запрос данных...',0,'0000-00-00 00:00:00'),(2630,'ru','Queue','Очередь',0,'0000-00-00 00:00:00'),(2631,'ru','Queues','Очереди',0,'0000-00-00 00:00:00'),(2632,'ru','RINGNOANSWER','Не удалось ответить на вызов',0,'0000-00-00 00:00:00'),(2633,'ru','Reactivate','Возобновить',0,'0000-00-00 00:00:00'),(2634,'ru','Realtime','Реальное время',0,'0000-00-00 00:00:00'),(2635,'ru','Received','Получено',0,'0000-00-00 00:00:00'),(2636,'ru','Record deleted','Запись удалена',0,'0000-00-00 00:00:00'),(2637,'ru','Record inserted','Запись вставлена',0,'0000-00-00 00:00:00'),(2638,'ru','Record updated','Запись обновлена',0,'0000-00-00 00:00:00'),(2639,'ru','Report','Отчет',0,'0000-00-00 00:00:00'),(2640,'ru','Reports','Отчеты',0,'0000-00-00 00:00:00'),(2641,'ru','Required field','Обязательное поле',0,'0000-00-00 00:00:00'),(2642,'ru','Revoke','Удалить',0,'0000-00-00 00:00:00'),(2643,'ru','Revoke Current License','Удалить текущую лицензию',0,'0000-00-00 00:00:00'),(2644,'ru','SLA','Соглашение об уровне обслуживания',0,'0000-00-00 00:00:00'),(2645,'ru','Saturday','Суббота',0,'0000-00-00 00:00:00'),(2646,'ru','Save','Сохранить',0,'0000-00-00 00:00:00'),(2647,'ru','Scheduled Reports and Alerts','Запланированные отчеты и уведомления',0,'0000-00-00 00:00:00'),(2648,'ru','Search','Поиск',0,'0000-00-00 00:00:00'),(2649,'ru','Seconds','Секунды',0,'0000-00-00 00:00:00'),(2650,'ru','Select Agents','Выбрать оператора',0,'0000-00-00 00:00:00'),(2651,'ru','Select Date Range','Выбрать диапазон дат',0,'0000-00-00 00:00:00'),(2652,'ru','Select Queues','Выбрать очередь',0,'0000-00-00 00:00:00'),(2653,'ru','Select Time Frame','Выбрать промежуток времени',0,'0000-00-00 00:00:00'),(2654,'ru','Select all %s records.','Выбрать все записи.',0,'0000-00-00 00:00:00'),(2655,'ru','Select an option','Выберите один вариант',0,'0000-00-00 00:00:00'),(2656,'ru','Select language','Выбрать язык',0,'0000-00-00 00:00:00'),(2657,'ru','Select option','Выбрать параметр',0,'0000-00-00 00:00:00'),(2658,'ru','Select some options','Выберите несколько вариантов',0,'0000-00-00 00:00:00'),(2659,'ru','Select the field to compare','Выберите поле для сравнения',0,'0000-00-00 00:00:00'),(2660,'ru','Select the report to check','Выберите отчет для проверки',0,'0000-00-00 00:00:00'),(2661,'ru','Select the report to control','Выберите отчет для управления Select the report to control',0,'0000-00-00 00:00:00'),(2662,'ru','Selected','Выбранные',0,'0000-00-00 00:00:00'),(2663,'ru','Selects all','Выбрать все',0,'0000-00-00 00:00:00'),(2664,'ru','Selects marked','Выбрать отмеченные',0,'0000-00-00 00:00:00'),(2665,'ru','Separate with comma ( , )<br>* means all','Разделяются запятой ( , )<br>* - все дни',0,'0000-00-00 00:00:00'),(2666,'ru','September','Сентябрь',0,'0000-00-00 00:00:00'),(2667,'ru','Server Time','Время на сервере',0,'0000-00-00 00:00:00'),(2668,'ru','Session Time','Время обработки вызова',0,'0000-00-00 00:00:00'),(2669,'ru','Sessions','Вызовы',0,'0000-00-00 00:00:00'),(2670,'ru','Setup','Настройки',0,'0000-00-00 00:00:00'),(2671,'ru','Shortcuts','Быстрый доступ',0,'0000-00-00 00:00:00'),(2672,'ru','Shortest Session Time','Минимальная длительность вызова',0,'0000-00-00 00:00:00'),(2673,'ru','Spy','Подслушать',0,'0000-00-00 00:00:00'),(2674,'ru','Start Date','Дата начала',0,'0000-00-00 00:00:00'),(2675,'ru','Start Position','Начальная позиция',0,'0000-00-00 00:00:00'),(2676,'ru','State','Состояние',0,'0000-00-00 00:00:00'),(2677,'ru','Steal','Перехватить',0,'0000-00-00 00:00:00'),(2678,'ru','String','Строка',0,'0000-00-00 00:00:00'),(2679,'ru','Success!','Завершено успешно!',0,'0000-00-00 00:00:00'),(2680,'ru','Sunday','Воскресенье',0,'0000-00-00 00:00:00'),(2681,'ru','TRANSFER','Transfer',0,'0000-00-00 00:00:00'),(2682,'ru','Talk Time','Время разговора',0,'0000-00-00 00:00:00'),(2683,'ru','There is no valid license file on this installation yet.','Отсутствует файл действующей лицензии. There is no valid license file on this installation yet.',0,'0000-00-00 00:00:00'),(2684,'ru','This month','Текущий месяц',0,'0000-00-00 00:00:00'),(2685,'ru','This week','Текущая неделя',0,'0000-00-00 00:00:00'),(2686,'ru','Thursday','Четверг',0,'0000-00-00 00:00:00'),(2687,'ru','Time','Время',0,'0000-00-00 00:00:00'),(2688,'ru','To','До',0,'0000-00-00 00:00:00'),(2689,'ru','Today','Сегодня',0,'0000-00-00 00:00:00'),(2690,'ru','Toggle Search Form','Форма поиска по меткам',0,'0000-00-00 00:00:00'),(2691,'ru','Total','Всего',0,'0000-00-00 00:00:00'),(2692,'ru','Total Answered Calls','Всего отвеченных вызовов',0,'0000-00-00 00:00:00'),(2693,'ru','Total Calls','Всего вызовов',0,'0000-00-00 00:00:00'),(2694,'ru','Total Duration','Общая продолжительность',0,'0000-00-00 00:00:00'),(2695,'ru','Total Session Time','Общее время обработки вызова',0,'0000-00-00 00:00:00'),(2696,'ru','Total Time per Agent (seconds)','Общее время разговора для каждого оператора (в секундах)',0,'0000-00-00 00:00:00'),(2697,'ru','Total Unanswered Calls','Всего неотвеченных вызовов',0,'0000-00-00 00:00:00'),(2698,'ru','Total records found','Всего найдено записей',0,'0000-00-00 00:00:00'),(2699,'ru','Transfered Calls','Переадресованные вызовы',0,'0000-00-00 00:00:00'),(2700,'ru','Transferred','Переадресован',0,'0000-00-00 00:00:00'),(2701,'ru','Transferred Calls','Переадресованные вызовы',0,'0000-00-00 00:00:00'),(2702,'ru','Translation','Перевод',0,'0000-00-00 00:00:00'),(2703,'ru','Tuesday','Вторник',0,'0000-00-00 00:00:00'),(2704,'ru','Type','Тип',0,'0000-00-00 00:00:00'),(2705,'ru','URL','URL-адрес',0,'0000-00-00 00:00:00'),(2706,'ru','Unanswered','Неотвеченные вызовы',0,'0000-00-00 00:00:00'),(2707,'ru','Unanswered Calls','Неотвеченные вызовы',0,'0000-00-00 00:00:00'),(2708,'ru','Unanswered Rate','Частота неотвеченных вызовов',0,'0000-00-00 00:00:00'),(2709,'ru','Unanswered by Day','Неотвеченные за день',0,'0000-00-00 00:00:00'),(2710,'ru','Use comma to separate emails','Для разделения нескольких электронных адресов используйте запятую.',0,'0000-00-00 00:00:00'),(2711,'ru','User','Пользователь',0,'0000-00-00 00:00:00'),(2712,'ru','View Record','Просмотреть запись',0,'0000-00-00 00:00:00'),(2713,'ru','Wait Time','Время ожидания',0,'0000-00-00 00:00:00'),(2714,'ru','Waiting','Ожидание',0,'0000-00-00 00:00:00'),(2715,'ru','Wednesday','Среда',0,'0000-00-00 00:00:00'),(2716,'ru','Week','Неделя',0,'0000-00-00 00:00:00'),(2717,'ru','Week days','День недели',0,'0000-00-00 00:00:00'),(2718,'ru','Write down the value to compare','Введите значение для сравнения',0,'0000-00-00 00:00:00'),(2719,'ru','Yes','Да',0,'0000-00-00 00:00:00'),(2720,'ru','You must select at least one agent','Необходимо выбрать хотя бы одного оператора',0,'0000-00-00 00:00:00'),(2721,'ru','You must select at least one queue','Необходимо выбрать хотя бы одну очередь',0,'0000-00-00 00:00:00'),(2722,'ru','admin-acl','Контроль доступа',0,'0000-00-00 00:00:00'),(2723,'ru','admin-designer','Конструктор отчетов',0,'0000-00-00 00:00:00'),(2724,'ru','admin-language','Перевод',0,'0000-00-00 00:00:00'),(2725,'ru','admin-schedule','Отчеты/Уведомления',0,'0000-00-00 00:00:00'),(2726,'ru','admin-setup','Параметры',0,'0000-00-00 00:00:00'),(2727,'ru','admin-users','Пользователи',0,'0000-00-00 00:00:00'),(2728,'ru','agent-dialout','Идет набор номера',0,'0000-00-00 00:00:00'),(2729,'ru','agent-not in use','Не используется',0,'0000-00-00 00:00:00'),(2730,'ru','agent_availability','Занятость оператора',0,'0000-00-00 00:00:00'),(2731,'ru','agent_detail','Полный отчет оператора',0,'0000-00-00 00:00:00'),(2732,'ru','agent_dispositions','Распоряжение вызова (Результат обработки вызова) оператором ',0,'0000-00-00 00:00:00'),(2733,'ru','agent_durations','Продолжительность вызовов и пауз оператора',0,'0000-00-00 00:00:00'),(2734,'ru','agent_pauses','Информация о паузе',0,'0000-00-00 00:00:00'),(2735,'ru','agent_summary','Сводка операторов',0,'0000-00-00 00:00:00'),(2736,'ru','all month','весь месяц',0,'0000-00-00 00:00:00'),(2737,'ru','answered_calls_by_agent','оператором',0,'0000-00-00 00:00:00'),(2738,'ru','answered_calls_by_duration','Отвеченные по длительности вызова',0,'0000-00-00 00:00:00'),(2739,'ru','answered_calls_by_event','Причина разъединения',0,'0000-00-00 00:00:00'),(2740,'ru','answered_calls_by_holdtime','Уровень обслуживания',0,'0000-00-00 00:00:00'),(2741,'ru','answered_calls_by_queue','в очереди',0,'0000-00-00 00:00:00'),(2742,'ru','answered_calls_by_url','по URL-адресу',0,'0000-00-00 00:00:00'),(2743,'ru','answered_calls_detail','Описание отвеченных вызовов',0,'0000-00-00 00:00:00'),(2744,'ru','answered_calls_summary','Сводка отвеченных вызовов',0,'0000-00-00 00:00:00'),(2745,'ru','answered_calls_transferred','Переадресованный вызов',0,'0000-00-00 00:00:00'),(2746,'ru','at hour','в час',0,'0000-00-00 00:00:00'),(2747,'ru','at minute','в минуту',0,'0000-00-00 00:00:00'),(2748,'ru','calls','вызовы',0,'0000-00-00 00:00:00'),(2749,'ru','day','день',0,'0000-00-00 00:00:00'),(2750,'ru','disposition_help_ABANDON','Абонент отменил позицию в очереди. Позицией является позиция абонента в очереди после завершения вызова. Исходной позицией является исходная позиция абонента в тот момент, когда вызов впервые попал в очередь. Время ожидания - это общее время, которое вызов ожидал в очереди до момента отключения от системы. The caller abandoned their position in the queue. The position is the\r\ncaller&rsquo;s position in the queue when they hungup, the origposition is\r\nthe original position the caller was when they first entered the\r\nqueue, and the waittime is how long the call had been waiting in the\r\nqueue at the time of disconnect.',0,'0000-00-00 00:00:00'),(2751,'ru','disposition_help_COMPLETEAGENT','Абонент был соединен с оператором, вызов был завершен в обычном режиме *оператором*. Время удержания и продолжительность вызова сохранены. Исходная позиция абонента в очереди сохранена в origposition. The caller was connected to an agent, and the call was terminated normally\r\nby the *agent*. The caller&lsquo;s hold time and the length of the call are both\r\nrecorded. The caller&lsquo;s original position in the queue is recorded in\r\norigposition.',0,'0000-00-00 00:00:00'),(2752,'ru','disposition_help_COMPLETECALLER','Абонент был соединен с оператором, вызов был завершен в обычном режиме *абонентом*. Время удрежания и продолжительность вызова сохранены. Исходная позиция абонента в очереди сохранена в origposition. The caller was connected to an agent, and the call was terminated normally\r\nby the *caller*. The callers hold time and the length of the call are both\r\nrecorded. The caller&rsquo;s original position in the queue is recorded in\r\norigposition.\r\n',0,'0000-00-00 00:00:00'),(2753,'ru','disposition_help_CONNECT','Абонент соединен с оператором.',0,'0000-00-00 00:00:00'),(2754,'ru','disposition_help_ENTERQUEUE','A caller entered the queue. Three parameters are also written: the URL (if specified) in the Info 1 field and the caller ID of the caller on the Info 2 field, and the original position where the call has landed in the Info 3 field.\r\nВызов поступил в очередь. Записываются три парамтера: в поле Инфо 1 вносится URL-адрес (при наличии), в поле Инфо 2 вносится ID абонента, в поле Инфо 3 вносится начальное положение вызова при поступлении.',0,'0000-00-00 00:00:00'),(2755,'ru','disposition_help_EXITWITEMPTY','Абоненты был отключен от очереди принудительно по причине отсутствия доступных операторов и того, что система настроена таким образом, отключать абонентов при отсутствии доступных операторов. The caller was exited from the queue forcefully because the queue had no\r\nreachable members and it&lsquo;s configured to do that to callers when there\r\nare no reachable members. The position is the caller&lsquo;s position in the\r\nqueue when they hungup, the origposition is the original position the\r\ncaller was when they first entered the queue, and the waittime is how\r\nlong the call had been waiting in the queue at the time of disconnect.',0,'0000-00-00 00:00:00'),(2756,'ru','disposition_help_EXITWITHKEY','Абонент решил воспользоваться кнопками меню для выхода из очереди. Кнопка и позиция абонента в очереди сохранены.  The caller elected to use a menu key to exit the queue. The key and\r\nthe caller&lsquo;s position in the queue are recorded.\r\n',0,'0000-00-00 00:00:00'),(2757,'ru','disposition_help_EXITWITHTIMEOUT','Абонент находился в режиме удержания слишком долго, и время ожидания истекло.',0,'0000-00-00 00:00:00'),(2758,'ru','disposition_help_RINGNOANSWER','Время ожидания ответа от участника очереди превышено. Фиксируется единичный параметр, указывающий общее время, в течение которого звонил добавочнй номер участника очереди, в поле Инфо 1. The timeout value for ringing the queue member was exceeded. A single parameter will also be written indicating the amount of time the member’s extension rang in the Info 1 field.',0,'0000-00-00 00:00:00'),(2759,'ru','disposition_help_TRANSFER','Вызов абонента был переведен на другой добавочный номер. Контекст и добавочный номер сохранены. Время удрежания и продолжительность вызова сохранены. ПОЖАЛУЙСТА, помните о том, что переадресация, выполненая SIP UA&lsquo;s при использовании опции \"повторно\" не всегда распознаются Asterisk и  запуск события. Context and extension\r\nare recorded.The caller&lsquo;s hold time and the length of the call are both\r\nrecorded. PLEASE remember that transfers performed by SIP UA&lsquo;s by way\r\nof a reinvite may not always be caught by Asterisk and trigger off this\r\nevent. Единственным способом для осуществления переадресации участником очереди, при котором Вы можете со 100-процентным результатом получить событие, является использование встроенного функционала переадресации в Фыеукшыл/ The only way to be 100% sure that you will get this event when\r\na transfer is performed by a queue member is to use the built-in transfer\r\nfunctionality of Asterisk.',0,'0000-00-00 00:00:00'),(2760,'ru','distribution_by_day','по дням',0,'0000-00-00 00:00:00'),(2761,'ru','distribution_by_day_of_week','по дням недели',0,'0000-00-00 00:00:00'),(2762,'ru','distribution_by_hour','по часам',0,'0000-00-00 00:00:00'),(2763,'ru','distribution_by_month','по месяцам',0,'0000-00-00 00:00:00'),(2764,'ru','distribution_by_queue','по очереди',0,'0000-00-00 00:00:00'),(2765,'ru','distribution_by_url','по URL-адресу',0,'0000-00-00 00:00:00'),(2766,'ru','distribution_by_week','по неделям',0,'0000-00-00 00:00:00'),(2767,'ru','distribution_detail','Подробный отчет распределения вызовов',0,'0000-00-00 00:00:00'),(2768,'ru','distribution_summary','Сводка распределения вызовов',0,'0000-00-00 00:00:00'),(2769,'ru','event_help_abandon_info1','Позиция - это позиция абонента в очереди после того, как абонент завершил вызов.',0,'0000-00-00 00:00:00'),(2770,'ru','event_help_abandon_info2','Исходная позиция абонента после того, как вызов был направлен в очередь.',0,'0000-00-00 00:00:00'),(2771,'ru','event_help_abandon_info3','Время ожидания - общее время, которое вызов ожида ответа в очереди во время отключения от системы. The waittime is how long the call had been waiting in the queue at the time of disconnect.',0,'0000-00-00 00:00:00'),(2772,'ru','event_help_agentcallbacklogin_info1','Оператор обратной связи вошел в систему. Добавочный номер и контекст сохранены. The callback agent logged in. The login extension and context is recorded.',0,'0000-00-00 00:00:00'),(2773,'ru','event_help_agentcallbacklogoff_info1','Оператор обратных вызовов вышел из системы.',0,'0000-00-00 00:00:00'),(2774,'ru','event_help_agentcallbacklogoff_info2','Последний добавочный номер регистрации и контекст, а также общее время нахождения оператора в системе сохранены.',0,'0000-00-00 00:00:00'),(2775,'ru','event_help_agentcallbacklogoff_info3','Причины выхода из системы, при условии, что это был не обычный выход из системы. (Например, автоматический выход из системы, канал не доступен) The reason for the logoff if it was not a normal logoff (e.g., Autologoff, Chanunavail)',0,'0000-00-00 00:00:00'),(2776,'ru','event_help_agentlogin_info1','Оператор вошел в систему. Канал записывается. The agent logged in. The channel is recorded.',0,'0000-00-00 00:00:00'),(2777,'ru','event_help_agentlogoff_info1','Оператор вышел из системы.',0,'0000-00-00 00:00:00'),(2778,'ru','event_help_agentlogoff_info2','Общее время нахождения оператора в системе.',0,'0000-00-00 00:00:00'),(2779,'ru','event_help_completeagent_info1','Время удержания вызова абонента&#39;.',0,'0000-00-00 00:00:00'),(2780,'ru','event_help_completeagent_info2','Продолжительность вызова.',0,'0000-00-00 00:00:00'),(2781,'ru','event_help_completeagent_info3','Исходная позиция абонента в очереди сохраняется в origposition.',0,'0000-00-00 00:00:00'),(2782,'ru','event_help_completecaller_info1','Время удержания вызова абонента&#39;.',0,'0000-00-00 00:00:00'),(2783,'ru','event_help_completecaller_info2','Продолжительность вызова.',0,'0000-00-00 00:00:00'),(2784,'ru','event_help_completecaller_info3','Исходная позиция абонента сохранена в origposition.',0,'0000-00-00 00:00:00'),(2785,'ru','event_help_connect_info1','Время удержания вызова - общее время нахождения вызова в режиме удержания.',0,'0000-00-00 00:00:00'),(2786,'ru','event_help_connect_info3','Время звонка - промежуток времени между моментом поступления вызова в очередь и моментом, когда на вызов\r\nбыл получен ответ оператора.',0,'0000-00-00 00:00:00'),(2787,'ru','event_help_enterqueue_info1','URL параметр ',0,'0000-00-00 00:00:00'),(2788,'ru','event_help_enterqueue_info2','Идентификатор абонента',0,'0000-00-00 00:00:00'),(2789,'ru','event_help_enterqueue_info3','Исходная позиция абонента при направлении вызова в очередь в первый раз. The original position the caller was positioned when they first entered the queue.',0,'0000-00-00 00:00:00'),(2790,'ru','event_help_exitempty_info1','Позиция абонента в очереди после завершения вызова.',0,'0000-00-00 00:00:00'),(2791,'ru','event_help_exitempty_info2','Origposition - это исходная позиция абонента, когда он в первый раз попал в очередь. is the original position the caller was when they first entered the queue.',0,'0000-00-00 00:00:00'),(2792,'ru','event_help_exitempty_info3','Время ожидания - это общее время, которое вызов ожидал ответа в очереди во время отключения от системы.',0,'0000-00-00 00:00:00'),(2793,'ru','event_help_exitwithkey_info1','Абонент выбрал использование кнопок меню для выхода из очереди.',0,'0000-00-00 00:00:00'),(2794,'ru','event_help_exitwithkey_info2','Позиция абонента.',0,'0000-00-00 00:00:00'),(2795,'ru','event_help_exitwithtimeout_info1','Позиция абонента при выходе из очереди.',0,'0000-00-00 00:00:00'),(2796,'ru','event_help_exitwithtimeout_info2','Исходная позиция абонента при попадании в очередь. Original position at which the called entered the queue.',0,'0000-00-00 00:00:00'),(2797,'ru','event_help_exitwithtimeout_info3','Общее время, которое абонент провел в очереди.',0,'0000-00-00 00:00:00'),(2798,'ru','event_help_pause_info1','Причина постановки вызова на паузу (при наличии)',0,'0000-00-00 00:00:00'),(2799,'ru','event_help_ringnoanswer_info1','Время в миллисекундах, которое звонил телефон оператора до того момента, когда был достигнут лимит ожидания ответа. Попытка дозвона, окончившаяся тем, что оператор не принял вызов. Time in milliseconds the agent phone rang until the timeout was reached. The attempt ended without the member picking up the call. Bad queue member!',0,'0000-00-00 00:00:00'),(2800,'ru','event_help_transfer_info1','Добавочный номер',0,'0000-00-00 00:00:00'),(2801,'ru','event_help_transfer_info2','Контекст',0,'0000-00-00 00:00:00'),(2802,'ru','event_help_transfer_info3','Время удержания вызова абонента&#39;.',0,'0000-00-00 00:00:00'),(2803,'ru','event_help_transfer_info4','Продолжительность вызова.',0,'0000-00-00 00:00:00'),(2804,'ru','event_help_transfer_info5','Позиция абонента во время переадресации вызова.',0,'0000-00-00 00:00:00'),(2805,'ru','event_help_unpause_info1','Причина снятия вызова с паузы (при наличии). ',0,'0000-00-00 00:00:00'),(2806,'ru','every day','каждый день',0,'0000-00-00 00:00:00'),(2807,'ru','every hour','каждый час',0,'0000-00-00 00:00:00'),(2808,'ru','every minute','каждую минуту',0,'0000-00-00 00:00:00'),(2809,'ru','help_text_ACTION','Определяет обработчика действий абонента, таким образом, Вы можете вызвать собственные функции/программы для обработки особых случаев. Вам необходимо создать функцию javascript в файле js/custom.js. При нажатии на иконку события он получит уникальный идентификатор вызова. Define a custom action handler, so you can call your own functions/program to handle special cases. You must create the javascript function in the js/custom.js file. It will receive the unique id of the call when the action icon is clicked.<br/>\r\n<br/>\r\nparameter: position,icon image,Tooltip<br/>\r\nvalue: javascript_function',0,'0000-00-00 00:00:00'),(2810,'ru','help_text_ANSWERED_DISPLAY_GRID','Если диаграмма задается во вкладке отчетов отвеченных вызовов, поле параметра, то используйте ширину сетчатой схемы в качестве настройки в поле значения. Сетка состоит из 12 столбцов: If a chart is defined in the answered reports tab, parameter field, then use the grid layout width as setup in the value field. The grid system has 12 columns in total:<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: width1,width2',0,'0000-00-00 00:00:00'),(2811,'ru','help_text_ANSWERED_DISPLAY_ROWS','Список полей, разделенный запятой, отображающийся в отчетах отвеченных вызовов. Поля определяются как COLUMN_ANSWERED.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields ',0,'0000-00-00 00:00:00'),(2812,'ru','help_text_CHART_ANSWERED','Отображает график на странице отчетов отвеченных вызовов.<br/><br/>\r\n\r\nparameter: position,group field,title<br/>\r\nvalue: field,field',0,'0000-00-00 00:00:00'),(2813,'ru','help_text_CHART_DISTRIBUTION','Отображает график на странице отчетов распределения вызовов. <br/><br/>\r\n\r\nparameter: position,group field,title<br/>\r\nvalue: field,field',0,'0000-00-00 00:00:00'),(2814,'ru','help_text_CHART_SERIES_COLOR','Цвета, используемые для построения диаграмм. Параметром является положение указателя, значением - шестнадцатиричный html цвет. Colors to use for charts. Parameter is the index position, and value the hex html color.',0,'0000-00-00 00:00:00'),(2815,'ru','help_text_CHART_UNANSWERED','Отображает график на странице отчетов неотвеченных вызовов.<br/><br/>\r\n\r\nparameter: position,group field,title<br/>\r\nvalue: field,field',0,'0000-00-00 00:00:00'),(2816,'ru','help_text_COLUMN_ANSWERED','Столбец в отчетах отвеченных вызовов. Вы можете добавить в отчет все столбцы, затем отсортировать их по каждой группе при помощи присвоения нумерации элементам списка ANSWERED_DISPLAY_ROWS.\r\nColumn to show in Answered reports. You can add all the columns you want for a report, then you can filter limit them on each group report by enumerating them in ANSWERED_DISPLAY_ROWS entries.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>\r\n\r\n',0,'0000-00-00 00:00:00'),(2817,'ru','help_text_COLUMN_ANSWERED_FORMAT','Формат отображения значения ячейки в отчетах отвеченных вызовов. Применяются общие правила форматирования печати за исключением часовых значений: {ЧЧ}, {ММ}, {СС}, {мм} и {сс}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nИмя поля параметра задается в качестве поля параметра в The parameter field name must be set as the parameter field on the COLUMN_ANSWERED entry.<br/>\r\nПример форматирования:<br/><br/>\r\nЗначение в секундах переводится в формат ЧЧ:ММ:СС с:<br/>\r\n{ЧЧ}:{ММ}:{СС}\r\n',0,'0000-00-00 00:00:00'),(2818,'ru','help_text_COLUMN_DISTRIBUTION','Столбец в отчетах распределения вызовов. Вы можете добавить в отчет все столбцы, затем отсортировать их по каждой группе при помощи присвоения нумерации элементам списка DISTRIBUTION_DISPLAY_ROWS.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>',0,'0000-00-00 00:00:00'),(2819,'ru','help_text_COLUMN_DISTRIBUTION_FORMAT','Формат отображения значения ячейки в отчетах распределения вызовов. Применяются общие правила форматирования печати за исключением часовых значений: {ЧЧ}, {ММ}, {СС}, {мм} и {сс}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nИмя поля параметра задается в качестве поля параметра в The parameter field name must be set as the parameter field on the COLUMN_DISTRIBUTION entry.<br/>\r\nПример форматирования:<br/><br/>\r\nЗначение в секундах переводится в формат ЧЧ:ММ:СС с:<br/>\r\n{ЧЧ}:{ММ}:{СС}\r\n\r\n',0,'0000-00-00 00:00:00'),(2820,'ru','help_text_COLUMN_REALTIME','Столбец сводки в реальном времени. Вы можете добавить в отчет все столбцы, затем отсортировать их по группам при помощи присвоения нумерации элементам списка REALTIME_DISPLAY_ROWS.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>',0,'0000-00-00 00:00:00'),(2821,'ru','help_text_COLUMN_REALTIME_FORMAT','Format to use for displaying a cell value in the realtime queue summary report.Формат отображения значения ячейки в сводке по очереди в реальном времени. Применяются общие правила форматирования печати за исключением часовых значений: {ЧЧ}, {ММ}, {СС}, {мм} и {сс}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nИмя поля параметра задается в качестве поля параметра в The parameter field name must be set as the parameter field on the COLUMN_REALTIME entry.<br/>\r\nПример форматирования:<br/><br/>\r\nЗначение в секундах переводится в формат ЧЧ:ММ:СС с:<br/>\r\n{ЧЧ}:{ММ}:{СС}\r\n',0,'0000-00-00 00:00:00'),(2822,'ru','help_text_COLUMN_REALTIME_STYLE','Для дополнительного форматирования ячеек в таблице сводок очередей, отображающих информацию в реальном времени, Вы можете использовать HTML-класс или стиль текста. Например:<br/>\r\n<br/>\r\nclass=&quot;bigblue&quot;\r\n<br/>\r\nstyle=&quot;border:1px solid red;&quot;\r\n\r\n',0,'0000-00-00 00:00:00'),(2823,'ru','help_text_COLUMN_UNANSWERED','Столбец в отчете неотвеченных вызовов. Вы можете добавить в отчет все столбцы, затем отсортировать их по группам при помощи присвоения нумерации элементам списка UNANSWERED_DISPLAY_ROWS.<br/>\r\n<br/>\r\nparameter: column name/label<br/>\r\nvalue: variable or formula<br/>',0,'0000-00-00 00:00:00'),(2824,'ru','help_text_COLUMN_UNANSWERED_FORMAT','Формат отображения значения ячейки в отчетах неотвеченных вызовов. Применяются общие правила форматирования печати за исключением часовых значений: {ЧЧ}, {ММ}, {СС}, {мм} и {сс}<br/>\r\n<br/>\r\nparameter: field name<br/>\r\nvalue: format string<br/>\r\n<br/>\r\nИмя поля параметра задается в качестве поля параметра в The parameter field name must be set as the parameter field on the COLUMN_UNANSWERED entry.<br/>\r\nПример форматирования:<br/><br/>\r\nЗначение в секундах переводится в формат ЧЧ:ММ:СС с:<br/>\r\n{ЧЧ}:{ММ}:{СС}\r\n\r\n\r\n',0,'0000-00-00 00:00:00'),(2825,'ru','help_text_DISTRIBUTION_DISPLAY_ROWS','Список полей, разделенный запятой, отображающийся в отчетах распределения вызовов. Поля определяются как COLUMN_DISTRIBUTION.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields',0,'0000-00-00 00:00:00'),(2826,'ru','help_text_EVENT_ABANDONED','Определяет события queue_log, которые подсчитывают счетчики/переменные, связанные с НЕСОСТОЯВШИМИСЯ ВЫЗОВАМИ, с использованием списка, разделенного запятыми. В стандартных настройках Asterisk должно быть установлено только \\\"ABANDON\\\". Define the queue_log events that will count towards the ABANDONED counters/variables in reports, using a comma separated list. In a standard Asterisk setup, this must be set to \\\"ABANDON\\\" and nothing else.счетчики/переменные ',0,'0000-00-00 00:00:00'),(2827,'ru','help_text_EVENT_ANSWERED','Определяет события queue_log, которые подсчитывают счетчики/переменные, связанные с ОТВЕЧЕННЫМИ ВЫЗОВАМИ, с использованием списка, разделенного запятыми. Define the queue_log events that will count towards the ANSWERED counters/variables in reports, using a comma separated list. Normal answered dispositions in the queue_log are COMPLETECALLER, COMPLETEAGENT, you could also want to count the TRANSFER disposition towards the ANSWERED column, but as transfers have their own variable, you can also leave them separated. Отвеченный вызов в queue_log обозначается COMPLETECALLER, COMPLETEAGENT. Вы также можете подсчитать количество результатов ПЕРЕАДРЕСОВАННЫЕ ВЫЗОВЫ в столбце ОТВЕЧЕННЫЕ ВЫЗОВЫ, но так как для переадресованных вызовов есть свои переменные, то они могут будет подсчитаны отдельно.',0,'0000-00-00 00:00:00'),(2828,'ru','help_text_EVENT_LOGIN','Определяет события queue_log, которые подсчитывают счетчики/переменные, связанные со ВХОДОМ В СИСТЕМУ, с использованием списка, разделенного запятыми.Как правило, имеются события AGENTLOGIN и ADDMEMBER в качестве действий по входу в систему в файле queue_log. В предыдущих версиях Asterisk также могут использоваться AGENTCALLBACKLOGIN.',0,'0000-00-00 00:00:00'),(2829,'ru','help_text_EVENT_LOGOUT','Определяет события queue_log, которые подсчитывают счетчики/переменные, связанные с ВЫХОДОМ ИЗ СИСТЕМЫ, с использованием списка, разделенного запятыми. Как правило, имеются AGENTLOGOFF и REMOVEMEMBER в качестве действий по выходу из системы в файле queue_log.',0,'0000-00-00 00:00:00'),(2830,'ru','help_text_EVENT_RECEIVED','Определяет события queue_log, которые подсчитывают счетчики/переменные, связанные с ПОЛУЧЕННЫМИ ВЫЗОВАМИ, с использованием списка, разделенного запятыми. Все результаты обработки вызовов в файле queue_log, имеющие отношение к полученным вызовам, должны быть перечислены здесь, например:<br/><br/>\r\nCOMPLETECALLER,COMPLETEAGENT,ABANDON,EXITEMPTY,EXITWITHKEY,EXITWITHTIMEOUT,TRANSFER',0,'0000-00-00 00:00:00'),(2831,'ru','help_text_EVENT_TRANSFERRED','Определяет события queue_log, которые подсчитывают счетчики/переменные, связанные с ПЕРЕАДРЕСОВАННЫМИ ВЫЗОВАМИ, с использованием списка, разделенного запятыми. В стандартных настройках Asterisk единственным событием, относящийся к переадрессации, является TRANSFER.',0,'0000-00-00 00:00:00'),(2832,'ru','help_text_EVENT_UNANSWERED','Определяет события queue_log, которые подсчитывают счетчики/переменные, связанные с НЕОТВЕЧЕННЫМИ ВЫЗОВАМИ, с использованием списка, разделенного запятыми. Так как для несостоявшегося вызова имеется собстввенная переменная, Вам необходимо перечислить все остальные результаты обработки вызовов как неотвеченные здесь, например:<br/><br/>\r\nEXITWITHKEY,EXITEMPTY,EXITWITHTIMEOUT',0,'0000-00-00 00:00:00'),(2833,'ru','help_text_REALTIME_COLUMN_WIDTHS','help_text_REALTIME_COLUMN_WIDTHS',0,'0000-00-00 00:00:00'),(2834,'ru','help_text_REALTIME_DISPLAY_ROWS','Список полей, разделенный запятой, отображающийся в таблице Сводки очередей в реальном времени. Поля определяются как COLUMN_REALTIME.<br/>\r\n<br/>\r\nparameter: group field (queue_summary)<br/>\r\nvalue: comma separated list of fields',0,'0000-00-00 00:00:00'),(2835,'ru','help_text_TOTAL_COLUMN_ANSWERED','Формула для строки \"Всего\" в отчете по отвеченным вызовам. Formula to use for the Total row on Answered reports.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',0,'0000-00-00 00:00:00'),(2836,'ru','help_text_TOTAL_COLUMN_DISTRIBUTION','Формула для строки \"Всего\" в отчете распределения вызовов.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',0,'0000-00-00 00:00:00'),(2837,'ru','help_text_TOTAL_COLUMN_REALTIME','Формула для строки \"Всего\" в отчетах в реальном времени.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',0,'0000-00-00 00:00:00'),(2838,'ru','help_text_TOTAL_COLUMN_UNANSWERED','Формула для строки \"Всего\" в отчете по неотвеченным вызовам.<br/>\r\n<br/>\r\nparameter: field<br/>\r\nvalue: formula',0,'0000-00-00 00:00:00'),(2839,'ru','help_text_UNANSWERED_DISPLAY_GRID','Если диаграмма задается в отчете неотвеченных вызовов, поле параметра, то используйте ширину сетчатой схемы в качестве настройки для значения поля. Сетка состоит из 12 столбцов: If a chart is defined in the unanswered reports, parameter field, then use the grid layout width as setup in the value field. The grid system has 12 columns in total:<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: width1,width2',0,'0000-00-00 00:00:00'),(2840,'ru','help_text_UNANSWERED_DISPLAY_ROWS','Список полей, разделенный запятой, отображающийся в отчетах неотвеченных вызовов. Поля определяются как COLUMN_UNANSWERED.<br/>\r\n<br/>\r\nparameter: group field<br/>\r\nvalue: comma separated list of fields',0,'0000-00-00 00:00:00'),(2841,'ru','help_text_agent_filter','Фильтр \"Регулярное выражение\" применяется для удаления из выделения ненужных операторов.<br/> Пример: <strong>Agent/[0-9][0-9][0-9][0-9]$</strong>\r\n\r\n\r\n',0,'0000-00-00 00:00:00'),(2842,'ru','help_text_agent_reports','Список отчетов, разделенный запятой, отображающийся на странице \"Оператор\". Вам необходимо задать правильный файл .php, отображающий необходимый Вам отчет по каждому элементу. Comma separated list of reports to show on the Agent page. You must specify the correct .php file that displays the report you want on each element.',0,'0000-00-00 00:00:00'),(2843,'ru','help_text_agent_row_color','Для придания ячейки цвета фона, соответствующего статусу оператора, в режиме реального времени, измените параметр на \"1\".',0,'0000-00-00 00:00:00'),(2844,'ru','help_text_answered_reports','Список отчетов, разделенный запятой, отображающийся на странице Отвеченных вызовов. Вам необходимо задать правильный файл .php, отображающий необходимый Вам отчет по каждому элементу. Comma separated list of reports to show on the Answered page. You must specify the correct .php file that displays the report you want on each element.',0,'0000-00-00 00:00:00'),(2845,'ru','help_text_asterisk_12','Установите значение \"1\", если Вы пользуетесь версией Asterisk 1.2 или более ранней версией. В противном случае возможно возникновение ограничений в использовании режима просмотра в реальном времени.',0,'0000-00-00 00:00:00'),(2846,'ru','help_text_avg_time_format','Формат поля средней продолжительности. ЧЧ = часы, ММ = минуты, СС = секунды, мм = полные минуты, сс = полные секунды. Используются в поисковых и подробных отчетах.',0,'0000-00-00 00:00:00'),(2847,'ru','help_text_call_time_format','Формат поля продолжительности вызова. ЧЧ = часы, ММ = минуты, СС = секунды, мм = полные минуты, сс = полные секунды. Используются в поисковых и подробных отчетах.',0,'0000-00-00 00:00:00'),(2848,'ru','help_text_csv_separator','Разделитель, используемый для экспорта файлов в формате CSV. По умолчанию разделителем является запятая (,). Если Вы пользуетесь LibreOffice/OpenOffice, то, возможно, потребуется изменить разделитель на точку с запятой (;). ',0,'0000-00-00 00:00:00'),(2849,'ru','help_text_custom_reports','Список индивидуальных отчетов, разделенный запятой, отображающийся в меню на вкладе \"Новый/Индивидуальный\". Параметром является название вклдаки для отображения, а значение - это список скрпитов .php, разделенные запятой, к загрузке. Comma separated list of custom reports to show on a new/custom tab on the menu. The parameter is the tab name to display, and value is a comma separated list of .php scripts to load.',0,'0000-00-00 00:00:00'),(2850,'ru','help_text_date_format','Формат поля даты с использованием синтаксиса MySQL. Например: %%м-%%д-%%Г %%Ч:%%м:%%с. Используется только в поисковых или полных отчетах. Формат отчета задается в конструкторе отчетов.',0,'0000-00-00 00:00:00'),(2851,'ru','help_text_decimal_places','Количество десятичных знаков для отображения чисел с плавающей запятой. ',0,'0000-00-00 00:00:00'),(2852,'ru','help_text_default_end_hour','Формат времени завершения по умолчанию ЧЧ:СС для выбора даты/времени.',0,'0000-00-00 00:00:00'),(2853,'ru','help_text_default_start_hour','Формат времени начала по умолчанию ЧЧ:СС для выбора даты/времени.',0,'0000-00-00 00:00:00'),(2854,'ru','help_text_detailed_agent_report','Отображает подробный отчет оператора во вкладке \"Оператор\". (Как и в случае  с детализированной информацией, представленной в периодическом отчете, но дополненной в соответствии с выбранным диапазонов дат). (Similar to the drill down information you can get on a regular report, but already expanded for the complete date range selection).',0,'0000-00-00 00:00:00'),(2855,'ru','help_text_dict_agent','Словарная запись для оператора. Заменяет идентификатор оператора, задаваемый в качестве параметра, на выбранное Вами значение (Таким образом, Вы можете использовать имя вместо номера).',0,'0000-00-00 00:00:00'),(2856,'ru','help_text_dict_queue','Словарная запись для очереди. Выполняет ту же функцию, что и словарная запись для оператора, но для замены имени очереди.',0,'0000-00-00 00:00:00'),(2857,'ru','help_text_distribution_interval','Интервал времени в минутахInterval in minutes to break up the distribution by hour report. По умолчанию интервал составляет час (60 минут), возможен выбор большего или меньшего значения. By default it breaks by hour (60 minutes), but you can use smaller or larger values.',0,'0000-00-00 00:00:00'),(2858,'ru','help_text_distribution_reports','Список отчетов, разделенный запятой, отображающийся на странице Распределения вызовов. Вам необходимо задать правильный файл .php, отображающий необходимый Вам отчет по каждому элементу. Comma separated list of reports to show on the Distribution page. You must specify the correct .php file that displays the report you want on each element.',0,'0000-00-00 00:00:00'),(2859,'ru','help_text_drilldown_records_per_page','Количество записей на странице отчета при разворачивании/детализации Number of records per page to show when expanding/drilling down on any report.',0,'0000-00-00 00:00:00'),(2860,'ru','help_text_first_page','Стартовая страница при загрузке (Например: answered.php, unanswered.php, distribution.php, agent.php). Возможно установить персональный вид стартовой страницы для каждого пользователя.',0,'0000-00-00 00:00:00'),(2861,'ru','help_text_hide_parsed_time','Установите значение \"1\", чтобы скрыть отображение в нижнем колонтитуле каждого отчета информации о времени обработки.',0,'0000-00-00 00:00:00'),(2862,'ru','help_text_ignore_none_abandons','Если Вы не хотите учитывать несостоявшиеся входящие вызовы при выборе в отчете нескольких операторов, измените параметр на \"один\". Эта функция полезна при отслеживании кампании исходящих вызовов и производительности каждого оператора, так как не учитываются несостоявшиеся входящие вызовы, распределенные в общую очередь (оператор \"NONE\"), но не прикрепленные к конкретному оператору. Если Вы выбираете всех операторов, включая и оператора \"NONE\", то несостоявшиеся входящие вызовы учитываются как обычно, даже если выбран параметр \"один\". \r\n',0,'0000-00-00 00:00:00'),(2863,'ru','help_text_language','Выбор языка. Если в поле параметра задать имя оператора, то использование языка будет ограничено для конкретного оператора. Если поле остается пустым, то выбранный язык применяется ко всем пользователям (основные настройки). Language to use. You can specify a user name in the parameter field to limit the language to a particular user. If the parameter field is left empty, then the language will be set for all users (global setting).',0,'0000-00-00 00:00:00'),(2864,'ru','help_text_mail_from_email','Для отправки запланированного отчета и уведомления электронным письмом, необходимо заполнить поле \"ОТ\".',0,'0000-00-00 00:00:00'),(2865,'ru','help_text_mail_from_name','Для отправки запланированного отчета и уведомления электронным письмом, необходимо заполнить поле \"ИМЯ\".',0,'0000-00-00 00:00:00'),(2866,'ru','help_text_mail_header_image','Файл изображения, используемый в качестве заголовка для отчетов/уведомлений, отправляемый электронной почтой.',0,'0000-00-00 00:00:00'),(2867,'ru','help_text_mail_smtp_password','При необходимости, для отправки запланированных отчетов и уведомлений введите пароль для SMTP-сервера.',0,'0000-00-00 00:00:00'),(2868,'ru','help_text_mail_smtp_server','Для отправки запланированных отчетов и уведомлений необходимо настроить SMTP-сервер. Наример: SSL-протокол: ssl://smtp.server.com ; TLS-протокол: tls://smtp.server.com ; без шифрования: smtp.server.com',0,'0000-00-00 00:00:00'),(2869,'ru','help_text_mail_smtp_server_port','При необходимости, для отправки запланированных отчетов и уведомления настройте SMTP-порт.',0,'0000-00-00 00:00:00'),(2870,'ru','help_text_mail_smtp_username','При необходимости, для отправки запланированных отчетов и уведомления введите имя пользователя для SMTP-сервера.',0,'0000-00-00 00:00:00'),(2871,'ru','help_text_realtime_alarm_call_duration','Предупреждающий сигнал, устанавливаемый для продолжительности вызова в секундах в режиме реального времени. Сигнал может быть задан для конкретной очереди путем Alarm in seconds for call duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',0,'0000-00-00 00:00:00'),(2872,'ru','help_text_realtime_alarm_last_call','Предупреждающий сигнал в секундах, сообщающий о последнем вызове в режиме реального времени. Alarm in seconds for the last call information in the realtime view. Can be set per queue by setting the parameter to the queue name.',0,'0000-00-00 00:00:00'),(2873,'ru','help_text_realtime_alarm_pause_duration','Предупреждающий сигнал в секундах, сообщающий о продолжительности паузы/перерыва в режиме реального времени. Alarm in seconds for pause/break duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',0,'0000-00-00 00:00:00'),(2874,'ru','help_text_realtime_alarm_row_color','Цвет фона строки, когда показатель Background row color when a value is in alarm in the realtime view.',0,'0000-00-00 00:00:00'),(2875,'ru','help_text_realtime_alarm_threshold','Пороговое значение (в процентах), начиная с которого вызовы обозначаются сигнальным цветом в режиме реального времени. Threshold (in percentage) from which to start coloring in alarm calls in the realtime view.',0,'0000-00-00 00:00:00'),(2876,'ru','help_text_realtime_alarm_wait_count','Предупреждающий сигнал для вызовов, ожидающих в очереди, в режиме реального времени. (Alarm (in number of calls) for calls waiting in a queue in the realtime view.',0,'0000-00-00 00:00:00'),(2877,'ru','help_text_realtime_alarm_wait_duration','Предупреждающий сигнал в секундах, устанавливаемый для продолжительности ожидания ответа в режиме реального времени. Alarm in seconds for call waiting duration in the realtime view. Can be set per queue by setting the parameter to the queue name.',0,'0000-00-00 00:00:00'),(2878,'ru','help_text_realtime_coach_options','Возможность для перехода в режим прослушивания вызова при запуске действия Тренер в реальном времени. Вы можете использовать любые варианты, доступные в приложении, например, Options to pass to chanspy when launching a Coach action from the realtime view. You can use any options available to the asterisk chanspy application, например &quot;w&quot; чтобы включить to enable whispering, or &quot;d&quot; to use dtmf to switch modes: 4 spy, 5 whisper, 6 barge., etc.',0,'0000-00-00 00:00:00'),(2879,'ru','help_text_realtime_custom_pauses','Если значение равно 1, то страница с просмотром в реальном времени будет проверять ASTDB на PAUSECUSTOM/Оператор и отобразит код паузы, хранящийся для конкретного Оператора в ASTDB.  If this value is set to 1 the realtime page will check the ASTDB for the PAUSECUSTOM/Agent family and it will show the pause code stored there for a particular Agent as stored in astdb Key. Например: PAUSECUSTOM/Agent/1000 = Break:${EPOCH}, сохраненный в ASTDB, will show Agent 1000 as break when paused.',0,'0000-00-00 00:00:00'),(2880,'ru','help_text_realtime_group_queues','Начать просмотр в реальном времени с отображением вызовов, сгруппированным по очередям обслуживания.',0,'0000-00-00 00:00:00'),(2881,'ru','help_text_realtime_hide_loggedoff','Начать просмотр в реальном времени без учета операторов, вышедших из системы. Start the realtime view without showing logged off Agents.',0,'0000-00-00 00:00:00'),(2882,'ru','help_text_realtime_refresh','Время обновления в секундах для режима просмота в реальном времени.',0,'0000-00-00 00:00:00'),(2883,'ru','help_text_realtime_refresh_sql','Время обновления в секундах для просмота статистики в таблице сводки очередей в реальном времени. Процесс получения информации оказывает большую нагрузку на процессор, поэтому для экономии возможно установить значние обновления по умолчанию 60 секунд или больше, если одновременно в реальном времени проверяют данные несколько супервизоров.',0,'0000-00-00 00:00:00'),(2884,'ru','help_text_realtime_reports','Список отчетов, разделенный запятой, отображающийся на странице Режима реального времени. Вам необходимо задать правильный файл .php, отображающий необходимый Вам отчет по каждому элементу. Comma separated list of reports to show on the Realtime page. You must specify the correct .php file that displays the report you want on each element.',0,'0000-00-00 00:00:00'),(2885,'ru','help_text_realtime_spy_device','Устройство, используемое пользователем (задается в поле параметра). Например: SIP/1234',0,'0000-00-00 00:00:00'),(2886,'ru','help_text_realtime_spy_extension','Добавочные номер для звонка на телефон супервизора при запуке действия перехвата вызова в режиме реального времени. Параметром должно являться им пользователя asternic, значением может быть добавочный номер с последующим контекстом, например: Extension to reach the supervisor phone when launching a call steal action in the realtime view. The parameter must be set to the asternic user name, the value could be the extension number followed by the context, for example: 100@from-internal',0,'0000-00-00 00:00:00'),(2887,'ru','help_text_realtime_spy_options','Возможность прослушать вызов при запуске действия \"Прослушать\" в режиме реального времени. Вы можете исползовать любые варианты, доступные в приложении прослушивания вызовов chanspy asterisk, например &quot;q&quot; отключить первый гудок, и т.п. Options to pass to chanspy when launching a Listen action from the realtime view. You can use any options available to the asterisk chanspy application, like &quot;q&quot; to disable the initial beep, etc.',0,'0000-00-00 00:00:00'),(2888,'ru','help_text_realtime_strict_interface_status','Данная настройка позволяет показывать статус режима просмотра в реальном времени, осуществляемое приложением Asterisk при помощи настроек STATE INTERFACE для приложения AddQueueMember. Для систем с участниками очереди локального типа с настройками STATE INTERFACE (например, FreePBX версия 2.8 или выше) необходимо установить значение 1. This setting will make the realtime view show status as returned by the asterisk queue application by means of the STATE INTERFACE options for the AddQueueMember application. It should be set to 1 in systems with Local type queue members with STATE INTERFACE set, like FreePBX 2.8 or higher.',0,'0000-00-00 00:00:00'),(2889,'ru','help_text_recordings_path','Местоположение записей на жестком диске в целях осуществления загрузки данных. Recordings location/directory in the hardrive to perform the direct download.',0,'0000-00-00 00:00:00'),(2890,'ru','help_text_session_time_format','Формат поля продолжительности обработки вызова. ЧЧ = часы, ММ = минуты, СС = секунды, мм = полные минуты, сс = полные секунды. Используются в отчетах оператора.',0,'0000-00-00 00:00:00'),(2891,'ru','help_text_setup_reports','Список отчетов, разделенный запятой, отображающийся на странице \"Параметры страницы\". Вам необходимо задать правильный файл .php, отображающий необходимый Вам отчет по каждому элементу. Comma separated list of reports to show on the Setup page. You must specify the correct .php file that displays the report you want on each element.',0,'0000-00-00 00:00:00'),(2892,'ru','help_text_short_abandon_threshold','Порог ожидания (в секундах) для того, чтобы вызов считался отмененным (если продолжительность вызова меньше заданного значения, то вызов полностью отклоняется). При указании имени очереди значение будет применимо только к этой очереди. Duration  treshhold (in seconds) for a call to be considered as abandoned (if duration is less than this value, then ignore the call completely). Specifying the queue name as a parameter will apply the value to that queue only.',0,'0000-00-00 00:00:00'),(2893,'ru','help_text_short_unanswered_threshold','Порог ожидания (в секундах) для вызова, чтобы считаться неотвеченным (если величина ожидания ниже установленного значения, то вызов не принимается во внимание). Задание имени очереди в качестве параметра определит значение только к заданной очереди. Duration  treshhold (in seconds) for a call to be considered as unanswered (if duration is less than this value, then ignore the call completely). Specifying the queue name as a parameter will apply the value to that queue only.',0,'0000-00-00 00:00:00'),(2894,'ru','help_text_show_agent_call','Отображает действия по завершению вызова при детализации отчета оператора. Show end call events when drilling down on agent reports',0,'0000-00-00 00:00:00'),(2895,'ru','help_text_show_url_field','Активировать и отобразить поле URL-адреса и отчетов',0,'0000-00-00 00:00:00'),(2896,'ru','help_text_sla_abandoned','Показатель уровня обслуживания в секундах для несостявшихся вызовов.',0,'0000-00-00 00:00:00'),(2897,'ru','help_text_sla_answered','Показатель уровня обслуживания в секундах для неотвеченных вызовов.',0,'0000-00-00 00:00:00'),(2898,'ru','help_text_sla_interval','Интервал времени в секундах для разделения таблицы для отчетов SLA (Соглашение об уровне обслуживания) и частоты отмены вызовов.',0,'0000-00-00 00:00:00'),(2899,'ru','help_text_sla_steps','Количество операций для отображения в отчетах SLA (Соглашение об уровне обслуживания) и частоты отмены вызовов.',0,'0000-00-00 00:00:00'),(2900,'ru','help_text_sla_transferred','Показатель уровня обслуживания в секундах для переадресованных вызовов.',0,'0000-00-00 00:00:00'),(2901,'ru','help_text_sla_unanswered','Показатель уровня обслуживания в секундах для неотвеченных (не отмененных, а неотвеченных в результате истечения времени ожидания, ) вызовов. вызовов. Service Level value in seconds for unanswered calls (not abandoned, but unanswered due to timeouts, exit with key, etc).',0,'0000-00-00 00:00:00'),(2902,'ru','help_text_timeframe_interval','Интервал времени в минутах - отображаются сведения о промежутке времени на домашней странице. Значение по умолчанию - 15 минут.',0,'0000-00-00 00:00:00'),(2903,'ru','help_text_timezone','Конфигурация часовго пояса для пользователя в формате [ -]ЧЧ:ММ\\\"\r\n\r\nЕсли имя пользователя задано в качестве параметра, то конфигурация применяется только к этому пользователю. Если поле остается пустым, конфигурация применяется повсеместно. If the user name is specified as parameter, then applies only to that user. If parameter is left blank it will be applied globally.',0,'0000-00-00 00:00:00'),(2904,'ru','help_text_unanswered_reports','Список отчетов, разделенный запятой, отображающийся на странице \"Неотвеченные вызовы\". Вам необходимо задать правильный файл .php, отображающий необходимый Вам отчет по каждому элементу. Comma separated list of reports to show on the Unanswered page. You must specify the correct .php file that displays the report you want on each element.',0,'0000-00-00 00:00:00'),(2905,'ru','help_text_variable_ABANDONED','Количество несостоявшихся вызовов (с результатом обработки вызова EVENT_ABANDON в queue_log).',0,'0000-00-00 00:00:00'),(2906,'ru','help_text_variable_ABANDONED_SLA','Количество несостоявшихся вызовов (с результатом обработки вызовов EVENT_ABANDON в queue_log)  с временем ожидания менее или равным значению sla_abandoned, заданному в Настройках.',0,'0000-00-00 00:00:00'),(2907,'ru','help_text_variable_ABANDONED_WAIT_TIME','Время ожидания для несостоявшихся вызовов для конкретного отчета с группировкой.',0,'0000-00-00 00:00:00'),(2908,'ru','help_text_variable_AGENTS_LOGGED_OFF','Количество неподключенных операторов. Данные доступны только в формуле COLUMN_REALTIME.',0,'0000-00-00 00:00:00'),(2909,'ru','help_text_variable_AGENTS_PAUSED','Количество приостановленных операторов. Данные доступны только в формуле COLUMN_REALTIME.',0,'0000-00-00 00:00:00'),(2910,'ru','help_text_variable_AGENTS_STAFFED','Количество зарегестрированных/доступных операторов. Данные доступны только в формуле COLUMN_REALTIME.',0,'0000-00-00 00:00:00'),(2911,'ru','help_text_variable_AGENTS_TALKING','Количество операторов, обслуживающих вызов. Данные доступны только в формуле COLUMN_REALTIME.',0,'0000-00-00 00:00:00'),(2912,'ru','help_text_variable_ANSWERED','Количество отвеченных вызовов (с результатом обработки вызова EVENT_ANSWERED в файле queue_log) для отчета с группировкой.',0,'0000-00-00 00:00:00'),(2913,'ru','help_text_variable_ANSWERED_SLA','Количество отвеченных вызовов (с результатом обработки вызовов EVENT_ANSWERED в queue_log) с временем ожидания менее или равным значению sla_answered, заданному в Настройках.',0,'0000-00-00 00:00:00'),(2914,'ru','help_text_variable_ANSWERED_TALK_TIME','Время разговора отвеченных вызовов для составления полного отчета с группировкой.',0,'0000-00-00 00:00:00'),(2915,'ru','help_text_variable_ANSWERED_WAIT_TIME','Время ожидания для отвеченных вызовов для конкртеного отчета с гуппировкой. (Время ожидания - это время ожидания абонента в очереди до момента, когда оператор ответил на вызов. Учитывается только то время, которое вызов провел в очереди, не учитывается вероятное предыдущее время, например Интерактивная система ответа, голосовое меню, и т.д.). Wait Time of Answered Calls for the particular grouped report. (Wait Time is the time an user was waiting on the queue before being connected to an agent, it only counts the time since the queue was entered, it does not count potential previous times like IVRs, etc.)',0,'0000-00-00 00:00:00'),(2916,'ru','help_text_variable_AVG_ABANDONED','Среднее количество несостявшихся вызовов',0,'0000-00-00 00:00:00'),(2917,'ru','help_text_variable_AVG_ABANDONED_SLA','Среднее количество несостявшихся вызовов, время ожидания которых меньше или равно времени abandoned_sla, заданным в Настройках.',0,'0000-00-00 00:00:00'),(2918,'ru','help_text_variable_AVG_ABANDONED_WAIT_TIME','Среднее время ожидания до отмены вызова',0,'0000-00-00 00:00:00'),(2919,'ru','help_text_variable_AVG_ANSWERED','Среднее количество отвеченных вызовов',0,'0000-00-00 00:00:00'),(2920,'ru','help_text_variable_AVG_ANSWERED_SLA','Среднее количество отвеченных вызовов, находившихся в ожидании менее или равное количество answered_sla секунд, определенных Настройками. Average number of Answered Calls that were waiting for less or equal than answered_sla seconds as set in Preferences.',0,'0000-00-00 00:00:00'),(2921,'ru','help_text_variable_AVG_ANSWERED_TALK_TIME','Средняя продолжительность разговора отвеченных вызовов',0,'0000-00-00 00:00:00'),(2922,'ru','help_text_variable_AVG_ANSWERED_WAIT_TIME','Среднее время ожидания ответа оператора. Average Wait Time for Answered Calls',0,'0000-00-00 00:00:00'),(2923,'ru','help_text_variable_AVG_LOGIN','Среднее количество действий операторов по входу в систему.',0,'0000-00-00 00:00:00'),(2924,'ru','help_text_variable_AVG_LOGOUT','Среднее количество действий операторов по выходу из системы.',0,'0000-00-00 00:00:00'),(2925,'ru','help_text_variable_AVG_RECEIVED','Среднее количество принятых вызовов',0,'0000-00-00 00:00:00'),(2926,'ru','help_text_variable_AVG_TRANSFERRED','Среднее количество переадресованных вызовов',0,'0000-00-00 00:00:00'),(2927,'ru','help_text_variable_AVG_TRANSFERRED_SLA','Среднее количество переадресованных вызовов, находившихся в ожидании менее или равное количество transferred_sla секунд, определенных Настройками. Average number of Transferred Calls that were waiting for less or equal than transferred_sla seconds as set in Preferences.',0,'0000-00-00 00:00:00'),(2928,'ru','help_text_variable_AVG_TRANSFERRED_TALK_TIME','Среднее время разговора переадресованных вызовов',0,'0000-00-00 00:00:00'),(2929,'ru','help_text_variable_AVG_TRANSFERRED_WAIT_TIME','Среднее время ожидания переадресации вызова Average Wait Time of Transferred Calls',0,'0000-00-00 00:00:00'),(2930,'ru','help_text_variable_AVG_UNANSWERED','Среднее количество неотвеченных вызовов',0,'0000-00-00 00:00:00'),(2931,'ru','help_text_variable_AVG_UNANSWERED_SLA','Среднее количество неотвеченных вызовов, время ожидания которых меньше или равно unanswered_sla секундам, заданным в Настройках.',0,'0000-00-00 00:00:00'),(2932,'ru','help_text_variable_AVG_UNANSWERED_WAIT_TIME','Среднее время ожидания для неотвеченных вызовов',0,'0000-00-00 00:00:00'),(2933,'ru','help_text_variable_CALLS_WAITING','Количество вызовов, находящихся в режиме ожидания. Данные доступны только в формуле COLUMN_REALTIME.',0,'0000-00-00 00:00:00'),(2934,'ru','help_text_variable_LOGIN','Количество входов в систему оператора.',0,'0000-00-00 00:00:00'),(2935,'ru','help_text_variable_LOGOUT','Количество выходов из системы оператора.',0,'0000-00-00 00:00:00'),(2936,'ru','help_text_variable_MAX_ABANDONED_WAIT_TIME','Максимальное время ожидания несостоявшихся вызовов.',0,'0000-00-00 00:00:00'),(2937,'ru','help_text_variable_MAX_ANSWERED_TALK_TIME','Максимальное время разговора отвеченных вызовов.',0,'0000-00-00 00:00:00'),(2938,'ru','help_text_variable_MAX_ANSWERED_WAIT_TIME','Максимальное время ожидания отвеченных вызовов.',0,'0000-00-00 00:00:00'),(2939,'ru','help_text_variable_MAX_CALLERS_WAITING','Максимальное количество абонентов, ожидающих в очереди.',0,'0000-00-00 00:00:00'),(2940,'ru','help_text_variable_MAX_COL','Максимальное значение столбца, используемое в формулах суммы.',0,'0000-00-00 00:00:00'),(2941,'ru','help_text_variable_MAX_TRANSFERRED_TALK_TIME','Максимальное время разговора переадресованных вызовов.',0,'0000-00-00 00:00:00'),(2942,'ru','help_text_variable_MAX_TRANSFERRED_WAIT_TIME','Максимальное время ожидания для переадресованных вызовов.',0,'0000-00-00 00:00:00'),(2943,'ru','help_text_variable_MAX_UNANSWERED_WAIT_TIME','Максимальное время ожидания неотвеченных вызовов.',0,'0000-00-00 00:00:00'),(2944,'ru','help_text_variable_MAX_WAIT_TIME','Максимальное время ожидания для отчета с группировкой.',0,'0000-00-00 00:00:00'),(2945,'ru','help_text_variable_MIN_ABANDONED_WAIT_TIME','Минимальное время ожидания в несостоявшихся вызовах.',0,'0000-00-00 00:00:00'),(2946,'ru','help_text_variable_MIN_ANSWERED_TALK_TIME','Минимальное время разговора отвеченных вызовов.',0,'0000-00-00 00:00:00'),(2947,'ru','help_text_variable_MIN_ANSWERED_WAIT_TIME','Минимальное время ожидания отвеченных вызовов.',0,'0000-00-00 00:00:00'),(2948,'ru','help_text_variable_MIN_COL','Минимальное значение столбца для формул СУММЫ.',0,'0000-00-00 00:00:00'),(2949,'ru','help_text_variable_MIN_TRANSFERRED_TALK_TIME','Минимальное время разговора переадресованных вызовов.',0,'0000-00-00 00:00:00'),(2950,'ru','help_text_variable_MIN_TRANSFERRED_WAIT_TIME','Минимальное время ожидания для переадресованных вызовов.',0,'0000-00-00 00:00:00'),(2951,'ru','help_text_variable_MIN_UNANSWERED_WAIT_TIME','Минимальное время ожидания неотвеченных вызовов.',0,'0000-00-00 00:00:00'),(2952,'ru','help_text_variable_RECEIVED','Количество принятых вызовов (с результатом обработки вызова EVENT_RECEIVED в файле queue_log) для отчета с группировкой.',0,'0000-00-00 00:00:00'),(2953,'ru','help_text_variable_ROW_COUNT','Количество строк в отчете. Используется в формулах суммы.',0,'0000-00-00 00:00:00'),(2954,'ru','help_text_variable_SUM_ABANDONED','Сумма несостоявшихся вызовов до конкретной строки в отчете.',0,'0000-00-00 00:00:00'),(2955,'ru','help_text_variable_SUM_ABANDONED_SLA','Сумма несостоявшихся вызовов в строке, время ожидания которых меньше или равно sla_abandoned секундам, заданным в Настройках. ',0,'0000-00-00 00:00:00'),(2956,'ru','help_text_variable_SUM_ABANDONED_WAIT_TIME','Сумма времени ожидания несостоявшихся вызовов до конкретной строки в отчете.',0,'0000-00-00 00:00:00'),(2957,'ru','help_text_variable_SUM_ANSWERED','Сумма отвеченных вызовов до конкретной строки в отчете.',0,'0000-00-00 00:00:00'),(2958,'ru','help_text_variable_SUM_ANSWERED_SLA','Сумма отвеченных вызовов в строке отчета, время ожидания которых меньше или равно sla_answered секундам, заданным в Настройках.',0,'0000-00-00 00:00:00'),(2959,'ru','help_text_variable_SUM_ANSWERED_TALK_TIME','Общее время разговора отвеченных вызовов до определенной строки в отчете. Sum of Talk Time for Answered calls up to the particular row in a report.',0,'0000-00-00 00:00:00'),(2960,'ru','help_text_variable_SUM_ANSWERED_WAIT_TIME','Сумма времени ожидания для отвеченных вызовов до конкретной строки в отчете.',0,'0000-00-00 00:00:00'),(2961,'ru','help_text_variable_SUM_COL','Сумма всех значений в конкретном столбце. Используется в формулах СУММЫ.',0,'0000-00-00 00:00:00'),(2962,'ru','help_text_variable_SUM_LOGIN','Сумма действий по входу в систему до конкретной строки в отчете.',0,'0000-00-00 00:00:00'),(2963,'ru','help_text_variable_SUM_LOGOUT','Сумма действий по выходу из системы до конкретной строки в отчете.',0,'0000-00-00 00:00:00'),(2964,'ru','help_text_variable_SUM_RECEIVED','Сумма полученных вызовов до конкретной строки в отчете.',0,'0000-00-00 00:00:00'),(2965,'ru','help_text_variable_SUM_TRANSFERRED','Сумма переадресованных вызовов до конкретной строки в отчете.',0,'0000-00-00 00:00:00'),(2966,'ru','help_text_variable_SUM_TRANSFERRED_SLA','Сумма переадресованных вызовов до строки в отчете, время ожидания которых меньше или равно sla_transferred секундам, заданным в Настройках.',0,'0000-00-00 00:00:00'),(2967,'ru','help_text_variable_SUM_TRANSFERRED_TALK_TIME','Общее время разговора переадресованных вызовов до определенной строки в отчете. Sum of Talk Time for Transferred calls up to the particular row in a report.',0,'0000-00-00 00:00:00'),(2968,'ru','help_text_variable_SUM_TRANSFERRED_WAIT_TIME','Сумма времени ожидания для переадресованных вызовов до строки в отчете.',0,'0000-00-00 00:00:00'),(2969,'ru','help_text_variable_SUM_UNANSWERED','Сумма неотвеченных вызовов до конкретной строки в отчете.',0,'0000-00-00 00:00:00'),(2970,'ru','help_text_variable_SUM_UNANSWERED_SLA','Сумма неотвеченных вызовов до строки в отчете, время ожидания которых меньше или равно transferred_sla секундам, заданным в Настройках.',0,'0000-00-00 00:00:00'),(2971,'ru','help_text_variable_SUM_UNANSWERED_WAIT_TIME','Сумма времени ожидания для переадресованных вызовов до строки в отчете.',0,'0000-00-00 00:00:00'),(2972,'ru','help_text_variable_TOTAL_ABANDONED','Общее количество несостоявшихся вызовов.',0,'0000-00-00 00:00:00'),(2973,'ru','help_text_variable_TOTAL_ABANDONED_SLA','Общее количество несостоявшихся вызовов, время ожидания которых меньше или равно abandoned_sla секундам, заданным в Настройках.',0,'0000-00-00 00:00:00'),(2974,'ru','help_text_variable_TOTAL_ABANDONED_WAIT_TIME','Общее время ожидания до отмены вызова.',0,'0000-00-00 00:00:00'),(2975,'ru','help_text_variable_TOTAL_ANSWERED','Общее количество отвеченных вызовов.',0,'0000-00-00 00:00:00'),(2976,'ru','help_text_variable_TOTAL_ANSWERED_SLA','Общее количество отвеченных вызовов, время ожидания которых меньше или равно answered_sla секундам, заданным в Настройках.',0,'0000-00-00 00:00:00'),(2977,'ru','help_text_variable_TOTAL_ANSWERED_TALK_TIME','Общее время разговора отвеченных вызовов',0,'0000-00-00 00:00:00'),(2978,'ru','help_text_variable_TOTAL_ANSWERED_WAIT_TIME','Общее время ожидания ответа для отвеченных вызовов',0,'0000-00-00 00:00:00'),(2979,'ru','help_text_variable_TOTAL_LOGIN','Общее количество действий по входу в систему.',0,'0000-00-00 00:00:00'),(2980,'ru','help_text_variable_TOTAL_LOGOUT','Общее количество действий по выходу из системы.',0,'0000-00-00 00:00:00'),(2981,'ru','help_text_variable_TOTAL_RECEIVED','Общее количество принятых вызовов.',0,'0000-00-00 00:00:00'),(2982,'ru','help_text_variable_TOTAL_TRANSFERRED','Общее количество переадресованных вызовов.',0,'0000-00-00 00:00:00'),(2983,'ru','help_text_variable_TOTAL_TRANSFERRED_SLA','Общее количество переадресованных вызовов, время ожидание которых меньше или равно transferred_sla секундам, заданым в Настройках.',0,'0000-00-00 00:00:00'),(2984,'ru','help_text_variable_TOTAL_TRANSFERRED_TALK_TIME','Общее время разговора переадресованных вызовов.',0,'0000-00-00 00:00:00'),(2985,'ru','help_text_variable_TOTAL_TRANSFERRED_WAIT_TIME','Общее время ожидания для переадресованных вызовов.',0,'0000-00-00 00:00:00'),(2986,'ru','help_text_variable_TOTAL_UNANSWERED','Общее количество неотвеченных вызовов.',0,'0000-00-00 00:00:00'),(2987,'ru','help_text_variable_TOTAL_UNANSWERED_SLA','Общее количество неотвеченных вызовов, время ожидание которых меньше или равно unanswered_sla секундам, заданым в Настройках.',0,'0000-00-00 00:00:00'),(2988,'ru','help_text_variable_TOTAL_UNANSWERED_WAIT_TIME','Время ожидания неотвеченных вызовов для полного набора данных.',0,'0000-00-00 00:00:00'),(2989,'ru','help_text_variable_TRANSFERRED','Количество переадресованных вызовов (с результатом обработки вызова EVENT_TRANSFERRED в queue_log)',0,'0000-00-00 00:00:00'),(2990,'ru','help_text_variable_TRANSFERRED_SLA','Количество переадресованных вызовов (с результатом обработки вызовов EVENT_TRANSFERRED в queue_log) с временем ожидания менее или равным значению transferred_sla, заданному в Настройках.',0,'0000-00-00 00:00:00'),(2991,'ru','help_text_variable_TRANSFERRED_TALK_TIME','Время разговора переадресованных вызовов определенной строки. Talk Time for Transferred Calls for a particular row.',0,'0000-00-00 00:00:00'),(2992,'ru','help_text_variable_TRANSFERRED_WAIT_TIME','Время ожидания переадресованных вызовов для строки.',0,'0000-00-00 00:00:00'),(2993,'ru','help_text_variable_UNANSWERED','Количество неотвеченных вызовов (с результатом обработки вызова EVENT_UNANSWERED в журнале очереди) для полного отчета с группировкой.',0,'0000-00-00 00:00:00'),(2994,'ru','help_text_variable_UNANSWERED_SLA','Количество неотвеченных вызовов (с результатом обработки вызова EVENT_UNANSWERED в queue_log) с временем ожидания менее или равным значению sla_unanswered, заданному в Настройках.',0,'0000-00-00 00:00:00'),(2995,'ru','help_text_variable_UNANSWERED_WAIT_TIME','Время ожидания неотвеченных вызовов для строки. ',0,'0000-00-00 00:00:00'),(2996,'ru','help_text_wait_time_format','Формат поля времени ожидания вызова. ЧЧ = часы, ММ = минуты, СС = секунды, мм = полные минуты, сс = полные секунды. Используются в поисковых и подробных отчетах.',0,'0000-00-00 00:00:00'),(2997,'ru','help_text_week_mode','Когда начинать отсчет недель в году When to start counting weeks from the year:<br><pre>\r\nРежим Первый день недели       Интервал Неделя 1 является первой неделей ...\r\n0         Воскресенье          0-53    с воскресенья в году\r\n1         Понедельник          0-53    с более, чем 3-мя днями в году\r\n2         Воскресенье          1-53    с воскресенья в году\r\n3         Понедельник          1-53    более, чем 3-мя днями в году\r\n4         Воскресенье          0-53    с более, чем 3-мя днями в году\r\n5         Понедельник          0-53    с понедельника в году\r\n6         Воскресенье          1-53    с более, чем 3-мя днями в году\r\n7         Понедельник          1-53    с понедельника в году\r\n</pre>',0,'0000-00-00 00:00:00'),(2998,'ru','hours','час',0,'0000-00-00 00:00:00'),(2999,'ru','info1','Информация 1',0,'0000-00-00 00:00:00'),(3000,'ru','info2','Информация 2',0,'0000-00-00 00:00:00'),(3001,'ru','info3','Информация 3',0,'0000-00-00 00:00:00'),(3002,'ru','info4','Информация 4',0,'0000-00-00 00:00:00'),(3003,'ru','info5','Информация 5',0,'0000-00-00 00:00:00'),(3004,'ru','none','отсутствует',0,'0000-00-00 00:00:00'),(3005,'ru','of','из',0,'0000-00-00 00:00:00'),(3006,'ru','on %s since %s seconds ago','на %s по истечение %s секунд',0,'0000-00-00 00:00:00'),(3007,'ru','on %s since %s secs ago','на %s по истечение %s секунд',0,'0000-00-00 00:00:00'),(3008,'ru','on days','в дни',0,'0000-00-00 00:00:00'),(3009,'ru','on hours','в часы',0,'0000-00-00 00:00:00'),(3010,'ru','on minutes','в минуты',0,'0000-00-00 00:00:00'),(3011,'ru','partial','неполный',0,'0000-00-00 00:00:00'),(3012,'ru','realtime-agent-busy','Занято',0,'0000-00-00 00:00:00'),(3013,'ru','realtime-agent-dialout','Исходящий вызов',0,'0000-00-00 00:00:00'),(3014,'ru','realtime-agent-hold','Вызов в режиме удержания',0,'0000-00-00 00:00:00'),(3015,'ru','realtime-agent-not in use','Не используется',0,'0000-00-00 00:00:00'),(3016,'ru','realtime-agent-ringing','Звонит',0,'0000-00-00 00:00:00'),(3017,'ru','realtime-agent-unavailable','Недоступен',0,'0000-00-00 00:00:00'),(3018,'ru','realtime_queue_summary','Сводка очереди',0,'0000-00-00 00:00:00'),(3019,'ru','seconds','секунды',0,'0000-00-00 00:00:00'),(3020,'ru','unanswered_calls_by_event','Причина разъединения',0,'0000-00-00 00:00:00'),(3021,'ru','unanswered_calls_by_holdtime','Уровень обслуживания',0,'0000-00-00 00:00:00'),(3022,'ru','unanswered_calls_by_queue','Неотвеченные вызовы в очереди',0,'0000-00-00 00:00:00'),(3023,'ru','unanswered_calls_by_url','Неотвеченные вызовы по URL-адресу',0,'0000-00-00 00:00:00'),(3024,'ru','unanswered_calls_detail','Описание неотвеченных вызовов',0,'0000-00-00 00:00:00'),(3025,'ru','unanswered_calls_summary','Сводка неотвеченных вызовов',0,'0000-00-00 00:00:00'),(3026,'ru','within','в течение',0,'0000-00-00 00:00:00'),(3027,'ru','within %d%s seconds','в течение %d%s секунд',0,'0000-00-00 00:00:00'),(3028,'es','distribution_by_agent (outbound)','Distribución por Agente (saliente)',0,'2013-05-22 15:27:04'),(3029,'en','distribution_by_agent (outbound)','Distribution by Agent (outbound)',0,'2013-05-18 00:15:17'),(3030,'ru','distribution_by_agent (outbound)','по оператором (исходящий)',0,'2013-05-27 19:28:58'),(3031,'pt_br','distribution_by_agent (outbound)','Ligações por Agente (saída)',0,'2013-06-25 11:36:03'),(3032,'es','distribution_by_agent','Distribución por Agente',0,'2013-05-22 15:27:04'),(3033,'en','distribution_by_agent','Distribution by Agent',0,'2013-05-18 00:15:17'),(3034,'ru','distribution_by_agent','по оператором',0,'2013-05-27 19:28:58'),(3035,'pt_br','distribution_by_agent','Ligações por Agente',0,'2013-06-25 11:36:03'),(3036,'es','distribution_by_day (outbound)','Distribución por Día (saliente)',0,'2013-05-22 15:27:04'),(3037,'en','distribution_by_day (outbound)','Distribution per Day (outbound)',0,'2013-05-17 14:53:36'),(3038,'ru','distribution_by_day (outbound)','по дням (исходящий)',0,'2013-05-27 19:28:58'),(3039,'pt_br','distribution_by_day (outbound)','Ligações por Dia (saída)',0,'2013-06-25 11:36:03'),(3040,'es','distribution_by_day_of_week (outbound)','Distribución por Día de Semana (saliente)',0,'2013-05-22 15:27:04'),(3041,'en','distribution_by_day_of_week (outbound)','Distribution per Day of Week (outbound)',0,'2013-05-17 14:53:36'),(3042,'ru','distribution_by_day_of_week (outbound)','по дням недели (исходящий)',0,'2013-05-27 19:28:58'),(3043,'pt_br','distribution_by_day_of_week (outbound)','Ligações por dia da Semana (saída)',0,'2013-06-25 11:36:03'),(3044,'es','distribution_by_hour (outbound)','Distribución por Hora (saliente)',0,'2013-05-22 15:27:04'),(3045,'en','distribution_by_hour (outbound)','Distribution per Hour (outbound)',0,'2013-05-17 14:53:36'),(3046,'ru','distribution_by_hour (outbound)','по часам (исходящий)',0,'2013-05-27 19:28:58'),(3047,'pt_br','distribution_by_hour (outbound)','Ligações por Hora (saída)',0,'2013-06-25 11:36:03'),(3048,'es','distribution_by_month (outbound)','Distribución por Mes (saliente)',0,'2013-05-22 15:27:04'),(3049,'en','distribution_by_month (outbound)','Distribution per Month (outbound)',0,'2013-05-17 14:53:36'),(3050,'ru','distribution_by_month (outbound)','по месяцам (исходящий)',0,'2013-05-27 19:28:58'),(3051,'pt_br','distribution_by_month (outbound)','Ligações por Mes (saída)',0,'2013-06-25 11:36:03'),(3052,'es','distribution_by_queue (outbound)','Distribución por Cola (saliente)',0,'2013-05-22 15:27:04'),(3053,'en','distribution_by_queue (outbound)','Distribution by Queue (outbound)',0,'2013-05-17 14:53:36'),(3054,'ru','distribution_by_queue (outbound)','по очереди (исходящий)',0,'2013-05-27 19:28:58'),(3055,'pt_br','distribution_by_queue (outbound)','Ligações por Fila (saída)',0,'2013-06-25 11:36:03'),(3056,'es','distribution_by_url (outbound)','Distribución por URL (saliente)',0,'2013-05-22 15:27:04'),(3057,'en','distribution_by_url (outbound)','Distribution by URL (outbound)',0,'2013-05-17 14:53:36'),(3058,'ru','distribution_by_url (outbound)','по URL-адресу (исходящий)',0,'2013-05-27 19:28:58'),(3059,'pt_br','distribution_by_url (outbound)','Ligações por URL (saída)',0,'2013-06-25 11:36:03'),(3060,'es','distribution_by_week (outbound)','Distribución por Semana (saliente)',0,'2013-05-22 15:27:04'),(3061,'en','distribution_by_week (outbound)','Distribution per Week (outbound)',0,'2013-05-17 14:53:36'),(3062,'ru','distribution_by_week (outbound)','по неделям (исходящий)',0,'2013-05-27 19:28:58'),(3063,'pt_br','distribution_by_week (outbound)','Ligações por Semana (saída)',0,'2013-06-25 11:36:03'),(3064,'es','Idle Time','Tiempo Ocioso',0,'2013-07-02 23:18:22'),(3065,'fr','Idle Time','Temps d\'inactivité',0,'2013-07-02 23:32:01'),(3066,'ru','Idle Time','время простоя',0,'2013-07-02 23:36:50'),(3067,'pt_br','Idle Time','Tempo ocioso',0,'2013-07-02 23:38:34'),(3068,'en','Fails','Fails',1,'2013-07-02 23:55:27'),(3069,'es','Fails','Fallos',0,'2013-07-03 00:04:09'),(3070,'fr','Fails','Manquer',0,'2013-07-03 00:04:28'),(3071,'pt_br','Fails','Falhas',0,'2013-07-03 00:04:46'),(3072,'ru','Fails','Неудачи',0,'2013-07-03 00:05:03'),(3073,'en','Outbound Calls','Outbound Calls',0,'2015-01-07 17:12:24'),(3074,'es','Outbound Calls','Llamadas Salientes',0,'2015-01-07 17:12:24'),(3075,'fr','Outbound Calls','Appels Sortants',0,'2015-01-07 17:12:24'),(3076,'pt_br','Outbound Calls','Chamadas de Saída',0,'2015-01-07 17:12:24'),(3077,'en','Number of Outbound Calls','Number of Outbound Calls',0,'2015-01-07 17:12:24'),(3078,'es','Number of Outbound Calls','Número de Llamadas Salientes',0,'2015-01-07 17:12:24'),(3079,'fr','Number of Outbound Calls','Nombre d\'Appels Sortants',0,'2015-01-07 17:12:24'),(3080,'pt_br','Number of Outbound Calls','Número de Chamadas de Saída',0,'2015-01-07 17:12:24'),(3081,'ru','Number of Outbound Calls','Количество исходящих звонков',0,'0000-00-00 00:00:00'),(3082,'ru','Outbound Calls','Исходящие вызовы',0,'0000-00-00 00:00:00'),(3083,'en','Dialer','Dialer',1,'2015-01-07 17:12:49'),(3084,'en','Dashboard','Dashboard',1,'2015-01-07 17:12:49'),(3085,'en','Campaigns','Campaigns',1,'2015-01-07 17:12:49'),(3086,'en','Numbers','Numbers',1,'2015-01-07 17:12:49'),(3087,'en','Lists','Lists',1,'2015-01-07 17:12:49'),(3088,'en','help_text_asterisk_16','Set this to 1 if you are using Asterisk 1.6, otherwise you will have some issues in the realtime view.\n',0,'2015-01-07 17:12:49'),(3089,'en','help_text_asterisk_18','Set this to 1 if you are using Asterisk 1.8, otherwise you will have some issues in the realtime view.',0,'2015-01-07 17:12:49'),(3090,'en','help_text_call_flow','To have separate reports for outbound queues, set call_flow for them. The parameter must be the queue name/number and the value must be set to \\\\\\\"outbound\\\\\\\".',0,'2015-01-07 17:12:49'),(3091,'en','help_text_freepbx_device_user_mode','Set this to 1 if you use FreePBX in user&device mode',0,'2015-01-07 17:12:49'),(3092,'en','help_text_mail_alert_subject','Subect to use when emailing alerts',0,'2015-01-07 17:12:49'),(3093,'en','help_text_mail_report_subject','Subject to use when emailing reports',0,'2015-01-07 17:12:49'),(3094,'en','help_text_pbxware','Set this to 1 if you use PBXWare for the realtime view to work correctly',0,'2015-01-07 17:12:49'),(3095,'en','help_text_realtime_agent_sort','If set to \\\"status\\\", busy agents will be shown first on the realtime page.',0,'2015-01-07 17:12:49'),(3096,'en','help_text_realtime_last_hour_stats','Set this option if you want the call counters in the realtime view to show only the last hour counts, and not the whole day.',0,'2015-01-07 17:12:49'),(3097,'en','help_text_realtime_tracking_mode','If set, coaching sessions in the realtime view will not end when the call ends, so the supervisor continues pinned to the agent for subsequent calls.',0,'2015-01-07 17:12:49'),(3098,'en','help_text_wrap_up','Optinoal wrap_up time, it can be set globally or per queue. This value will affect the AHL (Average Handling Time) numbers in reports.',0,'2015-01-07 17:12:49'),(3099,'es','Dialer','Dialer',1,'2015-01-07 17:37:29'),(3100,'es','Dashboard','Dashboard',1,'2015-01-07 17:37:29'),(3101,'es','Campaigns','Campaigns',1,'2015-01-07 17:37:29'),(3102,'es','Numbers','Numbers',1,'2015-01-07 17:37:29'),(3103,'es','Lists','Lists',1,'2015-01-07 17:37:29'),(3104,'es','help_text_asterisk_16','Ponga este valor en 1 si utiliza Asterisk 1.6 para que la vista de Estado Actual funcione correctamente.',0,'2015-01-07 17:37:29'),(3105,'es','help_text_asterisk_18','Ponga este valor en 1 si utiliza Asterisk 1.8 para que la vista de Estado Actual funcione correctamente.',0,'2015-01-07 17:37:29'),(3106,'es','help_text_call_flow','Configure este parámetro por cada cola con valor \\\'outbound\\\' para marcar la cola como saliente, de manera de tener reportes separados de distribución para los mismos.',0,'2015-01-07 17:37:29'),(3107,'es','help_text_freepbx_device_user_mode','Configure este valor en 1 si utiliza freepbx en modo user&device',0,'2015-01-07 17:37:29'),(3108,'es','help_text_mail_alert_subject','Asunto de mensaje a utilizar para los envios de alertas por mail',0,'2015-01-07 17:37:29'),(3109,'es','help_text_mail_report_subject','Asunto de mensaje a utilizar para los envios de reportes por mail',0,'2015-01-07 17:37:29'),(3110,'es','help_text_pbxware','Ponga este valor en 1 si utiliza PBXWare para que la vista  de Estado Actual funcione correctamente.',0,'2015-01-07 17:37:29'),(3111,'es','help_text_realtime_agent_sort','Ponga este valor en \\\'status\\\' para que la vista de Estado Actual ordene los agentes por su estado, mostrando a los que estén en llamado primero. De lo contrario el orden se hace por penalidad.',0,'2015-01-07 17:37:29'),(3112,'es','help_text_realtime_last_hour_stats','Configure esta opción para que la vista de Estado Actual solo muestre la última hora en las estadísticas de llamados recibidos/abandonados.',0,'2015-01-07 17:37:29'),(3113,'es','help_text_realtime_tracking_mode','Habilite tracking mode para que las escuchas lanzadas desde Estado Actual siguen activas aunque finalice el llamado del agente.',0,'2015-01-07 17:37:29'),(3114,'es','help_text_wrap_up','Este seteo permite especificar un tiempo de \\\'wrap up\\\' ya sea global o por cola. Este tiempo afectará el valor de AHT (Average Handling Time) en los reportes que incluyen esa métrica.',0,'2015-01-07 17:37:29');
/*!40000 ALTER TABLE `language` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `plugins`
--

LOCK TABLES `plugins` WRITE;
/*!40000 ALTER TABLE `plugins` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `qagent`
--

LOCK TABLES `qagent` WRITE;
/*!40000 ALTER TABLE `qagent` DISABLE KEYS */;
INSERT INTO `qagent` (`agent_id`, `agent`) VALUES (-1,'ALL'),(1,'NONE'),(2,'SIP/1001'),(3,'agent1001'),(4,'SIP/1002'),(5,'Agent2'),(6,'SIP/1005'),(7,'Agent1005'),(8,'Agent/1012'),(9,'Agent/7701');
/*!40000 ALTER TABLE `qagent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `qevent`
--

LOCK TABLES `qevent` WRITE;
/*!40000 ALTER TABLE `qevent` DISABLE KEYS */;
INSERT INTO `qevent` (`event_id`, `event`) VALUES (1,'ABANDON'),(2,'ADDMEMBER'),(3,'AGENTCALLBACKLOGIN'),(4,'AGENTCALLBACKLOGOFF'),(5,'AGENTDUMP'),(6,'AGENTLOGIN'),(7,'AGENTLOGOFF'),(8,'AGENTPAUSED'),(9,'COMPLETEAGENT'),(10,'COMPLETECALLER'),(11,'CONFIGRELOAD'),(12,'CONNECT'),(13,'CONNECTED'),(14,'DID'),(15,'ENTERQUEUE'),(16,'EXITEMPTY'),(17,'EXITWITHKEY'),(18,'EXITWITHTIMEOUT'),(19,'NONE'),(20,'PAUSE'),(21,'PAUSEALL'),(22,'PAUSECUSTOM'),(23,'QUEUESTART'),(24,'REMOVEMEMBER'),(25,'RINGNOANSWER'),(26,'TRANSFER'),(27,'UNPAUSE'),(28,'UNPAUSEALL');
/*!40000 ALTER TABLE `qevent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `qname`
--

LOCK TABLES `qname` WRITE;
/*!40000 ALTER TABLE `qname` DISABLE KEYS */;
INSERT INTO `qname` (`queue_id`, `queue`) VALUES (-1,'ALL'),(1,'NONE'),(2,'1000'),(3,'7001');
/*!40000 ALTER TABLE `qname` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `qstats.queue_stats_mv`
--

LOCK TABLES `qstats.queue_stats_mv` WRITE;
/*!40000 ALTER TABLE `qstats.queue_stats_mv` DISABLE KEYS */;
/*!40000 ALTER TABLE `qstats.queue_stats_mv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `queue_stats`
--

LOCK TABLES `queue_stats` WRITE;
/*!40000 ALTER TABLE `queue_stats` DISABLE KEYS */;
INSERT INTO `queue_stats` (`queue_stats_id`, `uniqueid`, `datetime`, `qname`, `qagent`, `qevent`, `info1`, `info2`, `info3`, `info4`, `info5`) VALUES (1,'NONE','2019-07-30 13:20:02',1,1,23,'','','','',''),(2,'NONE','2019-07-30 13:20:02',1,1,11,'','','','',''),(3,'NONE','2019-07-30 13:29:18',1,1,11,'','','','',''),(4,'NONE','2019-07-30 13:30:10',1,1,11,'','','','',''),(5,'NONE','2019-07-30 13:35:09',1,1,11,'','','','',''),(6,'NONE','2019-07-30 13:41:32',1,1,11,'','','','',''),(7,'NONE','2019-07-30 13:47:57',1,1,23,'','','','',''),(8,'NONE','2019-07-30 13:47:59',1,1,11,'','','','',''),(9,'NONE','2019-07-30 14:00:37',1,1,11,'','','','',''),(10,'NONE','2019-07-30 14:02:19',1,1,11,'','','','',''),(11,'NONE','2019-07-30 14:20:32',1,1,11,'','','','',''),(12,'NONE','2019-07-30 14:22:07',1,1,11,'','','','',''),(13,'MANAGER','2019-07-30 14:27:12',2,2,2,'','','','',''),(14,'NONE','2019-07-30 14:27:12',1,2,28,'','','','',''),(15,'NONE','2019-07-30 14:27:13',2,3,27,'','','','',''),(16,'MANAGER','2019-07-30 14:27:29',2,2,24,'','','','',''),(17,'MANAGER','2019-07-30 14:27:36',2,2,2,'','','','',''),(18,'NONE','2019-07-30 14:27:36',1,2,28,'','','','',''),(19,'NONE','2019-07-30 14:27:36',2,3,27,'','','','',''),(20,'MANAGER','2019-07-30 14:29:57',2,2,24,'','','','',''),(21,'MANAGER','2019-07-30 14:30:25',2,2,2,'','','','',''),(22,'NONE','2019-07-30 14:30:25',1,2,28,'','','','',''),(23,'NONE','2019-07-30 14:30:25',2,3,27,'','','','',''),(24,'MANAGER','2019-07-30 14:32:06',2,2,24,'','','','',''),(25,'MANAGER','2019-07-30 14:32:27',2,2,2,'','','','',''),(26,'NONE','2019-07-30 14:32:27',1,2,28,'','','','',''),(27,'NONE','2019-07-30 14:32:27',2,3,27,'','','','',''),(28,'1564497148.0','2019-07-30 14:32:42',2,1,14,'','','','',''),(29,'1564497148.0','2019-07-30 14:32:42',2,1,15,'','201','1','',''),(30,'1564497148.0','2019-07-30 14:32:50',2,3,12,'8','1564497162.1','7','',''),(31,'1564497148.0','2019-07-30 14:32:54',2,3,9,'8','4','1','',''),(32,'1564497275.3','2019-07-30 14:34:50',2,1,14,'','','','',''),(33,'1564497275.3','2019-07-30 14:34:50',2,1,15,'','201','1','',''),(34,'1564497275.3','2019-07-30 14:34:53',2,3,12,'3','1564497290.4','2','',''),(35,'1564497275.3','2019-07-30 14:35:19',2,3,9,'3','26','1','',''),(36,'MANAGER','2019-07-30 14:48:01',2,2,24,'','','','',''),(37,'NONE','2019-07-30 17:29:48',1,1,11,'','','','',''),(38,'NONE','2019-07-30 17:31:33',1,1,11,'','','','',''),(39,'MANAGER','2019-07-30 17:37:14',2,2,2,'','','','',''),(40,'NONE','2019-07-30 17:37:14',1,2,28,'','','','',''),(41,'NONE','2019-07-30 17:37:14',2,3,27,'','','','',''),(42,'MANAGER','2019-07-30 17:37:25',2,2,24,'','','','',''),(43,'MANAGER','2019-07-31 09:40:40',2,2,2,'','','','',''),(44,'NONE','2019-07-31 09:40:40',1,2,28,'','','','',''),(45,'NONE','2019-07-31 09:40:40',2,3,27,'','','','',''),(46,'NONE','2019-07-31 09:40:49',1,2,21,'','','','',''),(47,'NONE','2019-07-31 09:40:49',2,3,20,'obed','','','',''),(48,'MANAGER','2019-07-31 09:40:54',2,2,24,'','','','',''),(49,'NONE','2019-07-31 10:25:20',1,1,11,'','','','',''),(50,'NONE','2019-07-31 11:38:12',1,1,11,'','','','',''),(51,'MANAGER','2019-07-31 11:58:49',2,4,2,'','','','',''),(52,'NONE','2019-07-31 11:58:49',1,4,28,'','','','',''),(53,'NONE','2019-07-31 11:58:50',2,5,27,'','','','',''),(54,'MANAGER','2019-07-31 11:59:09',2,4,24,'','','','',''),(55,'MANAGER','2019-07-31 12:07:42',2,2,2,'','','','',''),(56,'NONE','2019-07-31 12:07:42',1,2,28,'','','','',''),(57,'NONE','2019-07-31 12:07:42',2,3,27,'','','','',''),(58,'MANAGER','2019-07-31 12:08:06',2,2,24,'','','','',''),(59,'MANAGER','2019-07-31 12:11:21',2,2,2,'','','','',''),(60,'NONE','2019-07-31 12:11:21',1,2,28,'','','','',''),(61,'NONE','2019-07-31 12:11:21',2,3,27,'','','','',''),(62,'NONE','2019-07-31 12:11:56',1,2,21,'','','','',''),(63,'NONE','2019-07-31 12:11:56',2,3,20,'obed','','','',''),(64,'MANAGER','2019-07-31 12:12:14',2,2,24,'','','','',''),(65,'MANAGER','2019-07-31 12:12:56',2,4,2,'','','','',''),(66,'NONE','2019-07-31 12:12:56',1,4,28,'','','','',''),(67,'NONE','2019-07-31 12:12:56',2,5,27,'','','','',''),(68,'MANAGER','2019-07-31 12:13:08',2,4,24,'','','','',''),(69,'MANAGER','2019-07-31 12:18:10',2,2,2,'','','','',''),(70,'NONE','2019-07-31 12:18:10',1,2,28,'','','','',''),(71,'NONE','2019-07-31 12:18:10',2,3,27,'','','','',''),(72,'NONE','2019-07-31 12:18:42',1,2,21,'','','','',''),(73,'NONE','2019-07-31 12:18:42',2,3,20,'obed','','','',''),(74,'NONE','2019-07-31 12:18:49',1,2,28,'','','','',''),(75,'NONE','2019-07-31 12:18:49',2,3,27,'','','','',''),(76,'MANAGER','2019-07-31 12:19:22',2,2,24,'','','','',''),(77,'MANAGER','2019-07-31 12:23:09',2,2,2,'','','','',''),(78,'NONE','2019-07-31 12:23:09',1,2,28,'','','','',''),(79,'NONE','2019-07-31 12:23:09',2,3,27,'','','','',''),(80,'MANAGER','2019-07-31 12:23:53',2,2,24,'','','','',''),(81,'MANAGER','2019-07-31 12:45:00',2,2,2,'','','','',''),(82,'NONE','2019-07-31 12:45:00',1,2,28,'','','','',''),(83,'NONE','2019-07-31 12:45:00',2,3,27,'','','','',''),(84,'MANAGER','2019-07-31 12:45:35',2,2,24,'','','','',''),(85,'MANAGER','2019-07-31 12:50:38',2,2,2,'','','','',''),(86,'NONE','2019-07-31 12:50:38',1,2,28,'','','','',''),(87,'NONE','2019-07-31 12:50:38',2,3,27,'','','','',''),(88,'MANAGER','2019-07-31 12:52:03',2,2,24,'','','','',''),(89,'MANAGER','2019-07-31 12:54:23',2,2,2,'','','','',''),(90,'NONE','2019-07-31 12:54:23',1,2,28,'','','','',''),(91,'NONE','2019-07-31 12:54:23',2,3,27,'','','','',''),(92,'MANAGER','2019-07-31 12:55:42',2,2,24,'','','','',''),(93,'MANAGER','2019-07-31 13:00:27',2,2,2,'','','','',''),(94,'NONE','2019-07-31 13:00:27',1,2,28,'','','','',''),(95,'NONE','2019-07-31 13:00:27',2,3,27,'','','','',''),(96,'MANAGER','2019-07-31 13:02:00',2,2,24,'','','','',''),(97,'MANAGER','2019-07-31 14:01:49',2,2,2,'','','','',''),(98,'NONE','2019-07-31 14:01:49',1,2,28,'','','','',''),(99,'NONE','2019-07-31 14:01:49',2,3,27,'','','','',''),(100,'1564581710.18','2019-07-31 14:02:11',2,1,14,'','','','',''),(101,'1564581710.18','2019-07-31 14:02:11',2,1,15,'','201','1','',''),(102,'1564581710.18','2019-07-31 14:02:19',2,3,12,'8','1564581731.19','7','',''),(103,'1564581710.18','2019-07-31 14:03:20',2,3,9,'8','61','1','',''),(104,'MANAGER','2019-07-31 14:04:01',2,2,24,'','','','',''),(105,'MANAGER','2019-07-31 14:04:09',2,2,2,'','','','',''),(106,'NONE','2019-07-31 14:04:09',1,2,28,'','','','',''),(107,'NONE','2019-07-31 14:04:09',2,3,27,'','','','',''),(108,'MANAGER','2019-07-31 14:04:49',2,2,24,'','','','',''),(109,'MANAGER','2019-07-31 14:05:08',2,2,2,'','','','',''),(110,'NONE','2019-07-31 14:05:08',1,2,28,'','','','',''),(111,'NONE','2019-07-31 14:05:08',2,3,27,'','','','',''),(112,'MANAGER','2019-07-31 14:12:27',2,2,24,'','','','',''),(113,'MANAGER','2019-07-31 14:15:28',2,6,2,'','','','',''),(114,'NONE','2019-07-31 14:15:28',1,6,28,'','','','',''),(115,'NONE','2019-07-31 14:15:28',2,7,27,'','','','',''),(116,'NONE','2019-07-31 14:25:22',1,1,11,'','','','',''),(117,'MANAGER','2019-07-31 14:44:59',2,6,24,'','','','',''),(118,'MANAGER','2019-07-31 16:46:34',2,2,2,'','','','',''),(119,'NONE','2019-07-31 16:46:34',1,2,28,'','','','',''),(120,'NONE','2019-07-31 16:46:34',2,3,27,'','','','',''),(121,'MANAGER','2019-07-31 16:47:23',2,2,24,'','','','',''),(122,'MANAGER','2019-07-31 16:49:55',2,2,2,'','','','',''),(123,'NONE','2019-07-31 16:49:55',1,2,28,'','','','',''),(124,'NONE','2019-07-31 16:49:55',2,3,27,'','','','',''),(125,'NONE','2019-07-31 16:50:54',1,2,21,'','','','',''),(126,'NONE','2019-07-31 16:50:54',2,3,20,'obed','','','',''),(127,'NONE','2019-07-31 16:51:10',1,2,28,'','','','',''),(128,'NONE','2019-07-31 16:51:10',2,3,27,'','','','',''),(129,'MANAGER','2019-07-31 16:51:19',2,2,24,'','','','',''),(130,'NONE','2019-07-31 16:55:19',1,1,11,'','','','',''),(131,'NONE','2019-07-31 16:55:58',1,1,11,'','','','',''),(132,'NONE','2019-08-01 06:40:12',1,1,23,'','','','',''),(133,'NONE','2019-08-01 06:40:12',1,1,11,'','','','',''),(134,'MANAGER','2019-08-01 06:43:33',2,2,2,'','','','',''),(135,'NONE','2019-08-01 06:43:33',1,2,28,'','','','',''),(136,'NONE','2019-08-01 06:43:33',2,3,27,'','','','',''),(137,'1564641814.2','2019-08-01 06:43:46',2,1,14,'','','','',''),(138,'1564641814.2','2019-08-01 06:43:46',2,1,15,'','201','1','',''),(139,'1564641814.2','2019-08-01 06:43:54',2,3,12,'8','1564641826.3','7','',''),(140,'MANAGER','2019-08-01 06:44:16',2,2,24,'','','','',''),(141,'1564641814.2','2019-08-01 06:44:16',2,3,9,'8','22','1','',''),(142,'MANAGER','2019-08-01 07:51:29',2,2,2,'','','','',''),(143,'NONE','2019-08-01 07:51:29',1,2,28,'','','','',''),(144,'NONE','2019-08-01 07:51:29',2,3,27,'','','','',''),(145,'MANAGER','2019-08-01 07:51:58',2,2,24,'','','','',''),(146,'MANAGER','2019-08-01 07:52:52',2,2,2,'','','','',''),(147,'NONE','2019-08-01 07:52:52',1,2,28,'','','','',''),(148,'NONE','2019-08-01 07:52:52',2,3,27,'','','','',''),(149,'1564645973.9','2019-08-01 07:53:05',2,1,14,'','','','',''),(150,'1564645973.9','2019-08-01 07:53:05',2,1,15,'','201','1','',''),(151,'1564645973.9','2019-08-01 07:53:12',2,3,12,'7','1564645985.10','6','',''),(152,'MANAGER','2019-08-01 07:53:46',2,2,24,'','','','',''),(153,'1564645973.9','2019-08-01 07:53:46',2,3,9,'7','34','1','',''),(154,'NONE','2019-08-01 08:15:16',1,1,11,'','','','',''),(155,'NONE','2019-08-01 08:16:02',1,1,11,'','','','',''),(156,'MANAGER','2019-08-01 08:33:22',2,2,2,'','','','',''),(157,'NONE','2019-08-01 08:33:22',1,2,28,'','','','',''),(158,'NONE','2019-08-01 08:33:22',2,3,27,'','','','',''),(159,'1564648402.13','2019-08-01 08:33:50',2,1,14,'','','','',''),(160,'1564648402.13','2019-08-01 08:33:50',2,1,15,'','201','1','',''),(161,'1564648402.13','2019-08-01 08:34:00',2,3,12,'10','1564648430.14','10','',''),(162,'1564648402.13','2019-08-01 08:34:07',2,3,9,'10','7','1','',''),(163,'1564648447.15','2019-08-01 08:34:22',2,1,14,'','','','',''),(164,'1564648447.15','2019-08-01 08:34:22',2,1,15,'','201','1','',''),(165,'1564648447.15','2019-08-01 08:34:37',2,3,25,'15000','','','',''),(166,'1564648447.15','2019-08-01 08:34:49',2,3,12,'27','1564648482.17','6','',''),(167,'1564648447.15','2019-08-01 08:35:27',2,3,10,'27','38','1','',''),(168,'NONE','2019-08-01 08:36:56',1,2,21,'','','','',''),(169,'NONE','2019-08-01 08:36:56',2,3,20,'obed','','','',''),(170,'MANAGER','2019-08-01 08:37:35',2,2,24,'','','','',''),(171,'NONE','2019-08-01 08:55:59',1,1,11,'','','','',''),(172,'1564649759.21','2019-08-01 08:56:11',2,1,14,'','','','',''),(173,'1564649759.21','2019-08-01 08:56:11',2,1,15,'','201','1','',''),(174,'1564649759.21','2019-08-01 08:56:28',2,1,1,'1','1','17','',''),(175,'1564649789.22','2019-08-01 08:56:43',2,1,14,'','','','',''),(176,'1564649789.22','2019-08-01 08:56:43',2,1,15,'','201','1','',''),(177,'1564649789.22','2019-08-01 08:57:26',2,1,1,'1','1','43','',''),(178,'MANAGER','2019-08-01 08:58:24',2,2,2,'','','','',''),(179,'NONE','2019-08-01 08:58:24',1,2,28,'','','','',''),(180,'NONE','2019-08-01 08:58:24',2,3,27,'','','','',''),(181,'MANAGER','2019-08-01 08:58:27',2,2,24,'','','','',''),(182,'MANAGER','2019-08-01 09:07:10',2,2,2,'','','','',''),(183,'NONE','2019-08-01 09:07:10',1,2,28,'','','','',''),(184,'NONE','2019-08-01 09:07:10',2,3,27,'','','','',''),(185,'MANAGER','2019-08-01 09:07:13',2,2,24,'','','','',''),(186,'MANAGER','2019-08-01 09:07:43',2,2,2,'','','','',''),(187,'NONE','2019-08-01 09:07:43',1,2,28,'','','','',''),(188,'NONE','2019-08-01 09:07:43',2,3,27,'','','','',''),(189,'MANAGER','2019-08-01 09:08:07',2,2,24,'','','','',''),(190,'MANAGER','2019-08-01 09:24:25',2,2,2,'','','','',''),(191,'NONE','2019-08-01 09:24:25',1,2,28,'','','','',''),(192,'NONE','2019-08-01 09:24:25',2,3,27,'','','','',''),(193,'NONE','2019-08-01 09:24:47',1,2,21,'','','','',''),(194,'NONE','2019-08-01 09:24:47',2,3,20,'obed','','','',''),(195,'NONE','2019-08-01 09:24:52',1,2,28,'','','','',''),(196,'NONE','2019-08-01 09:24:52',2,3,27,'','','','',''),(197,'MANAGER','2019-08-01 09:24:56',2,2,24,'','','','',''),(198,'1564651621.31','2019-08-01 09:27:14',1,8,6,'SIP/1001-0000001f','','','',''),(199,'1564651621.31','2019-08-01 09:27:32',1,8,7,'SIP/1001-0000001f','18','','',''),(200,'MANAGER','2019-08-01 09:37:56',2,2,2,'','','','',''),(201,'NONE','2019-08-01 09:37:56',1,2,28,'','','','',''),(202,'NONE','2019-08-01 09:37:56',2,3,27,'','','','',''),(203,'MANAGER','2019-08-01 09:38:34',2,2,24,'','','','',''),(204,'1564653645.35','2019-08-01 10:00:57',1,8,6,'SIP/1001-00000023','','','',''),(205,'1564653645.35','2019-08-01 10:01:49',1,8,7,'SIP/1001-00000023','52','','',''),(206,'MANAGER','2019-08-01 10:02:47',2,2,2,'','','','',''),(207,'NONE','2019-08-01 10:02:47',1,2,28,'','','','',''),(208,'NONE','2019-08-01 10:02:47',2,3,27,'','','','',''),(209,'MANAGER','2019-08-01 10:03:40',2,2,24,'','','','',''),(210,'MANAGER','2019-08-01 10:05:13',2,2,2,'','','','',''),(211,'NONE','2019-08-01 10:05:13',1,2,28,'','','','',''),(212,'NONE','2019-08-01 10:05:13',2,3,27,'','','','',''),(213,'MANAGER','2019-08-01 10:05:29',2,2,24,'','','','',''),(214,'MANAGER','2019-08-01 10:15:33',2,2,2,'','','','',''),(215,'NONE','2019-08-01 10:15:33',1,2,28,'','','','',''),(216,'NONE','2019-08-01 10:15:33',2,3,27,'','','','',''),(217,'MANAGER','2019-08-01 10:16:44',2,2,24,'','','','',''),(218,'MANAGER','2019-08-01 10:27:02',2,2,2,'','','','',''),(219,'NONE','2019-08-01 10:27:02',1,2,28,'','','','',''),(220,'NONE','2019-08-01 10:27:03',2,3,27,'','','','',''),(221,'MANAGER','2019-08-01 10:28:09',2,2,24,'','','','',''),(222,'MANAGER','2019-08-01 10:36:47',2,2,2,'','','','',''),(223,'NONE','2019-08-01 10:36:47',1,2,28,'','','','',''),(224,'NONE','2019-08-01 10:36:47',2,3,27,'','','','',''),(225,'MANAGER','2019-08-01 10:38:02',2,2,24,'','','','',''),(226,'MANAGER','2019-08-01 11:07:06',2,2,2,'','','','',''),(227,'NONE','2019-08-01 11:07:06',1,2,28,'','','','',''),(228,'NONE','2019-08-01 11:07:06',2,3,27,'','','','',''),(229,'MANAGER','2019-08-01 11:09:20',2,2,24,'','','','',''),(230,'MANAGER','2019-08-01 11:11:35',2,2,2,'','','','',''),(231,'NONE','2019-08-01 11:11:35',1,2,28,'','','','',''),(232,'NONE','2019-08-01 11:11:35',2,3,27,'','','','',''),(233,'MANAGER','2019-08-01 11:12:41',2,2,24,'','','','',''),(234,'MANAGER','2019-08-01 11:19:54',2,2,2,'','','','',''),(235,'NONE','2019-08-01 11:19:54',1,2,28,'','','','',''),(236,'NONE','2019-08-01 11:19:54',2,3,27,'','','','',''),(237,'MANAGER','2019-08-01 11:21:31',2,2,24,'','','','',''),(238,'MANAGER','2019-08-01 11:53:53',2,2,2,'','','','',''),(239,'NONE','2019-08-01 11:53:53',1,2,28,'','','','',''),(240,'NONE','2019-08-01 11:53:53',2,3,27,'','','','',''),(241,'MANAGER','2019-08-01 11:54:58',2,2,24,'','','','',''),(242,'MANAGER','2019-08-01 12:04:35',2,2,2,'','','','',''),(243,'NONE','2019-08-01 12:04:35',1,2,28,'','','','',''),(244,'NONE','2019-08-01 12:04:35',2,3,27,'','','','',''),(245,'NONE','2019-08-01 12:05:15',1,2,21,'','','','',''),(246,'NONE','2019-08-01 12:05:15',2,3,20,'obed','','','',''),(247,'NONE','2019-08-01 12:08:32',1,2,28,'','','','',''),(248,'NONE','2019-08-01 12:08:32',2,3,27,'','','','',''),(249,'MANAGER','2019-08-01 12:09:33',2,2,24,'','','','',''),(250,'MANAGER','2019-08-01 12:13:23',2,2,2,'','','','',''),(251,'NONE','2019-08-01 12:13:23',1,2,28,'','','','',''),(252,'NONE','2019-08-01 12:13:23',2,3,27,'','','','',''),(253,'MANAGER','2019-08-01 12:14:34',2,2,24,'','','','',''),(254,'MANAGER','2019-08-01 12:18:19',2,2,2,'','','','',''),(255,'NONE','2019-08-01 12:18:19',1,2,28,'','','','',''),(256,'NONE','2019-08-01 12:18:19',2,3,27,'','','','',''),(257,'MANAGER','2019-08-01 12:19:24',2,2,24,'','','','',''),(258,'MANAGER','2019-08-01 12:55:43',2,2,2,'','','','',''),(259,'NONE','2019-08-01 12:55:43',1,2,28,'','','','',''),(260,'NONE','2019-08-01 12:55:43',2,3,27,'','','','',''),(261,'MANAGER','2019-08-01 12:57:21',2,2,24,'','','','',''),(262,'NONE','2019-08-01 21:29:35',1,1,11,'','','','',''),(263,'1564695330.65','2019-08-01 21:35:42',1,9,6,'SIP/1005-00000041','','','',''),(264,'NONE','2019-08-01 21:45:23',1,1,11,'','','','',''),(265,'1564695330.65','2019-08-01 21:48:34',1,9,7,'SIP/1005-00000041','772','','',''),(266,'NONE','2019-08-02 01:02:02',1,1,11,'','','','',''),(267,'1564743782.72','2019-08-02 11:03:15',1,8,6,'SIP/1001-00000048','','','',''),(268,'1564743782.72','2019-08-02 11:03:28',1,8,7,'SIP/1001-00000048','13','','',''),(269,'1564756008.74','2019-08-02 14:26:48',3,1,14,'0048422069004','','','',''),(270,'1564756008.74','2019-08-02 14:26:48',3,1,15,'','201','1','0048422069004',''),(271,'1564756008.74','2019-08-02 14:26:54',3,1,1,'1','1','6','',''),(272,'1564756123.75','2019-08-02 14:28:43',3,1,14,'0048422069004','','','',''),(273,'1564756123.75','2019-08-02 14:28:43',3,1,15,'','201','1','0048422069004',''),(274,'1564756123.75','2019-08-02 14:28:49',3,1,1,'1','1','6','',''),(275,'1564756233.76','2019-08-02 14:30:33',3,1,14,'0048422069004','','','',''),(276,'1564756233.76','2019-08-02 14:30:33',3,1,15,'','201','1','0048422069004',''),(277,'1564756233.76','2019-08-02 14:30:39',3,1,1,'1','1','6','',''),(278,'1564756349.77','2019-08-02 14:32:30',3,1,14,'0048422069004','','','',''),(279,'1564756349.77','2019-08-02 14:32:30',3,1,15,'','201','1','0048422069004',''),(280,'1564756349.77','2019-08-02 14:32:36',3,1,1,'1','1','6','',''),(281,'1564756461.78','2019-08-02 14:34:22',3,1,14,'0048422069004','','','',''),(282,'1564756461.78','2019-08-02 14:34:22',3,1,15,'','201','1','0048422069004',''),(283,'1564756461.78','2019-08-02 14:34:28',3,1,1,'1','1','6','',''),(284,'1564756805.79','2019-08-02 14:40:06',3,1,14,'0048422069004','','','',''),(285,'1564756805.79','2019-08-02 14:40:06',3,1,15,'','201','1','0048422069004',''),(286,'1564756805.79','2019-08-02 14:40:12',3,1,1,'1','1','6','',''),(287,'1564757035.80','2019-08-02 14:43:55',3,1,14,'0048422069004','','','',''),(288,'1564757035.80','2019-08-02 14:43:55',3,1,15,'','201','1','0048422069004',''),(289,'1564757035.80','2019-08-02 14:44:01',3,1,1,'1','1','6','',''),(290,'1564757160.81','2019-08-02 14:46:00',3,1,14,'0048422069004','','','',''),(291,'1564757160.81','2019-08-02 14:46:00',3,1,15,'','201','1','0048422069004',''),(292,'1564757160.81','2019-08-02 14:46:06',3,1,1,'1','1','6','',''),(293,'1564757271.82','2019-08-02 14:47:51',3,1,14,'0048422069004','','','',''),(294,'1564757271.82','2019-08-02 14:47:51',3,1,15,'','201','1','0048422069004',''),(295,'1564757271.82','2019-08-02 14:47:57',3,1,1,'1','1','6','',''),(296,'1564757726.83','2019-08-02 14:55:27',3,1,14,'0048422069004','','','',''),(297,'1564757726.83','2019-08-02 14:55:27',3,1,15,'','201','1','0048422069004',''),(298,'1564757726.83','2019-08-02 14:55:33',3,1,1,'1','1','6','',''),(299,'1564758069.84','2019-08-02 15:01:10',3,1,14,'0048422069004','','','',''),(300,'1564758069.84','2019-08-02 15:01:10',3,1,15,'','201','1','0048422069004',''),(301,'1564758069.84','2019-08-02 15:01:16',3,1,1,'1','1','6','',''),(302,'1564758175.85','2019-08-02 15:02:56',3,1,14,'0048422069004','','','',''),(303,'1564758175.85','2019-08-02 15:02:56',3,1,15,'','201','1','0048422069004',''),(304,'1564758175.85','2019-08-02 15:03:02',3,1,1,'1','1','6','',''),(305,'1564758281.86','2019-08-02 15:04:42',3,1,14,'0048422069004','','','',''),(306,'1564758281.86','2019-08-02 15:04:42',3,1,15,'','201','1','0048422069004',''),(307,'1564758281.86','2019-08-02 15:04:47',3,1,1,'1','1','5','',''),(308,'1564758398.87','2019-08-02 15:06:39',3,1,14,'0048422069004','','','',''),(309,'1564758398.87','2019-08-02 15:06:39',3,1,15,'','201','1','0048422069004',''),(310,'1564758398.87','2019-08-02 15:06:45',3,1,1,'1','1','6','',''),(311,'1564758507.88','2019-08-02 15:08:27',3,1,14,'0048422069004','','','',''),(312,'1564758507.88','2019-08-02 15:08:27',3,1,15,'','201','1','0048422069004',''),(313,'1564758507.88','2019-08-02 15:08:33',3,1,1,'1','1','6','',''),(314,'1564758632.89','2019-08-02 15:10:32',3,1,14,'0048422069004','','','',''),(315,'1564758632.89','2019-08-02 15:10:32',3,1,15,'','201','1','0048422069004',''),(316,'1564758632.89','2019-08-02 15:10:38',3,1,1,'1','1','6','',''),(317,'1564758749.90','2019-08-02 15:12:30',3,1,14,'0048422069004','','','',''),(318,'1564758749.90','2019-08-02 15:12:30',3,1,15,'','201','1','0048422069004',''),(319,'1564758749.90','2019-08-02 15:12:36',3,1,1,'1','1','6','',''),(320,'1564758854.91','2019-08-02 15:14:14',3,1,14,'0048422069004','','','',''),(321,'1564758854.91','2019-08-02 15:14:14',3,1,15,'','201','1','0048422069004',''),(322,'1564758854.91','2019-08-02 15:14:20',3,1,1,'1','1','6','',''),(323,'1564758970.92','2019-08-02 15:16:11',3,1,14,'0048422069004','','','',''),(324,'1564758970.92','2019-08-02 15:16:11',3,1,15,'','201','1','0048422069004',''),(325,'1564758970.92','2019-08-02 15:16:16',3,1,1,'1','1','5','',''),(326,'1564759078.93','2019-08-02 15:17:59',3,1,14,'0048422069004','','','',''),(327,'1564759078.93','2019-08-02 15:17:59',3,1,15,'','201','1','0048422069004',''),(328,'1564759078.93','2019-08-02 15:18:05',3,1,1,'1','1','6','',''),(329,'1564759194.94','2019-08-02 15:19:55',3,1,14,'0048422069004','','','',''),(330,'1564759194.94','2019-08-02 15:19:55',3,1,15,'','201','1','0048422069004',''),(331,'1564759194.94','2019-08-02 15:20:01',3,1,1,'1','1','6','',''),(332,'1564766476.95','2019-08-02 17:21:17',3,1,14,'0048422069039','','','',''),(333,'1564766476.95','2019-08-02 17:21:17',3,1,15,'','201','1','0048422069039',''),(334,'1564766476.95','2019-08-02 17:21:23',3,1,1,'1','1','6','',''),(335,'1564766590.96','2019-08-02 17:23:11',3,1,14,'0048422069039','','','',''),(336,'1564766590.96','2019-08-02 17:23:11',3,1,15,'','201','1','0048422069039',''),(337,'1564766590.96','2019-08-02 17:23:16',3,1,1,'1','1','5','',''),(338,'1564766622.97','2019-08-02 17:23:43',3,1,14,'0048846181005','','','',''),(339,'1564766622.97','2019-08-02 17:23:43',3,1,15,'','201','1','0048846181005',''),(340,'1564766622.97','2019-08-02 17:23:49',3,1,1,'1','1','6','',''),(341,'1564767037.98','2019-08-02 17:30:38',3,1,14,'0048422069039','','','',''),(342,'1564767037.98','2019-08-02 17:30:38',3,1,15,'','201','1','0048422069039',''),(343,'1564767037.98','2019-08-02 17:30:44',3,1,1,'1','1','6','',''),(344,'1564767143.99','2019-08-02 17:32:23',3,1,14,'0048422069039','','','',''),(345,'1564767143.99','2019-08-02 17:32:23',3,1,15,'','201','1','0048422069039',''),(346,'1564767143.99','2019-08-02 17:32:29',3,1,1,'1','1','6','',''),(347,'1564767256.100','2019-08-02 17:34:16',3,1,14,'0048422069039','','','',''),(348,'1564767256.100','2019-08-02 17:34:16',3,1,15,'','201','1','0048422069039',''),(349,'1564767256.100','2019-08-02 17:34:22',3,1,1,'1','1','6','',''),(350,'1564767386.101','2019-08-02 17:36:26',3,1,14,'0048422069039','','','',''),(351,'1564767386.101','2019-08-02 17:36:26',3,1,15,'','201','1','0048422069039',''),(352,'1564767386.101','2019-08-02 17:36:32',3,1,1,'1','1','6','',''),(353,'1564767491.102','2019-08-02 17:38:11',3,1,14,'0048422069039','','','',''),(354,'1564767491.102','2019-08-02 17:38:11',3,1,15,'','201','1','0048422069039',''),(355,'1564767491.102','2019-08-02 17:38:17',3,1,1,'1','1','6','',''),(356,'1564767610.103','2019-08-02 17:40:11',3,1,14,'0048422069039','','','',''),(357,'1564767610.103','2019-08-02 17:40:11',3,1,15,'','201','1','0048422069039',''),(358,'1564767610.103','2019-08-02 17:40:17',3,1,1,'1','1','6','',''),(359,'1564767726.104','2019-08-02 17:42:06',3,1,14,'0048422069039','','','',''),(360,'1564767726.104','2019-08-02 17:42:06',3,1,15,'','201','1','0048422069039',''),(361,'1564767726.104','2019-08-02 17:42:12',3,1,1,'1','1','6','',''),(362,'1564767844.105','2019-08-02 17:44:04',3,1,14,'0048422069039','','','',''),(363,'1564767844.105','2019-08-02 17:44:04',3,1,15,'','201','1','0048422069039',''),(364,'1564767844.105','2019-08-02 17:44:10',3,1,1,'1','1','6','',''),(365,'1564767955.106','2019-08-02 17:45:55',3,1,14,'0048422069039','','','',''),(366,'1564767955.106','2019-08-02 17:45:55',3,1,15,'','201','1','0048422069039',''),(367,'1564767955.106','2019-08-02 17:46:01',3,1,1,'1','1','6','',''),(368,'1564768078.107','2019-08-02 17:47:58',3,1,14,'0048422069039','','','',''),(369,'1564768078.107','2019-08-02 17:47:58',3,1,15,'','201','1','0048422069039',''),(370,'1564768078.107','2019-08-02 17:48:04',3,1,1,'1','1','6','',''),(371,'1564768659.108','2019-08-02 17:57:40',3,1,14,'0048422069039','','','',''),(372,'1564768659.108','2019-08-02 17:57:40',3,1,15,'','201','1','0048422069039',''),(373,'1564768659.108','2019-08-02 17:57:46',3,1,1,'1','1','6','',''),(374,'1564769012.109','2019-08-02 18:03:33',3,1,14,'0048422069039','','','',''),(375,'1564769012.109','2019-08-02 18:03:33',3,1,15,'','201','1','0048422069039',''),(376,'1564769012.109','2019-08-02 18:03:39',3,1,1,'1','1','6','',''),(377,'1564769358.110','2019-08-02 18:09:18',3,1,14,'0048422069039','','','',''),(378,'1564769358.110','2019-08-02 18:09:18',3,1,15,'','201','1','0048422069039',''),(379,'1564769358.110','2019-08-02 18:09:24',3,1,1,'1','1','6','',''),(380,'1564769475.111','2019-08-02 18:11:15',3,1,14,'0048422069039','','','',''),(381,'1564769475.111','2019-08-02 18:11:15',3,1,15,'','201','1','0048422069039',''),(382,'1564769475.111','2019-08-02 18:11:21',3,1,1,'1','1','6','',''),(383,'1564769595.112','2019-08-02 18:13:15',3,1,14,'0048422069039','','','',''),(384,'1564769595.112','2019-08-02 18:13:15',3,1,15,'','201','1','0048422069039',''),(385,'1564769595.112','2019-08-02 18:13:21',3,1,1,'1','1','6','',''),(386,'1564769704.113','2019-08-02 18:15:05',3,1,14,'0048422069039','','','',''),(387,'1564769704.113','2019-08-02 18:15:05',3,1,15,'','201','1','0048422069039',''),(388,'1564769704.113','2019-08-02 18:15:11',3,1,1,'1','1','6','',''),(389,'1564769820.114','2019-08-02 18:17:01',3,1,14,'0048422069039','','','',''),(390,'1564769820.114','2019-08-02 18:17:01',3,1,15,'','201','1','0048422069039',''),(391,'1564769820.114','2019-08-02 18:17:07',3,1,1,'1','1','6','',''),(392,'1564769943.115','2019-08-02 18:19:03',3,1,14,'0048422069039','','','',''),(393,'1564769943.115','2019-08-02 18:19:03',3,1,15,'','201','1','0048422069039',''),(394,'1564769943.115','2019-08-02 18:19:09',3,1,1,'1','1','6','',''),(395,'1564770046.116','2019-08-02 18:20:46',3,1,14,'0048422069039','','','',''),(396,'1564770046.116','2019-08-02 18:20:46',3,1,15,'','201','1','0048422069039',''),(397,'1564770046.116','2019-08-02 18:20:52',3,1,1,'1','1','6','',''),(398,'1564770161.117','2019-08-02 18:22:42',3,1,14,'0048422069039','','','',''),(399,'1564770161.117','2019-08-02 18:22:42',3,1,15,'','201','1','0048422069039',''),(400,'1564770161.117','2019-08-02 18:22:48',3,1,1,'1','1','6','',''),(401,'1564770287.118','2019-08-02 18:24:48',3,1,14,'0048422069039','','','',''),(402,'1564770287.118','2019-08-02 18:24:48',3,1,15,'','201','1','0048422069039',''),(403,'1564770287.118','2019-08-02 18:24:53',3,1,1,'1','1','5','',''),(404,'1564770404.119','2019-08-02 18:26:45',3,1,14,'0048422069039','','','',''),(405,'1564770404.119','2019-08-02 18:26:45',3,1,15,'','201','1','0048422069039',''),(406,'1564770404.119','2019-08-02 18:26:51',3,1,1,'1','1','6','',''),(407,'1564770515.120','2019-08-02 18:28:35',3,1,14,'0048422069039','','','',''),(408,'1564770515.120','2019-08-02 18:28:35',3,1,15,'','201','1','0048422069039',''),(409,'1564770515.120','2019-08-02 18:28:41',3,1,1,'1','1','6','',''),(410,'1564770634.121','2019-08-02 18:30:34',3,1,14,'0048422069039','','','',''),(411,'1564770634.121','2019-08-02 18:30:34',3,1,15,'','201','1','0048422069039',''),(412,'1564770634.121','2019-08-02 18:30:40',3,1,1,'1','1','6','',''),(413,'1564770752.122','2019-08-02 18:32:32',3,1,14,'0048422069039','','','',''),(414,'1564770752.122','2019-08-02 18:32:32',3,1,15,'','201','1','0048422069039',''),(415,'1564770752.122','2019-08-02 18:32:38',3,1,1,'1','1','6','',''),(416,'1564770858.123','2019-08-02 18:34:19',3,1,14,'0048422069039','','','',''),(417,'1564770858.123','2019-08-02 18:34:19',3,1,15,'','201','1','0048422069039',''),(418,'1564770858.123','2019-08-02 18:34:25',3,1,1,'1','1','6','',''),(419,'1564775073.124','2019-08-02 19:44:33',3,1,14,'0048221530248','','','',''),(420,'1564775073.124','2019-08-02 19:44:33',3,1,15,'','201','1','0048221530248',''),(421,'1564775073.124','2019-08-02 19:44:39',3,1,1,'1','1','6','',''),(422,'1564775793.125','2019-08-02 19:56:33',3,1,14,'+46812410249','','','',''),(423,'1564775793.125','2019-08-02 19:56:33',3,1,15,'','201','1','+46812410249',''),(424,'1564775793.125','2019-08-02 19:56:39',3,1,1,'1','1','6','',''),(425,'1564776357.126','2019-08-02 20:05:58',3,1,14,'0046812410249','','','',''),(426,'1564776357.126','2019-08-02 20:05:58',3,1,15,'','201','1','0046812410249',''),(427,'1564776357.126','2019-08-02 20:06:04',3,1,1,'1','1','6','',''),(428,'1564776953.127','2019-08-02 20:15:54',3,1,14,'00046812410249','','','',''),(429,'1564776953.127','2019-08-02 20:15:54',3,1,15,'','201','1','00046812410249',''),(430,'1564776953.127','2019-08-02 20:16:00',3,1,1,'1','1','6','',''),(431,'1564777573.128','2019-08-02 20:26:14',3,1,14,'01146812410249','','','',''),(432,'1564777573.128','2019-08-02 20:26:14',3,1,15,'','201','1','01146812410249',''),(433,'1564777573.128','2019-08-02 20:26:20',3,1,1,'1','1','6','',''),(434,'1564778197.129','2019-08-02 20:36:37',3,1,14,'901146812410249','','','',''),(435,'1564778197.129','2019-08-02 20:36:37',3,1,15,'','201','1','901146812410249',''),(436,'1564778197.129','2019-08-02 20:36:43',3,1,1,'1','1','6','',''),(437,'NONE','2019-08-03 04:09:52',1,1,23,'','','','',''),(438,'NONE','2019-08-03 04:09:52',1,1,11,'','','','',''),(439,'1564805882.0','2019-08-03 04:18:02',3,1,14,'900246812410249','','','',''),(440,'1564805882.0','2019-08-03 04:18:02',3,1,15,'','201','1','900246812410249',''),(441,'1564805882.0','2019-08-03 04:18:08',3,1,1,'1','1','6','',''),(442,'1564805918.1','2019-08-03 04:18:38',3,1,14,'0048846181005','','','',''),(443,'1564805918.1','2019-08-03 04:18:38',3,1,15,'','201','1','0048846181005',''),(444,'1564805918.1','2019-08-03 04:18:44',3,1,1,'1','1','6','',''),(445,'1564806512.2','2019-08-03 04:28:32',3,1,14,'900746812410249','','','',''),(446,'1564806512.2','2019-08-03 04:28:32',3,1,15,'','201','1','900746812410249',''),(447,'1564806512.2','2019-08-03 04:28:38',3,1,1,'1','1','6','',''),(448,'1564807025.3','2019-08-03 04:37:05',3,1,14,'900846812410249','','','',''),(449,'1564807025.3','2019-08-03 04:37:05',3,1,15,'','201','1','900846812410249',''),(450,'1564807025.3','2019-08-03 04:37:11',3,1,1,'1','1','6','',''),(451,'1564807388.4','2019-08-03 04:43:09',3,1,14,'900946812410249','','','',''),(452,'1564807388.4','2019-08-03 04:43:09',3,1,15,'','201','1','900946812410249',''),(453,'1564807388.4','2019-08-03 04:43:15',3,1,1,'1','1','6','',''),(454,'1564807710.5','2019-08-03 04:48:31',3,1,14,'01246812410249','','','',''),(455,'1564807710.5','2019-08-03 04:48:31',3,1,15,'','201','1','01246812410249',''),(456,'1564807710.5','2019-08-03 04:48:37',3,1,1,'1','1','6','',''),(457,'MANAGER','2019-08-03 09:38:21',2,2,2,'','','','',''),(458,'NONE','2019-08-03 09:38:21',1,2,28,'','','','',''),(459,'NONE','2019-08-03 09:38:21',2,3,27,'','','','',''),(460,'MANAGER','2019-08-03 09:39:52',2,2,24,'','','','',''),(461,'MANAGER','2019-08-03 09:42:18',2,2,2,'','','','',''),(462,'NONE','2019-08-03 09:42:18',1,2,28,'','','','',''),(463,'NONE','2019-08-03 09:42:18',2,3,27,'','','','',''),(464,'MANAGER','2019-08-03 09:44:23',2,2,24,'','','','',''),(465,'1564828236.10','2019-08-03 10:30:46',2,1,14,'','','','',''),(466,'1564828236.10','2019-08-03 10:30:46',2,1,15,'','201','1','',''),(467,'1564828236.10','2019-08-03 10:31:29',2,1,1,'1','1','43','',''),(468,'1564828290.11','2019-08-03 10:31:45',2,1,14,'','','','',''),(469,'1564828290.11','2019-08-03 10:31:45',2,1,15,'','201','1','',''),(470,'1564828290.11','2019-08-03 10:31:46',2,1,1,'1','1','1','',''),(471,'1564828308.12','2019-08-03 10:31:58',2,1,14,'','','','',''),(472,'1564828308.12','2019-08-03 10:31:58',2,1,15,'','201','1','',''),(473,'1564828308.12','2019-08-03 10:31:59',2,1,1,'1','1','1','',''),(474,'MANAGER','2019-08-03 10:33:10',2,6,2,'','','','',''),(475,'NONE','2019-08-03 10:33:10',1,6,28,'','','','',''),(476,'NONE','2019-08-03 10:33:10',2,7,27,'','','','',''),(477,'1564828390.14','2019-08-03 10:33:21',2,1,14,'','','','',''),(478,'1564828390.14','2019-08-03 10:33:21',2,1,15,'','201','1','',''),(479,'1564828390.14','2019-08-03 10:33:24',2,7,12,'3','1564828401.15','3','',''),(480,'1564828390.14','2019-08-03 10:33:31',2,7,10,'3','7','1','',''),(481,'1564828495.16','2019-08-03 10:35:10',2,1,14,'','','','',''),(482,'1564828495.16','2019-08-03 10:35:10',2,1,15,'','201','1','',''),(483,'1564828495.16','2019-08-03 10:35:13',2,7,12,'3','1564828510.18','2','',''),(484,'1564828495.17','2019-08-03 10:35:14',2,1,14,'','','','',''),(485,'1564828495.17','2019-08-03 10:35:14',2,1,15,'','201','1','',''),(486,'1564828495.17','2019-08-03 10:35:29',2,7,25,'15000','','','',''),(487,'1564828495.16','2019-08-03 10:35:31',2,7,10,'3','18','1','',''),(488,'1564828495.17','2019-08-03 10:35:34',2,1,1,'1','1','20','',''),(489,'1564828534.22','2019-08-03 10:35:47',2,1,14,'','','','',''),(490,'1564828534.22','2019-08-03 10:35:47',2,1,15,'','201','1','',''),(491,'1564828534.22','2019-08-03 10:35:51',2,7,12,'4','1564828547.23','3','',''),(492,'1564828534.22','2019-08-03 10:35:54',2,7,10,'4','3','1','',''),(493,'1564828607.25','2019-08-03 10:37:00',2,1,14,'','','','',''),(494,'1564828607.25','2019-08-03 10:37:00',2,1,15,'','201','1','',''),(495,'1564828607.25','2019-08-03 10:37:03',2,7,12,'3','1564828620.26','2','',''),(496,'1564828607.25','2019-08-03 10:37:11',2,7,9,'3','8','1','',''),(497,'1564828640.27','2019-08-03 10:37:34',2,1,14,'','','','',''),(498,'1564828640.27','2019-08-03 10:37:34',2,1,15,'','201','1','',''),(499,'1564828640.27','2019-08-03 10:37:37',2,7,12,'3','1564828654.28','2','',''),(500,'1564828640.27','2019-08-03 10:40:41',2,7,10,'3','184','1','',''),(501,'1564831842.29','2019-08-03 11:30:42',3,1,14,'0048422069004','','','',''),(502,'1564831842.29','2019-08-03 11:30:42',3,1,15,'','201','1','0048422069004',''),(503,'1564831842.29','2019-08-03 11:31:07',3,1,1,'1','1','25','',''),(504,'1564831943.30','2019-08-03 11:32:23',3,1,14,'0048422069004','','','',''),(505,'1564831943.30','2019-08-03 11:32:23',3,1,15,'','201','1','0048422069004',''),(506,'1564831943.30','2019-08-03 11:32:48',3,1,1,'1','1','25','',''),(507,'1564832057.31','2019-08-03 11:34:18',3,1,14,'0048422069004','','','',''),(508,'1564832057.31','2019-08-03 11:34:18',3,1,15,'','201','1','0048422069004',''),(509,'1564832057.31','2019-08-03 11:34:43',3,1,1,'1','1','25','',''),(510,'1564832169.32','2019-08-03 11:36:09',3,1,14,'0048422069004','','','',''),(511,'1564832169.32','2019-08-03 11:36:09',3,1,15,'','201','1','0048422069004',''),(512,'1564832169.32','2019-08-03 11:36:40',3,1,1,'1','1','31','',''),(513,'1564832277.33','2019-08-03 11:37:57',3,1,14,'0048422069004','','','',''),(514,'1564832277.33','2019-08-03 11:37:57',3,1,15,'','201','1','0048422069004',''),(515,'1564832277.33','2019-08-03 11:38:28',3,1,1,'1','1','31','',''),(516,'1564832628.34','2019-08-03 11:43:48',3,1,14,'0048422069004','','','',''),(517,'1564832628.34','2019-08-03 11:43:48',3,1,15,'','201','1','0048422069004',''),(518,'1564832628.34','2019-08-03 11:44:14',3,1,1,'1','1','26','',''),(519,'1564832838.35','2019-08-03 11:47:18',3,1,14,'0048422069004','','','',''),(520,'1564832838.35','2019-08-03 11:47:18',3,1,15,'','201','1','0048422069004',''),(521,'1564832838.35','2019-08-03 11:47:45',3,1,1,'1','1','27','',''),(522,'1564832954.36','2019-08-03 11:49:15',3,1,14,'0048422069004','','','',''),(523,'1564832954.36','2019-08-03 11:49:15',3,1,15,'','201','1','0048422069004',''),(524,'1564832954.36','2019-08-03 11:49:41',3,1,1,'1','1','26','',''),(525,'1564833065.37','2019-08-03 11:51:06',3,1,14,'0048422069004','','','',''),(526,'1564833065.37','2019-08-03 11:51:06',3,1,15,'','201','1','0048422069004',''),(527,'1564833065.37','2019-08-03 11:51:33',3,1,1,'1','1','27','',''),(528,'1564833517.38','2019-08-03 11:58:38',3,1,14,'0048422069004','','','',''),(529,'1564833517.38','2019-08-03 11:58:38',3,1,15,'','201','1','0048422069004',''),(530,'1564833517.38','2019-08-03 11:59:06',3,1,1,'1','1','28','',''),(531,'1564833855.39','2019-08-03 12:04:15',3,1,14,'0048422069004','','','',''),(532,'1564833855.39','2019-08-03 12:04:15',3,1,15,'','201','1','0048422069004',''),(533,'1564833855.39','2019-08-03 12:04:44',3,1,1,'1','1','29','',''),(534,'1564833961.40','2019-08-03 12:06:01',3,1,14,'0048422069004','','','',''),(535,'1564833961.40','2019-08-03 12:06:01',3,1,15,'','201','1','0048422069004',''),(536,'1564833961.40','2019-08-03 12:06:30',3,1,1,'1','1','29','',''),(537,'1564834091.41','2019-08-03 12:08:12',3,1,14,'0048422069004','','','',''),(538,'1564834091.41','2019-08-03 12:08:12',3,1,15,'','201','1','0048422069004',''),(539,'1564834091.41','2019-08-03 12:08:41',3,1,1,'1','1','29','',''),(540,'1564834192.42','2019-08-03 12:09:53',3,1,14,'0048422069004','','','',''),(541,'1564834192.42','2019-08-03 12:09:53',3,1,15,'','201','1','0048422069004',''),(542,'1564834192.42','2019-08-03 12:10:23',3,1,1,'1','1','30','',''),(543,'1564834305.43','2019-08-03 12:11:45',3,1,14,'0048422069004','','','',''),(544,'1564834305.43','2019-08-03 12:11:45',3,1,15,'','201','1','0048422069004',''),(545,'1564834305.43','2019-08-03 12:12:15',3,1,1,'1','1','30','',''),(546,'1564834408.44','2019-08-03 12:13:28',3,1,14,'0048422069004','','','',''),(547,'1564834408.44','2019-08-03 12:13:28',3,1,15,'','201','1','0048422069004',''),(548,'1564834408.44','2019-08-03 12:13:58',3,1,1,'1','1','30','',''),(549,'1564834523.45','2019-08-03 12:15:24',3,1,14,'0048422069004','','','',''),(550,'1564834523.45','2019-08-03 12:15:24',3,1,15,'','201','1','0048422069004',''),(551,'1564834523.45','2019-08-03 12:15:54',3,1,1,'1','1','30','',''),(552,'1564834637.46','2019-08-03 12:17:17',3,1,14,'0048422069004','','','',''),(553,'1564834637.46','2019-08-03 12:17:17',3,1,15,'','201','1','0048422069004',''),(554,'1564834637.46','2019-08-03 12:17:48',3,1,1,'1','1','31','',''),(555,'1564834736.47','2019-08-03 12:18:56',3,1,14,'0048422069004','','','',''),(556,'1564834736.47','2019-08-03 12:18:56',3,1,15,'','201','1','0048422069004',''),(557,'1564834736.47','2019-08-03 12:19:27',3,1,1,'1','1','31','',''),(558,'1564834852.48','2019-08-03 12:20:53',3,1,14,'0048422069004','','','',''),(559,'1564834852.48','2019-08-03 12:20:53',3,1,15,'','201','1','0048422069004',''),(560,'1564834852.48','2019-08-03 12:21:23',3,1,1,'1','1','30','',''),(561,'1564834967.49','2019-08-03 12:22:47',3,1,14,'0048422069004','','','',''),(562,'1564834967.49','2019-08-03 12:22:47',3,1,15,'','201','1','0048422069004',''),(563,'1564834967.49','2019-08-03 12:23:18',3,1,1,'1','1','31','',''),(564,'1564837987.50','2019-08-03 13:13:07',3,1,14,'0048846181005','','','',''),(565,'1564837987.50','2019-08-03 13:13:07',3,1,15,'','201','1','0048846181005',''),(566,'1564837987.50','2019-08-03 13:13:38',3,1,1,'1','1','31','',''),(567,'MANAGER','2019-08-03 13:49:33',2,6,24,'','','','',''),(568,'1564842383.51','2019-08-03 14:26:23',3,1,14,'0048422069039','','','',''),(569,'1564842383.51','2019-08-03 14:26:23',3,1,15,'','201','1','0048422069039',''),(570,'1564842383.51','2019-08-03 14:26:54',3,1,1,'1','1','31','',''),(571,'1564842498.52','2019-08-03 14:28:19',3,1,14,'0048422069039','','','',''),(572,'1564842498.52','2019-08-03 14:28:19',3,1,15,'','201','1','0048422069039',''),(573,'1564842498.52','2019-08-03 14:28:49',3,1,1,'1','1','30','',''),(574,'1564842964.53','2019-08-03 14:36:04',3,1,14,'0048422069039','','','',''),(575,'1564842964.53','2019-08-03 14:36:04',3,1,15,'','201','1','0048422069039',''),(576,'1564842964.53','2019-08-03 14:36:35',3,1,1,'1','1','31','',''),(577,'1564843084.54','2019-08-03 14:38:04',3,1,14,'0048422069039','','','',''),(578,'1564843084.54','2019-08-03 14:38:04',3,1,15,'','201','1','0048422069039',''),(579,'1564843084.54','2019-08-03 14:38:35',3,1,1,'1','1','31','',''),(580,'1564843191.55','2019-08-03 14:39:52',3,1,14,'0048422069039','','','',''),(581,'1564843191.55','2019-08-03 14:39:52',3,1,15,'','201','1','0048422069039',''),(582,'1564843191.55','2019-08-03 14:40:22',3,1,1,'1','1','30','',''),(583,'1564843314.56','2019-08-03 14:41:54',3,1,14,'0048422069039','','','',''),(584,'1564843314.56','2019-08-03 14:41:54',3,1,15,'','201','1','0048422069039',''),(585,'1564843314.56','2019-08-03 14:42:25',3,1,1,'1','1','31','',''),(586,'1564843421.57','2019-08-03 14:43:42',3,1,14,'0048422069039','','','',''),(587,'1564843421.57','2019-08-03 14:43:42',3,1,15,'','201','1','0048422069039',''),(588,'1564843421.57','2019-08-03 14:44:12',3,1,1,'1','1','30','',''),(589,'1564843538.58','2019-08-03 14:45:38',3,1,14,'0048422069039','','','',''),(590,'1564843538.58','2019-08-03 14:45:38',3,1,15,'','201','1','0048422069039',''),(591,'1564843538.58','2019-08-03 14:46:09',3,1,1,'1','1','31','',''),(592,'1564843657.59','2019-08-03 14:47:38',3,1,14,'0048422069039','','','',''),(593,'1564843657.59','2019-08-03 14:47:38',3,1,15,'','201','1','0048422069039',''),(594,'1564843657.59','2019-08-03 14:48:08',3,1,1,'1','1','30','',''),(595,'1564843773.60','2019-08-03 14:49:34',3,1,14,'0048422069039','','','',''),(596,'1564843773.60','2019-08-03 14:49:34',3,1,15,'','201','1','0048422069039',''),(597,'1564843773.60','2019-08-03 14:50:04',3,1,1,'1','1','30','',''),(598,'1564843889.61','2019-08-03 14:51:29',3,1,14,'0048422069039','','','',''),(599,'1564843889.61','2019-08-03 14:51:29',3,1,15,'','201','1','0048422069039',''),(600,'1564843889.61','2019-08-03 14:52:00',3,1,1,'1','1','31','',''),(601,'1564844004.62','2019-08-03 14:53:25',3,1,14,'0048422069039','','','',''),(602,'1564844004.62','2019-08-03 14:53:25',3,1,15,'','201','1','0048422069039',''),(603,'1564844004.62','2019-08-03 14:53:55',3,1,1,'1','1','30','',''),(604,'1564844576.63','2019-08-03 15:02:56',3,1,14,'0048422069039','','','',''),(605,'1564844576.63','2019-08-03 15:02:56',3,1,15,'','201','1','0048422069039',''),(606,'1564844576.63','2019-08-03 15:03:27',3,1,1,'1','1','31','',''),(607,'1564844905.64','2019-08-03 15:08:25',3,1,14,'0048422069039','','','',''),(608,'1564844905.64','2019-08-03 15:08:25',3,1,15,'','201','1','0048422069039',''),(609,'1564844905.64','2019-08-03 15:08:56',3,1,1,'1','1','31','',''),(610,'1564845247.65','2019-08-03 15:14:08',3,1,14,'0048422069039','','','',''),(611,'1564845247.65','2019-08-03 15:14:08',3,1,15,'','201','1','0048422069039',''),(612,'1564845247.65','2019-08-03 15:14:38',3,1,1,'1','1','30','',''),(613,'1564845360.66','2019-08-03 15:16:00',3,1,14,'0048422069039','','','',''),(614,'1564845360.66','2019-08-03 15:16:00',3,1,15,'','201','1','0048422069039',''),(615,'1564845360.66','2019-08-03 15:16:31',3,1,1,'1','1','31','',''),(616,'1564845487.67','2019-08-03 15:18:08',3,1,14,'0048422069039','','','',''),(617,'1564845487.67','2019-08-03 15:18:08',3,1,15,'','201','1','0048422069039',''),(618,'1564845487.67','2019-08-03 15:18:38',3,1,1,'1','1','30','',''),(619,'1564845591.68','2019-08-03 15:19:52',3,1,14,'0048422069039','','','',''),(620,'1564845591.68','2019-08-03 15:19:52',3,1,15,'','201','1','0048422069039',''),(621,'1564845591.68','2019-08-03 15:20:22',3,1,1,'1','1','30','',''),(622,'1564845712.69','2019-08-03 15:21:53',3,1,14,'0048422069039','','','',''),(623,'1564845712.69','2019-08-03 15:21:53',3,1,15,'','201','1','0048422069039',''),(624,'1564845712.69','2019-08-03 15:22:23',3,1,1,'1','1','30','',''),(625,'1564845821.70','2019-08-03 15:23:42',3,1,14,'0048422069039','','','',''),(626,'1564845821.70','2019-08-03 15:23:42',3,1,15,'','201','1','0048422069039',''),(627,'1564845821.70','2019-08-03 15:24:12',3,1,1,'1','1','30','',''),(628,'1564845935.71','2019-08-03 15:25:36',3,1,14,'0048422069039','','','',''),(629,'1564845935.71','2019-08-03 15:25:36',3,1,15,'','201','1','0048422069039',''),(630,'1564845935.71','2019-08-03 15:26:06',3,1,1,'1','1','30','',''),(631,'1564846055.72','2019-08-03 15:27:36',3,1,14,'0048422069039','','','',''),(632,'1564846055.72','2019-08-03 15:27:36',3,1,15,'','201','1','0048422069039',''),(633,'1564846055.72','2019-08-03 15:28:06',3,1,1,'1','1','30','',''),(634,'1564846185.73','2019-08-03 15:29:45',3,1,14,'0048422069039','','','',''),(635,'1564846185.73','2019-08-03 15:29:45',3,1,15,'','201','1','0048422069039',''),(636,'1564846185.73','2019-08-03 15:30:16',3,1,1,'1','1','31','',''),(637,'1564846290.74','2019-08-03 15:31:31',3,1,14,'0048422069039','','','',''),(638,'1564846290.74','2019-08-03 15:31:31',3,1,15,'','201','1','0048422069039',''),(639,'1564846290.74','2019-08-03 15:32:01',3,1,1,'1','1','30','',''),(640,'1564846405.75','2019-08-03 15:33:26',3,1,14,'0048422069039','','','',''),(641,'1564846405.75','2019-08-03 15:33:26',3,1,15,'','201','1','0048422069039',''),(642,'1564846405.75','2019-08-03 15:33:56',3,1,1,'1','1','30','',''),(643,'1564846525.76','2019-08-03 15:35:25',3,1,14,'0048422069039','','','',''),(644,'1564846525.76','2019-08-03 15:35:25',3,1,15,'','201','1','0048422069039',''),(645,'1564846525.76','2019-08-03 15:35:56',3,1,1,'1','1','31','',''),(646,'1564846634.77','2019-08-03 15:37:14',3,1,14,'0048422069039','','','',''),(647,'1564846634.77','2019-08-03 15:37:14',3,1,15,'','201','1','0048422069039',''),(648,'1564846634.77','2019-08-03 15:37:45',3,1,1,'1','1','31','',''),(649,'1564846749.78','2019-08-03 15:39:10',3,1,14,'0048422069039','','','',''),(650,'1564846749.78','2019-08-03 15:39:10',3,1,15,'','201','1','0048422069039',''),(651,'1564846749.78','2019-08-03 15:39:40',3,1,1,'1','1','30','',''),(652,'1564849765.79','2019-08-03 16:29:25',3,1,14,'18104790645','','','',''),(653,'1564849765.79','2019-08-03 16:29:25',3,1,15,'','201','1','18104790645',''),(654,'1564849765.79','2019-08-03 16:29:31',3,1,1,'1','1','6','',''),(655,'1564849885.80','2019-08-03 16:31:26',3,1,14,'0018104790645','','','',''),(656,'1564849885.80','2019-08-03 16:31:26',3,1,15,'','201','1','0018104790645',''),(657,'1564849885.80','2019-08-03 16:31:32',3,1,1,'1','1','6','',''),(658,'1564850024.81','2019-08-03 16:33:45',3,1,14,'00018104790645','','','',''),(659,'1564850024.81','2019-08-03 16:33:45',3,1,15,'','201','1','00018104790645',''),(660,'1564850024.81','2019-08-03 16:33:51',3,1,1,'1','1','6','',''),(661,'1564850154.82','2019-08-03 16:35:55',3,1,14,'90018104790645','','','',''),(662,'1564850154.82','2019-08-03 16:35:55',3,1,15,'','201','1','90018104790645',''),(663,'1564850154.82','2019-08-03 16:36:00',3,1,1,'1','1','5','',''),(664,'1564850300.83','2019-08-03 16:38:21',3,1,14,'80018104790645','','','',''),(665,'1564850300.83','2019-08-03 16:38:21',3,1,15,'','201','1','80018104790645',''),(666,'1564850300.83','2019-08-03 16:38:27',3,1,1,'1','1','6','',''),(667,'1564850425.84','2019-08-03 16:40:25',3,1,14,'10018104790645','','','',''),(668,'1564850425.84','2019-08-03 16:40:25',3,1,15,'','201','1','10018104790645',''),(669,'1564850425.84','2019-08-03 16:40:31',3,1,1,'1','1','6','',''),(670,'MANAGER','2019-08-03 16:53:55',2,2,2,'','','','',''),(671,'NONE','2019-08-03 16:53:55',1,2,28,'','','','',''),(672,'NONE','2019-08-03 16:53:55',2,3,27,'','','','',''),(673,'MANAGER','2019-08-03 16:54:27',2,2,24,'','','','',''),(674,'1564851383.85','2019-08-03 16:56:24',3,1,14,'0048846181005','','','',''),(675,'1564851383.85','2019-08-03 16:56:24',3,1,15,'','201','1','0048846181005',''),(676,'1564851383.85','2019-08-03 16:56:30',3,1,1,'1','1','6','',''),(677,'MANAGER','2019-08-03 16:57:19',2,2,2,'','','','',''),(678,'NONE','2019-08-03 16:57:19',1,2,28,'','','','',''),(679,'NONE','2019-08-03 16:57:19',2,3,27,'','','','',''),(680,'MANAGER','2019-08-03 16:57:41',2,2,24,'','','','',''),(681,'MANAGER','2019-08-03 17:06:49',2,2,2,'','','','',''),(682,'NONE','2019-08-03 17:06:49',1,2,28,'','','','',''),(683,'NONE','2019-08-03 17:06:49',2,3,27,'','','','',''),(684,'MANAGER','2019-08-03 17:10:33',2,2,24,'','','','',''),(685,'MANAGER','2019-08-03 17:20:45',2,2,2,'','','','',''),(686,'NONE','2019-08-03 17:20:45',1,2,28,'','','','',''),(687,'NONE','2019-08-03 17:20:45',2,3,27,'','','','',''),(688,'MANAGER','2019-08-03 17:25:01',2,2,24,'','','','',''),(689,'MANAGER','2019-08-03 17:37:51',2,2,2,'','','','',''),(690,'NONE','2019-08-03 17:37:51',1,2,28,'','','','',''),(691,'NONE','2019-08-03 17:37:51',2,3,27,'','','','',''),(692,'MANAGER','2019-08-03 17:39:53',2,2,24,'','','','',''),(693,'NONE','2019-08-03 18:08:13',1,1,11,'','','','',''),(694,'MANAGER','2019-08-03 18:17:17',2,2,2,'','','','',''),(695,'NONE','2019-08-03 18:17:17',1,2,28,'','','','',''),(696,'NONE','2019-08-03 18:17:17',2,3,27,'','','','',''),(697,'MANAGER','2019-08-03 18:20:23',2,6,2,'','','','',''),(698,'NONE','2019-08-03 18:20:23',1,6,28,'','','','',''),(699,'NONE','2019-08-03 18:20:23',2,7,27,'','','','',''),(700,'1564856663.87','2019-08-03 18:24:32',2,1,14,'','','','',''),(701,'1564856663.87','2019-08-03 18:24:32',2,1,15,'','201','1','',''),(702,'1564856663.87','2019-08-03 18:24:39',2,7,12,'7','1564856672.88','7','',''),(703,'1564856663.87','2019-08-03 18:25:07',2,7,9,'7','28','1','',''),(704,'MANAGER','2019-08-03 18:25:59',2,6,24,'','','','',''),(705,'1564856787.92','2019-08-03 18:26:37',2,1,14,'','','','',''),(706,'1564856787.92','2019-08-03 18:26:37',2,1,15,'','201','1','',''),(707,'1564856787.92','2019-08-03 18:26:40',2,3,12,'3','1564856797.93','3','',''),(708,'1564856787.92','2019-08-03 18:26:45',2,3,9,'3','5','1','',''),(709,'MANAGER','2019-08-03 18:27:07',2,2,24,'','','','',''),(710,'1564856808.94','2019-08-03 18:27:15',2,1,14,'','','','',''),(711,'1564856808.94','2019-08-03 18:27:15',2,1,15,'','201','1','',''),(712,'1564856808.94','2019-08-03 18:27:18',2,1,1,'1','1','3','',''),(713,'NONE','2019-08-03 18:52:57',1,1,11,'','','','','');
/*!40000 ALTER TABLE `queue_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `queue_stats_mv`
--

LOCK TABLES `queue_stats_mv` WRITE;
/*!40000 ALTER TABLE `queue_stats_mv` DISABLE KEYS */;
INSERT INTO `queue_stats_mv` (`id`, `datetime`, `datetimeconnect`, `datetimeend`, `queue`, `agent`, `event`, `uniqueid`, `clid`, `url`, `did`, `position`, `info1`, `info2`, `info3`, `info4`, `info5`, `overflow`) VALUES (1,'2019-07-30 17:27:12','2019-07-30 14:27:12','2019-07-30 14:27:12','1000','SIP/1001','ADDMEMBER','x.1564860235.13','','','',1,'','','','','',1),(2,'2019-07-30 17:27:12','2019-07-30 14:27:12','2019-07-30 14:27:12','NONE','SIP/1001','UNPAUSEALL','x.1564860235.14','','','',1,'','','','','',1),(3,'2019-07-30 17:27:13','2019-07-30 14:27:13','2019-07-30 14:27:13','1000','agent1001','UNPAUSE','x.1564860235.15','','','',1,'','','','','',1),(4,'2019-07-30 17:27:29','2019-07-30 14:27:29','2019-07-30 14:27:29','1000','SIP/1001','REMOVEMEMBER','x.1564860235.16','','','',1,'','','','','',1),(5,'2019-07-30 17:27:36','2019-07-30 14:27:36','2019-07-30 14:27:36','1000','SIP/1001','ADDMEMBER','x.1564860235.17','','','',1,'','','','','',1),(6,'2019-07-30 17:27:36','2019-07-30 14:27:36','2019-07-30 14:27:36','NONE','SIP/1001','UNPAUSEALL','x.1564860235.18','','','',1,'','','','','',1),(7,'2019-07-30 17:27:36','2019-07-30 14:27:36','2019-07-30 14:27:36','1000','agent1001','UNPAUSE','x.1564860235.19','','','',1,'','','','','',1),(8,'2019-07-30 17:29:57','2019-07-30 14:29:57','2019-07-30 14:29:57','1000','SIP/1001','REMOVEMEMBER','x.1564860235.20','','','',1,'','','','','',1),(9,'2019-07-30 17:30:25','2019-07-30 14:30:25','2019-07-30 14:30:25','1000','SIP/1001','ADDMEMBER','x.1564860236.21','','','',1,'','','','','',1),(10,'2019-07-30 17:30:25','2019-07-30 14:30:25','2019-07-30 14:30:25','NONE','SIP/1001','UNPAUSEALL','x.1564860236.22','','','',1,'','','','','',1),(11,'2019-07-30 17:30:25','2019-07-30 14:30:25','2019-07-30 14:30:25','1000','agent1001','UNPAUSE','x.1564860236.23','','','',1,'','','','','',1),(12,'2019-07-30 17:32:06','2019-07-30 14:32:06','2019-07-30 14:32:06','1000','SIP/1001','REMOVEMEMBER','x.1564860236.24','','','',1,'','','','','',1),(13,'2019-07-30 17:32:27','2019-07-30 14:32:27','2019-07-30 14:32:27','1000','SIP/1001','ADDMEMBER','x.1564860236.25','','','',1,'','','','','',1),(14,'2019-07-30 17:32:27','2019-07-30 14:32:27','2019-07-30 14:32:27','NONE','SIP/1001','UNPAUSEALL','x.1564860236.26','','','',1,'','','','','',1),(15,'2019-07-30 17:32:27','2019-07-30 14:32:27','2019-07-30 14:32:27','1000','agent1001','UNPAUSE','x.1564860236.27','','','',1,'','','','','',1),(16,'2019-07-30 17:32:42','2019-07-30 14:32:50','2019-07-30 14:32:54','1000','agent1001','COMPLETEAGENT','1564497148.0','201','','',1,'8','4','1','','',0),(17,'2019-07-30 17:34:50','2019-07-30 14:34:53','2019-07-30 14:35:19','1000','agent1001','COMPLETEAGENT','1564497275.3','201','','',1,'3','26','1','','',0),(18,'2019-07-30 17:48:01','2019-07-30 14:48:01','2019-07-30 14:48:01','1000','SIP/1001','REMOVEMEMBER','x.1564860236.36','','','',1,'','','','','',1),(19,'2019-07-30 20:37:14','2019-07-30 17:37:14','2019-07-30 17:37:14','1000','SIP/1001','ADDMEMBER','x.1564860236.39','','','',1,'','','','','',1),(20,'2019-07-30 20:37:14','2019-07-30 17:37:14','2019-07-30 17:37:14','NONE','SIP/1001','UNPAUSEALL','x.1564860236.40','','','',1,'','','','','',1),(21,'2019-07-30 20:37:14','2019-07-30 17:37:14','2019-07-30 17:37:14','1000','agent1001','UNPAUSE','x.1564860236.41','','','',1,'','','','','',1),(22,'2019-07-30 20:37:25','2019-07-30 17:37:25','2019-07-30 17:37:25','1000','SIP/1001','REMOVEMEMBER','x.1564860236.42','','','',1,'','','','','',1),(23,'2019-07-31 12:40:40','2019-07-31 09:40:40','2019-07-31 09:40:40','1000','SIP/1001','ADDMEMBER','x.1564860236.43','','','',1,'','','','','',1),(24,'2019-07-31 12:40:40','2019-07-31 09:40:40','2019-07-31 09:40:40','NONE','SIP/1001','UNPAUSEALL','x.1564860236.44','','','',1,'','','','','',1),(25,'2019-07-31 12:40:40','2019-07-31 09:40:40','2019-07-31 09:40:40','1000','agent1001','UNPAUSE','x.1564860236.45','','','',1,'','','','','',1),(26,'2019-07-31 12:40:49','2019-07-31 09:40:49','2019-07-31 09:40:49','NONE','SIP/1001','PAUSEALL','x.1564860236.46','','','',1,'','','','','',1),(27,'2019-07-31 12:40:49','2019-07-31 09:40:49','2019-07-31 09:40:49','1000','agent1001','PAUSE','x.1564860236.47','','','',1,'obed','','','','',1),(28,'2019-07-31 12:40:54','2019-07-31 09:40:54','2019-07-31 09:40:54','1000','SIP/1001','REMOVEMEMBER','x.1564860236.48','','','',1,'','','','','',1),(29,'2019-07-31 14:58:49','2019-07-31 11:58:49','2019-07-31 11:58:49','1000','SIP/1002','ADDMEMBER','x.1564860236.51','','','',1,'','','','','',1),(30,'2019-07-31 14:58:49','2019-07-31 11:58:49','2019-07-31 11:58:49','NONE','SIP/1002','UNPAUSEALL','x.1564860236.52','','','',1,'','','','','',1),(31,'2019-07-31 14:58:50','2019-07-31 11:58:50','2019-07-31 11:58:50','1000','Agent2','UNPAUSE','x.1564860236.53','','','',1,'','','','','',1),(32,'2019-07-31 14:59:09','2019-07-31 11:59:09','2019-07-31 11:59:09','1000','SIP/1002','REMOVEMEMBER','x.1564860236.54','','','',1,'','','','','',1),(33,'2019-07-31 15:07:42','2019-07-31 12:07:42','2019-07-31 12:07:42','1000','SIP/1001','ADDMEMBER','x.1564860236.55','','','',1,'','','','','',1),(34,'2019-07-31 15:07:42','2019-07-31 12:07:42','2019-07-31 12:07:42','NONE','SIP/1001','UNPAUSEALL','x.1564860236.56','','','',1,'','','','','',1),(35,'2019-07-31 15:07:42','2019-07-31 12:07:42','2019-07-31 12:07:42','1000','agent1001','UNPAUSE','x.1564860236.57','','','',1,'','','','','',1),(36,'2019-07-31 15:08:06','2019-07-31 12:08:06','2019-07-31 12:08:06','1000','SIP/1001','REMOVEMEMBER','x.1564860236.58','','','',1,'','','','','',1),(37,'2019-07-31 15:11:21','2019-07-31 12:11:21','2019-07-31 12:11:21','1000','SIP/1001','ADDMEMBER','x.1564860236.59','','','',1,'','','','','',1),(38,'2019-07-31 15:11:21','2019-07-31 12:11:21','2019-07-31 12:11:21','NONE','SIP/1001','UNPAUSEALL','x.1564860236.60','','','',1,'','','','','',1),(39,'2019-07-31 15:11:21','2019-07-31 12:11:21','2019-07-31 12:11:21','1000','agent1001','UNPAUSE','x.1564860236.61','','','',1,'','','','','',1),(40,'2019-07-31 15:11:56','2019-07-31 12:11:56','2019-07-31 12:11:56','NONE','SIP/1001','PAUSEALL','x.1564860236.62','','','',1,'','','','','',1),(41,'2019-07-31 15:11:56','2019-07-31 12:11:56','2019-07-31 12:11:56','1000','agent1001','PAUSE','x.1564860236.63','','','',1,'obed','','','','',1),(42,'2019-07-31 15:12:14','2019-07-31 12:12:14','2019-07-31 12:12:14','1000','SIP/1001','REMOVEMEMBER','x.1564860236.64','','','',1,'','','','','',1),(43,'2019-07-31 15:12:56','2019-07-31 12:12:56','2019-07-31 12:12:56','1000','SIP/1002','ADDMEMBER','x.1564860236.65','','','',1,'','','','','',1),(44,'2019-07-31 15:12:56','2019-07-31 12:12:56','2019-07-31 12:12:56','NONE','SIP/1002','UNPAUSEALL','x.1564860236.66','','','',1,'','','','','',1),(45,'2019-07-31 15:12:56','2019-07-31 12:12:56','2019-07-31 12:12:56','1000','Agent2','UNPAUSE','x.1564860236.67','','','',1,'','','','','',1),(46,'2019-07-31 15:13:08','2019-07-31 12:13:08','2019-07-31 12:13:08','1000','SIP/1002','REMOVEMEMBER','x.1564860236.68','','','',1,'','','','','',1),(47,'2019-07-31 15:18:10','2019-07-31 12:18:10','2019-07-31 12:18:10','1000','SIP/1001','ADDMEMBER','x.1564860236.69','','','',1,'','','','','',1),(48,'2019-07-31 15:18:10','2019-07-31 12:18:10','2019-07-31 12:18:10','NONE','SIP/1001','UNPAUSEALL','x.1564860236.70','','','',1,'','','','','',1),(49,'2019-07-31 15:18:10','2019-07-31 12:18:10','2019-07-31 12:18:10','1000','agent1001','UNPAUSE','x.1564860236.71','','','',1,'','','','','',1),(50,'2019-07-31 15:18:42','2019-07-31 12:18:42','2019-07-31 12:18:42','NONE','SIP/1001','PAUSEALL','x.1564860236.72','','','',1,'','','','','',1),(51,'2019-07-31 15:18:42','2019-07-31 12:18:42','2019-07-31 12:18:42','1000','agent1001','PAUSE','x.1564860236.73','','','',1,'obed','','','','',1),(52,'2019-07-31 15:18:49','2019-07-31 12:18:49','2019-07-31 12:18:49','NONE','SIP/1001','UNPAUSEALL','x.1564860236.74','','','',1,'','','','','',1),(53,'2019-07-31 15:18:49','2019-07-31 12:18:49','2019-07-31 12:18:49','1000','agent1001','UNPAUSE','x.1564860236.75','','','',1,'','','','','',1),(54,'2019-07-31 15:19:22','2019-07-31 12:19:22','2019-07-31 12:19:22','1000','SIP/1001','REMOVEMEMBER','x.1564860236.76','','','',1,'','','','','',1),(55,'2019-07-31 15:23:09','2019-07-31 12:23:09','2019-07-31 12:23:09','1000','SIP/1001','ADDMEMBER','x.1564860236.77','','','',1,'','','','','',1),(56,'2019-07-31 15:23:09','2019-07-31 12:23:09','2019-07-31 12:23:09','NONE','SIP/1001','UNPAUSEALL','x.1564860236.78','','','',1,'','','','','',1),(57,'2019-07-31 15:23:09','2019-07-31 12:23:09','2019-07-31 12:23:09','1000','agent1001','UNPAUSE','x.1564860236.79','','','',1,'','','','','',1),(58,'2019-07-31 15:23:53','2019-07-31 12:23:53','2019-07-31 12:23:53','1000','SIP/1001','REMOVEMEMBER','x.1564860236.80','','','',1,'','','','','',1),(59,'2019-07-31 15:45:00','2019-07-31 12:45:00','2019-07-31 12:45:00','1000','SIP/1001','ADDMEMBER','x.1564860236.81','','','',1,'','','','','',1),(60,'2019-07-31 15:45:00','2019-07-31 12:45:00','2019-07-31 12:45:00','NONE','SIP/1001','UNPAUSEALL','x.1564860236.82','','','',1,'','','','','',1),(61,'2019-07-31 15:45:00','2019-07-31 12:45:00','2019-07-31 12:45:00','1000','agent1001','UNPAUSE','x.1564860236.83','','','',1,'','','','','',1),(62,'2019-07-31 15:45:35','2019-07-31 12:45:35','2019-07-31 12:45:35','1000','SIP/1001','REMOVEMEMBER','x.1564860236.84','','','',1,'','','','','',1),(63,'2019-07-31 15:50:38','2019-07-31 12:50:38','2019-07-31 12:50:38','1000','SIP/1001','ADDMEMBER','x.1564860236.85','','','',1,'','','','','',1),(64,'2019-07-31 15:50:38','2019-07-31 12:50:38','2019-07-31 12:50:38','NONE','SIP/1001','UNPAUSEALL','x.1564860236.86','','','',1,'','','','','',1),(65,'2019-07-31 15:50:38','2019-07-31 12:50:38','2019-07-31 12:50:38','1000','agent1001','UNPAUSE','x.1564860236.87','','','',1,'','','','','',1),(66,'2019-07-31 15:52:03','2019-07-31 12:52:03','2019-07-31 12:52:03','1000','SIP/1001','REMOVEMEMBER','x.1564860236.88','','','',1,'','','','','',1),(67,'2019-07-31 15:54:23','2019-07-31 12:54:23','2019-07-31 12:54:23','1000','SIP/1001','ADDMEMBER','x.1564860236.89','','','',1,'','','','','',1),(68,'2019-07-31 15:54:23','2019-07-31 12:54:23','2019-07-31 12:54:23','NONE','SIP/1001','UNPAUSEALL','x.1564860236.90','','','',1,'','','','','',1),(69,'2019-07-31 15:54:23','2019-07-31 12:54:23','2019-07-31 12:54:23','1000','agent1001','UNPAUSE','x.1564860236.91','','','',1,'','','','','',1),(70,'2019-07-31 15:55:42','2019-07-31 12:55:42','2019-07-31 12:55:42','1000','SIP/1001','REMOVEMEMBER','x.1564860236.92','','','',1,'','','','','',1),(71,'2019-07-31 16:00:27','2019-07-31 13:00:27','2019-07-31 13:00:27','1000','SIP/1001','ADDMEMBER','x.1564860236.93','','','',1,'','','','','',1),(72,'2019-07-31 16:00:27','2019-07-31 13:00:27','2019-07-31 13:00:27','NONE','SIP/1001','UNPAUSEALL','x.1564860236.94','','','',1,'','','','','',1),(73,'2019-07-31 16:00:27','2019-07-31 13:00:27','2019-07-31 13:00:27','1000','agent1001','UNPAUSE','x.1564860236.95','','','',1,'','','','','',1),(74,'2019-07-31 16:02:00','2019-07-31 13:02:00','2019-07-31 13:02:00','1000','SIP/1001','REMOVEMEMBER','x.1564860236.96','','','',1,'','','','','',1),(75,'2019-07-31 17:01:49','2019-07-31 14:01:49','2019-07-31 14:01:49','1000','SIP/1001','ADDMEMBER','x.1564860236.97','','','',1,'','','','','',1),(76,'2019-07-31 17:01:49','2019-07-31 14:01:49','2019-07-31 14:01:49','NONE','SIP/1001','UNPAUSEALL','x.1564860236.98','','','',1,'','','','','',1),(77,'2019-07-31 17:01:49','2019-07-31 14:01:49','2019-07-31 14:01:49','1000','agent1001','UNPAUSE','x.1564860236.99','','','',1,'','','','','',1),(78,'2019-07-31 17:02:11','2019-07-31 14:02:19','2019-07-31 14:03:20','1000','agent1001','COMPLETEAGENT','1564581710.18','201','','',1,'8','61','1','','',0),(79,'2019-07-31 17:04:01','2019-07-31 14:04:01','2019-07-31 14:04:01','1000','SIP/1001','REMOVEMEMBER','x.1564860236.104','','','',1,'','','','','',1),(80,'2019-07-31 17:04:09','2019-07-31 14:04:09','2019-07-31 14:04:09','1000','SIP/1001','ADDMEMBER','x.1564860236.105','','','',1,'','','','','',1),(81,'2019-07-31 17:04:09','2019-07-31 14:04:09','2019-07-31 14:04:09','NONE','SIP/1001','UNPAUSEALL','x.1564860236.106','','','',1,'','','','','',1),(82,'2019-07-31 17:04:09','2019-07-31 14:04:09','2019-07-31 14:04:09','1000','agent1001','UNPAUSE','x.1564860236.107','','','',1,'','','','','',1),(83,'2019-07-31 17:04:49','2019-07-31 14:04:49','2019-07-31 14:04:49','1000','SIP/1001','REMOVEMEMBER','x.1564860236.108','','','',1,'','','','','',1),(84,'2019-07-31 17:05:08','2019-07-31 14:05:08','2019-07-31 14:05:08','1000','SIP/1001','ADDMEMBER','x.1564860236.109','','','',1,'','','','','',1),(85,'2019-07-31 17:05:08','2019-07-31 14:05:08','2019-07-31 14:05:08','NONE','SIP/1001','UNPAUSEALL','x.1564860236.110','','','',1,'','','','','',1),(86,'2019-07-31 17:05:08','2019-07-31 14:05:08','2019-07-31 14:05:08','1000','agent1001','UNPAUSE','x.1564860236.111','','','',1,'','','','','',1),(87,'2019-07-31 17:12:27','2019-07-31 14:12:27','2019-07-31 14:12:27','1000','SIP/1001','REMOVEMEMBER','x.1564860236.112','','','',1,'','','','','',1),(88,'2019-07-31 17:15:28','2019-07-31 14:15:28','2019-07-31 14:15:28','1000','SIP/1005','ADDMEMBER','x.1564860236.113','','','',1,'','','','','',1),(89,'2019-07-31 17:15:28','2019-07-31 14:15:28','2019-07-31 14:15:28','NONE','SIP/1005','UNPAUSEALL','x.1564860236.114','','','',1,'','','','','',1),(90,'2019-07-31 17:15:28','2019-07-31 14:15:28','2019-07-31 14:15:28','1000','Agent1005','UNPAUSE','x.1564860236.115','','','',1,'','','','','',1),(91,'2019-07-31 17:44:59','2019-07-31 14:44:59','2019-07-31 14:44:59','1000','SIP/1005','REMOVEMEMBER','x.1564860236.117','','','',1,'','','','','',1),(92,'2019-07-31 19:46:34','2019-07-31 16:46:34','2019-07-31 16:46:34','1000','SIP/1001','ADDMEMBER','x.1564860236.118','','','',1,'','','','','',1),(93,'2019-07-31 19:46:34','2019-07-31 16:46:34','2019-07-31 16:46:34','NONE','SIP/1001','UNPAUSEALL','x.1564860236.119','','','',1,'','','','','',1),(94,'2019-07-31 19:46:34','2019-07-31 16:46:34','2019-07-31 16:46:34','1000','agent1001','UNPAUSE','x.1564860236.120','','','',1,'','','','','',1),(95,'2019-07-31 19:47:23','2019-07-31 16:47:23','2019-07-31 16:47:23','1000','SIP/1001','REMOVEMEMBER','x.1564860236.121','','','',1,'','','','','',1),(96,'2019-07-31 19:49:55','2019-07-31 16:49:55','2019-07-31 16:49:55','1000','SIP/1001','ADDMEMBER','x.1564860236.122','','','',1,'','','','','',1),(97,'2019-07-31 19:49:55','2019-07-31 16:49:55','2019-07-31 16:49:55','NONE','SIP/1001','UNPAUSEALL','x.1564860236.123','','','',1,'','','','','',1),(98,'2019-07-31 19:49:55','2019-07-31 16:49:55','2019-07-31 16:49:55','1000','agent1001','UNPAUSE','x.1564860236.124','','','',1,'','','','','',1),(99,'2019-07-31 19:50:54','2019-07-31 16:50:54','2019-07-31 16:50:54','NONE','SIP/1001','PAUSEALL','x.1564860236.125','','','',1,'','','','','',1),(100,'2019-07-31 19:50:54','2019-07-31 16:50:54','2019-07-31 16:50:54','1000','agent1001','PAUSE','x.1564860236.126','','','',1,'obed','','','','',1),(101,'2019-07-31 19:51:10','2019-07-31 16:51:10','2019-07-31 16:51:10','NONE','SIP/1001','UNPAUSEALL','x.1564860236.127','','','',1,'','','','','',1),(102,'2019-07-31 19:51:10','2019-07-31 16:51:10','2019-07-31 16:51:10','1000','agent1001','UNPAUSE','x.1564860236.128','','','',1,'','','','','',1),(103,'2019-07-31 19:51:19','2019-07-31 16:51:19','2019-07-31 16:51:19','1000','SIP/1001','REMOVEMEMBER','x.1564860236.129','','','',1,'','','','','',1),(104,'2019-08-01 09:43:33','2019-08-01 06:43:33','2019-08-01 06:43:33','1000','SIP/1001','ADDMEMBER','x.1564860236.134','','','',1,'','','','','',1),(105,'2019-08-01 09:43:33','2019-08-01 06:43:33','2019-08-01 06:43:33','NONE','SIP/1001','UNPAUSEALL','x.1564860236.135','','','',1,'','','','','',1),(106,'2019-08-01 09:43:33','2019-08-01 06:43:33','2019-08-01 06:43:33','1000','agent1001','UNPAUSE','x.1564860236.136','','','',1,'','','','','',1),(107,'2019-08-01 09:44:16','2019-08-01 06:44:16','2019-08-01 06:44:16','1000','SIP/1001','REMOVEMEMBER','x.1564860236.140','','','',1,'','','','','',1),(108,'2019-08-01 09:43:46','2019-08-01 06:43:54','2019-08-01 06:44:16','1000','agent1001','COMPLETEAGENT','1564641814.2','201','','',1,'8','22','1','','',0),(109,'2019-08-01 10:51:29','2019-08-01 07:51:29','2019-08-01 07:51:29','1000','SIP/1001','ADDMEMBER','x.1564860236.142','','','',1,'','','','','',1),(110,'2019-08-01 10:51:29','2019-08-01 07:51:29','2019-08-01 07:51:29','NONE','SIP/1001','UNPAUSEALL','x.1564860236.143','','','',1,'','','','','',1),(111,'2019-08-01 10:51:29','2019-08-01 07:51:29','2019-08-01 07:51:29','1000','agent1001','UNPAUSE','x.1564860236.144','','','',1,'','','','','',1),(112,'2019-08-01 10:51:58','2019-08-01 07:51:58','2019-08-01 07:51:58','1000','SIP/1001','REMOVEMEMBER','x.1564860236.145','','','',1,'','','','','',1),(113,'2019-08-01 10:52:52','2019-08-01 07:52:52','2019-08-01 07:52:52','1000','SIP/1001','ADDMEMBER','x.1564860236.146','','','',1,'','','','','',1),(114,'2019-08-01 10:52:52','2019-08-01 07:52:52','2019-08-01 07:52:52','NONE','SIP/1001','UNPAUSEALL','x.1564860236.147','','','',1,'','','','','',1),(115,'2019-08-01 10:52:52','2019-08-01 07:52:52','2019-08-01 07:52:52','1000','agent1001','UNPAUSE','x.1564860236.148','','','',1,'','','','','',1),(116,'2019-08-01 10:53:46','2019-08-01 07:53:46','2019-08-01 07:53:46','1000','SIP/1001','REMOVEMEMBER','x.1564860236.152','','','',1,'','','','','',1),(117,'2019-08-01 10:53:05','2019-08-01 07:53:12','2019-08-01 07:53:46','1000','agent1001','COMPLETEAGENT','1564645973.9','201','','',1,'7','34','1','','',0),(118,'2019-08-01 11:33:22','2019-08-01 08:33:22','2019-08-01 08:33:22','1000','SIP/1001','ADDMEMBER','x.1564860236.156','','','',1,'','','','','',1),(119,'2019-08-01 11:33:22','2019-08-01 08:33:22','2019-08-01 08:33:22','NONE','SIP/1001','UNPAUSEALL','x.1564860236.157','','','',1,'','','','','',1),(120,'2019-08-01 11:33:22','2019-08-01 08:33:22','2019-08-01 08:33:22','1000','agent1001','UNPAUSE','x.1564860236.158','','','',1,'','','','','',1),(121,'2019-08-01 11:33:50','2019-08-01 08:34:00','2019-08-01 08:34:07','1000','agent1001','COMPLETEAGENT','1564648402.13','201','','',1,'10','7','1','','',0),(122,'2019-08-01 11:34:22','2019-08-01 08:34:49','2019-08-01 08:35:27','1000','agent1001','COMPLETECALLER','1564648447.15','201','','',1,'27','38','1','','',0),(123,'2019-08-01 11:36:56','2019-08-01 08:36:56','2019-08-01 08:36:56','NONE','SIP/1001','PAUSEALL','x.1564860236.168','','','',1,'','','','','',1),(124,'2019-08-01 11:36:56','2019-08-01 08:36:56','2019-08-01 08:36:56','1000','agent1001','PAUSE','x.1564860236.169','','','',1,'obed','','','','',1),(125,'2019-08-01 11:37:35','2019-08-01 08:37:35','2019-08-01 08:37:35','1000','SIP/1001','REMOVEMEMBER','x.1564860236.170','','','',1,'','','','','',1),(126,'2019-08-01 11:56:11','2019-08-01 08:56:11','2019-08-01 08:56:28','1000','NONE','ABANDON','1564649759.21','201','','',1,'1','1','17','','',1),(127,'2019-08-01 11:56:43','2019-08-01 08:56:43','2019-08-01 08:57:26','1000','NONE','ABANDON','1564649789.22','201','','',1,'1','1','43','','',1),(128,'2019-08-01 11:58:24','2019-08-01 08:58:24','2019-08-01 08:58:24','1000','SIP/1001','ADDMEMBER','x.1564860237.178','','','',1,'','','','','',1),(129,'2019-08-01 11:58:24','2019-08-01 08:58:24','2019-08-01 08:58:24','NONE','SIP/1001','UNPAUSEALL','x.1564860237.179','','','',1,'','','','','',1),(130,'2019-08-01 11:58:24','2019-08-01 08:58:24','2019-08-01 08:58:24','1000','agent1001','UNPAUSE','x.1564860237.180','','','',1,'','','','','',1),(131,'2019-08-01 11:58:27','2019-08-01 08:58:27','2019-08-01 08:58:27','1000','SIP/1001','REMOVEMEMBER','x.1564860237.181','','','',1,'','','','','',1),(132,'2019-08-01 12:07:10','2019-08-01 09:07:10','2019-08-01 09:07:10','1000','SIP/1001','ADDMEMBER','x.1564860237.182','','','',1,'','','','','',1),(133,'2019-08-01 12:07:10','2019-08-01 09:07:10','2019-08-01 09:07:10','NONE','SIP/1001','UNPAUSEALL','x.1564860237.183','','','',1,'','','','','',1),(134,'2019-08-01 12:07:10','2019-08-01 09:07:10','2019-08-01 09:07:10','1000','agent1001','UNPAUSE','x.1564860237.184','','','',1,'','','','','',1),(135,'2019-08-01 12:07:13','2019-08-01 09:07:13','2019-08-01 09:07:13','1000','SIP/1001','REMOVEMEMBER','x.1564860237.185','','','',1,'','','','','',1),(136,'2019-08-01 12:07:43','2019-08-01 09:07:43','2019-08-01 09:07:43','1000','SIP/1001','ADDMEMBER','x.1564860237.186','','','',1,'','','','','',1),(137,'2019-08-01 12:07:43','2019-08-01 09:07:43','2019-08-01 09:07:43','NONE','SIP/1001','UNPAUSEALL','x.1564860237.187','','','',1,'','','','','',1),(138,'2019-08-01 12:07:43','2019-08-01 09:07:43','2019-08-01 09:07:43','1000','agent1001','UNPAUSE','x.1564860237.188','','','',1,'','','','','',1),(139,'2019-08-01 12:08:07','2019-08-01 09:08:07','2019-08-01 09:08:07','1000','SIP/1001','REMOVEMEMBER','x.1564860237.189','','','',1,'','','','','',1),(140,'2019-08-01 12:24:25','2019-08-01 09:24:25','2019-08-01 09:24:25','1000','SIP/1001','ADDMEMBER','x.1564860237.190','','','',1,'','','','','',1),(141,'2019-08-01 12:24:25','2019-08-01 09:24:25','2019-08-01 09:24:25','NONE','SIP/1001','UNPAUSEALL','x.1564860237.191','','','',1,'','','','','',1),(142,'2019-08-01 12:24:25','2019-08-01 09:24:25','2019-08-01 09:24:25','1000','agent1001','UNPAUSE','x.1564860237.192','','','',1,'','','','','',1),(143,'2019-08-01 12:24:47','2019-08-01 09:24:47','2019-08-01 09:24:47','NONE','SIP/1001','PAUSEALL','x.1564860237.193','','','',1,'','','','','',1),(144,'2019-08-01 12:24:47','2019-08-01 09:24:47','2019-08-01 09:24:47','1000','agent1001','PAUSE','x.1564860237.194','','','',1,'obed','','','','',1),(145,'2019-08-01 12:24:52','2019-08-01 09:24:52','2019-08-01 09:24:52','NONE','SIP/1001','UNPAUSEALL','x.1564860237.195','','','',1,'','','','','',1),(146,'2019-08-01 12:24:52','2019-08-01 09:24:52','2019-08-01 09:24:52','1000','agent1001','UNPAUSE','x.1564860237.196','','','',1,'','','','','',1),(147,'2019-08-01 12:24:56','2019-08-01 09:24:56','2019-08-01 09:24:56','1000','SIP/1001','REMOVEMEMBER','x.1564860237.197','','','',1,'','','','','',1),(148,'2019-08-01 12:27:14','2019-08-01 09:27:14','2019-08-01 09:27:14','NONE','Agent/1012','AGENTLOGIN','x.1564860237.198','','','',1,'SIP/1001-0000001f','','','','',1),(149,'2019-08-01 12:27:32','2019-08-01 09:27:32','2019-08-01 09:27:32','NONE','Agent/1012','AGENTLOGOFF','x.1564860237.199','','','',1,'SIP/1001-0000001f','18','','','',1),(150,'2019-08-01 12:37:56','2019-08-01 09:37:56','2019-08-01 09:37:56','1000','SIP/1001','ADDMEMBER','x.1564860237.200','','','',1,'','','','','',1),(151,'2019-08-01 12:37:56','2019-08-01 09:37:56','2019-08-01 09:37:56','NONE','SIP/1001','UNPAUSEALL','x.1564860237.201','','','',1,'','','','','',1),(152,'2019-08-01 12:37:56','2019-08-01 09:37:56','2019-08-01 09:37:56','1000','agent1001','UNPAUSE','x.1564860237.202','','','',1,'','','','','',1),(153,'2019-08-01 12:38:34','2019-08-01 09:38:34','2019-08-01 09:38:34','1000','SIP/1001','REMOVEMEMBER','x.1564860237.203','','','',1,'','','','','',1),(154,'2019-08-01 13:00:57','2019-08-01 10:00:57','2019-08-01 10:00:57','NONE','Agent/1012','AGENTLOGIN','x.1564860237.204','','','',1,'SIP/1001-00000023','','','','',1),(155,'2019-08-01 13:01:49','2019-08-01 10:01:49','2019-08-01 10:01:49','NONE','Agent/1012','AGENTLOGOFF','x.1564860237.205','','','',1,'SIP/1001-00000023','52','','','',1),(156,'2019-08-01 13:02:47','2019-08-01 10:02:47','2019-08-01 10:02:47','1000','SIP/1001','ADDMEMBER','x.1564860237.206','','','',1,'','','','','',1),(157,'2019-08-01 13:02:47','2019-08-01 10:02:47','2019-08-01 10:02:47','NONE','SIP/1001','UNPAUSEALL','x.1564860237.207','','','',1,'','','','','',1),(158,'2019-08-01 13:02:47','2019-08-01 10:02:47','2019-08-01 10:02:47','1000','agent1001','UNPAUSE','x.1564860237.208','','','',1,'','','','','',1),(159,'2019-08-01 13:03:40','2019-08-01 10:03:40','2019-08-01 10:03:40','1000','SIP/1001','REMOVEMEMBER','x.1564860237.209','','','',1,'','','','','',1),(160,'2019-08-01 13:05:13','2019-08-01 10:05:13','2019-08-01 10:05:13','1000','SIP/1001','ADDMEMBER','x.1564860237.210','','','',1,'','','','','',1),(161,'2019-08-01 13:05:13','2019-08-01 10:05:13','2019-08-01 10:05:13','NONE','SIP/1001','UNPAUSEALL','x.1564860237.211','','','',1,'','','','','',1),(162,'2019-08-01 13:05:13','2019-08-01 10:05:13','2019-08-01 10:05:13','1000','agent1001','UNPAUSE','x.1564860237.212','','','',1,'','','','','',1),(163,'2019-08-01 13:05:29','2019-08-01 10:05:29','2019-08-01 10:05:29','1000','SIP/1001','REMOVEMEMBER','x.1564860237.213','','','',1,'','','','','',1),(164,'2019-08-01 13:15:33','2019-08-01 10:15:33','2019-08-01 10:15:33','1000','SIP/1001','ADDMEMBER','x.1564860237.214','','','',1,'','','','','',1),(165,'2019-08-01 13:15:33','2019-08-01 10:15:33','2019-08-01 10:15:33','NONE','SIP/1001','UNPAUSEALL','x.1564860237.215','','','',1,'','','','','',1),(166,'2019-08-01 13:15:33','2019-08-01 10:15:33','2019-08-01 10:15:33','1000','agent1001','UNPAUSE','x.1564860237.216','','','',1,'','','','','',1),(167,'2019-08-01 13:16:44','2019-08-01 10:16:44','2019-08-01 10:16:44','1000','SIP/1001','REMOVEMEMBER','x.1564860237.217','','','',1,'','','','','',1),(168,'2019-08-01 13:27:02','2019-08-01 10:27:02','2019-08-01 10:27:02','1000','SIP/1001','ADDMEMBER','x.1564860237.218','','','',1,'','','','','',1),(169,'2019-08-01 13:27:02','2019-08-01 10:27:02','2019-08-01 10:27:02','NONE','SIP/1001','UNPAUSEALL','x.1564860237.219','','','',1,'','','','','',1),(170,'2019-08-01 13:27:03','2019-08-01 10:27:03','2019-08-01 10:27:03','1000','agent1001','UNPAUSE','x.1564860237.220','','','',1,'','','','','',1),(171,'2019-08-01 13:28:09','2019-08-01 10:28:09','2019-08-01 10:28:09','1000','SIP/1001','REMOVEMEMBER','x.1564860237.221','','','',1,'','','','','',1),(172,'2019-08-01 13:36:47','2019-08-01 10:36:47','2019-08-01 10:36:47','1000','SIP/1001','ADDMEMBER','x.1564860237.222','','','',1,'','','','','',1),(173,'2019-08-01 13:36:47','2019-08-01 10:36:47','2019-08-01 10:36:47','NONE','SIP/1001','UNPAUSEALL','x.1564860237.223','','','',1,'','','','','',1),(174,'2019-08-01 13:36:47','2019-08-01 10:36:47','2019-08-01 10:36:47','1000','agent1001','UNPAUSE','x.1564860237.224','','','',1,'','','','','',1),(175,'2019-08-01 13:38:02','2019-08-01 10:38:02','2019-08-01 10:38:02','1000','SIP/1001','REMOVEMEMBER','x.1564860237.225','','','',1,'','','','','',1),(176,'2019-08-01 14:07:06','2019-08-01 11:07:06','2019-08-01 11:07:06','1000','SIP/1001','ADDMEMBER','x.1564860237.226','','','',1,'','','','','',1),(177,'2019-08-01 14:07:06','2019-08-01 11:07:06','2019-08-01 11:07:06','NONE','SIP/1001','UNPAUSEALL','x.1564860237.227','','','',1,'','','','','',1),(178,'2019-08-01 14:07:06','2019-08-01 11:07:06','2019-08-01 11:07:06','1000','agent1001','UNPAUSE','x.1564860237.228','','','',1,'','','','','',1),(179,'2019-08-01 14:09:20','2019-08-01 11:09:20','2019-08-01 11:09:20','1000','SIP/1001','REMOVEMEMBER','x.1564860237.229','','','',1,'','','','','',1),(180,'2019-08-01 14:11:35','2019-08-01 11:11:35','2019-08-01 11:11:35','1000','SIP/1001','ADDMEMBER','x.1564860237.230','','','',1,'','','','','',1),(181,'2019-08-01 14:11:35','2019-08-01 11:11:35','2019-08-01 11:11:35','NONE','SIP/1001','UNPAUSEALL','x.1564860237.231','','','',1,'','','','','',1),(182,'2019-08-01 14:11:35','2019-08-01 11:11:35','2019-08-01 11:11:35','1000','agent1001','UNPAUSE','x.1564860237.232','','','',1,'','','','','',1),(183,'2019-08-01 14:12:41','2019-08-01 11:12:41','2019-08-01 11:12:41','1000','SIP/1001','REMOVEMEMBER','x.1564860237.233','','','',1,'','','','','',1),(184,'2019-08-01 14:19:54','2019-08-01 11:19:54','2019-08-01 11:19:54','1000','SIP/1001','ADDMEMBER','x.1564860237.234','','','',1,'','','','','',1),(185,'2019-08-01 14:19:54','2019-08-01 11:19:54','2019-08-01 11:19:54','NONE','SIP/1001','UNPAUSEALL','x.1564860237.235','','','',1,'','','','','',1),(186,'2019-08-01 14:19:54','2019-08-01 11:19:54','2019-08-01 11:19:54','1000','agent1001','UNPAUSE','x.1564860237.236','','','',1,'','','','','',1),(187,'2019-08-01 14:21:31','2019-08-01 11:21:31','2019-08-01 11:21:31','1000','SIP/1001','REMOVEMEMBER','x.1564860237.237','','','',1,'','','','','',1),(188,'2019-08-01 14:53:53','2019-08-01 11:53:53','2019-08-01 11:53:53','1000','SIP/1001','ADDMEMBER','x.1564860237.238','','','',1,'','','','','',1),(189,'2019-08-01 14:53:53','2019-08-01 11:53:53','2019-08-01 11:53:53','NONE','SIP/1001','UNPAUSEALL','x.1564860237.239','','','',1,'','','','','',1),(190,'2019-08-01 14:53:53','2019-08-01 11:53:53','2019-08-01 11:53:53','1000','agent1001','UNPAUSE','x.1564860237.240','','','',1,'','','','','',1),(191,'2019-08-01 14:54:58','2019-08-01 11:54:58','2019-08-01 11:54:58','1000','SIP/1001','REMOVEMEMBER','x.1564860237.241','','','',1,'','','','','',1),(192,'2019-08-01 15:04:35','2019-08-01 12:04:35','2019-08-01 12:04:35','1000','SIP/1001','ADDMEMBER','x.1564860237.242','','','',1,'','','','','',1),(193,'2019-08-01 15:04:35','2019-08-01 12:04:35','2019-08-01 12:04:35','NONE','SIP/1001','UNPAUSEALL','x.1564860237.243','','','',1,'','','','','',1),(194,'2019-08-01 15:04:35','2019-08-01 12:04:35','2019-08-01 12:04:35','1000','agent1001','UNPAUSE','x.1564860237.244','','','',1,'','','','','',1),(195,'2019-08-01 15:05:15','2019-08-01 12:05:15','2019-08-01 12:05:15','NONE','SIP/1001','PAUSEALL','x.1564860237.245','','','',1,'','','','','',1),(196,'2019-08-01 15:05:15','2019-08-01 12:05:15','2019-08-01 12:05:15','1000','agent1001','PAUSE','x.1564860237.246','','','',1,'obed','','','','',1),(197,'2019-08-01 15:08:32','2019-08-01 12:08:32','2019-08-01 12:08:32','NONE','SIP/1001','UNPAUSEALL','x.1564860237.247','','','',1,'','','','','',1),(198,'2019-08-01 15:08:32','2019-08-01 12:08:32','2019-08-01 12:08:32','1000','agent1001','UNPAUSE','x.1564860237.248','','','',1,'','','','','',1),(199,'2019-08-01 15:09:33','2019-08-01 12:09:33','2019-08-01 12:09:33','1000','SIP/1001','REMOVEMEMBER','x.1564860237.249','','','',1,'','','','','',1),(200,'2019-08-01 15:13:23','2019-08-01 12:13:23','2019-08-01 12:13:23','1000','SIP/1001','ADDMEMBER','x.1564860237.250','','','',1,'','','','','',1),(201,'2019-08-01 15:13:23','2019-08-01 12:13:23','2019-08-01 12:13:23','NONE','SIP/1001','UNPAUSEALL','x.1564860237.251','','','',1,'','','','','',1),(202,'2019-08-01 15:13:23','2019-08-01 12:13:23','2019-08-01 12:13:23','1000','agent1001','UNPAUSE','x.1564860237.252','','','',1,'','','','','',1),(203,'2019-08-01 15:14:34','2019-08-01 12:14:34','2019-08-01 12:14:34','1000','SIP/1001','REMOVEMEMBER','x.1564860237.253','','','',1,'','','','','',1),(204,'2019-08-01 15:18:19','2019-08-01 12:18:19','2019-08-01 12:18:19','1000','SIP/1001','ADDMEMBER','x.1564860237.254','','','',1,'','','','','',1),(205,'2019-08-01 15:18:19','2019-08-01 12:18:19','2019-08-01 12:18:19','NONE','SIP/1001','UNPAUSEALL','x.1564860237.255','','','',1,'','','','','',1),(206,'2019-08-01 15:18:19','2019-08-01 12:18:19','2019-08-01 12:18:19','1000','agent1001','UNPAUSE','x.1564860237.256','','','',1,'','','','','',1),(207,'2019-08-01 15:19:24','2019-08-01 12:19:24','2019-08-01 12:19:24','1000','SIP/1001','REMOVEMEMBER','x.1564860237.257','','','',1,'','','','','',1),(208,'2019-08-01 15:55:43','2019-08-01 12:55:43','2019-08-01 12:55:43','1000','SIP/1001','ADDMEMBER','x.1564860237.258','','','',1,'','','','','',1),(209,'2019-08-01 15:55:43','2019-08-01 12:55:43','2019-08-01 12:55:43','NONE','SIP/1001','UNPAUSEALL','x.1564860237.259','','','',1,'','','','','',1),(210,'2019-08-01 15:55:43','2019-08-01 12:55:43','2019-08-01 12:55:43','1000','agent1001','UNPAUSE','x.1564860237.260','','','',1,'','','','','',1),(211,'2019-08-01 15:57:21','2019-08-01 12:57:21','2019-08-01 12:57:21','1000','SIP/1001','REMOVEMEMBER','x.1564860237.261','','','',1,'','','','','',1),(212,'2019-08-02 00:35:42','2019-08-01 21:35:42','2019-08-01 21:35:42','NONE','Agent/7701','AGENTLOGIN','x.1564860237.263','','','',1,'SIP/1005-00000041','','','','',1),(213,'2019-08-02 00:48:34','2019-08-01 21:48:34','2019-08-01 21:48:34','NONE','Agent/7701','AGENTLOGOFF','x.1564860237.265','','','',1,'SIP/1005-00000041','772','','','',1),(214,'2019-08-02 14:03:15','2019-08-02 11:03:15','2019-08-02 11:03:15','NONE','Agent/1012','AGENTLOGIN','x.1564860237.267','','','',1,'SIP/1001-00000048','','','','',1),(215,'2019-08-02 14:03:28','2019-08-02 11:03:28','2019-08-02 11:03:28','NONE','Agent/1012','AGENTLOGOFF','x.1564860237.268','','','',1,'SIP/1001-00000048','13','','','',1),(216,'2019-08-02 17:26:48','2019-08-02 14:26:48','2019-08-02 14:26:54','7001','NONE','ABANDON','1564756008.74','201','','',1,'1','1','6','','',1),(217,'2019-08-02 17:28:43','2019-08-02 14:28:43','2019-08-02 14:28:49','7001','NONE','ABANDON','1564756123.75','201','','',1,'1','1','6','','',1),(218,'2019-08-02 17:30:33','2019-08-02 14:30:33','2019-08-02 14:30:39','7001','NONE','ABANDON','1564756233.76','201','','',1,'1','1','6','','',1),(219,'2019-08-02 17:32:30','2019-08-02 14:32:30','2019-08-02 14:32:36','7001','NONE','ABANDON','1564756349.77','201','','',1,'1','1','6','','',1),(220,'2019-08-02 17:34:22','2019-08-02 14:34:22','2019-08-02 14:34:28','7001','NONE','ABANDON','1564756461.78','201','','',1,'1','1','6','','',1),(221,'2019-08-02 17:40:06','2019-08-02 14:40:06','2019-08-02 14:40:12','7001','NONE','ABANDON','1564756805.79','201','','',1,'1','1','6','','',1),(222,'2019-08-02 17:43:55','2019-08-02 14:43:55','2019-08-02 14:44:01','7001','NONE','ABANDON','1564757035.80','201','','',1,'1','1','6','','',1),(223,'2019-08-02 17:46:00','2019-08-02 14:46:00','2019-08-02 14:46:06','7001','NONE','ABANDON','1564757160.81','201','','',1,'1','1','6','','',1),(224,'2019-08-02 17:47:51','2019-08-02 14:47:51','2019-08-02 14:47:57','7001','NONE','ABANDON','1564757271.82','201','','',1,'1','1','6','','',1),(225,'2019-08-02 17:55:27','2019-08-02 14:55:27','2019-08-02 14:55:33','7001','NONE','ABANDON','1564757726.83','201','','',1,'1','1','6','','',1),(226,'2019-08-02 18:01:10','2019-08-02 15:01:10','2019-08-02 15:01:16','7001','NONE','ABANDON','1564758069.84','201','','',1,'1','1','6','','',1),(227,'2019-08-02 18:02:56','2019-08-02 15:02:56','2019-08-02 15:03:02','7001','NONE','ABANDON','1564758175.85','201','','',1,'1','1','6','','',1),(228,'2019-08-02 18:04:42','2019-08-02 15:04:42','2019-08-02 15:04:47','7001','NONE','ABANDON','1564758281.86','201','','',1,'1','1','5','','',1),(229,'2019-08-02 18:06:39','2019-08-02 15:06:39','2019-08-02 15:06:45','7001','NONE','ABANDON','1564758398.87','201','','',1,'1','1','6','','',1),(230,'2019-08-02 18:08:27','2019-08-02 15:08:27','2019-08-02 15:08:33','7001','NONE','ABANDON','1564758507.88','201','','',1,'1','1','6','','',1),(231,'2019-08-02 18:10:32','2019-08-02 15:10:32','2019-08-02 15:10:38','7001','NONE','ABANDON','1564758632.89','201','','',1,'1','1','6','','',1),(232,'2019-08-02 18:12:30','2019-08-02 15:12:30','2019-08-02 15:12:36','7001','NONE','ABANDON','1564758749.90','201','','',1,'1','1','6','','',1),(233,'2019-08-02 18:14:14','2019-08-02 15:14:14','2019-08-02 15:14:20','7001','NONE','ABANDON','1564758854.91','201','','',1,'1','1','6','','',1),(234,'2019-08-02 18:16:11','2019-08-02 15:16:11','2019-08-02 15:16:16','7001','NONE','ABANDON','1564758970.92','201','','',1,'1','1','5','','',1),(235,'2019-08-02 18:17:59','2019-08-02 15:17:59','2019-08-02 15:18:05','7001','NONE','ABANDON','1564759078.93','201','','',1,'1','1','6','','',1),(236,'2019-08-02 18:19:55','2019-08-02 15:19:55','2019-08-02 15:20:01','7001','NONE','ABANDON','1564759194.94','201','','',1,'1','1','6','','',1),(237,'2019-08-02 20:21:17','2019-08-02 17:21:17','2019-08-02 17:21:23','7001','NONE','ABANDON','1564766476.95','201','','',1,'1','1','6','','',1),(238,'2019-08-02 20:23:11','2019-08-02 17:23:11','2019-08-02 17:23:16','7001','NONE','ABANDON','1564766590.96','201','','',1,'1','1','5','','',1),(239,'2019-08-02 20:23:43','2019-08-02 17:23:43','2019-08-02 17:23:49','7001','NONE','ABANDON','1564766622.97','201','','',1,'1','1','6','','',1),(240,'2019-08-02 20:30:38','2019-08-02 17:30:38','2019-08-02 17:30:44','7001','NONE','ABANDON','1564767037.98','201','','',1,'1','1','6','','',1),(241,'2019-08-02 20:32:23','2019-08-02 17:32:23','2019-08-02 17:32:29','7001','NONE','ABANDON','1564767143.99','201','','',1,'1','1','6','','',1),(242,'2019-08-02 20:34:16','2019-08-02 17:34:16','2019-08-02 17:34:22','7001','NONE','ABANDON','1564767256.100','201','','',1,'1','1','6','','',1),(243,'2019-08-02 20:36:26','2019-08-02 17:36:26','2019-08-02 17:36:32','7001','NONE','ABANDON','1564767386.101','201','','',1,'1','1','6','','',1),(244,'2019-08-02 20:38:11','2019-08-02 17:38:11','2019-08-02 17:38:17','7001','NONE','ABANDON','1564767491.102','201','','',1,'1','1','6','','',1),(245,'2019-08-02 20:40:11','2019-08-02 17:40:11','2019-08-02 17:40:17','7001','NONE','ABANDON','1564767610.103','201','','',1,'1','1','6','','',1),(246,'2019-08-02 20:42:06','2019-08-02 17:42:06','2019-08-02 17:42:12','7001','NONE','ABANDON','1564767726.104','201','','',1,'1','1','6','','',1),(247,'2019-08-02 20:44:04','2019-08-02 17:44:04','2019-08-02 17:44:10','7001','NONE','ABANDON','1564767844.105','201','','',1,'1','1','6','','',1),(248,'2019-08-02 20:45:55','2019-08-02 17:45:55','2019-08-02 17:46:01','7001','NONE','ABANDON','1564767955.106','201','','',1,'1','1','6','','',1),(249,'2019-08-02 20:47:58','2019-08-02 17:47:58','2019-08-02 17:48:04','7001','NONE','ABANDON','1564768078.107','201','','',1,'1','1','6','','',1),(250,'2019-08-02 20:57:40','2019-08-02 17:57:40','2019-08-02 17:57:46','7001','NONE','ABANDON','1564768659.108','201','','',1,'1','1','6','','',1),(251,'2019-08-02 21:03:33','2019-08-02 18:03:33','2019-08-02 18:03:39','7001','NONE','ABANDON','1564769012.109','201','','',1,'1','1','6','','',1),(252,'2019-08-02 21:09:18','2019-08-02 18:09:18','2019-08-02 18:09:24','7001','NONE','ABANDON','1564769358.110','201','','',1,'1','1','6','','',1),(253,'2019-08-02 21:11:15','2019-08-02 18:11:15','2019-08-02 18:11:21','7001','NONE','ABANDON','1564769475.111','201','','',1,'1','1','6','','',1),(254,'2019-08-02 21:13:15','2019-08-02 18:13:15','2019-08-02 18:13:21','7001','NONE','ABANDON','1564769595.112','201','','',1,'1','1','6','','',1),(255,'2019-08-02 21:15:05','2019-08-02 18:15:05','2019-08-02 18:15:11','7001','NONE','ABANDON','1564769704.113','201','','',1,'1','1','6','','',1),(256,'2019-08-02 21:17:01','2019-08-02 18:17:01','2019-08-02 18:17:07','7001','NONE','ABANDON','1564769820.114','201','','',1,'1','1','6','','',1),(257,'2019-08-02 21:19:03','2019-08-02 18:19:03','2019-08-02 18:19:09','7001','NONE','ABANDON','1564769943.115','201','','',1,'1','1','6','','',1),(258,'2019-08-02 21:20:46','2019-08-02 18:20:46','2019-08-02 18:20:52','7001','NONE','ABANDON','1564770046.116','201','','',1,'1','1','6','','',1),(259,'2019-08-02 21:22:42','2019-08-02 18:22:42','2019-08-02 18:22:48','7001','NONE','ABANDON','1564770161.117','201','','',1,'1','1','6','','',1),(260,'2019-08-02 21:24:48','2019-08-02 18:24:48','2019-08-02 18:24:53','7001','NONE','ABANDON','1564770287.118','201','','',1,'1','1','5','','',1),(261,'2019-08-02 21:26:45','2019-08-02 18:26:45','2019-08-02 18:26:51','7001','NONE','ABANDON','1564770404.119','201','','',1,'1','1','6','','',1),(262,'2019-08-02 21:28:35','2019-08-02 18:28:35','2019-08-02 18:28:41','7001','NONE','ABANDON','1564770515.120','201','','',1,'1','1','6','','',1),(263,'2019-08-02 21:30:34','2019-08-02 18:30:34','2019-08-02 18:30:40','7001','NONE','ABANDON','1564770634.121','201','','',1,'1','1','6','','',1),(264,'2019-08-02 21:32:32','2019-08-02 18:32:32','2019-08-02 18:32:38','7001','NONE','ABANDON','1564770752.122','201','','',1,'1','1','6','','',1),(265,'2019-08-02 21:34:19','2019-08-02 18:34:19','2019-08-02 18:34:25','7001','NONE','ABANDON','1564770858.123','201','','',1,'1','1','6','','',1),(266,'2019-08-02 22:44:33','2019-08-02 19:44:33','2019-08-02 19:44:39','7001','NONE','ABANDON','1564775073.124','201','','',1,'1','1','6','','',1),(267,'2019-08-02 22:56:33','2019-08-02 19:56:33','2019-08-02 19:56:39','7001','NONE','ABANDON','1564775793.125','201','','',1,'1','1','6','','',1),(268,'2019-08-02 23:05:58','2019-08-02 20:05:58','2019-08-02 20:06:04','7001','NONE','ABANDON','1564776357.126','201','','',1,'1','1','6','','',1),(269,'2019-08-02 23:15:54','2019-08-02 20:15:54','2019-08-02 20:16:00','7001','NONE','ABANDON','1564776953.127','201','','',1,'1','1','6','','',1),(270,'2019-08-02 23:26:14','2019-08-02 20:26:14','2019-08-02 20:26:20','7001','NONE','ABANDON','1564777573.128','201','','',1,'1','1','6','','',1),(271,'2019-08-02 23:36:37','2019-08-02 20:36:37','2019-08-02 20:36:43','7001','NONE','ABANDON','1564778197.129','201','','',1,'1','1','6','','',1),(272,'2019-08-03 07:18:02','2019-08-03 04:18:02','2019-08-03 04:18:08','7001','NONE','ABANDON','1564805882.0','201','','',1,'1','1','6','','',1),(273,'2019-08-03 07:18:38','2019-08-03 04:18:38','2019-08-03 04:18:44','7001','NONE','ABANDON','1564805918.1','201','','',1,'1','1','6','','',1),(274,'2019-08-03 07:28:32','2019-08-03 04:28:32','2019-08-03 04:28:38','7001','NONE','ABANDON','1564806512.2','201','','',1,'1','1','6','','',1),(275,'2019-08-03 07:37:05','2019-08-03 04:37:05','2019-08-03 04:37:11','7001','NONE','ABANDON','1564807025.3','201','','',1,'1','1','6','','',1),(276,'2019-08-03 07:43:09','2019-08-03 04:43:09','2019-08-03 04:43:15','7001','NONE','ABANDON','1564807388.4','201','','',1,'1','1','6','','',1),(277,'2019-08-03 07:48:31','2019-08-03 04:48:31','2019-08-03 04:48:37','7001','NONE','ABANDON','1564807710.5','201','','',1,'1','1','6','','',1),(278,'2019-08-03 12:38:21','2019-08-03 09:38:21','2019-08-03 09:38:21','1000','SIP/1001','ADDMEMBER','x.1564860238.457','','','',1,'','','','','',1),(279,'2019-08-03 12:38:21','2019-08-03 09:38:21','2019-08-03 09:38:21','NONE','SIP/1001','UNPAUSEALL','x.1564860238.458','','','',1,'','','','','',1),(280,'2019-08-03 12:38:21','2019-08-03 09:38:21','2019-08-03 09:38:21','1000','agent1001','UNPAUSE','x.1564860238.459','','','',1,'','','','','',1),(281,'2019-08-03 12:39:52','2019-08-03 09:39:52','2019-08-03 09:39:52','1000','SIP/1001','REMOVEMEMBER','x.1564860238.460','','','',1,'','','','','',1),(282,'2019-08-03 12:42:18','2019-08-03 09:42:18','2019-08-03 09:42:18','1000','SIP/1001','ADDMEMBER','x.1564860238.461','','','',1,'','','','','',1),(283,'2019-08-03 12:42:18','2019-08-03 09:42:18','2019-08-03 09:42:18','NONE','SIP/1001','UNPAUSEALL','x.1564860238.462','','','',1,'','','','','',1),(284,'2019-08-03 12:42:18','2019-08-03 09:42:18','2019-08-03 09:42:18','1000','agent1001','UNPAUSE','x.1564860238.463','','','',1,'','','','','',1),(285,'2019-08-03 12:44:23','2019-08-03 09:44:23','2019-08-03 09:44:23','1000','SIP/1001','REMOVEMEMBER','x.1564860238.464','','','',1,'','','','','',1),(286,'2019-08-03 13:30:46','2019-08-03 10:30:46','2019-08-03 10:31:29','1000','NONE','ABANDON','1564828236.10','201','','',1,'1','1','43','','',1),(287,'2019-08-03 13:31:45','2019-08-03 10:31:45','2019-08-03 10:31:46','1000','NONE','ABANDON','1564828290.11','201','','',1,'1','1','1','','',1),(288,'2019-08-03 13:31:58','2019-08-03 10:31:58','2019-08-03 10:31:59','1000','NONE','ABANDON','1564828308.12','201','','',1,'1','1','1','','',1),(289,'2019-08-03 13:33:10','2019-08-03 10:33:10','2019-08-03 10:33:10','1000','SIP/1005','ADDMEMBER','x.1564860238.474','','','',1,'','','','','',1),(290,'2019-08-03 13:33:10','2019-08-03 10:33:10','2019-08-03 10:33:10','NONE','SIP/1005','UNPAUSEALL','x.1564860238.475','','','',1,'','','','','',1),(291,'2019-08-03 13:33:10','2019-08-03 10:33:10','2019-08-03 10:33:10','1000','Agent1005','UNPAUSE','x.1564860238.476','','','',1,'','','','','',1),(292,'2019-08-03 13:33:21','2019-08-03 10:33:24','2019-08-03 10:33:31','1000','Agent1005','COMPLETECALLER','1564828390.14','201','','',1,'3','7','1','','',0),(293,'2019-08-03 13:35:10','2019-08-03 10:35:13','2019-08-03 10:35:31','1000','Agent1005','COMPLETECALLER','1564828495.16','201','','',1,'3','18','1','','',0),(294,'2019-08-03 13:35:14','2019-08-03 10:35:14','2019-08-03 10:35:34','1000','NONE','ABANDON','1564828495.17','201','','',1,'1','1','20','','',1),(295,'2019-08-03 13:35:47','2019-08-03 10:35:51','2019-08-03 10:35:54','1000','Agent1005','COMPLETECALLER','1564828534.22','201','','',1,'4','3','1','','',0),(296,'2019-08-03 13:37:00','2019-08-03 10:37:03','2019-08-03 10:37:11','1000','Agent1005','COMPLETEAGENT','1564828607.25','201','','',1,'3','8','1','','',0),(297,'2019-08-03 13:37:34','2019-08-03 10:37:37','2019-08-03 10:40:41','1000','Agent1005','COMPLETECALLER','1564828640.27','201','','',1,'3','184','1','','',0),(298,'2019-08-03 14:30:42','2019-08-03 11:30:42','2019-08-03 11:31:07','7001','NONE','ABANDON','1564831842.29','201','','',1,'1','1','25','','',1),(299,'2019-08-03 14:32:23','2019-08-03 11:32:23','2019-08-03 11:32:48','7001','NONE','ABANDON','1564831943.30','201','','',1,'1','1','25','','',1),(300,'2019-08-03 14:34:18','2019-08-03 11:34:18','2019-08-03 11:34:43','7001','NONE','ABANDON','1564832057.31','201','','',1,'1','1','25','','',1),(301,'2019-08-03 14:36:09','2019-08-03 11:36:09','2019-08-03 11:36:40','7001','NONE','ABANDON','1564832169.32','201','','',1,'1','1','31','','',1),(302,'2019-08-03 14:37:57','2019-08-03 11:37:57','2019-08-03 11:38:28','7001','NONE','ABANDON','1564832277.33','201','','',1,'1','1','31','','',1),(303,'2019-08-03 14:43:48','2019-08-03 11:43:48','2019-08-03 11:44:14','7001','NONE','ABANDON','1564832628.34','201','','',1,'1','1','26','','',1),(304,'2019-08-03 14:47:18','2019-08-03 11:47:18','2019-08-03 11:47:45','7001','NONE','ABANDON','1564832838.35','201','','',1,'1','1','27','','',1),(305,'2019-08-03 14:49:15','2019-08-03 11:49:15','2019-08-03 11:49:41','7001','NONE','ABANDON','1564832954.36','201','','',1,'1','1','26','','',1),(306,'2019-08-03 14:51:06','2019-08-03 11:51:06','2019-08-03 11:51:33','7001','NONE','ABANDON','1564833065.37','201','','',1,'1','1','27','','',1),(307,'2019-08-03 14:58:38','2019-08-03 11:58:38','2019-08-03 11:59:06','7001','NONE','ABANDON','1564833517.38','201','','',1,'1','1','28','','',1),(308,'2019-08-03 15:04:15','2019-08-03 12:04:15','2019-08-03 12:04:44','7001','NONE','ABANDON','1564833855.39','201','','',1,'1','1','29','','',1),(309,'2019-08-03 15:06:01','2019-08-03 12:06:01','2019-08-03 12:06:30','7001','NONE','ABANDON','1564833961.40','201','','',1,'1','1','29','','',1),(310,'2019-08-03 15:08:12','2019-08-03 12:08:12','2019-08-03 12:08:41','7001','NONE','ABANDON','1564834091.41','201','','',1,'1','1','29','','',1),(311,'2019-08-03 15:09:53','2019-08-03 12:09:53','2019-08-03 12:10:23','7001','NONE','ABANDON','1564834192.42','201','','',1,'1','1','30','','',1),(312,'2019-08-03 15:11:45','2019-08-03 12:11:45','2019-08-03 12:12:15','7001','NONE','ABANDON','1564834305.43','201','','',1,'1','1','30','','',1),(313,'2019-08-03 15:13:28','2019-08-03 12:13:28','2019-08-03 12:13:58','7001','NONE','ABANDON','1564834408.44','201','','',1,'1','1','30','','',1),(314,'2019-08-03 15:15:24','2019-08-03 12:15:24','2019-08-03 12:15:54','7001','NONE','ABANDON','1564834523.45','201','','',1,'1','1','30','','',1),(315,'2019-08-03 15:17:17','2019-08-03 12:17:17','2019-08-03 12:17:48','7001','NONE','ABANDON','1564834637.46','201','','',1,'1','1','31','','',1),(316,'2019-08-03 15:18:56','2019-08-03 12:18:56','2019-08-03 12:19:27','7001','NONE','ABANDON','1564834736.47','201','','',1,'1','1','31','','',1),(317,'2019-08-03 15:20:53','2019-08-03 12:20:53','2019-08-03 12:21:23','7001','NONE','ABANDON','1564834852.48','201','','',1,'1','1','30','','',1),(318,'2019-08-03 15:22:47','2019-08-03 12:22:47','2019-08-03 12:23:18','7001','NONE','ABANDON','1564834967.49','201','','',1,'1','1','31','','',1),(319,'2019-08-03 16:13:07','2019-08-03 13:13:07','2019-08-03 13:13:38','7001','NONE','ABANDON','1564837987.50','201','','',1,'1','1','31','','',1),(320,'2019-08-03 16:49:33','2019-08-03 13:49:33','2019-08-03 13:49:33','1000','SIP/1005','REMOVEMEMBER','x.1564860238.567','','','',1,'','','','','',1),(321,'2019-08-03 17:26:23','2019-08-03 14:26:23','2019-08-03 14:26:54','7001','NONE','ABANDON','1564842383.51','201','','',1,'1','1','31','','',1),(322,'2019-08-03 17:28:19','2019-08-03 14:28:19','2019-08-03 14:28:49','7001','NONE','ABANDON','1564842498.52','201','','',1,'1','1','30','','',1),(323,'2019-08-03 17:36:04','2019-08-03 14:36:04','2019-08-03 14:36:35','7001','NONE','ABANDON','1564842964.53','201','','',1,'1','1','31','','',1),(324,'2019-08-03 17:38:04','2019-08-03 14:38:04','2019-08-03 14:38:35','7001','NONE','ABANDON','1564843084.54','201','','',1,'1','1','31','','',1),(325,'2019-08-03 17:39:52','2019-08-03 14:39:52','2019-08-03 14:40:22','7001','NONE','ABANDON','1564843191.55','201','','',1,'1','1','30','','',1),(326,'2019-08-03 17:41:54','2019-08-03 14:41:54','2019-08-03 14:42:25','7001','NONE','ABANDON','1564843314.56','201','','',1,'1','1','31','','',1),(327,'2019-08-03 17:43:42','2019-08-03 14:43:42','2019-08-03 14:44:12','7001','NONE','ABANDON','1564843421.57','201','','',1,'1','1','30','','',1),(328,'2019-08-03 17:45:38','2019-08-03 14:45:38','2019-08-03 14:46:09','7001','NONE','ABANDON','1564843538.58','201','','',1,'1','1','31','','',1),(329,'2019-08-03 17:47:38','2019-08-03 14:47:38','2019-08-03 14:48:08','7001','NONE','ABANDON','1564843657.59','201','','',1,'1','1','30','','',1),(330,'2019-08-03 17:49:34','2019-08-03 14:49:34','2019-08-03 14:50:04','7001','NONE','ABANDON','1564843773.60','201','','',1,'1','1','30','','',1),(331,'2019-08-03 17:51:29','2019-08-03 14:51:29','2019-08-03 14:52:00','7001','NONE','ABANDON','1564843889.61','201','','',1,'1','1','31','','',1),(332,'2019-08-03 17:53:25','2019-08-03 14:53:25','2019-08-03 14:53:55','7001','NONE','ABANDON','1564844004.62','201','','',1,'1','1','30','','',1),(333,'2019-08-03 18:02:56','2019-08-03 15:02:56','2019-08-03 15:03:27','7001','NONE','ABANDON','1564844576.63','201','','',1,'1','1','31','','',1),(334,'2019-08-03 18:08:25','2019-08-03 15:08:25','2019-08-03 15:08:56','7001','NONE','ABANDON','1564844905.64','201','','',1,'1','1','31','','',1),(335,'2019-08-03 18:14:08','2019-08-03 15:14:08','2019-08-03 15:14:38','7001','NONE','ABANDON','1564845247.65','201','','',1,'1','1','30','','',1),(336,'2019-08-03 18:16:00','2019-08-03 15:16:00','2019-08-03 15:16:31','7001','NONE','ABANDON','1564845360.66','201','','',1,'1','1','31','','',1),(337,'2019-08-03 18:18:08','2019-08-03 15:18:08','2019-08-03 15:18:38','7001','NONE','ABANDON','1564845487.67','201','','',1,'1','1','30','','',1),(338,'2019-08-03 18:19:52','2019-08-03 15:19:52','2019-08-03 15:20:22','7001','NONE','ABANDON','1564845591.68','201','','',1,'1','1','30','','',1),(339,'2019-08-03 18:21:53','2019-08-03 15:21:53','2019-08-03 15:22:23','7001','NONE','ABANDON','1564845712.69','201','','',1,'1','1','30','','',1),(340,'2019-08-03 18:23:42','2019-08-03 15:23:42','2019-08-03 15:24:12','7001','NONE','ABANDON','1564845821.70','201','','',1,'1','1','30','','',1),(341,'2019-08-03 18:25:36','2019-08-03 15:25:36','2019-08-03 15:26:06','7001','NONE','ABANDON','1564845935.71','201','','',1,'1','1','30','','',1),(342,'2019-08-03 18:27:36','2019-08-03 15:27:36','2019-08-03 15:28:06','7001','NONE','ABANDON','1564846055.72','201','','',1,'1','1','30','','',1),(343,'2019-08-03 18:29:45','2019-08-03 15:29:45','2019-08-03 15:30:16','7001','NONE','ABANDON','1564846185.73','201','','',1,'1','1','31','','',1),(344,'2019-08-03 18:31:31','2019-08-03 15:31:31','2019-08-03 15:32:01','7001','NONE','ABANDON','1564846290.74','201','','',1,'1','1','30','','',1),(345,'2019-08-03 18:33:26','2019-08-03 15:33:26','2019-08-03 15:33:56','7001','NONE','ABANDON','1564846405.75','201','','',1,'1','1','30','','',1),(346,'2019-08-03 18:35:25','2019-08-03 15:35:25','2019-08-03 15:35:56','7001','NONE','ABANDON','1564846525.76','201','','',1,'1','1','31','','',1),(347,'2019-08-03 18:37:14','2019-08-03 15:37:14','2019-08-03 15:37:45','7001','NONE','ABANDON','1564846634.77','201','','',1,'1','1','31','','',1),(348,'2019-08-03 18:39:10','2019-08-03 15:39:10','2019-08-03 15:39:40','7001','NONE','ABANDON','1564846749.78','201','','',1,'1','1','30','','',1),(349,'2019-08-03 19:29:25','2019-08-03 16:29:25','2019-08-03 16:29:31','7001','NONE','ABANDON','1564849765.79','201','','',1,'1','1','6','','',1),(350,'2019-08-03 19:31:26','2019-08-03 16:31:26','2019-08-03 16:31:32','7001','NONE','ABANDON','1564849885.80','201','','',1,'1','1','6','','',1),(351,'2019-08-03 19:33:45','2019-08-03 16:33:45','2019-08-03 16:33:51','7001','NONE','ABANDON','1564850024.81','201','','',1,'1','1','6','','',1),(352,'2019-08-03 19:35:55','2019-08-03 16:35:55','2019-08-03 16:36:00','7001','NONE','ABANDON','1564850154.82','201','','',1,'1','1','5','','',1),(353,'2019-08-03 19:38:21','2019-08-03 16:38:21','2019-08-03 16:38:27','7001','NONE','ABANDON','1564850300.83','201','','',1,'1','1','6','','',1),(354,'2019-08-03 19:40:25','2019-08-03 16:40:25','2019-08-03 16:40:31','7001','NONE','ABANDON','1564850425.84','201','','',1,'1','1','6','','',1),(355,'2019-08-03 19:53:55','2019-08-03 16:53:55','2019-08-03 16:53:55','1000','SIP/1001','ADDMEMBER','x.1564860238.670','','','',1,'','','','','',1),(356,'2019-08-03 19:53:55','2019-08-03 16:53:55','2019-08-03 16:53:55','NONE','SIP/1001','UNPAUSEALL','x.1564860239.671','','','',1,'','','','','',1),(357,'2019-08-03 19:53:55','2019-08-03 16:53:55','2019-08-03 16:53:55','1000','agent1001','UNPAUSE','x.1564860239.672','','','',1,'','','','','',1),(358,'2019-08-03 19:54:27','2019-08-03 16:54:27','2019-08-03 16:54:27','1000','SIP/1001','REMOVEMEMBER','x.1564860239.673','','','',1,'','','','','',1),(359,'2019-08-03 19:56:24','2019-08-03 16:56:24','2019-08-03 16:56:30','7001','NONE','ABANDON','1564851383.85','201','','',1,'1','1','6','','',1),(360,'2019-08-03 19:57:19','2019-08-03 16:57:19','2019-08-03 16:57:19','1000','SIP/1001','ADDMEMBER','x.1564860239.677','','','',1,'','','','','',1),(361,'2019-08-03 19:57:19','2019-08-03 16:57:19','2019-08-03 16:57:19','NONE','SIP/1001','UNPAUSEALL','x.1564860239.678','','','',1,'','','','','',1),(362,'2019-08-03 19:57:19','2019-08-03 16:57:19','2019-08-03 16:57:19','1000','agent1001','UNPAUSE','x.1564860239.679','','','',1,'','','','','',1),(363,'2019-08-03 19:57:41','2019-08-03 16:57:41','2019-08-03 16:57:41','1000','SIP/1001','REMOVEMEMBER','x.1564860239.680','','','',1,'','','','','',1),(364,'2019-08-03 20:06:49','2019-08-03 17:06:49','2019-08-03 17:06:49','1000','SIP/1001','ADDMEMBER','x.1564860239.681','','','',1,'','','','','',1),(365,'2019-08-03 20:06:49','2019-08-03 17:06:49','2019-08-03 17:06:49','NONE','SIP/1001','UNPAUSEALL','x.1564860239.682','','','',1,'','','','','',1),(366,'2019-08-03 20:06:49','2019-08-03 17:06:49','2019-08-03 17:06:49','1000','agent1001','UNPAUSE','x.1564860239.683','','','',1,'','','','','',1),(367,'2019-08-03 20:10:33','2019-08-03 17:10:33','2019-08-03 17:10:33','1000','SIP/1001','REMOVEMEMBER','x.1564860239.684','','','',1,'','','','','',1),(368,'2019-08-03 20:20:45','2019-08-03 17:20:45','2019-08-03 17:20:45','1000','SIP/1001','ADDMEMBER','x.1564860239.685','','','',1,'','','','','',1),(369,'2019-08-03 20:20:45','2019-08-03 17:20:45','2019-08-03 17:20:45','NONE','SIP/1001','UNPAUSEALL','x.1564860239.686','','','',1,'','','','','',1),(370,'2019-08-03 20:20:45','2019-08-03 17:20:45','2019-08-03 17:20:45','1000','agent1001','UNPAUSE','x.1564860239.687','','','',1,'','','','','',1),(371,'2019-08-03 20:25:01','2019-08-03 17:25:01','2019-08-03 17:25:01','1000','SIP/1001','REMOVEMEMBER','x.1564860239.688','','','',1,'','','','','',1),(372,'2019-08-03 20:37:51','2019-08-03 17:37:51','2019-08-03 17:37:51','1000','SIP/1001','ADDMEMBER','x.1564860239.689','','','',1,'','','','','',1),(373,'2019-08-03 20:37:51','2019-08-03 17:37:51','2019-08-03 17:37:51','NONE','SIP/1001','UNPAUSEALL','x.1564860239.690','','','',1,'','','','','',1),(374,'2019-08-03 20:37:51','2019-08-03 17:37:51','2019-08-03 17:37:51','1000','agent1001','UNPAUSE','x.1564860239.691','','','',1,'','','','','',1),(375,'2019-08-03 20:39:53','2019-08-03 17:39:53','2019-08-03 17:39:53','1000','SIP/1001','REMOVEMEMBER','x.1564860239.692','','','',1,'','','','','',1),(376,'2019-08-03 21:17:17','2019-08-03 18:17:17','2019-08-03 18:17:17','1000','SIP/1001','ADDMEMBER','x.1564860239.694','','','',1,'','','','','',1),(377,'2019-08-03 21:17:17','2019-08-03 18:17:17','2019-08-03 18:17:17','NONE','SIP/1001','UNPAUSEALL','x.1564860239.695','','','',1,'','','','','',1),(378,'2019-08-03 21:17:17','2019-08-03 18:17:17','2019-08-03 18:17:17','1000','agent1001','UNPAUSE','x.1564860239.696','','','',1,'','','','','',1),(379,'2019-08-03 21:20:23','2019-08-03 18:20:23','2019-08-03 18:20:23','1000','SIP/1005','ADDMEMBER','x.1564860239.697','','','',1,'','','','','',1),(380,'2019-08-03 21:20:23','2019-08-03 18:20:23','2019-08-03 18:20:23','NONE','SIP/1005','UNPAUSEALL','x.1564860239.698','','','',1,'','','','','',1),(381,'2019-08-03 21:20:23','2019-08-03 18:20:23','2019-08-03 18:20:23','1000','Agent1005','UNPAUSE','x.1564860239.699','','','',1,'','','','','',1),(382,'2019-08-03 21:24:32','2019-08-03 18:24:39','2019-08-03 18:25:07','1000','Agent1005','COMPLETEAGENT','1564856663.87','201','','',1,'7','28','1','','',0),(383,'2019-08-03 21:25:59','2019-08-03 18:25:59','2019-08-03 18:25:59','1000','SIP/1005','REMOVEMEMBER','x.1564860239.704','','','',1,'','','','','',1),(384,'2019-08-03 21:26:37','2019-08-03 18:26:40','2019-08-03 18:26:45','1000','agent1001','COMPLETEAGENT','1564856787.92','201','','',1,'3','5','1','','',0),(385,'2019-08-03 21:27:07','2019-08-03 18:27:07','2019-08-03 18:27:07','1000','SIP/1001','REMOVEMEMBER','x.1564860239.709','','','',1,'','','','','',1),(386,'2019-08-03 21:27:15','2019-08-03 18:27:15','2019-08-03 18:27:18','1000','NONE','ABANDON','1564856808.94','201','','',1,'1','1','3','','',1);
/*!40000 ALTER TABLE `queue_stats_mv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `recordings`
--

LOCK TABLES `recordings` WRITE;
/*!40000 ALTER TABLE `recordings` DISABLE KEYS */;
/*!40000 ALTER TABLE `recordings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `sched`
--

LOCK TABLES `sched` WRITE;
/*!40000 ALTER TABLE `sched` DISABLE KEYS */;
/*!40000 ALTER TABLE `sched` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `secure_level`
--

LOCK TABLES `secure_level` WRITE;
/*!40000 ALTER TABLE `secure_level` DISABLE KEYS */;
INSERT INTO `secure_level` (`level`, `detail`) VALUES (1,'user'),(2,'admin'),(4,'agent'),(8,'supervisor');
/*!40000 ALTER TABLE `secure_level` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `setup`
--

LOCK TABLES `setup` WRITE;
/*!40000 ALTER TABLE `setup` DISABLE KEYS */;
INSERT INTO `setup` (`id`, `keyword`, `parameter`, `value`) VALUES (1,'realtime_alarm_call_duration','','300'),(2,'realtime_alarm_row_color','','#ff0'),(3,'realtime_alarm_threshold','','50'),(4,'avg_time_format','','HH:MM:SS'),(5,'call_time_format','','HH:MM:SS'),(6,'csv_separator','',','),(7,'date_format','','%m-%d-%Y %H:%i:%S'),(8,'decimal_places','','2'),(9,'default_end_hour','','23:59'),(10,'default_start_hour','','00:00'),(11,'detailed_agent_report','','1'),(12,'distribution_interval','','60'),(13,'first_page','','distribution.php'),(14,'honor_timeframe_in_agent','','true'),(15,'language','','en'),(16,'realtime_refresh','','5'),(17,'recordings_path','','/var/spool/asterisk/monitor'),(18,'session_time_format','','HH:MM:SS'),(19,'show_agent_call','','1'),(20,'show_agent_field','','0'),(21,'show_url_field','','0'),(22,'sla_abandoned','','15'),(23,'sla_answered','','60'),(24,'sla_interval','','15'),(25,'sla_steps','','10'),(26,'sla_transferred','','60'),(27,'sla_unanswered','','15'),(28,'timeframe_interval','','1'),(29,'wait_time_format','','HH:MM:SS'),(30,'week_mode','','7');
/*!40000 ALTER TABLE `setup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `sqlrealtime`
--

LOCK TABLES `sqlrealtime` WRITE;
/*!40000 ALTER TABLE `sqlrealtime` DISABLE KEYS */;
/*!40000 ALTER TABLE `sqlrealtime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `user_filter`
--

LOCK TABLES `user_filter` WRITE;
/*!40000 ALTER TABLE `user_filter` DISABLE KEYS */;
INSERT INTO `user_filter` (`user`, `param`, `value`) VALUES ('user','queue','ALL'),('user','agent','ALL'),('admin','queue','ALL'),('admin','agent','ALL'),('supervisor','queue','ALL'),('supervisor','agent','ALL'),('restUser','queue','ALL'),('restUser','agent','ALL');
/*!40000 ALTER TABLE `user_filter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `userqagent`
--

LOCK TABLES `userqagent` WRITE;
/*!40000 ALTER TABLE `userqagent` DISABLE KEYS */;
INSERT INTO `userqagent` (`users_id`, `qagent_agent_id`) VALUES (1,-1),(2,-1),(3,-1),(4,-1);
/*!40000 ALTER TABLE `userqagent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `userqname`
--

LOCK TABLES `userqname` WRITE;
/*!40000 ALTER TABLE `userqname` DISABLE KEYS */;
INSERT INTO `userqname` (`users_id`, `qname_queue_id`) VALUES (1,-1),(2,-1),(3,-1),(4,-1);
/*!40000 ALTER TABLE `userqname` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `login`, `password`, `name`, `level`) VALUES (1,'admin','d033e22ae348aeb5660fc2140aec35850c4da997','Administrator','15'),(2,'user','12dea96fec20593566ab75692c9949596833adc9','User','1'),(3,'supervisor','0f4d09e43d208d5e9222322fbc7091ceea1a78c3','Supervisor','8'),(4,'restUser','3fe3445084aa644b001565bdf71e7fb1b956f0ff','REST User','15');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-04-29 23:59:11
