-- MySQL dump 10.14  Distrib 5.5.68-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: endpointconfig
-- ------------------------------------------------------
-- Server version	5.5.68-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `configlog`
--

DROP TABLE IF EXISTS `configlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `configlog` (
  `lastlog` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `endpoint` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_manufacturer` int(10) unsigned NOT NULL,
  `id_model` int(10) unsigned DEFAULT NULL,
  `mac_address` char(17) DEFAULT NULL,
  `last_known_ipv4` varchar(15) DEFAULT NULL,
  `last_scanned` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `last_configured` datetime DEFAULT NULL,
  `selected` int(1) unsigned NOT NULL DEFAULT '0',
  `authtoken_sha1` char(40) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mac_address` (`mac_address`),
  KEY `id_manufacturer` (`id_manufacturer`),
  KEY `id_model` (`id_model`),
  CONSTRAINT `endpoint_ibfk_1` FOREIGN KEY (`id_manufacturer`) REFERENCES `manufacturer` (`id`),
  CONSTRAINT `endpoint_ibfk_2` FOREIGN KEY (`id_model`) REFERENCES `model` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `endpoint_account`
--

DROP TABLE IF EXISTS `endpoint_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `endpoint_account` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_endpoint` int(10) unsigned NOT NULL,
  `tech` varchar(10) NOT NULL,
  `account` varchar(50) NOT NULL,
  `priority` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_endpoint` (`id_endpoint`),
  CONSTRAINT `endpoint_account_ibfk_1` FOREIGN KEY (`id_endpoint`) REFERENCES `endpoint` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `endpoint_account_properties`
--

DROP TABLE IF EXISTS `endpoint_account_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `endpoint_account_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_endpoint_account` int(10) unsigned NOT NULL,
  `property_key` varchar(128) NOT NULL,
  `property_value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_endpoint_account` (`id_endpoint_account`),
  CONSTRAINT `endpoint_account_properties_ibfk_1` FOREIGN KEY (`id_endpoint_account`) REFERENCES `endpoint_account` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `endpoint_properties`
--

DROP TABLE IF EXISTS `endpoint_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `endpoint_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_endpoint` int(10) unsigned NOT NULL,
  `property_key` varchar(128) NOT NULL,
  `property_value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_endpoint` (`id_endpoint`),
  CONSTRAINT `endpoint_properties_ibfk_1` FOREIGN KEY (`id_endpoint`) REFERENCES `endpoint` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mac_prefix`
--

DROP TABLE IF EXISTS `mac_prefix`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `mac_prefix` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_manufacturer` int(10) unsigned NOT NULL,
  `mac_prefix` char(8) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_manufacturer` (`id_manufacturer`),
  CONSTRAINT `mac_prefix_ibfk_1` FOREIGN KEY (`id_manufacturer`) REFERENCES `manufacturer` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `manufacturer`
--

DROP TABLE IF EXISTS `manufacturer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `manufacturer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `model`
--

DROP TABLE IF EXISTS `model`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `model` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_manufacturer` int(10) unsigned NOT NULL,
  `name` varchar(128) NOT NULL,
  `description` text NOT NULL,
  `max_accounts` int(10) unsigned NOT NULL DEFAULT '1',
  `static_ip_supported` tinyint(1) NOT NULL DEFAULT '0',
  `dynamic_ip_supported` tinyint(1) NOT NULL DEFAULT '1',
  `static_prov_supported` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_manufacturer` (`id_manufacturer`),
  CONSTRAINT `model_ibfk_1` FOREIGN KEY (`id_manufacturer`) REFERENCES `manufacturer` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `model_properties`
--

DROP TABLE IF EXISTS `model_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `model_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_model` int(10) unsigned NOT NULL,
  `property_key` varchar(128) NOT NULL,
  `property_value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_model` (`id_model`),
  CONSTRAINT `model_properties_ibfk_1` FOREIGN KEY (`id_model`) REFERENCES `model` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=511 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-04-29 23:59:10
-- MySQL dump 10.14  Distrib 5.5.68-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: endpointconfig
-- ------------------------------------------------------
-- Server version	5.5.68-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `configlog`
--

LOCK TABLES `configlog` WRITE;
/*!40000 ALTER TABLE `configlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `configlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `endpoint_account`
--

LOCK TABLES `endpoint_account` WRITE;
/*!40000 ALTER TABLE `endpoint_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `endpoint_account_properties`
--

LOCK TABLES `endpoint_account_properties` WRITE;
/*!40000 ALTER TABLE `endpoint_account_properties` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_account_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `endpoint_properties`
--

LOCK TABLES `endpoint_properties` WRITE;
/*!40000 ALTER TABLE `endpoint_properties` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `mac_prefix`
--

LOCK TABLES `mac_prefix` WRITE;
/*!40000 ALTER TABLE `mac_prefix` DISABLE KEYS */;
INSERT INTO `mac_prefix` (`id`, `id_manufacturer`, `mac_prefix`, `description`) VALUES (1,1,'00:08:5D','Aastra'),(2,2,'00:09:45','Atcom - Palmmicro Communication'),(3,3,'74:65:D1','Atlinks'),(4,4,'00:90:8F','AudioCodes'),(5,5,'00:03:6B','Cisco'),(6,5,'00:07:EB','Cisco - 7940'),(7,5,'00:0B:5F','Cisco - 7960'),(8,5,'00:0D:29','Cisco 79xx'),(9,5,'00:0D:ED','Cisco - 7960'),(10,5,'00:0E:38','Cisco - 7960'),(11,5,'00:0F:23','Cisco - 7960'),(12,5,'00:12:00','Cisco - 7940'),(13,5,'00:12:43','Cisco - 7940 '),(14,5,'00:12:7F','Cisco - 7690 '),(15,5,'00:13:19','Cisco - 7940'),(16,5,'00:13:C3','Cisco - 7960'),(17,5,'00:14:A9','Cisco - 7940'),(18,5,'00:15:FA','Cisco - 7960'),(19,5,'00:16:46','Cisco - 7940'),(20,5,'00:17:0E','Cisco 79xx'),(21,5,'00:18:18','Cisco - 7940'),(22,5,'00:18:73','Cisco - 7940'),(23,5,'00:19:AA','Cisco - 7940'),(24,5,'00:19:E7','Cisco - 7940'),(25,5,'00:1A:6D','Cisco - 7961 '),(26,5,'00:1A:A1','Cisco - 7961 '),(27,5,'00:1B:53','Cisco - 7931'),(28,5,'00:1E:4A','Cisco  7906-7970 '),(29,5,'00:21:55','Cisco - 7961 '),(30,6,'7C:14:76','Damall'),(31,8,'00:26:8B','Escene'),(32,9,'00:A8:59','Fanvil'),(33,10,'00:0B:82','Grandstream'),(34,11,'B4:0E:DC','LG-ERICSSON'),(35,12,'00:0E:08','Linksys/Sipura'),(36,13,'00:D0:1E','Pingtel - Generic'),(37,14,'00:04:F2','Polycom'),(38,14,'00:E0:DB','Polycom - VSX7000A'),(39,15,'00:01:E3','Siemens - SL75 WLAN'),(40,16,'00:04:13','Snom360'),(41,16,'00:04:23','Snom360'),(42,16,'00:04:25','Snom300'),(43,16,'00:04:27','Snom320'),(44,17,'00:0E:50','Thomson - Generic'),(45,17,'00:14:7F','Thomson - ST 2030'),(46,17,'00:18:F6','Thomson - ST 2022 '),(47,18,'00:E0:11','Uniden - Generic'),(48,19,'00:0E:30','VOPTech'),(49,20,'64:24:00','Xorcom'),(50,21,'00:15:65','Yealink'),(51,22,'00:0B:EA','Zultys Technologies'),(52,23,'00:19:15','Digium Phones'),(53,23,'00:0F:D3','Digium Phones'),(54,24,'6C:A9:06','RCA IP Phones'),(55,24,'74:65:D1','RCA IP160s'),(56,25,'00:1F:C1','Hanlong'),(57,9,'00:38:3E','Fanvil'),(58,7,'30:6C:BE','Elastix'),(59,7,'0C:11:05','Elastix'),(60,9,'0C:38:3E','Fanvil'),(61,26,'1C:DF:0F','Cisco SPA502G'),(62,26,'58:BF:EA','Cisco SPA502G'),(63,26,'00:02:FD','Cisco SPA504G'),(64,26,'C8:9C:1D','Cisco SPA504G'),(65,26,'00:26:99','Cisco SPA504G'),(66,26,'64:9E:F3','Cisco SPA504G'),(67,26,'70:81:05','Cisco SPA504G'),(68,26,'58:0A:20','Cisco SPA504G'),(69,26,'CC:EF:48','Cisco SPA504G'),(70,26,'E0:2F:6D','Cisco SPA504G'),(71,26,'30:F7:0D','Cisco SPA525G2'),(72,26,'B0:FA:EB','Cisco SPA525G2'),(73,26,'1C:1D:86','Cisco SPA525G2'),(74,26,'4C:00:82','Cisco SPA525G2'),(75,26,'A4:93:4C','Cisco SPA514G'),(76,26,'3C:CE:73','Cisco SPA301G'),(77,26,'3C:CE:73','Cisco SPA303G'),(78,26,'E8:B7:48','Cisco SPA504G'),(79,26,'54:75:D0','Cisco SPA301G'),(80,27,'00:03:2A','INCOM ICW-1000');
/*!40000 ALTER TABLE `mac_prefix` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `manufacturer`
--

LOCK TABLES `manufacturer` WRITE;
/*!40000 ALTER TABLE `manufacturer` DISABLE KEYS */;
INSERT INTO `manufacturer` (`id`, `name`, `description`) VALUES (1,'Aastra','Aastra'),(2,'Atcom','IP Phone'),(3,'Atlinks','Atlinks'),(4,'AudioCodes','AudioCodes'),(5,'Cisco','Cisco'),(6,'Damall','Damall Technology Co'),(7,'Elastix','PaloSanto Solution'),(8,'Escene','Escene Communication'),(9,'Fanvil','Fanvil Technology Co.'),(10,'Grandstream','Grandstream'),(11,'LG-ERICSSON','LG-ERICSSON'),(12,'Linksys','Linksys/Sipura'),(13,'Pingtel','Generic'),(14,'Polycom','Polycom'),(15,'Siemens','Siemens'),(16,'Snom','Snom360'),(17,'Thomson','Generic'),(18,'Uniden','Generic'),(19,'VOPTech','VOPTech'),(20,'Xorcom','Xorcom'),(21,'Yealink','Yealink'),(22,'Zultys','Zultys Technologies'),(23,'Digium','Digium DPMA Phones'),(24,'RCA','RCA IP Phones'),(25,'Hanlong','Hanlong Technology'),(26,'CiscoSPA','CiscoSPA'),(27,'INCOM','INCOM');
/*!40000 ALTER TABLE `manufacturer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `model`
--

LOCK TABLES `model` WRITE;
/*!40000 ALTER TABLE `model` DISABLE KEYS */;
INSERT INTO `model` (`id`, `id_manufacturer`, `name`, `description`, `max_accounts`, `static_ip_supported`, `dynamic_ip_supported`, `static_prov_supported`) VALUES (1,1,'480i','480i',9,1,1,1),(2,1,'480i CT','480i CT',9,1,1,1),(3,1,'51i','51i',1,1,1,1),(4,1,'53i','53i',9,1,1,1),(5,1,'55i','55i',9,1,1,1),(6,1,'57i','57i',9,1,1,1),(7,1,'57i CT','53i CT',9,1,1,1),(8,1,'6730i','6730i',6,1,1,1),(9,1,'6731i','6731i',6,1,1,1),(10,1,'6739i','6739i',9,1,1,1),(11,1,'6755i','6755i',9,1,1,1),(12,1,'6757i','6757i',9,1,1,1),(13,1,'9112i','9112i',1,1,1,1),(14,1,'9133i','9133i',9,1,1,1),(15,1,'9143i','9143i',9,1,1,1),(16,1,'9480i','9480i',9,1,1,1),(17,1,'9480i CT','9480i CT',9,1,1,1),(18,2,'AT320','AT320',1,1,1,1),(19,2,'AT530','AT530',3,1,1,1),(20,2,'AT610','AT610',2,1,1,1),(21,2,'AT620','AT620',3,1,1,1),(22,2,'AT640','AT640',5,1,1,1),(23,2,'AT800','AT800',1,1,1,1),(24,3,'Temporis IP800','ALCATEL Temporis IP800',6,1,1,1),(25,4,'310HD','310HD',1,1,1,1),(26,4,'320HD','320HD',4,1,1,1),(27,5,'7690','7690',1,0,1,0),(28,5,'7906','7906',1,0,1,0),(29,5,'7931','7931',3,0,1,0),(30,5,'7940','7940',2,0,1,0),(31,5,'7960','7960',6,0,1,0),(32,5,'7961','7961',6,0,1,0),(33,5,'7970','7970',8,0,1,0),(34,5,'7971','7971',8,0,1,0),(35,6,'D-3310','D-3310',2,1,1,1),(36,7,'LXP100','LXP100',2,1,1,1),(37,7,'LXP200','LXP200',2,1,1,1),(38,8,'ES620','ES620',8,1,1,1),(39,9,'C56','C56/C56P',2,1,1,1),(40,9,'C58','C58/C58P',3,1,1,1),(41,9,'C60','C60',4,1,1,1),(42,9,'C62','C62',5,1,1,1),(43,10,'BT200','BT200',1,1,1,1),(44,10,'HT386','HT386',2,1,1,0),(45,10,'GXP280','GXP280',1,1,1,1),(46,10,'GXP1400','GXP1400',2,1,1,1),(47,10,'GXP1405','GXP1405',2,1,1,1),(48,10,'GXP1450','GXP1450',2,1,1,1),(49,10,'GXP2000','GXP2000',4,1,1,0),(50,10,'GXP2020','GXP2020',6,1,1,0),(51,10,'GXP2100','GXP2100',4,1,1,0),(52,10,'GXP2120','GXP2120',6,1,1,0),(53,10,'GXP2200','GXP2200',6,1,1,0),(54,10,'GXV3140','GXV3140',3,1,1,0),(55,10,'GXV3175','GXV3175',3,1,1,0),(56,11,'IP8802','IP8802/8802A',1,1,1,0),(57,12,'SPA841','SPA841',2,1,1,0),(58,12,'SPA921','SPA921',1,1,1,0),(59,12,'SPA922','SPA922',1,1,1,0),(60,12,'SPA941','SPA941',2,1,1,0),(61,12,'SPA942','SPA942',4,1,1,0),(62,12,'SPA962','SPA962',6,1,1,0),(63,14,'SoundPoint IP 301','SoundPoint IP 301',2,0,1,0),(64,14,'SoundPoint IP 320','SoundPoint IP 320',2,0,1,0),(65,14,'SoundPoint IP 430','SoundPoint IP 430',2,0,1,0),(66,14,'SoundPoint IP 501','SoundPoint IP 501',3,0,1,0),(67,14,'SoundPoint IP 550','SoundPoint IP 550',4,0,1,0),(68,14,'SoundPoint IP 601','SoundPoint IP 601',6,0,1,0),(69,14,'SoundPoint IP 650','SoundPoint IP 650',34,0,1,0),(70,14,'SoundStation IP 4000','SoundStation IP 4000',1,1,1,0),(71,14,'VSX7000A','VSX7000A',1,1,1,0),(72,15,'SL75 WLAN','SL75 WLAN',1,1,1,0),(73,16,'300','300',4,1,1,1),(74,16,'320','320',12,1,1,1),(75,16,'360','360',12,1,1,1),(76,16,'821','snom821-SIP',12,1,1,1),(77,16,'m9','m9',9,1,1,1),(78,17,'ST 2022','ST 2022',2,1,1,0),(79,17,'ST 2030','ST 2030',1,1,1,0),(80,19,'VI2006','VI2006',2,1,1,1),(81,19,'VI2007','VI2007',3,1,1,1),(82,19,'VI2008','VI2008',4,1,1,1),(83,20,'XP0100P','XP0100P',2,1,1,0),(84,20,'XP0120P','XP0120P',3,1,1,0),(85,21,'SIP-T20/T20P','SIP-T20/T20P',2,1,1,1),(86,21,'SIP-T22/T22P','SIP-T22/T22P',3,1,1,1),(87,21,'SIP-T26/T26P','SIP-T26/T26P',3,1,1,1),(88,21,'SIP-T28/T28P','SIP-T28/T28P',6,1,1,1),(89,21,'SIP-T38G','SIP-T38G',6,1,1,1),(90,21,'VP530','VP530',4,1,1,1),(91,22,'ZIP2x1','Zultys ZIP 2x1',1,0,1,0),(92,22,'ZIP2x2','Zultys ZIP 2x2',1,0,1,0),(93,23,'D40','D40',2,0,1,1),(94,23,'D50','D50',4,0,1,1),(95,23,'D70','D70',6,0,1,1),(96,24,'IP150','IP150',6,1,1,1),(97,14,'SoundPoint IP 330','SoundPoint IP 330',2,0,1,0),(98,16,'710','snom710-SIP',4,1,1,1),(99,16,'720','snom720-SIP',12,1,1,1),(100,16,'760','snom760-SIP',12,1,1,1),(101,16,'870','snom870-SIP',12,1,1,1),(102,24,'IP115','IP115',2,1,1,1),(103,24,'IP125','IP125',3,1,1,1),(104,24,'IP160s','IP160s',8,1,1,1),(105,10,'GXP2160','GXP2160',6,1,1,1),(106,25,'UC862','UC862',4,1,1,1),(107,7,'LXP180','Elastix LXP180',2,1,1,1),(108,7,'LXP150','Elastix LXP150',1,1,1,1),(109,7,'LXP250','Elastix LXP250',3,1,1,1),(110,10,'GXP2130','GXP2130',3,1,1,1),(111,10,'GXP2140','GXP2140',4,1,1,1),(112,9,'X3','X3/X3P',2,1,1,1),(113,9,'X5','X5/X5P',6,1,1,1),(114,9,'C400','C400/C400P',6,1,1,1),(115,9,'C600','C600/C600P',6,1,1,1),(116,9,'D900','D900',6,1,1,1),(117,26,'SPA501G','SPA501G',4,1,1,0),(118,26,'SPA502G','SPA502G',1,1,1,0),(119,26,'SPA504G','SPA504G',4,1,1,0),(120,26,'SPA508G','SPA508G',8,1,1,0),(121,26,'SPA509G','SPA509G',12,1,1,0),(122,26,'SPA512G','SPA512G',1,1,1,0),(123,26,'SPA514G','SPA514G',4,1,1,0),(124,26,'SPA525G2','SPA525G2',5,1,1,0),(125,26,'SPA301G','SPA301G',1,1,1,0),(126,26,'SPA303G','SPA303G',3,1,1,0),(127,27,'ICW-1000','ICW-1000',1,1,1,1),(128,9,'X6','X6',6,1,1,1),(129,9,'X4','X4',4,1,1,1),(130,9,'H5','H5',1,1,1,1),(131,9,'i20S','i20S',1,1,1,1),(132,10,'GXP2130','GXP2130',3,1,1,1),(133,10,'GXP2140','GXP2140',4,1,1,1),(134,10,'GXP1625','GXP1625',2,1,1,1),(135,10,'GXP1760','GXP1760',3,1,1,1),(136,10,'GXV3240','GXV3240',6,1,1,1);
/*!40000 ALTER TABLE `model` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `model_properties`
--

LOCK TABLES `model_properties` WRITE;
/*!40000 ALTER TABLE `model_properties` DISABLE KEYS */;
INSERT INTO `model_properties` (`id`, `id_model`, `property_key`, `property_value`) VALUES (1,1,'max_sip_accounts','9'),(2,1,'max_iax2_accounts','0'),(3,2,'max_sip_accounts','9'),(4,2,'max_iax2_accounts','0'),(5,3,'max_sip_accounts','1'),(6,3,'max_iax2_accounts','0'),(7,4,'max_sip_accounts','9'),(8,4,'max_iax2_accounts','0'),(9,5,'max_sip_accounts','9'),(10,5,'max_iax2_accounts','0'),(11,6,'max_sip_accounts','9'),(12,6,'max_iax2_accounts','0'),(13,7,'max_sip_accounts','9'),(14,7,'max_iax2_accounts','0'),(15,8,'max_sip_accounts','6'),(16,8,'max_iax2_accounts','0'),(17,9,'max_sip_accounts','6'),(18,9,'max_iax2_accounts','0'),(19,10,'max_sip_accounts','9'),(20,10,'max_iax2_accounts','0'),(21,11,'max_sip_accounts','9'),(22,11,'max_iax2_accounts','0'),(23,12,'max_sip_accounts','9'),(24,12,'max_iax2_accounts','0'),(25,13,'max_sip_accounts','1'),(26,13,'max_iax2_accounts','0'),(27,14,'max_sip_accounts','9'),(28,14,'max_iax2_accounts','0'),(29,15,'max_sip_accounts','9'),(30,15,'max_iax2_accounts','0'),(31,16,'max_sip_accounts','9'),(32,16,'max_iax2_accounts','0'),(33,17,'max_sip_accounts','9'),(34,17,'max_iax2_accounts','0'),(35,18,'max_sip_accounts','1'),(36,18,'max_iax2_accounts','0'),(37,19,'max_sip_accounts','2'),(38,19,'max_iax2_accounts','1'),(39,20,'max_sip_accounts','2'),(40,20,'max_iax2_accounts','0'),(41,21,'max_sip_accounts','2'),(42,21,'max_iax2_accounts','1'),(43,22,'max_sip_accounts','4'),(44,22,'max_iax2_accounts','1'),(45,23,'max_sip_accounts','1'),(46,23,'max_iax2_accounts','0'),(47,24,'max_sip_accounts','6'),(48,24,'max_iax2_accounts','0'),(49,25,'max_sip_accounts','1'),(50,25,'max_iax2_accounts','0'),(51,26,'max_sip_accounts','4'),(52,26,'max_iax2_accounts','0'),(53,27,'max_sip_accounts','1'),(54,27,'max_iax2_accounts','0'),(55,28,'max_sip_accounts','1'),(56,28,'max_iax2_accounts','0'),(57,29,'max_sip_accounts','3'),(58,29,'max_iax2_accounts','0'),(59,30,'max_sip_accounts','2'),(60,30,'max_iax2_accounts','0'),(61,31,'max_sip_accounts','6'),(62,31,'max_iax2_accounts','0'),(63,32,'max_sip_accounts','6'),(64,32,'max_iax2_accounts','0'),(65,33,'max_sip_accounts','8'),(66,33,'max_iax2_accounts','0'),(67,34,'max_sip_accounts','8'),(68,34,'max_iax2_accounts','0'),(69,35,'max_sip_accounts','2'),(70,35,'max_iax2_accounts','0'),(71,36,'max_sip_accounts','2'),(72,36,'max_iax2_accounts','0'),(73,37,'max_sip_accounts','2'),(74,37,'max_iax2_accounts','0'),(75,38,'max_sip_accounts','8'),(76,38,'max_iax2_accounts','0'),(77,39,'max_sip_accounts','2'),(78,39,'max_iax2_accounts','0'),(79,40,'max_sip_accounts','2'),(80,40,'max_iax2_accounts','1'),(81,41,'max_sip_accounts','3'),(82,41,'max_iax2_accounts','1'),(83,42,'max_sip_accounts','4'),(84,42,'max_iax2_accounts','1'),(85,43,'max_sip_accounts','1'),(86,43,'max_iax2_accounts','0'),(87,44,'max_sip_accounts','2'),(88,44,'max_iax2_accounts','0'),(89,45,'max_sip_accounts','1'),(90,45,'max_iax2_accounts','0'),(91,46,'max_sip_accounts','2'),(92,46,'max_iax2_accounts','0'),(93,47,'max_sip_accounts','2'),(94,47,'max_iax2_accounts','0'),(95,48,'max_sip_accounts','2'),(96,48,'max_iax2_accounts','0'),(97,49,'max_sip_accounts','4'),(98,49,'max_iax2_accounts','0'),(99,50,'max_sip_accounts','6'),(100,50,'max_iax2_accounts','0'),(101,51,'max_sip_accounts','4'),(102,51,'max_iax2_accounts','0'),(103,52,'max_sip_accounts','6'),(104,52,'max_iax2_accounts','0'),(105,53,'max_sip_accounts','6'),(106,53,'max_iax2_accounts','0'),(107,54,'max_sip_accounts','3'),(108,54,'max_iax2_accounts','0'),(109,55,'max_sip_accounts','3'),(110,55,'max_iax2_accounts','0'),(111,56,'max_sip_accounts','1'),(112,56,'max_iax2_accounts','0'),(113,57,'max_sip_accounts','2'),(114,57,'max_iax2_accounts','0'),(115,58,'max_sip_accounts','1'),(116,58,'max_iax2_accounts','0'),(117,59,'max_sip_accounts','1'),(118,59,'max_iax2_accounts','0'),(119,60,'max_sip_accounts','2'),(120,60,'max_iax2_accounts','0'),(121,61,'max_sip_accounts','4'),(122,61,'max_iax2_accounts','0'),(123,62,'max_sip_accounts','6'),(124,62,'max_iax2_accounts','0'),(125,63,'max_sip_accounts','2'),(126,63,'max_iax2_accounts','0'),(127,64,'max_sip_accounts','2'),(128,64,'max_iax2_accounts','0'),(129,65,'max_sip_accounts','2'),(130,65,'max_iax2_accounts','0'),(131,66,'max_sip_accounts','3'),(132,66,'max_iax2_accounts','0'),(133,67,'max_sip_accounts','4'),(134,67,'max_iax2_accounts','0'),(135,68,'max_sip_accounts','6'),(136,68,'max_iax2_accounts','0'),(137,69,'max_sip_accounts','34'),(138,69,'max_iax2_accounts','0'),(139,70,'max_sip_accounts','1'),(140,70,'max_iax2_accounts','0'),(141,71,'max_sip_accounts','1'),(142,71,'max_iax2_accounts','0'),(143,72,'max_sip_accounts','1'),(144,72,'max_iax2_accounts','0'),(145,73,'max_sip_accounts','4'),(146,73,'max_iax2_accounts','0'),(147,74,'max_sip_accounts','12'),(148,74,'max_iax2_accounts','0'),(149,75,'max_sip_accounts','12'),(150,75,'max_iax2_accounts','0'),(151,76,'max_sip_accounts','12'),(152,76,'max_iax2_accounts','0'),(153,77,'max_sip_accounts','9'),(154,77,'max_iax2_accounts','0'),(155,78,'max_sip_accounts','2'),(156,78,'max_iax2_accounts','0'),(157,79,'max_sip_accounts','2'),(158,79,'max_iax2_accounts','0'),(159,80,'max_sip_accounts','2'),(160,80,'max_iax2_accounts','0'),(161,81,'max_sip_accounts','2'),(162,81,'max_iax2_accounts','1'),(163,82,'max_sip_accounts','3'),(164,82,'max_iax2_accounts','1'),(165,83,'max_sip_accounts','2'),(166,83,'max_iax2_accounts','0'),(167,84,'max_sip_accounts','3'),(168,84,'max_iax2_accounts','0'),(169,85,'max_sip_accounts','2'),(170,85,'max_iax2_accounts','0'),(171,86,'max_sip_accounts','3'),(172,86,'max_iax2_accounts','0'),(173,87,'max_sip_accounts','3'),(174,87,'max_iax2_accounts','0'),(175,88,'max_sip_accounts','6'),(176,88,'max_iax2_accounts','0'),(177,90,'max_sip_accounts','4'),(178,90,'max_iax2_accounts','0'),(179,89,'max_sip_accounts','6'),(180,89,'max_iax2_accounts','0'),(181,91,'max_sip_accounts','1'),(182,91,'max_iax2_accounts','0'),(183,92,'max_sip_accounts','1'),(184,92,'max_iax2_accounts','0'),(185,1,'http_username','admin'),(186,1,'http_password','22222'),(187,2,'http_username','admin'),(188,2,'http_password','22222'),(189,3,'http_username','admin'),(190,3,'http_password','22222'),(191,4,'http_username','admin'),(192,4,'http_password','22222'),(193,5,'http_username','admin'),(194,5,'http_password','22222'),(195,6,'http_username','admin'),(196,6,'http_password','22222'),(197,7,'http_username','admin'),(198,7,'http_password','22222'),(199,8,'http_username','admin'),(200,8,'http_password','22222'),(201,9,'http_username','admin'),(202,9,'http_password','22222'),(203,10,'http_username','admin'),(204,10,'http_password','22222'),(205,11,'http_username','admin'),(206,11,'http_password','22222'),(207,12,'http_username','admin'),(208,12,'http_password','22222'),(209,13,'http_username','admin'),(210,13,'http_password','22222'),(211,14,'http_username','admin'),(212,14,'http_password','22222'),(213,15,'http_username','admin'),(214,15,'http_password','22222'),(215,16,'http_username','admin'),(216,16,'http_password','22222'),(217,17,'http_username','admin'),(218,17,'http_password','22222'),(219,18,'telnet_password','12345678'),(220,18,'http_username','admin'),(221,18,'http_password','admin'),(222,19,'telnet_username','admin'),(223,19,'telnet_password','admin'),(224,19,'http_username','admin'),(225,19,'http_password','admin'),(226,20,'telnet_username','admin'),(227,20,'telnet_password','admin'),(228,20,'http_username','admin'),(229,20,'http_password','admin'),(230,21,'telnet_username','admin'),(231,21,'telnet_password','admin'),(232,21,'http_username','admin'),(233,21,'http_password','admin'),(234,22,'telnet_username','admin'),(235,22,'telnet_password','admin'),(236,22,'http_username','admin'),(237,22,'http_password','admin'),(238,24,'http_username','admin'),(239,24,'http_password','admin'),(240,25,'telnet_username','admin'),(241,25,'telnet_password','1234'),(242,25,'http_username','admin'),(243,25,'http_password','1234'),(244,26,'telnet_username','admin'),(245,26,'telnet_password','1234'),(246,26,'http_username','admin'),(247,26,'http_password','1234'),(248,27,'telnet_password','cisco'),(249,28,'telnet_password','cisco'),(250,29,'telnet_password','cisco'),(251,30,'telnet_password','cisco'),(252,31,'telnet_password','cisco'),(253,32,'telnet_password','cisco'),(254,33,'telnet_password','cisco'),(255,34,'telnet_password','cisco'),(256,35,'http_username','admin'),(257,35,'http_password','admin'),(258,36,'http_password','admin'),(259,37,'http_password','admin'),(260,38,'telnet_username','root'),(261,38,'telnet_password','root'),(262,38,'http_username','root'),(263,38,'http_password','root'),(264,39,'telnet_username','admin'),(265,39,'telnet_password','admin'),(266,39,'http_username','admin'),(267,39,'http_password','admin'),(268,40,'telnet_username','admin'),(269,40,'telnet_password','admin'),(270,40,'http_username','admin'),(271,40,'http_password','admin'),(272,41,'telnet_username','admin'),(273,41,'telnet_password','admin'),(274,41,'http_username','admin'),(275,41,'http_password','admin'),(276,42,'telnet_username','admin'),(277,42,'telnet_password','admin'),(278,42,'http_username','admin'),(279,42,'http_password','admin'),(280,43,'telnet_password','admin'),(281,44,'telnet_password','admin'),(282,45,'telnet_password','admin'),(283,46,'telnet_password','admin'),(284,47,'telnet_password','admin'),(285,48,'ssh_username','admin'),(286,48,'ssh_password','admin'),(287,49,'telnet_password','admin'),(288,50,'telnet_password','admin'),(289,51,'telnet_password','admin'),(290,52,'telnet_password','admin'),(291,53,'ssh_username','admin'),(292,53,'ssh_password','admin'),(293,54,'telnet_password','admin'),(294,55,'telnet_password','admin'),(295,43,'http_password','admin'),(296,44,'http_password','admin'),(297,45,'http_password','admin'),(298,46,'http_password','admin'),(299,47,'http_password','admin'),(300,48,'http_password','admin'),(301,48,'http_password','admin'),(302,49,'http_password','admin'),(303,50,'http_password','admin'),(304,51,'http_password','admin'),(305,52,'http_password','admin'),(306,53,'http_password','admin'),(307,53,'http_password','admin'),(308,54,'http_username','admin'),(309,55,'http_username','admin'),(310,54,'http_password','admin'),(311,55,'http_password','admin'),(312,56,'telnet_username','private'),(313,56,'telnet_password','lip'),(314,77,'http_username','admin'),(315,77,'http_password','password'),(316,80,'telnet_username','admin'),(317,80,'telnet_password','admin'),(318,80,'http_username','admin'),(319,80,'http_password','admin'),(320,81,'telnet_username','admin'),(321,81,'telnet_password','admin'),(322,81,'http_username','admin'),(323,81,'http_password','admin'),(324,82,'telnet_username','admin'),(325,82,'telnet_password','admin'),(326,82,'http_username','admin'),(327,82,'http_password','admin'),(328,85,'http_username','admin'),(329,85,'http_password','admin'),(330,86,'http_username','admin'),(331,86,'http_password','admin'),(332,87,'http_username','admin'),(333,87,'http_password','admin'),(334,88,'http_username','admin'),(335,88,'http_password','admin'),(336,89,'http_username','admin'),(337,89,'http_password','admin'),(338,90,'http_username','admin'),(339,90,'http_password','admin'),(340,93,'max_sip_accounts','2'),(341,93,'max_iax2_accounts','0'),(342,94,'max_sip_accounts','4'),(343,94,'max_iax2_accounts','0'),(344,95,'max_sip_accounts','6'),(345,95,'max_iax2_accounts','0'),(346,93,'http_username','admin'),(347,93,'http_password','789'),(348,94,'http_username','admin'),(349,94,'http_password','789'),(350,95,'http_username','admin'),(351,95,'http_password','789'),(352,96,'max_sip_accounts','6'),(353,96,'max_iax2_accounts','0'),(354,96,'ssh_username','root'),(355,96,'ssh_password','admin'),(356,96,'http_username','admin'),(357,96,'http_password','admin'),(358,97,'max_sip_accounts','2'),(359,97,'max_iax2_accounts','0'),(361,98,'max_sip_accounts','4'),(362,98,'max_iax2_accounts','0'),(363,99,'max_sip_accounts','12'),(364,99,'max_iax2_accounts','0'),(365,100,'max_sip_accounts','12'),(366,100,'max_iax2_accounts','0'),(367,101,'max_sip_accounts','12'),(368,101,'max_iax2_accounts','0'),(369,102,'max_sip_accounts','2'),(370,102,'max_iax2_accounts','0'),(371,102,'telnet_username','root'),(372,102,'telnet_password','root'),(373,102,'http_username','root'),(374,102,'http_password','root'),(375,103,'max_sip_accounts','3'),(376,103,'max_iax2_accounts','0'),(377,103,'telnet_username','root'),(378,103,'telnet_password','root'),(379,103,'http_username','root'),(380,103,'http_password','root'),(381,104,'max_sip_accounts','8'),(382,104,'max_iax2_accounts','0'),(383,104,'http_username','admin'),(384,104,'http_password','7227'),(385,105,'max_sip_accounts','6'),(386,105,'max_iax2_accounts','0'),(387,105,'ssh_username','admin'),(388,105,'ssh_password','admin'),(389,105,'http_username','admin'),(390,105,'http_password','admin'),(391,106,'max_sip_accounts','4'),(392,106,'max_iax2_accounts','0'),(393,106,'http_username','admin'),(394,106,'http_password','admin'),(395,107,'max_sip_accounts','2'),(396,107,'max_iax2_accounts','0'),(397,107,'http_username','admin'),(398,107,'http_password','admin'),(399,108,'max_sip_accounts','1'),(400,108,'max_iax2_accounts','0'),(401,108,'http_username','admin'),(402,108,'http_password','admin'),(403,109,'max_sip_accounts','3'),(404,109,'max_iax2_accounts','0'),(405,109,'http_username','admin'),(406,109,'http_password','admin'),(407,110,'max_sip_accounts','3'),(408,110,'max_iax2_accounts','0'),(409,110,'ssh_username','admin'),(410,110,'ssh_password','admin'),(411,110,'http_username','admin'),(412,110,'http_password','admin'),(413,111,'max_sip_accounts','4'),(414,111,'max_iax2_accounts','0'),(415,111,'ssh_username','admin'),(416,111,'ssh_password','admin'),(417,111,'http_username','admin'),(418,111,'http_password','admin'),(419,112,'max_sip_accounts','2'),(420,112,'max_iax2_accounts','0'),(421,112,'http_username','admin'),(422,112,'http_password','admin'),(423,113,'max_sip_accounts','6'),(424,113,'max_iax2_accounts','0'),(425,113,'http_username','admin'),(426,113,'http_password','admin'),(427,114,'max_sip_accounts','6'),(428,114,'max_iax2_accounts','0'),(429,114,'http_username','admin'),(430,114,'http_password','admin'),(431,115,'max_sip_accounts','6'),(432,115,'max_iax2_accounts','0'),(433,115,'http_username','admin'),(434,115,'http_password','admin'),(435,116,'max_sip_accounts','6'),(436,116,'max_iax2_accounts','0'),(437,116,'http_username','admin'),(438,116,'http_password','admin'),(439,117,'max_sip_accounts','4'),(440,117,'max_iax2_accounts','0'),(441,117,'http_username','admin'),(442,117,'http_password','22222'),(443,118,'max_sip_accounts','1'),(444,118,'max_iax2_accounts','0'),(445,118,'http_username','admin'),(446,118,'http_password','22222'),(447,119,'max_sip_accounts','4'),(448,119,'max_iax2_accounts','0'),(449,119,'http_username','admin'),(450,119,'http_password','22222'),(451,120,'max_sip_accounts','8'),(452,120,'max_iax2_accounts','0'),(453,120,'http_username','admin'),(454,120,'http_password','22222'),(455,121,'max_sip_accounts','12'),(456,121,'max_iax2_accounts','0'),(457,121,'http_username','admin'),(458,121,'http_password','22222'),(459,122,'max_sip_accounts','1'),(460,122,'max_iax2_accounts','0'),(461,122,'http_username','admin'),(462,122,'http_password','22222'),(463,123,'max_sip_accounts','4'),(464,123,'max_iax2_accounts','0'),(465,123,'http_username','admin'),(466,123,'http_password','22222'),(467,124,'max_sip_accounts','5'),(468,124,'max_iax2_accounts','0'),(469,124,'http_username','admin'),(470,124,'http_password','22222'),(471,125,'max_sip_accounts','1'),(472,125,'max_iax2_accounts','0'),(473,125,'http_username','admin'),(474,125,'http_password','22222'),(475,126,'max_sip_accounts','3'),(476,126,'max_iax2_accounts','0'),(477,126,'http_username','admin'),(478,126,'http_password','22222'),(479,127,'max_sip_accounts','1'),(480,127,'max_iax2_accounts','0'),(481,127,'http_username','admin'),(482,127,'http_password','000000'),(483,128,'max_sip_accounts','6'),(484,128,'max_iax2_accounts','0'),(485,128,'http_username','admin'),(486,128,'http_password','admin'),(487,129,'max_sip_accounts','4'),(488,129,'max_iax2_accounts','0'),(489,129,'http_username','admin'),(490,129,'http_password','admin'),(491,130,'max_sip_accounts','1'),(492,130,'max_iax2_accounts','0'),(493,130,'http_username','admin'),(494,130,'http_password','admin'),(495,131,'max_sip_accounts','1'),(496,131,'max_iax2_accounts','0'),(497,131,'http_username','admin'),(498,131,'http_password','admin'),(499,135,'max_sip_accounts','3'),(500,135,'max_iax2_accounts','0'),(501,135,'http_username','admin'),(502,135,'http_password','admin'),(503,134,'max_sip_accounts','2'),(504,134,'max_iax2_accounts','0'),(505,134,'http_username','admin'),(506,134,'http_password','admin'),(507,136,'max_sip_accounts','6'),(508,136,'max_iax2_accounts','0'),(509,136,'http_username','admin'),(510,136,'http_password','admin');
/*!40000 ALTER TABLE `model_properties` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-04-29 23:59:10
